/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Vector;
import visad.DerivedUnit;
import visad.OffsetUnit;
import visad.ScaledUnit;
import visad.Unit;
import visad.UnitException;

public final class BaseUnit
extends Unit
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String unitName;
    private final String quantityName;
    final DerivedUnit derivedUnit;
    final boolean isDimless;
    private static final Vector<BaseUnit> baseUnits = new Vector(9);

    private BaseUnit(String unitName, String abbreviation, String quantityName, boolean isDimless) throws UnitException {
        super(abbreviation);
        if (unitName == null || abbreviation == null || quantityName == null) {
            throw new UnitException("Base unit name, abbreviation, or quantity name is null");
        }
        this.unitName = unitName;
        this.quantityName = quantityName;
        baseUnits.addElement(this);
        this.derivedUnit = new DerivedUnit(this);
        this.isDimless = isDimless;
    }

    public boolean isDimensionless() {
        return this.isDimless;
    }

    public Unit scale(double amount) throws UnitException {
        return ScaledUnit.getInstance(amount, this);
    }

    public Unit shift(double offset) throws UnitException {
        return OffsetUnit.getInstance(offset, this);
    }

    public Unit log(double base) {
        return this.derivedUnit.log(base);
    }

    public Unit pow(int power) {
        return this.derivedUnit.pow(power);
    }

    public Unit pow(double power) throws IllegalArgumentException {
        return this.derivedUnit.pow(power);
    }

    public Unit root(int root) throws IllegalArgumentException {
        return this.derivedUnit.root(root);
    }

    public String unitName() {
        return this.unitName;
    }

    public String unitSymbol() {
        return this.getIdentifier();
    }

    public String quantityName() {
        return this.quantityName;
    }

    public static BaseUnit addBaseUnit(String quantityName, String unitName) throws UnitException {
        return BaseUnit.addBaseUnit(quantityName, unitName, unitName);
    }

    public static synchronized BaseUnit addBaseUnit(String quantityName, String unitName, String abbreviation) throws UnitException {
        return BaseUnit.addBaseUnit(quantityName, unitName, abbreviation, false);
    }

    public static synchronized BaseUnit addBaseUnit(String quantityName, String unitName, String abbreviation, boolean isDimless) throws UnitException {
        BaseUnit baseUnit = BaseUnit.quantityNameToUnit(quantityName);
        if (baseUnit == null) {
            return new BaseUnit(unitName, abbreviation, quantityName, isDimless);
        }
        if (baseUnit.unitName.equals(unitName) && baseUnit.getIdentifier().equals(abbreviation) && baseUnit.isDimless == isDimless) {
            return baseUnit;
        }
        throw new UnitException("Attempt to redefine quantity \"" + quantityName + "\" base unit from \"" + baseUnit.unitName + "(" + baseUnit.getIdentifier() + ")" + "\" to \"" + unitName + "(" + abbreviation + ")" + "\"");
    }

    public static synchronized BaseUnit unitNameToUnit(String unitName) {
        for (int i = 0; i < baseUnits.size(); ++i) {
            BaseUnit baseUnit = baseUnits.elementAt(i);
            if (!baseUnit.unitName.equals(unitName)) continue;
            return baseUnit;
        }
        return null;
    }

    public static synchronized BaseUnit quantityNameToUnit(String quantityName) {
        for (int i = 0; i < baseUnits.size(); ++i) {
            BaseUnit baseUnit = baseUnits.elementAt(i);
            if (!baseUnit.quantityName.equals(quantityName)) continue;
            return baseUnit;
        }
        return null;
    }

    private static void myAssert(boolean assertion) {
        if (!assertion) {
            throw new AssertionError();
        }
    }

    private static void myAssert(String have, String expect) {
        if (!have.equals(expect)) {
            throw new AssertionError((Object)(have + " != " + expect));
        }
    }

    private static void myAssert(Unit have, Unit expect) {
        if (!have.equals(expect)) {
            throw new AssertionError((Object)(have.toString() + " != " + expect));
        }
    }

    private static void myAssert(double have, double expect) {
        if (have != expect) {
            throw new AssertionError((Object)("" + have + " != " + expect));
        }
    }

    private static void myAssert(double[] have, double[] expect) {
        if (!Arrays.equals(have, expect)) {
            throw new AssertionError((Object)("" + have + " != " + expect));
        }
    }

    public static void main(String[] args) throws UnitException {
        BaseUnit meter = BaseUnit.addBaseUnit("Length", "meter", "m");
        BaseUnit.myAssert(meter, meter);
        BaseUnit.myAssert(meter.isConvertible(meter));
        BaseUnit.myAssert(meter.toString(), "m");
        BaseUnit.myAssert(meter.pow(2), meter.multiply(meter));
        BaseUnit.myAssert(meter.pow(2).sqrt(), meter);
        BaseUnit second = BaseUnit.addBaseUnit("Time", "second", "s");
        BaseUnit.myAssert(!meter.equals(second));
        BaseUnit.myAssert(!meter.isConvertible(second));
        Unit unit = meter.multiply(second);
        BaseUnit.myAssert(unit, second.multiply(meter));
        unit = meter.divide(second);
        BaseUnit.myAssert(unit, second.divide(meter).pow(-1));
        BaseUnit.myAssert(!unit.equals(meter));
        BaseUnit.myAssert(!unit.equals(second));
        BaseUnit.myAssert(meter.toThis(5.0, (Unit)meter), 5.0);
        BaseUnit.myAssert(meter.toThat(5.0, (Unit)meter), 5.0);
        double[] values = new double[]{1.0, 2.0};
        BaseUnit.myAssert(meter.toThis(values, meter), values);
        BaseUnit.myAssert(meter.toThat(values, meter), values);
        System.out.println("Checking exceptions:");
        try {
            meter.toThis(5.0, (Unit)second);
            throw new AssertionError();
        }
        catch (UnitException e) {
            System.out.println(e.getMessage());
            try {
                meter.toThat(5.0, (Unit)second);
                throw new AssertionError();
            }
            catch (UnitException e2) {
                System.out.println(e2.getMessage());
                try {
                    BaseUnit.addBaseUnit("Length", "foot", "ft");
                    throw new AssertionError();
                }
                catch (UnitException e3) {
                    System.out.println(e3.getMessage());
                    System.out.println("Done");
                    return;
                }
            }
        }
    }

    double[] toThis(double[] values, BaseUnit that) throws UnitException {
        return this.toThis(values, that, true);
    }

    float[] toThis(float[] values, BaseUnit that) throws UnitException {
        return this.toThis(values, that, true);
    }

    double[] toThis(double[] values, BaseUnit that, boolean copy) throws UnitException {
        if (this.equals(that)) {
            double[] newValues = copy ? (double[])values.clone() : values;
            return newValues;
        }
        throw new UnitException("Attempt to convert from unit \"" + that + "\" to unit \"" + this + "\"");
    }

    float[] toThis(float[] values, BaseUnit that, boolean copy) throws UnitException {
        if (this.equals(that)) {
            float[] newValues = copy ? (float[])values.clone() : values;
            return newValues;
        }
        throw new UnitException("Attempt to convert from unit \"" + that + "\" to unit \"" + this + "\"");
    }

    public double[] toThis(double[] values, Unit that) throws UnitException {
        return this.toThis(values, that, true);
    }

    public float[] toThis(float[] values, Unit that) throws UnitException {
        return this.toThis(values, that, true);
    }

    public double[] toThis(double[] values, Unit that, boolean copy) throws UnitException {
        return that.toThat(values, (Unit)this.derivedUnit, copy);
    }

    public float[] toThis(float[] values, Unit that, boolean copy) throws UnitException {
        return that.toThat(values, (Unit)this.derivedUnit, copy);
    }

    double[] toThat(double[] values, BaseUnit that) throws UnitException {
        return this.toThat(values, that, true);
    }

    float[] toThat(float[] values, BaseUnit that) throws UnitException {
        return this.toThat(values, that, true);
    }

    double[] toThat(double[] values, BaseUnit that, boolean copy) throws UnitException {
        if (this.equals(that)) {
            double[] newValues = copy ? (double[])values.clone() : values;
            return newValues;
        }
        throw new UnitException("Attempt to convert from unit \"" + this + "\" to unit \"" + that + "\"");
    }

    float[] toThat(float[] values, BaseUnit that, boolean copy) throws UnitException {
        if (this.equals(that)) {
            float[] newValues = copy ? (float[])values.clone() : values;
            return newValues;
        }
        throw new UnitException("Attempt to convert from unit \"" + this + "\" to unit \"" + that + "\"");
    }

    public double[] toThat(double[] values, Unit that) throws UnitException {
        return this.toThat(values, that, true);
    }

    public float[] toThat(float[] values, Unit that) throws UnitException {
        return this.toThat(values, that, true);
    }

    public double[] toThat(double[] values, Unit that, boolean copy) throws UnitException {
        return that.toThis(values, (Unit)this.derivedUnit, copy);
    }

    public float[] toThat(float[] values, Unit that, boolean copy) throws UnitException {
        return that.toThis(values, (Unit)this.derivedUnit, copy);
    }

    public String getDefinition() {
        return this.getIdentifier();
    }

    protected Unit protectedClone(String identifier) throws UnitException {
        throw new UnitException("Base units may not be cloned");
    }

    public boolean equals(Unit unit) {
        if (this == unit) {
            return true;
        }
        if (!(unit instanceof BaseUnit)) {
            return this.derivedUnit.equals(unit);
        }
        BaseUnit that = (BaseUnit)unit;
        return this.unitName.equals(that.unitName) && this.quantityName.equals(that.quantityName) && this.isDimless == that.isDimless;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.unitName.hashCode() ^ this.quantityName.hashCode() ^ Boolean.valueOf(this.isDimless).hashCode();
        }
        return this.hashCode;
    }

    public Unit multiply(Unit that) throws UnitException {
        return this.derivedUnit.multiply(that);
    }

    public Unit divide(Unit that) throws UnitException {
        return this.derivedUnit.divide(that);
    }

    protected Unit divideInto(Unit that) throws UnitException {
        return this.derivedUnit.divideInto(that);
    }

    public boolean isConvertible(Unit unit) {
        return unit == null ? false : this.derivedUnit.isConvertible(unit);
    }

    public DerivedUnit getDerivedUnit() {
        return this.derivedUnit;
    }
}

