/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.thredds.server;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import thredds.catalog.InvAccess;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.ThreddsMetadata;
import ucar.nc2.NetcdfFile;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.thredds.ThreddsDataFactory;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.TimeUnit;
import ucar.nc2.util.NamedObject;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.util.Format;
import ucar.unidata.util.Parameter;

public class TestIDVdatasets {
    boolean extract = false;
    String skip;
    int countDone = 0;
    int maxDone = Integer.MAX_VALUE;
    int errCount = 0;
    InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory(true);
    ThreddsDataFactory tdataFactory = new ThreddsDataFactory();

    void extract(PrintStream out, String catName, boolean doOneOnly, String skip, int maxDone) {
        InvCatalogImpl cat;
        this.skip = skip;
        if (maxDone > 0) {
            this.maxDone = maxDone;
        }
        out.println("******* read " + catName);
        try {
            cat = this.catFactory.readXML(catName);
            StringBuilder buff = new StringBuilder();
            boolean isValid = cat.check(buff, false);
            out.println("catalog <" + cat.getName() + "> " + (isValid ? "is" : "is not") + " valid");
            out.println(" validation output=\n" + buff);
        }
        catch (Exception e) {
            e.printStackTrace(out);
            return;
        }
        out.println("***CATALOG " + cat.getCreateFrom());
        this.extractDatasetInfo(out, cat.getDatasets(), doOneOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void extractDatasetInfo(PrintStream out, List datasets, boolean doOneOnly) {
        InvDataset ds;
        int i;
        if (this.countDone > this.maxDone) {
            return;
        }
        for (i = 0; i < datasets.size(); ++i) {
            ds = (InvDataset)datasets.get(i);
            out.print(" DATASET " + ds.getName() + " id= " + ds.getID());
            if (ds instanceof InvCatalogRef) {
                InvCatalogRef catref = (InvCatalogRef)ds;
                out.print(" catref=" + catref.getURI());
            }
            if (ds.getName().equals(this.skip)) {
                out.println(" SKIP ");
                continue;
            }
            if (ds.hasAccess()) {
                String st;
                long start;
                ThreddsDataFactory.Result tdata;
                block32: {
                    tdata = null;
                    start = System.currentTimeMillis();
                    try {
                        tdata = this.tdataFactory.openFeatureDataset(ds, null);
                        if (!tdata.fatalError) break block32;
                        out.println("  *ERROR " + tdata.errLog);
                        if (!doOneOnly) break block32;
                    }
                    catch (Throwable e) {
                        out.println(this.errCount + "  *FAILED to open ");
                        e.printStackTrace(out);
                        ++this.errCount;
                        continue;
                    }
                    try {
                        if (tdata == null || tdata.featureDataset == null) break;
                        tdata.featureDataset.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                    break;
                }
                int took = (int)(System.currentTimeMillis() - start);
                InvAccess access = tdata.accessUsed;
                String string = st = access == null ? " UNKNOWN" : access.getService().getServiceType().toString();
                if (tdata.featureType == FeatureType.GRID) {
                    out.println(" *Opened " + this.countDone + " GRID " + tdata.location + " " + st + " (" + took + " msecs)");
                    if (this.extract) {
                        this.extractGrid(out, (GridDataset)((Object)tdata.featureDataset));
                    }
                } else if (tdata.featureType == FeatureType.POINT) {
                    out.println(" *Opened " + this.countDone + " TYPE " + (Object)((Object)ds.getDataType()) + " " + tdata.location + " " + st);
                } else if (tdata.featureType == FeatureType.STATION) {
                    out.println(" *Opened " + this.countDone + " TYPE " + (Object)((Object)ds.getDataType()) + " " + tdata.location + " " + st);
                }
                ++this.countDone;
                if (this.countDone > this.maxDone) {
                    return;
                }
                if (!doOneOnly) continue;
                break;
            }
            out.println();
        }
        if (this.countDone > this.maxDone) {
            return;
        }
        i = 0;
        while (i < datasets.size()) {
            ds = (InvDataset)datasets.get(i);
            if (ds.getName().equals(this.skip)) {
                out.println(" SKIP ");
            } else {
                if (this.countDone > this.maxDone) {
                    return;
                }
                this.extractDatasetInfo(out, ds.getDatasets(), doOneOnly);
            }
            ++i;
        }
    }

    private void extractGrid(PrintStream out, GridDataset gridDs) {
        NetcdfFile ds = gridDs.getNetcdfFile();
        if (gridDs == null) {
            return;
        }
        List<GridDatatype> grids = gridDs.getGrids();
        String fileFormat = ds.findAttValueIgnoreCase(null, "FileFormat", "");
        out.println("   " + grids.size() + " grids; file format=" + fileFormat);
        GridCoordSystem gcsMax = null;
        LatLonRect llbbMax = null;
        LatLonRect llbb = null;
        DateRange dateRange = null;
        long nx = 0L;
        long ny = 0L;
        for (GridDataset.Gridset gset : gridDs.getGridsets()) {
            CoordinateAxis1D vaxis;
            GridCoordSystem gcs = gset.getGeoCoordSystem();
            long nx2 = gcs.getXHorizAxis().getSize();
            long ny2 = gcs.getYHorizAxis().getSize();
            if (nx != nx2 || ny != ny2) {
                if (gcs.getXHorizAxis() instanceof CoordinateAxis1D && gcs.getYHorizAxis() instanceof CoordinateAxis1D) {
                    CoordinateAxis1D xaxis = (CoordinateAxis1D)gcs.getXHorizAxis();
                    CoordinateAxis1D yaxis = (CoordinateAxis1D)gcs.getYHorizAxis();
                    nx = nx2;
                    ny = ny2;
                    double dx = xaxis.getIncrement();
                    double dy = yaxis.getIncrement();
                    out.print("   horizontal = " + nx + " by " + ny + " points, resolution " + Format.d(dx, 4) + " " + Format.d(dy, 4) + " " + xaxis.getUnitsString());
                } else {
                    out.print("   horizontal 2D = " + nx + " by " + ny + " " + gcs.getXHorizAxis().getUnitsString());
                }
                ProjectionImpl proj = gcs.getProjection();
                if (proj != null) {
                    out.print(", " + proj.getClassName() + " projection;");
                    List<Parameter> params = proj.getProjectionParameters();
                    for (int i = 0; i < params.size(); ++i) {
                        Parameter p = params.get(i);
                        out.print("       " + p.getName() + " " + p.getStringValue());
                    }
                }
                out.println();
            }
            LatLonRect llbb2 = gcs.getLatLonBoundingBox();
            if (llbb == null || !llbb2.equals(llbb)) {
                llbb = llbb2;
                if (llbbMax == null) {
                    llbbMax = llbb;
                } else {
                    llbbMax.extend(llbb);
                }
                if (llbb.getWidth() >= 360.0) {
                    out.println("   BoundingBox == GLOBAL");
                } else {
                    StringBuffer buff = new StringBuffer();
                    LatLonPointImpl ll = llbb.getLowerLeftPoint();
                    LatLonPointImpl ur = llbb.getUpperRightPoint();
                    buff.append(Double.toString(ll.getLongitude()));
                    buff.append(" ");
                    buff.append(Double.toString(ll.getLatitude()));
                    buff.append(" ");
                    buff.append(Double.toString(ur.getLongitude()));
                    buff.append(" ");
                    buff.append(Double.toString(ur.getLatitude()));
                    buff.append(" ");
                    out.println("   BoundingBox == " + llbb + " width= " + llbb.getWidth() + " " + (llbb.getWidth() >= 360.0 ? "global" : ""));
                }
            }
            CoordinateAxis1DTime taxis = gcs.getTimeAxis1D();
            DateRange dateRange2 = gcs.getDateRange();
            if (dateRange2 == null) {
                out.println("  NO DateRange");
            } else if (!(taxis == null || dateRange != null && dateRange2.equals(dateRange))) {
                long ntimes = taxis.getSize();
                try {
                    TimeUnit tUnit = null;
                    if (taxis.isRegular()) {
                        tUnit = taxis.getTimeResolution();
                    }
                    dateRange = new DateRange(dateRange2, "1 hour");
                    out.println("   DateRange == start= " + dateRange.getStart() + " end= " + dateRange.getEnd() + " duration= " + dateRange.getDuration() + " ntimes = " + ntimes + " data resolution = " + tUnit);
                }
                catch (Exception e) {
                    e.printStackTrace(out);
                }
            }
            if ((vaxis = gcs.getVerticalAxis()) == null) continue;
            long nvert = vaxis.getSize();
            out.print("   Vertical axis= " + vaxis.getName() + " units=" + vaxis.getUnitsString() + " size= " + nvert);
            VerticalCT vt = gcs.getVerticalCT();
            if (vt != null) {
                out.print(" transform= " + vt.getVerticalTransformType());
            }
            List<NamedObject> vertNames = vaxis.getNames();
            for (int i = 0; i < vertNames.size(); ++i) {
                out.print(" " + vertNames.get(i));
            }
            out.println();
            if (gcsMax != null && gcsMax.getVerticalAxis().getSize() >= vaxis.getSize()) continue;
            gcsMax = gcs;
        }
        if (llbbMax == null) {
            out.println("***NO BB");
        } else {
            ThreddsMetadata.GeospatialCoverage gc = new ThreddsMetadata.GeospatialCoverage();
            gc.setBoundingBox(llbbMax);
            if (gcsMax != null) {
                gc.setVertical(gcsMax.getVerticalAxis());
                gc.setZPositiveUp(gcsMax.isZPositive());
            }
        }
    }

    public static void main(String[] args) throws Exception {
        String server = "http://motherlode.ucar.edu:8081/thredds";
        if (args.length > 0) {
            server = args[0];
        }
        TestIDVdatasets ts = new TestIDVdatasets();
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream("C:/temp/servertest4.txt"));
        PrintStream pout = System.out;
        ts.extract(System.out, server + "/idv/models.xml", false, null, 0);
    }
}

