/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribGridRecord;
import ucar.grib.grib2.Grib2DataRepresentationSection;
import ucar.grib.grib2.Grib2DataSection;
import ucar.grib.grib2.Grib2IdentificationSection;
import ucar.grib.grib2.Grib2ProductDefinitionSection;
import ucar.grib.grib2.Grib2Record;
import ucar.grib.grib2.Grib2Tables;
import ucar.grib.grib2.ParameterTable;
import ucar.grid.GridDefRecord;
import ucar.grid.GridParameter;
import ucar.grid.GridRecord;
import ucar.grid.GridTableLookup;

public final class Grib2GridTableLookup
implements GridTableLookup {
    private static Logger logger = LoggerFactory.getLogger(Grib2GridTableLookup.class);
    private final Grib2ProductDefinitionSection firstPDS;
    private final Grib2IdentificationSection firstID;
    private final Grib2DataRepresentationSection firstDRS;

    public Grib2GridTableLookup(Grib2Record firstRecord) {
        this.firstPDS = firstRecord.getPDS();
        this.firstID = firstRecord.getId();
        this.firstDRS = firstRecord.getDRS();
    }

    public final String getGridName(GridDefRecord gds) {
        return Grib2Tables.getGridName(gds.getParamInt("grid_type"));
    }

    public final String getShapeName(GridDefRecord gds) {
        return Grib2Tables.getShapeName(gds.getParamInt("grid_shape_code"));
    }

    public final String getDisciplineName(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return ParameterTable.getDisciplineName(ggr.discipline);
    }

    public final String getCategoryName(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return ParameterTable.getCategoryName(ggr.discipline, ggr.category);
    }

    public GridParameter getParameter(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return ParameterTable.getParameter(ggr.discipline, ggr.category, ggr.paramNumber);
    }

    public int[] getParameterId(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        int[] result = new int[]{2, ggr.discipline, ggr.category, ggr.paramNumber};
        return result;
    }

    public final String getProductDefinitionName(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return Grib2Tables.getProductDefinitionName(ggr.productType);
    }

    public final int getProductDefinition(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return ggr.productType;
    }

    public final String getTypeGenProcessName(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return Grib2Tables.getTypeGenProcessName(ggr.typeGenProcess);
    }

    public final int getTypeGenProcess(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return ggr.typeGenProcess;
    }

    public final boolean isEnsemble(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return ggr.typeGenProcess == 4 || ggr.typeGenProcess == 193;
    }

    public final String NumberOfForecastsInEnsemble(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return Integer.toString(ggr.numberForecasts);
    }

    public final String makeEnsembleName(GridRecord gr, GridTableLookup lookup) {
        if (!(lookup instanceof Grib2GridTableLookup)) {
            return "";
        }
        return this.makeSuffix(gr);
    }

    public final boolean isProbability(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return ggr.typeGenProcess == 5 || ggr.typeGenProcess == 10;
    }

    public final String NumberOfForecastsInProbability(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return Integer.toString(ggr.numberForecasts);
    }

    public final String makeProbabilityName(GridRecord gr, GridTableLookup lookup) {
        if (!(lookup instanceof Grib2GridTableLookup)) {
            return "";
        }
        return this.makeSuffix(gr);
    }

    public String makeSuffix(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return Grib2Tables.makeSuffix(ggr);
    }

    public final String getLevelName(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return Grib2Tables.getTypeSurfaceNameShort(ggr.levelType1);
    }

    public final String getLevelDescription(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return Grib2Tables.getTypeSurfaceName(ggr.levelType1);
    }

    public final String getLevelUnit(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return Grib2Tables.getTypeSurfaceUnit(ggr.levelType1);
    }

    public final Date getFirstBaseTime() {
        return this.firstID.getBaseTime();
    }

    public final String getFirstTimeRangeUnitName() {
        return Grib2Tables.getTimeRangeUnitName(this.firstPDS.getPdsVars().getTimeRangeUnit());
    }

    public final String getFirstCenterName() {
        return this.firstID.getCenter_idName();
    }

    public final int getFirstSubcenterId() {
        return this.firstID.getSubcenter_id();
    }

    public final String getFirstProductStatusName() {
        return this.firstID.getProductStatusName();
    }

    public final String getFirstProductTypeName() {
        return this.firstID.getProductTypeName();
    }

    public final String getFirstSignificanceOfRTName() {
        return this.firstID.getSignificanceOfRTName();
    }

    public final boolean isLatLon(GridDefRecord gds) {
        int grid_type = gds.getParamInt("grid_type");
        return grid_type == 0 || grid_type >= 40 && grid_type < 44;
    }

    public final int getProjectionType(GridDefRecord gds) {
        return Grib2Tables.getProjectionType(gds.getParamInt("grid_type"));
    }

    public final boolean isVerticalCoordinate(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        if (ggr.levelType1 == 105) {
            return true;
        }
        String units = this.getLevelUnit(gr);
        if (units == null || units.length() == 0) {
            return false;
        }
        if (ggr.levelType1 == 0) {
            return false;
        }
        return ggr.levelType1 != 104;
    }

    public final boolean isPositiveUp(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return ggr.levelType1 != 20 && ggr.levelType1 != 100 && ggr.levelType1 != 106 && ggr.levelType1 != 160;
    }

    public final float getFirstMissingValue() {
        if (Grib2DataSection.isStaticMissingValueInUse()) {
            return Float.NaN;
        }
        if (this.firstDRS.getMissingValueManagement() == 0) {
            return Float.NaN;
        }
        if (this.firstDRS.getMissingValueManagement() == 1) {
            return this.firstDRS.getPrimaryMissingValue();
        }
        if (this.firstDRS.getMissingValueManagement() == 2) {
            return this.firstDRS.getSecondaryMissingValue();
        }
        return -9999.0f;
    }

    public final boolean isLayer(GridRecord gr) {
        return gr.getLevelType2() != 255 && gr.getLevelType2() != 0;
    }

    public final String getGridType() {
        return "GRIB-2";
    }
}

