/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import ucar.grib.grib1.Grib1Data;
import ucar.unidata.io.RandomAccessFile;

public final class Grib1GetData {
    private static void usage(String className) {
        System.out.println();
        System.out.println("Usage of " + className + ":");
        System.out.println("Parameters:");
        System.out.println("<GribFileContainingData> ");
        System.out.println("<GDSOffset> obtained from GribIndexer ");
        System.out.println("<DataOffset> obtained from GribIndexer ");
        System.out.println("<DeciamlScale> obtained from GribIndexer ");
        System.out.println("<true/false> does bmsExists from Grib1Indexer ");
        System.out.println();
        System.out.println("java -Xmx256m ucar/grib/grib1/" + className + " <GribFileContainingData> <OffsetToData> <DecimalScale> <output file>");
        System.exit(0);
    }

    public static void main(String[] args) {
        Grib1GetData func = new Grib1GetData();
        if (args.length < 4) {
            Class<?> cl = func.getClass();
            Grib1GetData.usage(cl.getName());
        }
        TimeZone tz = TimeZone.getTimeZone("127");
        TimeZone.setDefault(tz);
        Date now = Calendar.getInstance().getTime();
        try {
            Boolean B;
            RandomAccessFile raf = null;
            PrintStream ps = System.out;
            long offset1 = 0L;
            long offset2 = 0L;
            boolean bmsExists = true;
            int decimalScale = 1;
            raf = new RandomAccessFile(args[0], "r");
            raf.order(0);
            offset1 = Long.decode(args[1]);
            if (args.length == 4) {
                decimalScale = Integer.parseInt(args[2]);
                B = Boolean.valueOf(args[3]);
                bmsExists = B;
            } else if (args.length == 5) {
                offset2 = Long.decode(args[2]);
                decimalScale = Integer.parseInt(args[3]);
                B = Boolean.valueOf(args[4]);
                bmsExists = B;
            } else if (args.length == 6) {
                offset2 = Long.decode(args[2]);
                decimalScale = Integer.parseInt(args[3]);
                B = Boolean.valueOf(args[4]);
                bmsExists = B;
                ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(args[5], false)));
            } else {
                System.exit(0);
            }
            long start = System.currentTimeMillis();
            Grib1Data g1d = new Grib1Data(raf);
            float[] data = args.length == 4 ? g1d.getData(offset1, decimalScale, bmsExists) : g1d.getData(offset1, offset2, decimalScale, bmsExists);
            System.out.println("getting data size " + data.length + " took " + (System.currentTimeMillis() - start) + " msec");
            if (data != null) {
                for (int j = 0; j < data.length; ++j) {
                    ps.println("data[ " + j + " ]=" + data[j]);
                }
            }
            raf.close();
            ps.close();
        }
        catch (FileNotFoundException noFileError) {
            System.err.println("FileNotFoundException : " + noFileError);
        }
        catch (IOException ioError) {
            System.err.println("IOException : " + ioError);
        }
        now = Calendar.getInstance().getTime();
    }
}

