#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader.core import debug


class ApplicationManager:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_current_application(self):
        curr_app = self.env["screen"]["new_application"].upper()
        if not curr_app:
            curr_app = "DEFAULT"
        if curr_app == "":
            curr_app = "DEFAULT"
        return curr_app

    def get_prev_application(self):
        prev_app = self.env["screen"]["oldApplication"].upper()
        if not prev_app:
            prev_app = "DEFAULT"
        if prev_app == "":
            prev_app = "DEFAULT"
        return prev_app

    def is_application_change(self):
        return (
            self.env["screen"]["oldApplication"]
            != self.env["screen"]["new_application"]
        )
