#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.


from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        self.env["runtime"]["VmenuManager"].toggle_vmenu_mode()
        return _("Entering or Leaving v menu mode.")

    def run(self):
        self.env["runtime"]["VmenuManager"].toggle_vmenu_mode()
        if self.env["runtime"]["VmenuManager"].get_active():
            self.env["runtime"]["OutputManager"].present_text(
                _("Entering v menu."), interrupt=True
            )
        else:
            self.env["runtime"]["OutputManager"].present_text(
                _("Leaving v menu."), interrupt=True
            )

    def set_callback(self, callback):
        pass
