/* $Id: chip_cirrus_gd5446_gen.c,v 1.14 2009-01-28 12:59:17 potyra Exp $ 
 *
 * Copyright (C) 2006-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef GEN_NAME
#error chip_cirrus_gd5446_gen.c needs GEN_NAME defined
#endif
#ifndef GEN_RGB
#error chip_cirrus_gd5446_gen.c needs GEN_RGB defined
#endif
#ifndef REFRESH_CYCLES
#error chip_cirrus_gd5446_gen.c needs REFRESH_CYCLES defined
#endif

extern void
paste(_cirrus_gen_, GEN_NAME)(
	struct cpssp *cpssp,
	struct sig_vga *video,
	unsigned int width,
	unsigned int height,
	unsigned long offset,
	unsigned int pitch
)
{
        int x;
        uint8_t r, g, b;
	int scan_count;

	unsigned long cursor_ptr_base;
	unsigned long cursor_ptr;
        unsigned cursor_size;
        unsigned cursor_line_offset;
        unsigned cursor_plane_offset;
        unsigned cursor_x;
	unsigned cursor_y;
        unsigned char cursor_val;

        cursor_ptr_base = CIRRUS_MAX_VRAM_SIZE - 16 * 1024;

        if (!(cpssp->ext_graph_curs_attr & 0x01)) {
                /* no hardware cursor enabled */
                cursor_size = 0;
                cursor_line_offset = 0;  /* make gcc happy */
                cursor_plane_offset = 0; /* make gcc happy */
        } else {
                if (cpssp->ext_graph_curs_attr & 0x04) {
                        /* 64x64px in 1024 bytes
                         * 512 byte-per-plane * 2 cursor planes
                         * "Stored one cursor scanline at a time; 8 bytes
                         *  written across the four logical display planes
                         *  (2-bytes-per-plane). One cursor scanline is loaded
                         *  from Cursor Plane 0 followed by one cursor scanline
                         *  from Cursor Plane 1. This is done until all 64
                         *  scanlines from the Cursor Plane 0 and Cursor Plane 1
                         *  are loaded into display memory."
                         */
                        cursor_size = 64;
                        cursor_line_offset = 16;
                        cursor_plane_offset = 8;
                        cursor_ptr_base += (cpssp->ext_graph_curs_pattern_addr_offset & 0x3c) * 256;
                } else {
                        /* 32x32px in 256 bytes
                         * 128 byte-per-plane * 2 cursor planes
                         * "The 256 bytes are stored across the four logical
                         *  Display Memory planes - 64 bytes per plane, the
                         *  first 32 bytes of each memory plane are from
                         *  Cursor Plane 0, and the last 32 bytes are from
                         *  Cursor Plane 1."
                         */
                        cursor_size = 32;
                        cursor_line_offset = 4;
                        cursor_plane_offset = 128;
                        cursor_ptr_base += (cpssp->ext_graph_curs_pattern_addr_offset & 0x3f) * 256;
                }
        }

#ifdef CIRRUS_DEBUG_GEN
        faum_log(FAUM_LOG_DEBUG, __FUNCTION__, "",
                 "o=0x%08lx w=%d h=%d p=%d cursor: x=%d y=%d s=%d\n",
                 offset, width, height, pitch,
                 cpssp->hw_cursor_x, cpssp->hw_cursor_y,
                 cursor_size);
#endif

	scan_count = 1 + height / REFRESH_CYCLES;

        if (cursor_size) {
                /* hardware cursor enabled */

		while (scan_count && cpssp->scanline < height) {

                        if (cpssp->hw_cursor_y <= cpssp->scanline
                            && cpssp->scanline < (cpssp->hw_cursor_y + cursor_size)) {

                                /* cursor intersects line */
                                cursor_x = 0;
				cursor_y = cpssp->scanline - cpssp->hw_cursor_y;
				cursor_ptr = cursor_ptr_base + cursor_y * cursor_line_offset;

                                for (x = 0; x < width; x++) {

                                        GEN_RGB;

                                        if (cpssp->hw_cursor_x <= x
                                            && x < (cpssp->hw_cursor_x + cursor_size)) {

                                                /* in cursor square */

                                                cursor_val = 0;

                                                /* select correct bit of byte on cursor plane 0 */
                                                if (video_readb(cpssp,cursor_ptr + (cursor_x / 8))
                                                    & (0x80 >> (cursor_x % 8))) {
                                                        /* left bit is 1 */
                                                        cursor_val |= 0x01;
                                                }

                                                /* select correct bit of byte on cursor plane 1 */
                                                if (video_readb(cpssp,cursor_ptr + cursor_plane_offset + (cursor_x / 8))
                                                            & (0x80 >> (cursor_x % 8))) {
                                                        /* right bit is 1 */
                                                        cursor_val |= 0x02;
                                                }

                                                switch (cursor_val) {
                                                case 0:
                                                        /* transparent */
                                                        sig_video_out(video->video, cpssp, r, g, b);
                                                        break;
                                                case 1:
                                                        /* invert */
                                                        sig_video_out(video->video, cpssp,
                                                                  r ^ 0xff,
                                                                  g ^ 0xff,
                                                                  b ^ 0xff);
                                                        break;
                                                case 2:
                                                        /* foreground */
                                                        sig_video_out(video->video, cpssp,
                                                                  video_col_get(cpssp, 256, 0),
                                                                  video_col_get(cpssp, 256, 1),
                                                                  video_col_get(cpssp, 256, 2));
                                                        break;
                                                case 3:
                                                        /* background */
                                                        sig_video_out(video->video, cpssp,
                                                                  video_col_get(cpssp, 257, 0),
                                                                  video_col_get(cpssp, 257, 1),
                                                                  video_col_get(cpssp, 257, 2));
                                                        break;
                                                default:
                                                        assert(0); /* can't happen */
                                                }

                                                cursor_x++;

                                        } else {

                                                /* not in cursor square */
                                                sig_video_out(video->video, cpssp, r, g, b);
                                        }
                                }

                        } else {

                                /* cursor doesn't intersect line */
                                for (x = 0; x < width; x++) {

                                        GEN_RGB;
                                        sig_video_out(video->video, cpssp, 
							r, g, b);
                                }
                        }

			cpssp->scanline++;
                        cpssp->offset += pitch;
			scan_count--;
			sig_video_hor_retrace(video->video, cpssp);
                }

        } else { /* hardware cursor not enabled */

		while (scan_count && cpssp->scanline < height) {

                        for (x = 0; x < width; x++) {

                                GEN_RGB;
                                sig_video_out(video->video, cpssp, r, g, b);
                        }

			cpssp->scanline++;
                        cpssp->offset += pitch;
			scan_count--;
                        sig_video_hor_retrace(video->video, cpssp);
                }
        }

	if (cpssp->scanline >= height) {
		cpssp->scanline = 0;
		cpssp->offset = offset;
		sig_video_vert_retrace(video->video, cpssp);
	}
}
