/* $Id: glue-log.h,v 1.5 2009-01-27 17:44:19 potyra Exp $ 
 *
 * Copyright (C) 2005-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __GLUE_LOG_H_INCLUDED
#define __GLUE_LOG_H_INCLUDED

/*
 * DEBUG:	should only be shown if debugging is enabled
 * INFO:	all information that is useful to the *user*
 * WARNING:	if something is not being simulated correctly, but
 * 		should continue working without problems
 * ERROR:	if something definitely went wrong, but the component
 * 		continues working
 * CRITICAL:	if something went wrong and the component
 * 		is not supposed to continue working correctly
 * FATAL:	if the component does not know what to do
 */

enum faum_log_level {
	FAUM_LOG_FATAL,
	FAUM_LOG_CRITICAL,
	FAUM_LOG_ERROR,
	FAUM_LOG_WARNING,
	FAUM_LOG_INFO,
	FAUM_LOG_DEBUG,
};

extern void
faum_log(enum faum_log_level level,
		const char *type, const char *name, const char *fmt, ...)
	__attribute__ ((format (printf, 4, 5)));
extern void
faum_cont(enum faum_log_level level, const char *fmt, ...)
	__attribute__ ((format (printf, 2, 3)));

#endif /* __GLUE_LOG_H_INCLUDED */
