/* $Id: cim_dio24.c,v 1.21 2009-01-27 17:06:39 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "cim_dio24.h"

static void
cim_dio24_set(void *_css, unsigned int val, unsigned int nr)
{
	// unsigned int i;
	struct cim_dio24 *css = (struct cim_dio24 *) _css;
	
	css->val[nr] = val;
	
	/*
	fprintf(stderr, "%s val=%d, nr=%d\n", __FUNCTION__, val, nr);
	fprintf(stderr, "%s val=|", __FUNCTION__);
	for (i = 0; i < 24; i++) {
		fprintf(stderr, "%d|", css->val[i]);
	}
	fprintf(stderr, "\n");
	*/

	cim_send(&css->bridge, css->val, sizeof(css->val));
}

static void
cim_dio24_set00(void *_css, unsigned int val)
{
	cim_dio24_set(_css, val, 0);
}

static void
cim_dio24_set01(void *_css, unsigned int val)
{
	cim_dio24_set(_css, val, 1);
}

static void
cim_dio24_set02(void *_css, unsigned int val)
{
	cim_dio24_set(_css, val, 2);
}

static void
cim_dio24_set03(void *_css, unsigned int val)
{
	cim_dio24_set(_css, val, 3);
}

static void
cim_dio24_set04(void *_css, unsigned int val)
{
	cim_dio24_set(_css, val, 4);
}

static void
cim_dio24_set05(void *_css, unsigned int val)
{
	cim_dio24_set(_css, val, 5);
}

static void
cim_dio24_set06(void *_css, unsigned int val)
{
	cim_dio24_set(_css, val, 6);
}

static void
cim_dio24_set07(void *_css, unsigned int val)
{
	cim_dio24_set(_css, val, 7);
}

static void
cim_dio24_set08(void *_css, unsigned int val)
{
	cim_dio24_set(_css, val, 8);
}

static void
cim_dio24_set09(void *_css, unsigned int val)
{
	cim_dio24_set(_css, val, 9);
}

static void
cim_dio24_set10(void *_css, unsigned int val)
{
	cim_dio24_set(_css, val, 10);
}

static void
cim_dio24_set11(void *_css, unsigned int val)
{
	cim_dio24_set(_css, val, 11);
}

static void
cim_dio24_set12(void *_css, unsigned int val)
{
	cim_dio24_set(_css, val, 12);
}

static void
cim_dio24_set13(void *_css, unsigned int val)
{
	cim_dio24_set(_css, val, 13);
}

static void
cim_dio24_set14(void *_css, unsigned int val)
{
	cim_dio24_set(_css, val, 14);
}

static void
cim_dio24_set15(void *_css, unsigned int val)
{
	cim_dio24_set(_css, val, 15);
}

static void
cim_dio24_set16(void *_css, unsigned int val)
{
	cim_dio24_set(_css, val, 16);
}

static void
cim_dio24_set17(void *_css, unsigned int val)
{
	cim_dio24_set(_css, val, 17);
}

static void
cim_dio24_set18(void *_css, unsigned int val)
{
	cim_dio24_set(_css, val, 18);
}

static void
cim_dio24_set19(void *_css, unsigned int val)
{
	cim_dio24_set(_css, val, 19);
}

static void
cim_dio24_set20(void *_css, unsigned int val)
{
	cim_dio24_set(_css, val, 20);
}

static void
cim_dio24_set21(void *_css, unsigned int val)
{
	cim_dio24_set(_css, val, 21);
}

static void
cim_dio24_set22(void *_css, unsigned int val)
{
	cim_dio24_set(_css, val, 22);
}

static void
cim_dio24_set23(void *_css, unsigned int val)
{
	cim_dio24_set(_css, val, 23);
}

static void
cim_dio24_receive(void *_css, void *_valp, unsigned int bufsize)
{
	struct cim_dio24 *css = (struct cim_dio24 *) _css;
	unsigned int *valp = (unsigned int *) _valp;
	unsigned int i;

	/*
	fprintf(stderr, "%s val=|", __FUNCTION__);
	for (i = 0; i < 24; i++) {
		fprintf(stderr, "%d|", valp[i]);
	}
	fprintf(stderr, "\n");
	*/

	for (i = 0; i < 24; i++) {
		sig_std_logic_set(css->sig->sig[i], css, valp[i]);
	}
}

void
cim_dio24_init(
	struct cim_dio24 *css,
	struct sig_dio24 *sig
)
{
	unsigned int i;
	
	for (i=0; i<24; i++) {
		css->val[i] = SIG_STD_LOGIC_Z;
	}
	
#define def_set(X) \
	static const struct sig_std_logic_funcs func ## X = { \
		.set_ext = cim_dio24_set ## X, \
	}

def_set(00);
def_set(01);
def_set(02);
def_set(03);
def_set(04);
def_set(05);
def_set(06);
def_set(07);
def_set(08);
def_set(09);
def_set(10);
def_set(11);
def_set(12);
def_set(13);
def_set(14);
def_set(15);
def_set(16);
def_set(17);
def_set(18);
def_set(19);
def_set(20);
def_set(21);
def_set(22);
def_set(23);

#undef def_set
		
	cim_connect(&css->bridge, cim_dio24_receive, css);

	css->sig = sig;

	sig_std_logic_connect_in(sig->sig[0], css, &func00);
	sig_std_logic_connect_out(sig->sig[0], css, SIG_STD_LOGIC_Z);
	sig_std_logic_connect_in(sig->sig[1], css, &func01);
	sig_std_logic_connect_out(sig->sig[1], css, SIG_STD_LOGIC_Z);
	sig_std_logic_connect_in(sig->sig[2], css, &func02);
	sig_std_logic_connect_out(sig->sig[2], css, SIG_STD_LOGIC_Z);
	sig_std_logic_connect_in(sig->sig[3], css, &func03);
	sig_std_logic_connect_out(sig->sig[3], css, SIG_STD_LOGIC_Z);
	sig_std_logic_connect_in(sig->sig[4], css, &func04);
	sig_std_logic_connect_out(sig->sig[4], css, SIG_STD_LOGIC_Z);
	sig_std_logic_connect_in(sig->sig[5], css, &func05);
	sig_std_logic_connect_out(sig->sig[5], css, SIG_STD_LOGIC_Z);
	sig_std_logic_connect_in(sig->sig[6], css, &func06);
	sig_std_logic_connect_out(sig->sig[6], css, SIG_STD_LOGIC_Z);
	sig_std_logic_connect_in(sig->sig[7], css, &func07);
	sig_std_logic_connect_out(sig->sig[7], css, SIG_STD_LOGIC_Z);
	sig_std_logic_connect_in(sig->sig[8], css, &func08);
	sig_std_logic_connect_out(sig->sig[8], css, SIG_STD_LOGIC_Z);
	sig_std_logic_connect_in(sig->sig[9], css, &func09);
	sig_std_logic_connect_out(sig->sig[9], css, SIG_STD_LOGIC_Z);
	sig_std_logic_connect_in(sig->sig[10], css, &func10);
	sig_std_logic_connect_out(sig->sig[10], css, SIG_STD_LOGIC_Z);
	sig_std_logic_connect_in(sig->sig[11], css, &func11);
	sig_std_logic_connect_out(sig->sig[11], css, SIG_STD_LOGIC_Z);
	sig_std_logic_connect_in(sig->sig[12], css, &func12);
	sig_std_logic_connect_out(sig->sig[12], css, SIG_STD_LOGIC_Z);
	sig_std_logic_connect_in(sig->sig[13], css, &func13);
	sig_std_logic_connect_out(sig->sig[13], css, SIG_STD_LOGIC_Z);
	sig_std_logic_connect_in(sig->sig[14], css, &func14);
	sig_std_logic_connect_out(sig->sig[14], css, SIG_STD_LOGIC_Z);
	sig_std_logic_connect_in(sig->sig[15], css, &func15);
	sig_std_logic_connect_out(sig->sig[15], css, SIG_STD_LOGIC_Z);
	sig_std_logic_connect_in(sig->sig[16], css, &func16);
	sig_std_logic_connect_out(sig->sig[16], css, SIG_STD_LOGIC_Z);
	sig_std_logic_connect_in(sig->sig[17], css, &func17);
	sig_std_logic_connect_out(sig->sig[17], css, SIG_STD_LOGIC_Z);
	sig_std_logic_connect_in(sig->sig[18], css, &func18);
	sig_std_logic_connect_out(sig->sig[18], css, SIG_STD_LOGIC_Z);
	sig_std_logic_connect_in(sig->sig[19], css, &func19);
	sig_std_logic_connect_out(sig->sig[19], css, SIG_STD_LOGIC_Z);
	sig_std_logic_connect_in(sig->sig[20], css, &func20);
	sig_std_logic_connect_out(sig->sig[20], css, SIG_STD_LOGIC_Z);
	sig_std_logic_connect_in(sig->sig[21], css, &func21);
	sig_std_logic_connect_out(sig->sig[21], css, SIG_STD_LOGIC_Z);
	sig_std_logic_connect_in(sig->sig[22], css, &func22);
	sig_std_logic_connect_out(sig->sig[22], css, SIG_STD_LOGIC_Z);
	sig_std_logic_connect_in(sig->sig[23], css, &func23);
	sig_std_logic_connect_out(sig->sig[23], css, SIG_STD_LOGIC_Z);
}

void
cim_dio24_create(struct cim_dio24 *css)
{
	cim_create(&css->bridge);
}

void
cim_dio24_destroy(struct cim_dio24 *css)
{
	cim_destroy(&css->bridge);
}
