/* $Id$ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __AMBIGUOUS_TYPES_HPP_INCLUDED
#define __AMBIGUOUS_TYPES_HPP_INCLUDED

#include "frontend/reporting/CompileError.hpp"

namespace ast {

//! type resolution resulted in ambigous types
/** Error class, if type resolution determined more than one possible 
 *  type for a complete context.
 */
class AmbiguousTypes : public CompileError {
public:
	//! c'tor
	/** @param ambigousNode node which resolves to ambigous types.
	 *  @param possibleTypes possible type declarations for this node.
	 *  @param msg message.
	 */
	AmbiguousTypes(
		const AstNode &ambigousNode,
		std::list<const TypeDeclaration*> possibleTypes,
		std::string msg);

protected:
	/** output error to stream
	 *  @param stream stream to write error to.
	 */
	virtual void put(std::ostream &stream) const;

	/** list of type names together with the source location. */
	std::list< std::pair<std::string, Location> > typeNames;
};

}; /* namespace ast */

#endif /* __AMBIGUOUS_TYPES_HPP_INCLUDED */
