/* $Id$
 *
 * ValDeclaration: abstract representation of a signal, variable or constant 
 *                 declaration.
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "frontend/ast/ValDeclaration.hpp"
#include <list>
#include "frontend/visitor/ResolveTypes.hpp"

namespace ast {

bool
ValDeclaration::isUnconstraint(void) const
{
	assert(this->subtypeIndic != NULL);

	switch (this->subtypeIndic->baseType) {
	case BASE_TYPE_ARRAY:
		break;

	default:
		return false;
	}

	return ! ResolveTypes::isConstraintArray(this->subtypeIndic);
}

}; /* namespace ast */
