-- $Id: proc1.vhdl 4327 2009-01-27 14:41:18Z potyra $ 

-- Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.

package t is 
	procedure foo(signal a : in boolean; signal b : out boolean);
end package t;

package body t is
	procedure foo(signal a : in boolean; signal b : out boolean) is
	begin
		b <= a after 10 ms;
	end;
end t;

entity test_bench is
end entity test_bench;

use t.all;
architecture test_bench_impl of test_bench is
	signal int_a, int_b : boolean;
begin
	p : process
	begin
		int_a <= true;
		int_b <= false;
		wait on int_a;

		foo(int_a, int_b);
		wait on int_b for 100 ms;
		assert int_b report "b must be true" severity failure;
		assert false report "simulation finished" severity note;
		wait;
	end process;
end test_bench_impl;
