-- $Id: selnames.vhdl 4326 2009-01-27 14:37:19Z potyra $ 

-- test for various different kinds of selected names.
-- the last line of this test *must* fail during parsing, because
-- selected names are getting looked up there.

-- Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.



package outer2 is
	signal foo : integer;
end package outer2;

entity outer1 is 
	signal foo : integer;

	type R1 is record
		elem1 : integer;
		elem2 : integer;
	end record;

	type R2 is record
		elem1 : integer;
		elem2 : R1;
	end record;

	type R3 is record
		elem1 : R1;
		elem2 : R2;
	end record;
end entity outer1;

architecture inner of outer1 is
	function foo (foobar : integer) return integer is
	begin
		return - foobar;
	end;
begin
	p1 : process
		variable foo : integer;
		variable bar : std.standard.boolean;
		variable vr1 : r1;
		variable vr2 : r2;
		variable vr3 : r3;
	begin
		wait on outer1.foo;
		foo := 2;
		p1.foo := 3;
		outer1.foo <= 4;
		outer2.foo <= 5;
		work.outer2.foo <= 6;
		--inner.foo <= 7; -- doesn't make sense.
		inner.p1.foo := 9;

		foo := vr1.elem1;
		foo := vr1.elem2;

		foo := vr2.elem1;
		foo := vr2.elem2.elem1;
		foo := vr2.elem2.elem2;

		--foo := vr3.elem1; -- error here!
		foo := vr3.elem1.elem1;
		foo := vr3.elem1.elem2;

		foo := vr3.elem2.elem1;
		foo := vr3.elem2.elem2.elem1;
		foo := vr3.elem2.elem2.elem2;

		foo := vr3.outer1; -- @ERROR@ Symbol 'outer1' undefined
	end process p1;
end architecture inner;
