/* $Id: fauhdlstring.h 5105 2012-02-17 21:08:43Z potyra $
 *
 * Helper functions for strings.
 *
 * Copyright (C) 2012 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */


#ifndef __FAUHDLSTRING_H
#define __FAUHDLSTRING_H

#include <stdlib.h>

/** duplicate string src using allocator to obtain memory.
 *  @param src null-terminated string to duplicate.
 *  @param allocator memory allocator (e.g. malloc).
 *  @return duplicated string.
 */
extern char *fauhdlstrdup(const char *src, void *(*allocator)(size_t));

#endif /* ! __FAUHDLSTRING_H */
