/* $Id: GetSimTime.hpp 4479 2009-04-20 16:49:31Z potyra $ 
 *
 * GetSimTime: retrieve the current simulation time.
 *
 * Copyright (C) 2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __GETSIMTIME_HPP_INCLUDED
#define __GETSIMTIME_HPP_INCLUDED

#include "intermediate/opcodes/OpCode.hpp"
#include "intermediate/operands/Operand.hpp"

namespace intermediate {

//! Retrieve the current simulation time.
/** This intermediate opcode can be used to retrieve the current simulation
 *  time.
 *
 *  Read operands: No explicit operands read.
 *  Write operands: dst.
 *
 *  Operation: store the current simulation time in dst.
 */
class GetSimTime : public OpCode {
public:
	//! c'tor
	/** @param destination destination operand.
	 */
	GetSimTime(Operand *destination) : dst(destination) {}

	//! Accept a Visitor.
 	/** All intermediate code nodes need to implement this method.
         *
         *  @param v the Visitor that can visit this node.
         */
	virtual void accept(Visitor& v) {
		v.visit(*this);
	}

	/** destination operand */
	Operand *dst;

protected:
	virtual ~GetSimTime() {
		util::MiscUtil::terminate(this->dst);
	}
};

}; /* namespace intermediate */

#endif /* __GETSIMTIME_HPP_INCLUDED */
