// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file bitmask_structTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#include "bitmask_structTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>
#include "bitmask_struct.hpp"


using namespace eprosima::fastdds::dds::xtypes;

void register_ColorBitmask_type_identifier(
        TypeIdentifierPair& type_ids_ColorBitmask)
{
    ReturnCode_t return_code_ColorBitmask {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ColorBitmask =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ColorBitmask", type_ids_ColorBitmask);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ColorBitmask)
    {
        BitmaskTypeFlag bitmask_flags_ColorBitmask = 0;
        BitBound bit_bound_ColorBitmask = 8;
        CommonEnumeratedHeader common_ColorBitmask = TypeObjectUtils::build_common_enumerated_header(bit_bound_ColorBitmask, true);
        QualifiedTypeName type_name_ColorBitmask = "ColorBitmask";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ColorBitmask;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ColorBitmask;
        AppliedAnnotationSeq tmp_ann_custom_ColorBitmask;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_ColorBitmask;
        if (!tmp_ann_custom_ColorBitmask.empty())
        {
            ann_custom_ColorBitmask = tmp_ann_custom_ColorBitmask;
        }

        CompleteTypeDetail detail_ColorBitmask = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ColorBitmask, ann_custom_ColorBitmask, type_name_ColorBitmask.to_string());
        CompleteEnumeratedHeader header_ColorBitmask = TypeObjectUtils::build_complete_enumerated_header(common_ColorBitmask, detail_ColorBitmask, true);
        CompleteBitflagSeq flag_seq_ColorBitmask;
        {
            uint16_t position_red = 0;
            BitflagFlag flags_red = 0;
            CommonBitflag common_red = TypeObjectUtils::build_common_bitflag(position_red, flags_red);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_red;
            ann_custom_ColorBitmask.reset();
            MemberName name_red = "red";
            CompleteMemberDetail detail_red = TypeObjectUtils::build_complete_member_detail(name_red, member_ann_builtin_red, ann_custom_ColorBitmask);
            CompleteBitflag bitflag_red = TypeObjectUtils::build_complete_bitflag(common_red, detail_red);
            TypeObjectUtils::add_complete_bitflag(flag_seq_ColorBitmask, bitflag_red);
        }
        {
            uint16_t position_green = 2;
            BitflagFlag flags_green = 0;
            CommonBitflag common_green = TypeObjectUtils::build_common_bitflag(position_green, flags_green);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_green;
            ann_custom_ColorBitmask.reset();
            AppliedAnnotationSeq tmp_ann_custom_green;
            if (!tmp_ann_custom_green.empty())
            {
                ann_custom_ColorBitmask = tmp_ann_custom_green;
            }
            MemberName name_green = "green";
            CompleteMemberDetail detail_green = TypeObjectUtils::build_complete_member_detail(name_green, member_ann_builtin_green, ann_custom_ColorBitmask);
            CompleteBitflag bitflag_green = TypeObjectUtils::build_complete_bitflag(common_green, detail_green);
            TypeObjectUtils::add_complete_bitflag(flag_seq_ColorBitmask, bitflag_green);
        }
        {
            uint16_t position_blue = 3;
            BitflagFlag flags_blue = 0;
            CommonBitflag common_blue = TypeObjectUtils::build_common_bitflag(position_blue, flags_blue);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_blue;
            ann_custom_ColorBitmask.reset();
            MemberName name_blue = "blue";
            CompleteMemberDetail detail_blue = TypeObjectUtils::build_complete_member_detail(name_blue, member_ann_builtin_blue, ann_custom_ColorBitmask);
            CompleteBitflag bitflag_blue = TypeObjectUtils::build_complete_bitflag(common_blue, detail_blue);
            TypeObjectUtils::add_complete_bitflag(flag_seq_ColorBitmask, bitflag_blue);
        }
        {
            uint16_t position_yellow = 5;
            BitflagFlag flags_yellow = 0;
            CommonBitflag common_yellow = TypeObjectUtils::build_common_bitflag(position_yellow, flags_yellow);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_yellow;
            ann_custom_ColorBitmask.reset();
            AppliedAnnotationSeq tmp_ann_custom_yellow;
            if (!tmp_ann_custom_yellow.empty())
            {
                ann_custom_ColorBitmask = tmp_ann_custom_yellow;
            }
            MemberName name_yellow = "yellow";
            CompleteMemberDetail detail_yellow = TypeObjectUtils::build_complete_member_detail(name_yellow, member_ann_builtin_yellow, ann_custom_ColorBitmask);
            CompleteBitflag bitflag_yellow = TypeObjectUtils::build_complete_bitflag(common_yellow, detail_yellow);
            TypeObjectUtils::add_complete_bitflag(flag_seq_ColorBitmask, bitflag_yellow);
        }
        CompleteBitmaskType bitmask_type_ColorBitmask = TypeObjectUtils::build_complete_bitmask_type(bitmask_flags_ColorBitmask, header_ColorBitmask, flag_seq_ColorBitmask);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_bitmask_type_object(bitmask_type_ColorBitmask,
                    type_name_ColorBitmask.to_string(), type_ids_ColorBitmask))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "ColorBitmask already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_BitmaskStruct_type_identifier(
        TypeIdentifierPair& type_ids_BitmaskStruct)
{

    ReturnCode_t return_code_BitmaskStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_BitmaskStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "BitmaskStruct", type_ids_BitmaskStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_BitmaskStruct)
    {
        StructTypeFlag struct_flags_BitmaskStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_BitmaskStruct = "BitmaskStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_BitmaskStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_BitmaskStruct;
        AppliedAnnotationSeq tmp_ann_custom_BitmaskStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_BitmaskStruct;
        if (!tmp_ann_custom_BitmaskStruct.empty())
        {
            ann_custom_BitmaskStruct = tmp_ann_custom_BitmaskStruct;
        }

        CompleteTypeDetail detail_BitmaskStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_BitmaskStruct, ann_custom_BitmaskStruct, type_name_BitmaskStruct.to_string());
        CompleteStructHeader header_BitmaskStruct;
        header_BitmaskStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_BitmaskStruct);
        CompleteStructMemberSeq member_seq_BitmaskStruct;
        {
            TypeIdentifierPair type_ids_my_bitmask;
            ReturnCode_t return_code_my_bitmask {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_bitmask =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "ColorBitmask", type_ids_my_bitmask);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_bitmask)
            {
            ::register_ColorBitmask_type_identifier(type_ids_my_bitmask);
            }
            StructMemberFlag member_flags_my_bitmask = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_bitmask = 0x00000000;
            bool common_my_bitmask_ec {false};
            CommonStructMember common_my_bitmask {TypeObjectUtils::build_common_struct_member(member_id_my_bitmask, member_flags_my_bitmask, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_bitmask, common_my_bitmask_ec))};
            if (!common_my_bitmask_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_bitmask member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_bitmask = "my_bitmask";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_bitmask;
            ann_custom_BitmaskStruct.reset();
            CompleteMemberDetail detail_my_bitmask = TypeObjectUtils::build_complete_member_detail(name_my_bitmask, member_ann_builtin_my_bitmask, ann_custom_BitmaskStruct);
            CompleteStructMember member_my_bitmask = TypeObjectUtils::build_complete_struct_member(common_my_bitmask, detail_my_bitmask);
            TypeObjectUtils::add_complete_struct_member(member_seq_BitmaskStruct, member_my_bitmask);
        }
        CompleteStructType struct_type_BitmaskStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_BitmaskStruct, header_BitmaskStruct, member_seq_BitmaskStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_BitmaskStruct, type_name_BitmaskStruct.to_string(), type_ids_BitmaskStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "BitmaskStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
