# frozen_string_literal: true

describe Facts::Linux::Processors::Physicalcount do
  describe '#call_the_resolver' do
    subject(:fact) { Facts::Linux::Processors::Physicalcount.new }

    let(:physical_count) { '2' }

    before do
      allow(Facter::Resolvers::Linux::Processors).to \
        receive(:resolve).with(:physical_count).and_return(physical_count)
    end

    it 'returns processors physical count fact' do
      expect(fact.call_the_resolver).to be_an_instance_of(Array).and \
        contain_exactly(an_object_having_attributes(name: 'processors.physicalcount', value: physical_count),
                        an_object_having_attributes(name: 'physicalprocessorcount',
                                                    value: physical_count,
                                                    type: :legacy))
    end
  end
end
