/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.startup;

import java.awt.Container;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.BevelBorder;

public class ProgList {
    private String[] allProgs;
    private String[] allDescription;
    private int numProgs = 0;
    private int nm;
    private int npG;
    private JMenuItem[] mItem;
    private Font menuFont = new Font("SansSerif", 1, 11);
    private Hashtable programGroup = new Hashtable();

    public ProgList(String woss, JMenuBar menuBar) {
        String line;
        int numGroups = 0;
        int numMenuItems = 0;
        try {
            HashMap<String, String> progDescs = new HashMap<String, String>();
            BufferedReader in = new BufferedReader(new StringReader(woss));
            while ((line = in.readLine()) != null) {
                ++numGroups;
                while ((line = in.readLine()) != null && !(line = line.trim()).equals("")) {
                    ++numMenuItems;
                    int split = line.indexOf(" ");
                    int len = line.length();
                    String progname = line.substring(0, split);
                    if (progDescs.containsKey(progname)) continue;
                    String progdesc = line.substring(split + 1, len).trim();
                    progDescs.put(progname, progdesc);
                }
            }
            in.close();
            this.numProgs = progDescs.size();
            this.allProgs = progDescs.keySet().toArray(new String[this.numProgs]);
            Arrays.sort(this.allProgs, 0, this.numProgs);
            this.allDescription = new String[this.numProgs];
            for (int i = 0; i < this.numProgs; ++i) {
                this.allDescription[i] = (String)progDescs.get(this.allProgs[i]);
            }
        }
        catch (IOException e) {
            System.out.println("Cannot read wossname string");
        }
        HorizontalMenu[] primaryGroups = new HorizontalMenu[numGroups];
        JMenu[] secondaryGroups = new JMenu[numGroups];
        this.mItem = new JMenuItem[numMenuItems];
        this.npG = 0;
        this.nm = 0;
        try {
            String groups;
            String sg = "";
            int nsG = 0;
            int start = 0;
            BufferedReader in = new BufferedReader(new StringReader(woss));
            while ((groups = in.readLine()) != null) {
                int j;
                String pg;
                if ((groups = groups.trim()).equals("")) continue;
                int index = groups.indexOf(":");
                boolean sexist = false;
                if (index > 0) {
                    pg = groups.substring(0, index);
                    sg = groups.substring(index + 1, groups.length());
                    sexist = true;
                } else {
                    pg = groups;
                }
                boolean exist = false;
                for (j = 0; j < this.npG; ++j) {
                    if (!pg.equalsIgnoreCase(primaryGroups[j].getText())) continue;
                    exist = true;
                    index = j;
                    break;
                }
                if (!exist) {
                    primaryGroups[this.npG] = new HorizontalMenu(pg);
                    primaryGroups[this.npG].setBorder(new BevelBorder(0));
                    menuBar.add(primaryGroups[this.npG]);
                    index = this.npG++;
                }
                exist = false;
                if (sexist) {
                    for (j = start; j < nsG; ++j) {
                        if (!sg.equalsIgnoreCase(secondaryGroups[j].getText())) continue;
                        exist = true;
                        index = j;
                        break;
                    }
                    if (!exist) {
                        secondaryGroups[nsG] = new JMenu(sg);
                        secondaryGroups[nsG].setFont(this.menuFont);
                        primaryGroups[index].add(secondaryGroups[nsG]);
                        index = nsG++;
                    }
                }
                while ((line = in.readLine()) != null && !line.equals("")) {
                    int split = line.indexOf(" ");
                    int app = 0;
                    if (split < 0) {
                        System.out.println("WARNING SKIPPING : " + line);
                        continue;
                    }
                    String p = line.substring(0, split);
                    for (int i = 0; i < this.numProgs; ++i) {
                        if (!p.equalsIgnoreCase(this.allProgs[i])) continue;
                        this.programGroup.put(this.allProgs[i], groups);
                        app = i;
                        break;
                    }
                    this.mItem[this.nm] = new JMenuItem(p + "   " + this.allDescription[app]);
                    this.mItem[this.nm].setFont(this.menuFont);
                    if (!sexist) {
                        primaryGroups[index].add(this.mItem[this.nm]);
                    } else {
                        secondaryGroups[index].add(this.mItem[this.nm]);
                    }
                    ++this.nm;
                }
                start = nsG;
            }
            in.close();
        }
        catch (IOException ex) {
            System.out.println("Cannot open EMBOSS acd file ");
        }
    }

    public int getNumProgs() {
        return this.numProgs;
    }

    public String[] getProgsList() {
        return this.allProgs;
    }

    public String[] getProgDescription() {
        return this.allDescription;
    }

    public String getProgramGroup(String app) {
        if (this.programGroup.containsKey(app)) {
            return (String)this.programGroup.get(app);
        }
        return null;
    }

    public void writeList() {
        for (int i = 0; i < this.allProgs.length; ++i) {
            System.out.println(this.allProgs[i]);
        }
    }

    public JMenuItem[] getMenuItems() {
        return this.mItem;
    }

    public int getNumberMenuItems() {
        return this.nm;
    }

    public int getNumPrimaryGroups() {
        return this.npG;
    }

    class HorizontalMenu
    extends JMenu {
        HorizontalMenu(String label) {
            super(label);
            JPopupMenu pm = this.getPopupMenu();
            pm.setLayout(new BoxLayout(pm, 1));
            this.setFont(ProgList.this.menuFont);
            this.setMinimumSize(this.getPreferredSize());
        }

        public void setPopupMenuVisible(boolean b) {
            boolean isVisible = this.isPopupMenuVisible();
            if (b != isVisible) {
                if (b && this.isShowing()) {
                    int x = 0;
                    int y = 0;
                    Container parent = this.getParent();
                    if (parent instanceof JPopupMenu) {
                        x = 0;
                        y = this.getHeight();
                    } else {
                        x = this.getWidth();
                        y = 0;
                    }
                    this.getPopupMenu().show(this, x, y);
                } else {
                    this.getPopupMenu().setVisible(false);
                }
            }
        }
    }
}

