/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import org.emboss.jemboss.editor.Sequence;

public class SequenceNameJButton
extends JToggleButton {
    private int boundWidth = 6;
    private int fontSize = 12;
    private String nameLabel;
    private int ypad = 0;
    private Font font = new Font("Monospaced", 0, this.fontSize);

    public SequenceNameJButton(Sequence seq, int ypad) {
        this.ypad = ypad;
        this.nameLabel = seq.getID().equals("") ? new String("") : (seq.getLength() > 0 ? new String(seq.getID() + "/" + Integer.toString(seq.getLength())) : new String(seq.getID()));
        this.setText(this.nameLabel);
        this.setBackground(Color.white);
        this.setHorizontalTextPosition(4);
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setFont(this.font);
        this.setBorderPainted(false);
    }

    public void setFontSize(int size) {
        this.fontSize = size;
        this.font = new Font("Monospaced", 0, this.fontSize);
        this.setMaximumSize(this.getPreferredSize());
        this.setMinimumSize(this.getPreferredSize());
        this.setFont(this.font);
    }

    public Font getFont() {
        return this.font;
    }

    public int getPanelWidth() {
        FontMetrics metrics = this.getFontMetrics(this.font);
        return metrics.stringWidth(this.nameLabel) + this.boundWidth + 10;
    }

    public int getPanelHeight() {
        FontMetrics metrics = this.getFontMetrics(this.font);
        this.boundWidth = metrics.stringWidth("A");
        return metrics.stringWidth("A") + this.boundWidth;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getPanelWidth(), this.getPanelHeight() + this.ypad);
    }
}

