/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.emboss.jemboss.editor.GraphicSequenceCollection;
import org.emboss.jemboss.editor.Matrix;
import org.emboss.jemboss.editor.Sequence;

public class PlotConsensus
extends JPanel {
    private float[] sumscore;
    private int numbins;
    private int interval;
    private float ymin = 0.0f;
    private float ymax = 0.0f;
    private GraphicSequenceCollection viewPane = null;

    public PlotConsensus(File matrixFile, Vector seqs, int winsize, int interval, GraphicSequenceCollection viewPane) {
        this.interval = interval;
        this.viewPane = viewPane;
        System.out.println("viewPane ");
        Matrix mat = new Matrix(matrixFile);
        this.createPlot(mat, seqs, winsize);
    }

    public PlotConsensus(File matrixFile, Vector seqs, int winsize, int interval) {
        this.interval = interval;
        Matrix mat = new Matrix(matrixFile);
        this.createPlot(mat, seqs, winsize);
    }

    public PlotConsensus(String matrixJar, String matrixFileName, Vector seqs, int winsize, int interval) {
        this(new Matrix(matrixJar, matrixFileName), seqs, winsize, interval);
    }

    public PlotConsensus(Matrix mat, Vector seqs, int winsize, int interval, GraphicSequenceCollection viewPane) {
        this.viewPane = viewPane;
        this.interval = interval;
        this.createPlot(mat, seqs, winsize);
    }

    public PlotConsensus(Matrix mat, Vector seqs, int winsize, int interval) {
        this.interval = interval;
        this.createPlot(mat, seqs, winsize);
    }

    private void createPlot(Matrix mat, Vector seqs, int winsize) {
        int mseq;
        int[][] matrix = mat.getMatrix();
        int numseq = seqs.size();
        this.numbins = mseq = this.getMaxSequenceLength(seqs);
        this.sumscore = new float[this.numbins];
        int bin2 = winsize / 2;
        float[][] score = new float[numseq][mseq];
        for (int k = 0; k < mseq; ++k) {
            for (int i = 0; i < numseq; ++i) {
                String s1 = this.getResidue(seqs, i, k);
                int m1 = mat.getMatrixIndex(s1);
                for (int j = i + 1; j < numseq; ++j) {
                    String s2 = this.getResidue(seqs, j, k);
                    int m2 = mat.getMatrixIndex(s2);
                    if (m1 < 0 || m2 < 0) continue;
                    float contrj = (float)matrix[m1][m2] * this.getSequenceWeight(seqs, j) + score[i][k];
                    float contri = (float)matrix[m1][m2] * this.getSequenceWeight(seqs, i) + score[j][k];
                    score[i][k] = contrj;
                    score[j][k] = contri;
                }
            }
            if (k < winsize - 1) continue;
            int binup = k + 1;
            int binlo = k - winsize + 1;
            int binmid = binlo + bin2;
            for (int i = 0; i < numseq; ++i) {
                for (int bin = binlo; bin < binup; ++bin) {
                    int n = binmid;
                    this.sumscore[n] = this.sumscore[n] + score[i][bin];
                }
            }
        }
        for (int bin = 0; bin < this.numbins; ++bin) {
            this.sumscore[bin] = this.sumscore[bin] / (float)(numseq * (numseq - 1) * winsize * winsize);
            if (this.ymax < this.sumscore[bin]) {
                this.ymax = this.sumscore[bin];
            }
            if (!(this.ymin > this.sumscore[bin])) continue;
            this.ymin = this.sumscore[bin];
        }
        this.setPlotSize();
    }

    public void setPlotSize() {
        this.setPreferredSize(new Dimension(this.numbins * this.interval, (int)(this.ymax - this.ymin + 1.0f) * this.interval));
    }

    public String getResidue(Vector seqs, int i, int k) {
        String res = "-";
        try {
            res = ((Sequence)seqs.get(i)).getSequence().substring(k, k + 1);
        }
        catch (StringIndexOutOfBoundsException sexp) {
            // empty catch block
        }
        return res;
    }

    public float getSequenceWeight(Vector seqs, int i) {
        return ((Sequence)seqs.get(i)).getWeight();
    }

    public int getMaxSequenceLength(Vector seqs) {
        int len = 0;
        Enumeration enumer = seqs.elements();
        while (enumer.hasMoreElements()) {
            Sequence seq = (Sequence)enumer.nextElement();
            if (len >= seq.getLength()) continue;
            len = seq.getLength();
        }
        return len;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        float scale = 2.0f / (this.ymax - this.ymin);
        float ytop = scale * this.ymax * (float)this.interval;
        int istart = 0;
        int istop = this.numbins;
        if (this.viewPane != null) {
            Rectangle viewRect = this.viewPane.getViewRect();
            istart = viewRect.x / this.interval - 2;
            if (istart < 0) {
                istart = 0;
            }
            if ((istop = istart + viewRect.width / this.interval + 4) > this.numbins) {
                istop = this.numbins;
            }
        }
        g.setColor(Color.lightGray);
        g.drawLine(0, (int)(scale * this.ymax * (float)this.interval), this.numbins * this.interval, (int)(scale * this.ymax * (float)this.interval));
        g.setColor(Color.red);
        int bin = istart;
        while (bin + 1 < istop) {
            int y1 = (int)(ytop - scale * this.sumscore[bin] * (float)this.interval);
            int y2 = (int)(ytop - scale * this.sumscore[bin + 1] * (float)this.interval);
            g.drawLine((int)(((double)bin + 0.5) * (double)this.interval), y1, (int)(((double)bin + 1.5) * (double)this.interval), y2);
            ++bin;
        }
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public static void main(String[] args) {
        Vector<Sequence> seqs = new Vector<Sequence>();
        seqs.add(new Sequence("MHQDGISSMNQLGGLFVNGRP"));
        seqs.add(new Sequence("-MQNSHSGVNQLGGVFVNGRP"));
        seqs.add(new Sequence("STPLGQGRVNQLGGVFINGRP"));
        seqs.add(new Sequence("STPLGQGRVNQLGGVFINGRP"));
        seqs.add(new Sequence("-MEQTYGEVNQLGGVFVNGRP"));
        int wsize = 2;
        int interval = 10;
        Matrix mat = new Matrix("resources/resources.jar", "EDNAFULL");
        PlotConsensus pc = new PlotConsensus(mat, seqs, wsize, interval);
        JFrame f = new JFrame("Plot Consensus");
        JPanel pane = (JPanel)f.getContentPane();
        pane.add(pc);
        pane.setPreferredSize(pc.getPreferredSize());
        f.setSize(pc.getPreferredSize());
        f.pack();
        f.setVisible(true);
    }
}

