/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.table.TableColumn;
import org.emboss.jemboss.editor.PrintableJTable;
import org.emboss.jemboss.editor.Sequence;

public class IDTableJFrame
extends JFrame {
    private PrintableJTable idTable = new PrintableJTable();

    public IDTableJFrame(Vector vseq) {
        super("Percentatge ID");
        int nseq = vseq.size();
        Font font = this.idTable.getFont();
        FontMetrics fm = this.idTable.getFontMetrics(font);
        int max_width = 0;
        String[] columnNames = new String[nseq + 1];
        Object[][] rowData = new Object[nseq][nseq + 1];
        columnNames[0] = new String("");
        for (int i = 0; i < nseq; ++i) {
            Sequence s1 = (Sequence)vseq.get(i);
            int len1 = s1.getLength();
            String s1Name = s1.getName();
            int w = fm.stringWidth(s1Name + "  ");
            if (w > max_width) {
                max_width = w;
            }
            columnNames[i + 1] = s1Name;
            rowData[i][0] = s1Name;
            if (s1Name.equals("Consensus")) continue;
            for (int j = i; j < nseq; ++j) {
                Sequence s2 = (Sequence)vseq.get(j);
                if (s2.getName().equals("Consensus")) continue;
                int id = 0;
                int len2 = s2.getLength();
                if (len2 > len1) {
                    len1 = len2;
                }
                for (int p = 0; p < len1; ++p) {
                    try {
                        if (!s1.getResidueAt(p).equals(s2.getResidueAt(p))) continue;
                        ++id;
                        continue;
                    }
                    catch (StringIndexOutOfBoundsException outBounds) {
                        System.out.println("Sequences have different length!");
                    }
                }
                float percent = Math.round((float)id / (float)len1 * 10000.0f);
                rowData[i][j + 1] = new Float(percent / 100.0f);
            }
        }
        this.idTable = new PrintableJTable(rowData, columnNames);
        TableColumn column = null;
        column = this.idTable.getColumnModel().getColumn(0);
        column.setPreferredWidth(max_width);
        for (int i = 0; i < nseq; ++i) {
            column = this.idTable.getColumnModel().getColumn(i + 1);
            String name = this.idTable.getColumnName(i + 1);
            int wid = fm.stringWidth(name + "  ");
            column.setPreferredWidth(wid);
        }
        this.idTable.setAutoResizeMode(0);
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        JMenuItem printMenu = new JMenuItem("Print");
        printMenu.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        printMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IDTableJFrame.this.idTable.doPrintActions();
            }
        });
        fileMenu.add(printMenu);
        fileMenu.add(new JSeparator());
        JMenuItem fileMenuExit = new JMenuItem("Close");
        fileMenuExit.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        fileMenuExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IDTableJFrame.this.setVisible(false);
            }
        });
        fileMenu.add(fileMenuExit);
        menuBar.add(fileMenu);
        this.setJMenuBar(menuBar);
        JScrollPane scrollTable = new JScrollPane(this.idTable);
        scrollTable.setPreferredSize(this.idTable.getPreferredSize());
        this.getContentPane().add(scrollTable);
        this.pack();
    }

    protected void printTable() {
        int ncol = this.idTable.getColumnCount();
        int nrow = this.idTable.getRowCount();
        for (int i = 0; i < nrow; ++i) {
            for (int j = 0; j < ncol; ++j) {
                Object val = this.idTable.getValueAt(i, j);
                if (val == null) {
                    val = "-";
                }
                System.out.print(val + "\t");
            }
            System.out.print("\n");
        }
    }
}

