/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import org.emboss.jemboss.editor.AlignJFrame;
import org.emboss.jemboss.editor.ColourMenu;
import org.emboss.jemboss.editor.ColourPanel;
import org.emboss.jemboss.gui.ScrollPanel;

public class ColourJFrame
extends JFrame {
    private Box YBox = new Box(1);
    private Hashtable colourTable;
    private JScrollPane jspColour;
    private AlignJFrame align;

    public ColourJFrame(AlignJFrame align) {
        super("Colour");
        this.align = align;
        JPanel mainPane = (JPanel)this.getContentPane();
        mainPane.setLayout(new BorderLayout());
        ScrollPanel mainColourPanel = new ScrollPanel(new BorderLayout());
        mainColourPanel.add(this.YBox);
        this.jspColour = new JScrollPane(mainColourPanel);
        mainPane.add(this.jspColour);
        mainColourPanel.setBackground(Color.white);
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        fileMenu.add(new JSeparator());
        JMenuItem fileMenuExit = new JMenuItem("Close");
        fileMenuExit.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        fileMenuExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ColourJFrame.this.setVisible(false);
            }
        });
        fileMenu.add(fileMenuExit);
        menuBar.add(fileMenu);
        this.setJMenuBar(menuBar);
        this.setSize(70, 150);
    }

    public void setCurrentColour(Hashtable colourTable) {
        this.colourTable = colourTable;
        this.YBox.removeAll();
        Enumeration enumer = colourTable.keys();
        while (enumer.hasMoreElements()) {
            String res = (String)enumer.nextElement();
            Box XBox = new Box(0);
            JLabel residueField = new JLabel(res);
            residueField.setPreferredSize(new Dimension(20, 20));
            residueField.setMaximumSize(new Dimension(20, 20));
            XBox.add(residueField);
            ResidueColourPanel colPane = new ResidueColourPanel(res, (Color)colourTable.get(res));
            XBox.add(colPane);
            this.YBox.add(XBox);
        }
        this.YBox.add(Box.createVerticalGlue());
        this.jspColour.getViewport().setViewPosition(new Point(0, 0));
    }

    public Hashtable getCurrentColourScheme() {
        return this.colourTable;
    }

    class ResidueColourPanel
    extends ColourPanel {
        private String res;

        public ResidueColourPanel(String res, Color col) {
            super(res + " Colour", col);
            this.res = res;
        }

        public void actionPerformed(ActionEvent e) {
            ColourMenu m = (ColourMenu)e.getSource();
            this.col = m.getColor();
            this.repaint();
            ColourJFrame.this.colourTable.remove(this.res);
            ColourJFrame.this.colourTable.put(this.res, this.col);
            ColourJFrame.this.align.repaintSequences(ColourJFrame.this.colourTable);
        }
    }
}

