/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.draw;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.emboss.jemboss.draw.DNADraw;
import org.emboss.jemboss.gui.ScrollPanel;

public class PrintDNAImage
extends ScrollPanel {
    private PageFormat format = null;
    private DNADraw dna;
    private JTextField statusField = new JTextField("");
    private String type;

    public PrintDNAImage(DNADraw dna) {
        this.dna = dna;
        this.setBackground(Color.white);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g.create();
        this.dna.drawAll(g2d, true);
    }

    public void print() {
        if (this.format == null) {
            this.getFormatDialog();
        }
        try {
            File fsave = this.showOptions();
            if (fsave == null) {
                return;
            }
            RenderedImage rendImage = this.createDNAImage(0);
            this.writeImageToFile(rendImage, fsave, this.type);
        }
        catch (NoClassDefFoundError ex) {
            JOptionPane.showMessageDialog(this, "This option requires Java 1.4 or higher.");
        }
    }

    protected PageFormat getFormatDialog() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        this.format = new PageFormat();
        this.format = printerJob.pageDialog(this.format);
        return this.format;
    }

    private RenderedImage createDNAImage(int pageIndex) {
        int width = (int)this.format.getWidth();
        int height = (int)this.format.getHeight();
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.setColor(Color.white);
        g2d.fillRect(0, 0, width, height);
        this.dna.drawAll(g2d, true);
        return bufferedImage;
    }

    protected void printPreview() {
        Border loweredbevel = BorderFactory.createLoweredBevelBorder();
        Border raisedbevel = BorderFactory.createRaisedBevelBorder();
        CompoundBorder compound = BorderFactory.createCompoundBorder(raisedbevel, loweredbevel);
        this.statusField.setBorder(compound);
        this.statusField.setEditable(false);
        if (this.format == null) {
            this.format = this.getFormatDialog();
        }
        this.statusField.setText("DNA map");
        final JFrame f = new JFrame("Print Preview");
        JPanel jpane = (JPanel)f.getContentPane();
        JScrollPane scrollPane = new JScrollPane(this);
        jpane.setLayout(new BorderLayout());
        jpane.add((Component)scrollPane, "Center");
        jpane.add((Component)this.statusField, "South");
        Dimension d = new Dimension((int)this.format.getWidth(), (int)this.format.getHeight());
        this.setPreferredSize(d);
        f.setSize(d);
        JMenuBar menuBar = new JMenuBar();
        JMenu filemenu = new JMenu("File");
        menuBar.add(filemenu);
        JMenu printMenu = new JMenu("Print");
        filemenu.add(printMenu);
        JMenuItem print = new JMenuItem("Print Postscript...");
        print.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintDNAImage.this.dna.doPrintActions();
            }
        });
        printMenu.add(print);
        JMenuItem printImage = new JMenuItem("Print png/jpeg Image...");
        printImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintDNAImage.this.print();
            }
        });
        printMenu.add(printImage);
        filemenu.add(new JSeparator());
        JMenuItem menuClose = new JMenuItem("Close");
        menuClose.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        filemenu.add(menuClose);
        menuClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                f.dispose();
            }
        });
        f.setJMenuBar(menuBar);
        f.setVisible(true);
    }

    private File showOptions() {
        String cwd = System.getProperty("user.dir");
        JFileChooser fc = new JFileChooser(cwd);
        File fselect = new File(cwd + System.getProperty("file.separator") + "dna_image.jpeg");
        fc.setSelectedFile(fselect);
        Box bdown = Box.createVerticalBox();
        bdown.add(Box.createVerticalGlue());
        JLabel labFormat = new JLabel("Select Format:");
        Font font = labFormat.getFont();
        labFormat.setFont(font.deriveFont(1));
        bdown.add(labFormat);
        Box bacross = Box.createHorizontalBox();
        JComboBox<String> formatSelect = new JComboBox<String>(ImageIO.getWriterFormatNames());
        Dimension d = formatSelect.getPreferredSize();
        formatSelect.setMaximumSize(d);
        bacross.add(Box.createHorizontalGlue());
        bacross.add(formatSelect);
        bdown.add(bacross);
        fc.setAccessory(bdown);
        int n = fc.showSaveDialog(null);
        if (n == 1) {
            return null;
        }
        this.type = (String)formatSelect.getSelectedItem();
        return fc.getSelectedFile();
    }

    private void writeImageToFile(RenderedImage image, File file, String type) {
        try {
            ImageIO.write(image, type, file);
        }
        catch (IOException e) {
            System.out.println("Java 1.4+ is required");
        }
    }
}

