/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.io.AlignFile;
import jalview.io.FileParse;
import jalview.io.ModellerDescription;
import jalview.util.Comparison;
import java.io.IOException;
import java.util.Vector;

public class PIRFile
extends AlignFile {
    public static boolean useModellerOutput = false;
    Vector words = new Vector();

    public PIRFile() {
    }

    public PIRFile(String inFile, String type) throws IOException {
        super(inFile, type);
    }

    public PIRFile(FileParse source) throws IOException {
        super(source);
    }

    public void parse() throws IOException {
        String line = null;
        while ((line = this.nextLine()) != null) {
            if (line.length() == 0 || line.indexOf("C;") == 0 || line.indexOf("#") == 0) continue;
            Sequence newSeq = this.parseId(line.substring(line.indexOf(";") + 1));
            StringBuffer sequence = new StringBuffer();
            newSeq.setDescription(this.nextLine());
            boolean starFound = false;
            while (!starFound) {
                line = this.nextLine();
                sequence.append(line);
                if (line == null) break;
                if (line.indexOf("*") <= -1) continue;
                starFound = true;
            }
            if (sequence.length() <= 0) continue;
            sequence.setLength(sequence.length() - 1);
            newSeq.setSequence(sequence.toString());
            this.seqs.addElement(newSeq);
            ModellerDescription md = new ModellerDescription(newSeq.getDescription());
            md.updateSequenceI(newSeq);
        }
    }

    public String print() {
        return this.print(this.getSeqsAsArray());
    }

    public String print(SequenceI[] s) {
        boolean is_NA = Comparison.isNucleotide(s);
        int len = 72;
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < s.length && s[i] != null; ++i) {
            String seq = s[i].getSequenceAsString();
            seq = seq + "*";
            if (is_NA) {
                out.append(">N1;" + s[i].getName() + "\n");
                if (s[i].getDescription() == null) {
                    out.append(s[i].getName() + " " + (s[i].getEnd() - s[i].getStart() + 1));
                    out.append(is_NA ? " bases\n" : " residues\n");
                } else {
                    out.append(s[i].getDescription() + "\n");
                }
            } else if (useModellerOutput) {
                out.append(">P1;" + s[i].getName() + "\n");
                ModellerDescription md = new ModellerDescription(s[i]);
                out.append(md.getDescriptionLine() + "\n");
            } else {
                out.append(">P1;" + this.printId(s[i]) + "\n");
                if (s[i].getDescription() != null) {
                    out.append(s[i].getDescription() + "\n");
                } else {
                    out.append(s[i].getName() + " " + (s[i].getEnd() - s[i].getStart() + 1) + " residues\n");
                }
            }
            int nochunks = seq.length() / len + 1;
            for (int j = 0; j < nochunks; ++j) {
                int start = j * len;
                int end = start + len;
                if (end < seq.length()) {
                    out.append(seq.substring(start, end) + "\n");
                    continue;
                }
                if (start >= seq.length()) continue;
                out.append(seq.substring(start) + "\n");
            }
        }
        return out.toString();
    }
}

