/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.io.AppletFormatAdapter;
import jalview.io.FileParse;

public class IdentifyFile {
    public String Identify(String file, String protocol) {
        String emessage = "UNIDENTIFIED FILE PARSING ERROR";
        FileParse parser = null;
        try {
            parser = new FileParse(file, protocol);
            if (parser.isValid()) {
                return this.Identify(parser);
            }
        }
        catch (Exception e) {
            System.err.println("Error whilst identifying");
            e.printStackTrace(System.err);
            emessage = e.getMessage();
        }
        if (parser != null) {
            return parser.errormessage;
        }
        return emessage;
    }

    public String Identify(FileParse source) {
        return this.Identify(source, true);
    }

    public String Identify(FileParse source, boolean closeSource) {
        String reply = "PFAM";
        int length = 0;
        boolean lineswereskipped = false;
        boolean isBinary = false;
        try {
            String data;
            if (!closeSource) {
                source.mark();
            }
            while ((data = source.nextLine()) != null) {
                length += data.length();
                if (!lineswereskipped) {
                    for (int i = 0; !isBinary && i < data.length(); ++i) {
                        char c = data.charAt(i);
                        isBinary = c < ' ' && c != '\t' && c != '\n' && c != '\r' && c != '\u0005' && c != '\u001b';
                    }
                }
                if (isBinary) {
                    String fileStr;
                    if (source.inFile != null && ((fileStr = source.inFile.getName()).lastIndexOf(".jar") > -1 || fileStr.lastIndexOf(".zip") > -1)) {
                        reply = "Jalview";
                    }
                    if (!lineswereskipped && data.startsWith("PK")) {
                        reply = "Jalview";
                        break;
                    }
                }
                if ((data = data.toUpperCase()).indexOf("# STOCKHOLM") > -1) {
                    reply = "STH";
                    break;
                }
                if (data.length() < 1 || data.indexOf("#") == 0) {
                    lineswereskipped = true;
                    continue;
                }
                if (data.indexOf("PILEUP") > -1) {
                    reply = "PileUp";
                    break;
                }
                if (data.indexOf("//") == 0 || data.indexOf("!!") > -1 && data.indexOf("!!") < data.indexOf("_MULTIPLE_ALIGNMENT ")) {
                    reply = "MSF";
                    break;
                }
                if (data.indexOf("CLUSTAL") > -1) {
                    reply = "CLUSTAL";
                    break;
                }
                if (data.indexOf(">P1;") > -1 || data.indexOf(">DL;") > -1) {
                    reply = "PIR";
                    break;
                }
                if (data.indexOf(">") > -1) {
                    data = source.nextLine();
                    if (data.indexOf(">") > -1) {
                        reply = "BLC";
                        break;
                    }
                    source.nextLine();
                    String data2 = source.nextLine();
                    if (data2 != null && data.indexOf("*") > -1 && data.indexOf("*") == data2.indexOf("*")) {
                        reply = "BLC";
                        break;
                    }
                    reply = "FASTA";
                    break;
                }
                if (data.indexOf("HEADER") == 0 || data.indexOf("ATOM") == 0) {
                    reply = "PDB";
                    break;
                }
                if (!lineswereskipped && data.charAt(0) != '*' && data.charAt(0) != ' ' && data.indexOf(":") < data.indexOf(",")) {
                    reply = "JnetFile";
                    break;
                }
                lineswereskipped = true;
            }
            if (closeSource) {
                source.close();
            } else {
                source.reset();
            }
        }
        catch (Exception ex) {
            System.err.println("File Identification failed!\n" + ex);
            return source.errormessage;
        }
        if (length == 0) {
            System.err.println("File Identification failed! - Empty file was read.");
            return "EMPTY DATA FILE";
        }
        return reply;
    }

    public static void main(String[] args) {
        for (int i = 0; args != null && i < args.length; ++i) {
            IdentifyFile ider = new IdentifyFile();
            String type = ider.Identify(args[i], AppletFormatAdapter.FILE);
            System.out.println("Type of " + args[i] + " is " + type);
        }
        if (args == null || args.length == 0) {
            System.err.println("Usage: <Filename> [<Filename> ...]");
        }
    }
}

