/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.Mapping;
import jalview.datamodel.SearchResults;
import jalview.datamodel.SequenceI;
import jalview.util.MapList;
import java.util.Enumeration;
import java.util.Vector;

public class AlignedCodonFrame {
    public int[][] codons = null;
    public int aaWidth = 0;
    Vector a_aaSeqs = new Vector();
    SequenceI[] dnaSeqs = null;
    Mapping[] dnaToProt = null;

    public AlignedCodonFrame(int aWidth) {
        if (aWidth <= 0) {
            this.codons = null;
            return;
        }
        this.codons = new int[aWidth][];
        for (int res = 0; res < aWidth; ++res) {
            this.codons[res] = null;
        }
    }

    public int[][] checkCodonFrameWidth(int aslen) {
        if (this.codons.length <= aslen + 1) {
            int[][] c = new int[this.codons.length + 10][];
            for (int i = 0; i < this.codons.length; ++i) {
                c[i] = this.codons[i];
                this.codons[i] = null;
            }
            this.codons = c;
        }
        return this.codons;
    }

    public int getaaWidth() {
        return this.aaWidth;
    }

    public void insertAAGap(int aspos, char gapCharacter) {
        ++this.aaWidth;
        if (this.a_aaSeqs != null) {
            Enumeration sq = this.a_aaSeqs.elements();
            while (sq.hasMoreElements()) {
                ((SequenceI)sq.nextElement()).insertCharAt(aspos, gapCharacter);
            }
        }
        this.checkCodonFrameWidth(aspos);
        if (aspos < this.aaWidth) {
            ++this.aaWidth;
            System.arraycopy(this.codons, aspos, this.codons, aspos + 1, this.aaWidth - aspos);
            this.codons[aspos] = null;
        }
    }

    public void setAaWidth(int aapos) {
        this.aaWidth = aapos;
    }

    public void addMap(SequenceI dnaseq, SequenceI aaseq, MapList map) {
        int nlen = 1;
        if (this.dnaSeqs != null) {
            nlen = this.dnaSeqs.length + 1;
        }
        SequenceI[] ndna = new SequenceI[nlen];
        Mapping[] ndtp = new Mapping[nlen];
        if (this.dnaSeqs != null) {
            System.arraycopy(this.dnaSeqs, 0, ndna, 0, this.dnaSeqs.length);
            System.arraycopy(this.dnaToProt, 0, ndtp, 0, this.dnaSeqs.length);
        }
        this.dnaSeqs = ndna;
        this.dnaToProt = ndtp;
        this.dnaSeqs[--nlen] = dnaseq.getDatasetSequence() == null ? dnaseq : dnaseq.getDatasetSequence();
        Mapping mp = new Mapping(map);
        mp.to = aaseq.getDatasetSequence() == null ? aaseq : aaseq.getDatasetSequence();
        this.a_aaSeqs.addElement(aaseq);
        this.dnaToProt[nlen] = mp;
    }

    public SequenceI[] getdnaSeqs() {
        return this.dnaSeqs;
    }

    public SequenceI[] getAaSeqs() {
        if (this.dnaToProt == null) {
            return null;
        }
        SequenceI[] sqs = new SequenceI[this.dnaToProt.length];
        for (int sz = 0; sz < this.dnaToProt.length; ++sz) {
            sqs[sz] = this.dnaToProt[sz].to;
        }
        return sqs;
    }

    public MapList[] getdnaToProt() {
        if (this.dnaToProt == null) {
            return null;
        }
        MapList[] sqs = new MapList[this.dnaToProt.length];
        for (int sz = 0; sz < this.dnaToProt.length; ++sz) {
            sqs[sz] = this.dnaToProt[sz].map;
        }
        return sqs;
    }

    public Mapping[] getProtMappings() {
        return this.dnaToProt;
    }

    public SequenceI getAaForDnaSeq(SequenceI dnaSeqRef) {
        if (this.dnaSeqs == null) {
            return null;
        }
        SequenceI dnads = dnaSeqRef.getDatasetSequence();
        for (int ds = 0; ds < this.dnaSeqs.length; ++ds) {
            if (this.dnaSeqs[ds] != dnaSeqRef && this.dnaSeqs[ds] != dnads) continue;
            return this.dnaToProt[ds].to;
        }
        return null;
    }

    public SequenceI getDnaForAaSeq(SequenceI aaSeqRef) {
        if (this.dnaToProt == null) {
            return null;
        }
        SequenceI aads = aaSeqRef.getDatasetSequence();
        for (int as = 0; as < this.dnaToProt.length; ++as) {
            if (this.dnaToProt[as].to != aaSeqRef && this.dnaToProt[as].to != aads) continue;
            return this.dnaSeqs[as];
        }
        return null;
    }

    public boolean involvesSequence(SequenceI seq) {
        return this.getAaForDnaSeq(seq) != null || this.getDnaForAaSeq(seq) != null;
    }

    public void markMappedRegion(SequenceI seq, int index, SearchResults results) {
        if (this.dnaToProt == null) {
            return;
        }
        SequenceI ds = seq.getDatasetSequence();
        for (int mi = 0; mi < this.dnaToProt.length; ++mi) {
            int i;
            int[] codon;
            if (this.dnaSeqs[mi] == seq || this.dnaSeqs[mi] == ds) {
                codon = this.dnaToProt[mi].map.locateInTo(index, index);
                if (codon == null) continue;
                for (i = 0; i < codon.length; i += 2) {
                    results.addResult(this.dnaToProt[mi].to, codon[i], codon[i + 1]);
                }
                continue;
            }
            if (this.dnaToProt[mi].to != seq && this.dnaToProt[mi].to != ds || (codon = this.dnaToProt[mi].map.locateInFrom(index, index)) == null) continue;
            for (i = 0; i < codon.length; i += 2) {
                results.addResult(this.dnaSeqs[mi], codon[i], codon[i + 1]);
            }
        }
    }
}

