/*
 * Decompiled with CFR 0.152.
 */
package com.stevesoft.pat;

import com.stevesoft.pat.patInf;

public class patInt {
    int i;
    boolean inf;

    public patInt() {
        this.i = 0;
        this.inf = false;
    }

    public patInt(int init) {
        this.i = init;
        this.inf = false;
    }

    public patInt(patInt p) {
        this.i = p.i;
        this.inf = p.inf;
    }

    public void setInf(boolean b) {
        this.inf = b;
        if (b) {
            this.i = Integer.MAX_VALUE;
        }
    }

    public final void inc() {
        if (!this.inf) {
            ++this.i;
        }
    }

    public final void dec() {
        if (!this.inf) {
            --this.i;
        }
    }

    public final boolean lessEq(patInt j) {
        return !this.inf && (j.inf || this.i <= j.i);
    }

    public final boolean equals(patInt j) {
        return !j.inf && !this.inf && this.i == j.i;
    }

    public final String toString() {
        if (this.inf) {
            return "";
        }
        return "" + this.i;
    }

    public final patInt pluseq(patInt p) {
        if (this.inf || p.inf) {
            this.setInf(true);
        } else {
            this.i += p.i;
        }
        return this;
    }

    public final patInt mul(patInt p) {
        if (this.inf || p.inf) {
            return new patInf();
        }
        return new patInt(this.i * p.i);
    }

    public final patInt mineq(patInt p) {
        if (p.inf) {
            return this;
        }
        if (this.inf) {
            this.i = p.i;
        } else if (p.i < this.i) {
            this.i = p.i;
        }
        this.setInf(false);
        return this;
    }

    public final patInt maxeq(patInt p) {
        if (this.inf || p.inf) {
            this.setInf(true);
            return this;
        }
        if (p.i > this.i) {
            this.i = p.i;
        }
        return this;
    }

    public boolean finite() {
        return !this.inf;
    }

    public int intValue() {
        return this.inf ? Integer.MAX_VALUE : this.i;
    }
}

