/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.appletgui.AlignViewport;
import jalview.appletgui.AnnotationLabels;
import jalview.appletgui.AnnotationPanel;
import jalview.appletgui.PaintRefresher;
import jalview.datamodel.SequenceI;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.util.Vector;

public class IdCanvas
extends Panel {
    protected AlignViewport av;
    protected boolean showScores = true;
    protected int maxIdLength = -1;
    protected String maxIdStr = null;
    Image image;
    Graphics gg;
    int imgHeight = 0;
    boolean fastPaint = false;
    Vector searchResults;

    public IdCanvas(AlignViewport av) {
        this.setLayout(null);
        this.av = av;
        PaintRefresher.Register(this, av.getSequenceSetId());
    }

    public void drawIdString(Graphics gg, SequenceI s, int i, int starty, int ypos) {
        int charHeight = this.av.getCharHeight();
        if (this.searchResults != null && this.searchResults.contains(s)) {
            gg.setColor(Color.black);
            gg.fillRect(0, (i - starty) * charHeight + ypos, this.getSize().width, charHeight);
            gg.setColor(Color.white);
        } else if (this.av.getSelectionGroup() != null && this.av.getSelectionGroup().getSequences(null).contains(s)) {
            gg.setColor(Color.lightGray);
            gg.fillRect(0, (i - starty) * charHeight + ypos, this.getSize().width, charHeight);
            gg.setColor(Color.white);
        } else {
            gg.setColor(this.av.getSequenceColour(s));
            gg.fillRect(0, (i - starty) * charHeight + ypos, this.getSize().width, charHeight);
            gg.setColor(Color.black);
        }
        gg.drawString(s.getDisplayId(this.av.getShowJVSuffix()), 0, (i - starty) * charHeight + ypos + charHeight - charHeight / 5);
        if (this.av.hasHiddenRows && this.av.showHiddenMarkers) {
            this.drawMarker(i, starty, ypos);
        }
    }

    public void fastPaint(int vertical) {
        if (this.gg == null) {
            this.repaint();
            return;
        }
        this.gg.copyArea(0, 0, this.getSize().width, this.imgHeight, 0, -vertical * this.av.charHeight);
        int ss = this.av.startSeq;
        int es = this.av.endSeq;
        int transY = 0;
        if (vertical > 0) {
            ss = es - vertical;
            if (ss < this.av.startSeq) {
                ss = this.av.startSeq;
            } else {
                transY = this.imgHeight - vertical * this.av.charHeight;
            }
        } else if (vertical < 0 && (es = ss - vertical) > this.av.endSeq) {
            es = this.av.endSeq;
        }
        this.gg.translate(0, transY);
        this.drawIds(ss, es);
        this.gg.translate(0, -transY);
        this.fastPaint = true;
        this.repaint();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.getSize().height < 0 || this.getSize().width < 0) {
            return;
        }
        if (this.fastPaint) {
            this.fastPaint = false;
            g.drawImage(this.image, 0, 0, this);
            return;
        }
        this.imgHeight = this.getSize().height;
        this.imgHeight -= this.imgHeight % this.av.charHeight;
        if (this.imgHeight < 1) {
            return;
        }
        if (this.image == null || this.imgHeight != this.image.getHeight(this)) {
            this.image = this.createImage(this.getSize().width, this.imgHeight);
            this.gg = this.image.getGraphics();
            this.gg.setFont(this.av.getFont());
        }
        this.gg.setColor(Color.white);
        Font italic = new Font(this.av.getFont().getName(), 2, this.av.getFont().getSize());
        this.gg.setFont(italic);
        this.gg.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.drawIds(this.av.startSeq, this.av.endSeq);
        g.drawImage(this.image, 0, 0, this);
    }

    void drawIds(int starty, int endy) {
        Font italic = new Font(this.av.getFont().getName(), 2, this.av.getFont().getSize());
        this.gg.setFont(italic);
        Color currentColor = Color.white;
        Color currentTextColor = Color.black;
        if (this.av.getWrapAlignment()) {
            int maxwidth = this.av.alignment.getWidth();
            int alheight = this.av.alignment.getHeight();
            if (this.av.hasHiddenColumns) {
                maxwidth = this.av.getColumnSelection().findColumnPosition(maxwidth) - 1;
            }
            int annotationHeight = 0;
            AnnotationLabels labels = null;
            if (this.av.showAnnotation) {
                AnnotationPanel ap = new AnnotationPanel(this.av);
                annotationHeight = ap.adjustPanelHeight();
                labels = new AnnotationLabels(this.av);
            }
            int hgap = this.av.charHeight;
            if (this.av.scaleAboveWrapped) {
                hgap += this.av.charHeight;
            }
            int cHeight = alheight * this.av.charHeight + hgap + annotationHeight;
            int rowSize = this.av.getEndRes() - this.av.getStartRes();
            int ypos = hgap;
            for (int row = this.av.startRes; ypos <= this.getSize().height && row < maxwidth; ypos += cHeight, row += rowSize) {
                for (int i = starty; i < alheight; ++i) {
                    SequenceI s = this.av.alignment.getSequenceAt(i);
                    this.gg.setFont(italic);
                    if (this.av.hasHiddenRows) {
                        this.setHiddenFont(s);
                    }
                    this.drawIdString(this.gg, s, i, 0, ypos);
                }
                if (labels == null) continue;
                this.gg.translate(0, ypos + alheight * this.av.charHeight);
                labels.drawComponent(this.gg, this.getSize().width);
                this.gg.translate(0, -ypos - alheight * this.av.charHeight);
            }
        } else {
            for (int i = starty; i < endy; ++i) {
                SequenceI seq = this.av.alignment.getSequenceAt(i);
                if (seq == null) continue;
                this.gg.setFont(italic);
                if (this.av.hasHiddenRows) {
                    this.setHiddenFont(seq);
                }
                if (this.searchResults != null && this.searchResults.contains(seq)) {
                    currentColor = Color.black;
                    currentTextColor = Color.white;
                } else if (this.av.getSelectionGroup() != null && this.av.getSelectionGroup().getSequences(null).contains(seq)) {
                    currentColor = Color.lightGray;
                    currentTextColor = Color.black;
                } else {
                    currentColor = this.av.getSequenceColour(seq);
                    currentTextColor = Color.black;
                }
                this.gg.setColor(currentColor);
                this.gg.fillRect(0, (i - starty) * this.av.charHeight, this.getSize().width, this.av.charHeight);
                this.gg.setColor(currentTextColor);
                this.gg.drawString(seq.getDisplayId(this.av.getShowJVSuffix()), 0, (i - starty) * this.av.charHeight + this.av.charHeight - this.av.charHeight / 5);
                if (!this.av.hasHiddenRows || !this.av.showHiddenMarkers) continue;
                this.drawMarker(i, starty, 0);
            }
        }
    }

    public void setHighlighted(Vector found) {
        this.searchResults = found;
        this.repaint();
    }

    void drawMarker(int i, int starty, int yoffset) {
        SequenceI[] hseqs = this.av.alignment.getHiddenSequences().hiddenSequences;
        int hSize = hseqs.length;
        int hiddenIndex = i;
        int lastIndex = i - 1;
        int nextIndex = i + 1;
        for (int j = 0; j < hSize; ++j) {
            if (hseqs[j] == null) continue;
            if (j - 1 < hiddenIndex) {
                ++hiddenIndex;
            }
            if (j - 1 < lastIndex) {
                ++lastIndex;
            }
            if (j - 1 >= nextIndex) continue;
            ++nextIndex;
        }
        boolean below = hiddenIndex > lastIndex + 1;
        boolean above = nextIndex > hiddenIndex + 1;
        this.gg.setColor(Color.blue);
        if (below) {
            this.gg.fillPolygon(new int[]{this.getSize().width - this.av.charHeight, this.getSize().width - this.av.charHeight, this.getSize().width}, new int[]{(i - starty) * this.av.charHeight + yoffset, (i - starty) * this.av.charHeight + yoffset + this.av.charHeight / 4, (i - starty) * this.av.charHeight + yoffset}, 3);
        }
        if (above) {
            this.gg.fillPolygon(new int[]{this.getSize().width - this.av.charHeight, this.getSize().width - this.av.charHeight, this.getSize().width}, new int[]{(i - starty + 1) * this.av.charHeight + yoffset, (i - starty + 1) * this.av.charHeight + yoffset - this.av.charHeight / 4, (i - starty + 1) * this.av.charHeight + yoffset}, 3);
        }
    }

    boolean setHiddenFont(SequenceI seq) {
        Font bold = new Font(this.av.getFont().getName(), 1, this.av.getFont().getSize());
        if (this.av.hiddenRepSequences != null && this.av.hiddenRepSequences.containsKey(seq)) {
            this.gg.setFont(bold);
            return true;
        }
        return false;
    }
}

