function results_struct = geweke_chi2_test(results1,results2,results_struct,options_)
% results_struct = geweke_chi2_test(results1,results2,results_struct,options_)
% PURPOSE: computes Geweke's chi-squared test for two sets of MCMC sample draws
%
% INPUTS
%   results1         [1 by (4+n_taper*2) vector] vector with post. mean,
%                           std, NSE_iid, RNE_iid, and tapered NSE and RNE
%                           for chain part 1
%   results2         [1 by (4+n_taper*2) vector] vector with post. mean,
%                           std, NSE_iid, RNE_iid, and tapered NSE and RNE
%                           for chain part 2
%   results_struct   [structure] results structure generated by geweke_moments
%   options_         [structure]
%
% OUTPUTS
%   results_struct   [structure]  containing the following fields:
%       pooled_mean               Pooled mean of the chain parts, weighted
%                                   with precision
%       rpooled_nse               Pooled NSE of the chain parts, weighted
%                                   with precision
%       prob_chi2_test            p-value of Chi2-test for equality of
%                                   means in both chain parts
% -----------------------------------------------------------------

%
% SPECIAL REQUIREMENTS
%   None.

% Copyright © 2013-2017 Dynare Team
%
% This file is part of Dynare.
%
% Dynare is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% Dynare is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with Dynare.  If not, see <https://www.gnu.org/licenses/>.
%
% ------------------------------------------------
% REFERENCES: Geweke (1992), `Evaluating the accuracy of sampling-based
% approaches to the calculation of posterior moments', in J.O. Berger,
% J.M. Bernardo, A.P. Dawid, and A.F.M. Smith (eds.) Proceedings of
% the Fourth Valencia International Meeting on Bayesian Statistics,
% pp. 169-194, Oxford University Press
% Geweke (1999): `Using simulation methods for Bayesian econometric models:
% Inference, development and communication', Econometric Reviews, 18(1),
% 1-73

% written by: Johannes Pfeifer,
% based on code by James P. LeSage, who in turn
% drew on MATLAB programs written by Siddartha Chib

for k=1:length(options_.convergence.geweke.taper_steps)+1
    NSE=[results1(:,3+(k-1)*2) results2(:,3+(k-1)*2)];
    means=[results1(:,1) results2(:,1)];
    diff_Means=means(:,1)-means(:,2);
    sum_of_weights=sum(1./(NSE.^2),2);
    pooled_mean=sum(means./(NSE.^2),2)./sum_of_weights;
    pooled_NSE=1./sqrt(sum_of_weights);

    test_stat=diff_Means.^2./sum(NSE.^2,2);
    p = 1-chi2cdf(test_stat,1);
    results_struct.pooled_mean(:,k) = pooled_mean;
    results_struct.pooled_nse(:,k) = pooled_NSE;
    results_struct.prob_chi2_test(:,k) = p;
end
