namespace Spectre.Console.Rendering;

/// <summary>
/// Represents the different parts of a table border.
/// </summary>
public enum TableBorderPart
{
    /// <summary>
    /// The top left part of a header.
    /// </summary>
    HeaderTopLeft,

    /// <summary>
    /// The top part of a header.
    /// </summary>
    HeaderTop,

    /// <summary>
    /// The top separator part of a header.
    /// </summary>
    HeaderTopSeparator,

    /// <summary>
    /// The top right part of a header.
    /// </summary>
    HeaderTopRight,

    /// <summary>
    /// The left part of a header.
    /// </summary>
    HeaderLeft,

    /// <summary>
    /// A header separator.
    /// </summary>
    HeaderSeparator,

    /// <summary>
    /// The right part of a header.
    /// </summary>
    HeaderRight,

    /// <summary>
    /// The bottom left part of a header.
    /// </summary>
    HeaderBottomLeft,

    /// <summary>
    /// The bottom part of a header.
    /// </summary>
    HeaderBottom,

    /// <summary>
    /// The bottom separator part of a header.
    /// </summary>
    HeaderBottomSeparator,

    /// <summary>
    /// The bottom right part of a header.
    /// </summary>
    HeaderBottomRight,

    /// <summary>
    /// The top left part of a footer.
    /// </summary>
    FooterTopLeft,

    /// <summary>
    /// The top part of a footer.
    /// </summary>
    FooterTop,

    /// <summary>
    /// The top separator part of a footer.
    /// </summary>
    FooterTopSeparator,

    /// <summary>
    /// The top right part of a footer.
    /// </summary>
    FooterTopRight,

    /// <summary>
    /// The left part of a cell.
    /// </summary>
    CellLeft,

    /// <summary>
    /// A cell separator.
    /// </summary>
    CellSeparator,

    /// <summary>
    /// The right part of a cell.
    /// </summary>
    CellRight,

    /// <summary>
    /// The bottom left part of a footer.
    /// </summary>
    FooterBottomLeft,

    /// <summary>
    /// The bottom part of a footer.
    /// </summary>
    FooterBottom,

    /// <summary>
    /// The bottom separator part of a footer.
    /// </summary>
    FooterBottomSeparator,

    /// <summary>
    /// The bottom right part of a footer.
    /// </summary>
    FooterBottomRight,

    /// <summary>
    /// The left part of a row.
    /// </summary>
    RowLeft,

    /// <summary>
    /// The center part of a row.
    /// </summary>
    RowCenter,

    /// <summary>
    /// The separator part of a row.
    /// </summary>
    RowSeparator,

    /// <summary>
    /// The right part of a row.
    /// </summary>
    RowRight,
}