using System.Reflection;
using System.Timers;
using Mono.Linker.Tests.Cases.Expectations.Assertions;
using Mono.Linker.Tests.Cases.Expectations.Helpers;
using Mono.Linker.Tests.Cases.Expectations.Metadata;

namespace Mono.Linker.Tests.Cases.Attributes
{
    [Reference("System.dll")]
    [SetupLinkerTrimMode("link")]
    // System.dll referenced by a dynamically (for example in TypeConverterAttribute on IComponent)
    // has unresolved references.
    [SetupLinkerArgument("--skip-unresolved", "true")]
    [KeptAttributeInAssembly(PlatformAssemblies.CoreLib, typeof(AssemblyDescriptionAttribute))]
    [KeptAttributeInAssembly(PlatformAssemblies.CoreLib, typeof(AssemblyCompanyAttribute))]
#if !NET
    [KeptAttributeInAssembly("System.dll", typeof(AssemblyDescriptionAttribute))]
    [KeptAttributeInAssembly("System.dll", typeof(AssemblyCompanyAttribute))]
#endif
    public class CoreLibraryAssemblyAttributesAreKept
    {
        public static void Main()
        {
            // Use something from System so that the entire reference isn't linked away
            var system = new Timer();
        }
    }
}
