using System;
using System.IO;
using System.Xml.Serialization;


class Program
{
    static public T DeserializeFromString<T>(string xml) where T : class
    {

        if (String.IsNullOrEmpty(xml))
        {
            return null;
        }

        StringReader reader = null;
        T deserializedObject = null;
        try
        {
            reader = new StringReader(xml);
            XmlSerializer serializer = new XmlSerializer(typeof(T));
            deserializedObject = serializer.Deserialize(reader) as T;
        }
        finally
        {
            if (null != reader)
            {
                reader.Close();
            }
        }
        return deserializedObject;
    }


    static void Main(string[] args)
    {
        string myXML = @"<?xml version=""1.0"" encoding=""utf-8""?><TASK><OptionA/></TASK>";

        // The following line fails on Mono 2.8 2.10 2.10.8.1 2.10.9
        TASK data = DeserializeFromString<TASK>(myXML);
        if(data == null)
        {
            throw new Exception("A#01");
        }
        if(data.ItemElementName != ItemChoiceType.OptionA)
        {
            throw new Exception("A#02");
        }
    }
}

// Below is the code generated from the following XSD:
/*
<?xml version="1.0" encoding="UTF-8"?>
<xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema" elementFormDefault="qualified" attributeFormDefault="unqualified">
        <xs:element name="TASK">
                <xs:complexType>
                        <xs:choice>
                                <xs:element name="OptionA"/>
                                <xs:element name="OptionB"/>
                        </xs:choice>
                </xs:complexType>
        </xs:element>
</xs:schema>
*/

//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Runtime Version:4.0.30319.239
//
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

// 
// This source code was auto-generated by xsd, Version=4.0.30319.1.
// 


/// <remarks/>
[System.CodeDom.Compiler.GeneratedCodeAttribute("xsd", "4.0.30319.1")]
[System.SerializableAttribute()]
[System.Diagnostics.DebuggerStepThroughAttribute()]
[System.ComponentModel.DesignerCategoryAttribute("code")]
[System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true)]
[System.Xml.Serialization.XmlRootAttribute(Namespace="", IsNullable=false)]
public partial class TASK {
    
    private object itemField;
    
    private ItemChoiceType itemElementNameField;
    
    /// <remarks/>
    [System.Xml.Serialization.XmlElementAttribute("OptionA", typeof(object), Order=0)]
    [System.Xml.Serialization.XmlElementAttribute("OptionB", typeof(object), Order=0)]
    [System.Xml.Serialization.XmlChoiceIdentifierAttribute("ItemElementName")]
    public object Item {
        get {
            return this.itemField;
        }
        set {
            this.itemField = value;
        }
    }
    
    /// <remarks/>
    [System.Xml.Serialization.XmlElementAttribute(Order=1)]
    [System.Xml.Serialization.XmlIgnoreAttribute()]
    public ItemChoiceType ItemElementName {
        get {
            return this.itemElementNameField;
        }
        set {
            this.itemElementNameField = value;
        }
    }
}

/// <remarks/>
[System.CodeDom.Compiler.GeneratedCodeAttribute("xsd", "4.0.30319.1")]
[System.SerializableAttribute()]
[System.Xml.Serialization.XmlTypeAttribute(IncludeInSchema=false)]
public enum ItemChoiceType {
    
    /// <remarks/>
    OptionA,
    
    /// <remarks/>
    OptionB,
}
