/****************************************************************************
** Dooble - The Secure Internet Web Browser
**
** Copyright (c) 2008, 2009 Alexis Megas, 
** Gunther van Dooble, and the Dooble Team. 
** All rights reserved.
**
**
** License: GPL2 only: 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; version 2 of the License only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
** or see here: http://www.gnu.org/licenses/gpl.html
**
**
** For the WebKit library, please see: http://webkit.org.
**
** THE CODE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY
** EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
** PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
** ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
** IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS APPLICATION, EVEN IF ADVISED
** OF THE POSSIBILITY OF SUCH DAMAGE.
**
** Please report all praise, requests, bugs, and problems to the project
** team and administrators: http://sf.net/projects/dooble.
**
** You can find us listed at our project page. New team members are welcome.
** The name of the authors should not be used to endorse or promote products
** derived from Dooble without specific prior written permission.
** If you use this code for other projects, please let us know.
**
** Web sites:
**   http://dooble.net/projects/dooble
**   http://dooble.sf.net
**   http://www.getadooble.com
****************************************************************************/


#include <QDir>
#include <QMap>
#include <QUrl>
#include <QLocale>
#include <QSettings>
#include <QFileDialog>
#include <QWebSettings>

#include "dsettings.h"

dsettings::dsettings():QDialog()
{
  ui.setupUi(this);

  QSettings settings;
  QSettings cfgSettings(settings.value("iconSet").toString(),
			QSettings::IniFormat);

  setWindowIcon
    (QIcon(cfgSettings.value("settingsWindow/windowIcon").toString()));
  connect(ui.buttonBox, SIGNAL(clicked(QAbstractButton *)),
	  this, SLOT(slotClicked(QAbstractButton *)));
  connect(ui.chooseIconSetPushButton, SIGNAL(clicked(void)),
	  this, SLOT(slotSelectIconCfgFile(void)));
  connect(ui.chooseBackgroundPushButton, SIGNAL(clicked(void)),
	  this, SLOT(slotChooseBackgroundImage(void)));
  ui.doobleSearchLineEdit->setText
    (QUrl::fromLocalFile(QString("%1/Tab/Default/search.html").arg
			 (QDir::currentPath())).toString());
  settings.setValue("settingsWindow/url12",
		    ui.doobleSearchLineEdit->text().trimmed());
}

dsettings::~dsettings()
{
}

void dsettings::exec(QWidget *parent)
{
  ui.desktopBackgroundComboBox->clear();

  QSettings settings;
  QStringList allKeys(settings.allKeys());

  for(int i = 0; i < allKeys.size(); i++)
    if(allKeys[i].startsWith("desktopBackground") ||
       allKeys[i].startsWith("settingsWindow/backgroundImage"))
      if(QFile::exists(settings.value(allKeys[i]).toString().trimmed()))
	{
	  if(ui.desktopBackgroundComboBox->findText
	     (settings.value(allKeys[i]).toString().trimmed()) == -1)
	    ui.desktopBackgroundComboBox->addItem
	      (settings.value(allKeys[i]).toString().trimmed());

	  if(settings.value(allKeys[i]).toString().trimmed() ==
	     settings.value("desktopBackground").toString().trimmed())
	    ui.desktopBackgroundComboBox->setCurrentIndex
	      (ui.desktopBackgroundComboBox->findText
	       (settings.value("desktopBackground").toString().trimmed()));
	}

  allKeys.clear();
  ui.url01lineEdit->setText
    (settings.value("settingsWindow/url1", "").toString().trimmed());
  ui.url02lineEdit->setText
    (settings.value("settingsWindow/url2", "").toString().trimmed());
  ui.url03lineEdit->setText
    (settings.value("settingsWindow/url3", "").toString().trimmed());
  ui.url04lineEdit->setText
    (settings.value("settingsWindow/url4", "").toString().trimmed());
  ui.url05lineEdit->setText
    (settings.value("settingsWindow/url5", "").toString().trimmed());
  ui.url06lineEdit->setText
    (settings.value("settingsWindow/url6", "").toString().trimmed());
  ui.url07lineEdit->setText
    (settings.value("settingsWindow/url7", "").toString().trimmed());
  ui.url08lineEdit->setText
    (settings.value("settingsWindow/url8", "").toString().trimmed());
  ui.url09lineEdit->setText
    (settings.value("settingsWindow/url9", "").toString().trimmed());
  ui.url10lineEdit->setText
    (settings.value("settingsWindow/url10", "").toString().trimmed());
  ui.url11lineEdit->setText
    (settings.value("settingsWindow/url11", "").toString().trimmed());
  ui.displayDesktopCheckBox->setChecked
    (settings.value("settingsWindow/displayDesktopCheckBox", false).toBool());
  ui.proceedToNewTabCheckBox->setChecked
    (settings.value("settingsWindow/proceedToNewTab", true).toBool());
  ui.openInNewTabsCheckBox->setChecked
    (settings.value("settingsWindow/openInNewTab", true).toBool());

  if(!settings.value("settingsWindow/url12", "").toString().isEmpty())
    ui.doobleSearchLineEdit->setText
      (settings.value("settingsWindow/url12", "").toString().trimmed());

  allKeys = settings.allKeys();

  QMap<QString, QString> itemsMap;

  for(int i = 0; i < allKeys.size(); i++)
    if(allKeys[i].contains("iconSet"))
      {
	QSettings cfgSettings
	  (settings.value(allKeys[i]).toString(), QSettings::IniFormat);

	cfgSettings.beginGroup("Description");
	itemsMap[cfgSettings.value("Name").toString()] =
	  settings.value(allKeys[i]).toString();
      }

  allKeys.clear();
  ui.iconSetComboBox->clear();

  QSettings cfgSettings
    (settings.value("iconSet").toString(), QSettings::IniFormat);

  cfgSettings.beginGroup("Description");

  for(int i = 0; i < itemsMap.size(); i++)
    {
      ui.iconSetComboBox->addItem(itemsMap.keys()[i],
				  itemsMap.values()[i]);

      if(cfgSettings.value("Name").toString() == itemsMap.keys()[i])
	ui.iconSetComboBox->setCurrentIndex(i);
    }

  itemsMap.clear();
  ui.javascriptGroupBox->setChecked
    (settings.value("settingsWindow/javascriptEnabled", false).toBool());
  ui.jsAllowNewWindowsCheckBox->setChecked
    (settings.value("settingsWindow/javascriptAllowNewWindows",
		    false).toBool());
  ui.languageComboBox->clear();

  QLocale locale;

  ui.languageComboBox->addItem(locale.languageToString(locale.language()));

  if(settings.contains("settingsWindow/size"))
    resize(settings.value("settingsWindow/size").toSize());

  int X = 0;
  int Y = 0;
  QPoint p(0, 0);

  p = parent->pos();

  if(parent->width() >= width())
    X = p.x() + parent->width() / 2 - width() / 2;
  else
    X = p.x() - (width() / 2 - parent->width() / 2);

  if(parent->height() >= height())
    Y = p.y() + parent->height() / 2 - height() / 2;
  else
    Y = p.y() - (height() / 2 - parent->height() / 2);

  move(X, Y);
  QDialog::exec();
}

void dsettings::slotClicked(QAbstractButton *button)
{
  if(ui.buttonBox->buttonRole(button) == QDialogButtonBox::AcceptRole)
    {
      QSettings settings;

      settings.setValue
	("iconSet",
	 ui.iconSetComboBox->itemData(ui.iconSetComboBox->currentIndex()).
	 toString());
      settings.setValue
	("desktopBackground", ui.desktopBackgroundComboBox->currentText());
      settings.beginGroup("settingsWindow");
      settings.setValue("size", geometry().size());
      settings.setValue("url1",
			ui.url01lineEdit->text().trimmed());
      settings.setValue("url2",
			ui.url02lineEdit->text().trimmed());
      settings.setValue("url3",
			ui.url03lineEdit->text().trimmed());
      settings.setValue("url4",
			ui.url04lineEdit->text().trimmed());
      settings.setValue("url5",
			ui.url05lineEdit->text().trimmed());
      settings.setValue("url6",
			ui.url06lineEdit->text().trimmed());
      settings.setValue("url7",
			ui.url07lineEdit->text().trimmed());
      settings.setValue("url8",
			ui.url08lineEdit->text().trimmed());
      settings.setValue("url9",
			ui.url09lineEdit->text().trimmed());
      settings.setValue("url10",
			ui.url10lineEdit->text().trimmed());
      settings.setValue("url11",
			ui.url11lineEdit->text().trimmed());
      settings.setValue("url12",
			ui.doobleSearchLineEdit->text().trimmed());
      settings.setValue("javascriptEnabled",
			ui.javascriptGroupBox->isChecked());
      settings.setValue("javascriptAllowNewWindows",
			ui.jsAllowNewWindowsCheckBox->isChecked());
      settings.setValue("displayDesktopCheckBox",
			ui.displayDesktopCheckBox->isChecked());
      settings.setValue("proceedToNewTab",
			ui.proceedToNewTabCheckBox->isChecked());
      settings.setValue("openInNewTab",
			ui.openInNewTabsCheckBox->isChecked());
      QWebSettings::globalSettings()->setAttribute
	(QWebSettings::JavascriptEnabled,
	 ui.javascriptGroupBox->isChecked());
      QWebSettings::globalSettings()->setAttribute
	(QWebSettings::JavascriptCanOpenWindows,
	 ui.jsAllowNewWindowsCheckBox->isChecked());

      for(int i = 0; i < ui.iconSetComboBox->count(); i++)
	settings.setValue(QString("iconSet%1").arg(i + 1),
			  ui.iconSetComboBox->itemData(i));

      emit iconsChangedSignal();
      emit backgroundImageChangedSignal();
    }

  setVisible(false);
}

void dsettings::keyPressEvent(QKeyEvent *event)
{
  if(event->key() == Qt::Key_Escape)
    setVisible(false);
}

void dsettings::slotSelectIconCfgFile(void)
{
  QDir currentDir(QDir::current());
  QFileDialog fileDialog(this);

  currentDir.cd("Icons");
  fileDialog.setDirectory(currentDir.path());
  fileDialog.setWindowTitle(tr("Dooble Web Browser: Theme "
			       "Selection"));
  fileDialog.setFileMode(QFileDialog::ExistingFile);
  fileDialog.setLabelText(QFileDialog::Accept, tr("&Select"));
  fileDialog.setNameFilter(tr("Theme Configuration File (*.cfg)"));

  if(fileDialog.exec() == QDialog::Accepted)
    {
      bool itemInserted = false;
      QSettings cfgSettings(fileDialog.selectedFiles()[0],
			    QSettings::IniFormat);

      cfgSettings.beginGroup("Description");

      for(int i = 0; i < ui.iconSetComboBox->count(); i++)
	if(cfgSettings.value("Name").toString() <
	   ui.iconSetComboBox->itemText(i))
	  {
	    itemInserted = true;
	    ui.iconSetComboBox->insertItem
	      (i, cfgSettings.value("Name").toString(),
	       fileDialog.selectedFiles()[0]);
	    ui.iconSetComboBox->setCurrentIndex(i);
	    break;
	  }
	else if(cfgSettings.value("Name").toString() ==
		ui.iconSetComboBox->itemText(i))
	  {
	    itemInserted = true;
	    ui.iconSetComboBox->setCurrentIndex(i);
	    break;
	  }

      if(!itemInserted)
	{
	  ui.iconSetComboBox->addItem
	    (cfgSettings.value("Name").toString(),
	     fileDialog.selectedFiles()[0]);
	  ui.iconSetComboBox->setCurrentIndex
	    (ui.iconSetComboBox->count() - 1);
	}
    }
}

void dsettings::slotChooseBackgroundImage(void)
{
  QDir currentDir(QDir::current());
  QFileDialog fileDialog(this);

  currentDir.cd("Images");
  fileDialog.setDirectory(currentDir.path());
  fileDialog.setWindowTitle(tr("Dooble Web Browser: Desktop Background "
			       "Image Selection"));
  fileDialog.setFileMode(QFileDialog::ExistingFile);
  fileDialog.setLabelText(QFileDialog::Accept, tr("&Select"));

  if(fileDialog.exec() == QDialog::Accepted)
    {
      int index = -1;

      if((index = ui.desktopBackgroundComboBox->findText
	  (fileDialog.selectedFiles()[0])) == -1)
	{
	  ui.desktopBackgroundComboBox->addItem(fileDialog.selectedFiles()[0]);
	  ui.desktopBackgroundComboBox->setCurrentIndex
	    (ui.desktopBackgroundComboBox->count() - 1);
	}
      else
	ui.desktopBackgroundComboBox->setCurrentIndex(index);
    }
}
