/* --- BEGIN COPYRIGHT BLOCK ---
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2.1 of the License.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301  USA 
 * 
 * Copyright (C) 2007 Red Hat, Inc.
 * All rights reserved.
 * --- END COPYRIGHT BLOCK ---
 */

#ifndef EXTERNAL_AUTHENTICATE_APDU_H
#define EXTERNAL_AUTHENTICATE_APDU_H

#ifdef HAVE_CONFIG_H
#ifndef AUTOTOOLS_CONFIG_H
#define AUTOTOOLS_CONFIG_H

/* Eliminate warnings when using Autotools */
#undef PACKAGE_BUGREPORT
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION

#include <config.h>
#endif /* AUTOTOOLS_CONFIG_H */
#endif /* HAVE_CONFIG_H */

#include "main/Base.h"
#include "main/Buffer.h"
#include "apdu/APDU.h"
#include "channel/Secure_Channel.h"

#ifdef XP_WIN32
#define TPS_PUBLIC __declspec(dllexport)
#else /* !XP_WIN32 */
#define TPS_PUBLIC
#endif /* !XP_WIN32 */

class External_Authenticate_APDU : public APDU
{
  public:
	// TPS_PUBLIC External_Authenticate_APDU(Buffer &data);
	TPS_PUBLIC External_Authenticate_APDU(Buffer &data, SecurityLevel sl);
	TPS_PUBLIC ~External_Authenticate_APDU();
	TPS_PUBLIC APDU_Type GetType();
  public:
	TPS_PUBLIC Buffer &GetHostCryptogram();
};

#endif /* EXTERNAL_AUTHENTICATE_APDU_H */
