/*
 *   This file is part of Dianara
 *   Copyright 2012-2014  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef ASOBJECT_H
#define ASOBJECT_H

#include <QObject>
#include <QVariantMap>

#include <QDebug>


class ASObject : public QObject
{
    Q_OBJECT

public:
    explicit ASObject(QVariantMap objectMap,
                      QObject *parent = 0);
    ~ASObject();

    QString getId();
    QString getType();
    QString getUrl();
    QString getCreatedAt();
    QString getUpdatedAt();
    QString getLocation();

    QString getDeletedTime();
    QString isLiked();

    QVariantMap getAuthorMap();
    QString getAuthorName();
    QString getAuthorId();
    QString getAuthorAvatar();
    QString getAuthorUrl();
    QString getAuthorHometown();
    QString getAuthorBio();

    QString getTitle();
    QString getContent();

    QString getImageUrl();

    QString getLikesCount();
    QString getCommentsCount();
    QString getSharesCount();

    QVariantList getLastLikesList();
    QVariantList getLastCommentsList();
    QVariantList getLastSharesList();

    QString getLikesUrl();
    QString getCommentsUrl();
    QString getSharesUrl();

    QVariantMap getOriginalObject();
    QVariantMap getInReplyTo();

signals:

public slots:

private:
    QString id;
    QString type;
    QString url;
    QString createdAt;
    QString updatedAt;
    QString location;

    QString deleted;
    QString liked;


    QVariantMap authorMap;
    QString authorName;
    QString authorId;
    QString authorAvatar;
    QString authorUrl;
    QString authorHometown;
    QString authorBio;

    QString title;
    QString content;

    QString imageUrl;

    QString likesCount;
    QString commentsCount;
    QString sharesCount;

    QVariantList lastLikesList;
    QVariantList lastCommentsList;
    QVariantList lastSharesList;

    QString likesUrl;
    QString commentsUrl;
    QString sharesUrl;

    QVariantMap originalObjectMap;
    QVariantMap inReplyToMap;
};

#endif // ASOBJECT_H
