#!/bin/sh -e

pkg="deepnano"
test_required_pkg="${pkg}-data"
datadir=/usr/share/poretools/data

if [ "$AUTOPKGTEST_TMP" = "" ] ; then
  AUTOPKGTEST_TMP=$(mktemp -d /tmp/${pkg}-test.XXXXXX)
  trap "rm -rf $AUTOPKGTEST_TMP" 0 INT QUIT ABRT PIPE TERM
fi

cp -a /usr/share/${test_required_pkg}/* $AUTOPKGTEST_TMP
mkdir -p $AUTOPKGTEST_TMP/test_data/

# Copy only 10 data sets since test with all data takes to long
for d in `ls $datadir | sort | head -n10` ; do cp $datadir/$d $AUTOPKGTEST_TMP/test_data/ ; done

cd $AUTOPKGTEST_TMP

find . -name "*gz" -exec gunzip \{\} \;
#echo '!!!!!!!!!!'
#ls -R
echo -e "\n#1 - deepnano_basecall"
OMP_NUM_THREADS=`nproc` deepnano_basecall test_data/*
cat output.fasta

echo -e "\n#2 - deepnano_basecall_no_metrichor"
OMP_NUM_THREADS=`nproc` deepnano_basecall_no_metrichor test_data/*

echo "PASS"
