#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "cross_compiling.hpp"

dependency_list cross_compiling::to_cross(architecture const &arch, dependency_list const &deps)
{
	dependency_list ret;
	for(dependency_list::const_iterator i = deps.begin(); i != deps.end(); ++i)
	{
		dependency_alternative_list alts;
		for(dependency_alternative_list::const_iterator j = i->begin(); j != i->end(); ++j)
			alts.push_back(dependency(j->package + "-" + arch + "-cross", j->op, j->ver));
		ret.push_back(alts);
	}
	return ret;
}
