/*
 * Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either 
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>. */

#ifndef _POST_PROCESSOR_H_
#define _POST_PROCESSOR_H_

#include <qglobal.h>

class ProcessingOptions;

class PostProcessor {
  public:
    PostProcessor( const ProcessingOptions& processingOptions);
    PostProcessor( const PostProcessor& postProcessor );
    ~PostProcessor();
    void apply16( QByteArray& _rgb );
    void setConvertToSRGB( bool v );
    bool convertToSRGB() const;
  private:
    struct Private;
    Private* const d;
};

#endif

