#!/usr/bin/env python3

helptext = """
Usage: rename-example section name_in name_out

where 'section' is one of specular, scatter2d, ...
      'name' is without extension

Writes shell commands to stdout
"""

import sys

if __name__ == '__main__':
    if len(sys.argv)!=4:
        print(helptext)
        exit(1)

    s = sys.argv[1]  # section
    n0 = sys.argv[2] # name_in
    n1 = sys.argv[3] # name_out
    f0 = s+"/"+n0
    f1 = s+"/"+n1

    print(f"""\
cd /G/sw/ba
k mv rawEx/{f0}.py rawEx/{f1}.py
k mv auto/Examples/{f0}.py auto/Examples/{f1}.py
k mv auto/FigExamples/{f0}.py auto/FigExamples/{f1}.py
k mv auto/MiniExamples/{f0}.py auto/MiniExamples/{f1}.py
k mv Tests/ReferenceData/MiniExamples/{f0}.int Tests/ReferenceData/MiniExamples/{f1}.int
rm hugo/static/py/auto/Examples/{f0}.py
rm hugo/static/img/auto/{f0}.png
ed -s Tests/Examples/CMakeLists.txt <<< $'g/{n0}/s//{n1}/g\nw'
for f in `fmd`;do ed -s $f <<< $'g/{n0}/s//{1}/g\nw'; done
cd build
cm -DDEV=ON
j
t4
j excopy
j figures
ks

kcom -m"rename example {n0} -> {n1}"
""")
