// Boost.Geometry (aka GGL, Generic Geometry Library)

// Copyright (c) 2008-2012 Barend Gehrels, Amsterdam, the Netherlands.

// This file was modified by Oracle on 2017, 2018.
// Modifications copyright (c) 2017-2018, Oracle and/or its affiliates.
// Contributed and/or modified by Adam Wulkiewicz, on behalf of Oracle

// Use, modification and distribution is subject to the Boost Software License,
// Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)

#ifndef BOOST_GEOMETRY_PROJECTIONS_EPSG_TRAITS_HPP
#define BOOST_GEOMETRY_PROJECTIONS_EPSG_TRAITS_HPP


#include <boost/geometry/core/tags.hpp>

#include <boost/geometry/srs/projections/factory.hpp>
#include <boost/geometry/srs/projections/impl/projects.hpp>
#include <boost/geometry/srs/projections/srid_traits.hpp>


namespace boost { namespace geometry { namespace projections
{

#ifndef DOXYGEN_NO_DETAIL
namespace detail
{

/*!
    \brief EPSG traits
    \details With help of the EPSG traits library users can statically use projections
        or coordinate systems specifying an EPSG code. The correct projections for transformations
        are used automically then, still keeping static polymorphism.
    \ingroup projection
    \tparam EPSG epsg code
*/
template <size_t EPSG>
struct epsg_traits
{
    // Specializations define:
    // - type to get projection type
    // - function par to get parameters
};

BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2000, tmerc, clrk80, "+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2001, tmerc, clrk80, "+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2002, tmerc, clrk80, "+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=725,685,536,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2003, tmerc, clrk80, "+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=72,213.7,93,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2004, tmerc, clrk80, "+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=174,359,365,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2005, tmerc, clrk80, "+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2006, tmerc, clrk80, "+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=-149,128,296,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2007, tmerc, clrk80, "+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=195.671,332.517,274.607,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2008, tmerc, clrk66, "+proj=tmerc +lat_0=0 +lon_0=-55.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2009, tmerc, clrk66, "+proj=tmerc +lat_0=0 +lon_0=-58.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2010, tmerc, clrk66, "+proj=tmerc +lat_0=0 +lon_0=-61.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2011, tmerc, clrk66, "+proj=tmerc +lat_0=0 +lon_0=-64.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2012, tmerc, clrk66, "+proj=tmerc +lat_0=0 +lon_0=-67.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2013, tmerc, clrk66, "+proj=tmerc +lat_0=0 +lon_0=-70.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2014, tmerc, clrk66, "+proj=tmerc +lat_0=0 +lon_0=-73.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2015, tmerc, clrk66, "+proj=tmerc +lat_0=0 +lon_0=-76.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2016, tmerc, clrk66, "+proj=tmerc +lat_0=0 +lon_0=-79.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2017, tmerc, clrk66, "+proj=tmerc +lat_0=0 +lon_0=-73.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2018, tmerc, clrk66, "+proj=tmerc +lat_0=0 +lon_0=-76.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2019, tmerc, clrk66, "+proj=tmerc +lat_0=0 +lon_0=-79.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2020, tmerc, clrk66, "+proj=tmerc +lat_0=0 +lon_0=-82.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2021, tmerc, clrk66, "+proj=tmerc +lat_0=0 +lon_0=-81 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2022, tmerc, clrk66, "+proj=tmerc +lat_0=0 +lon_0=-84 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2023, tmerc, clrk66, "+proj=tmerc +lat_0=0 +lon_0=-87 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2024, tmerc, clrk66, "+proj=tmerc +lat_0=0 +lon_0=-90 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2025, tmerc, clrk66, "+proj=tmerc +lat_0=0 +lon_0=-93 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2026, tmerc, clrk66, "+proj=tmerc +lat_0=0 +lon_0=-96 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2027, utm, clrk66, "+proj=utm +zone=15 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2028, utm, clrk66, "+proj=utm +zone=16 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2029, utm, clrk66, "+proj=utm +zone=17 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2030, utm, clrk66, "+proj=utm +zone=18 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2031, utm, clrk66, "+proj=utm +zone=17 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2032, utm, clrk66, "+proj=utm +zone=18 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2033, utm, clrk66, "+proj=utm +zone=19 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2034, utm, clrk66, "+proj=utm +zone=20 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2035, utm, clrk66, "+proj=utm +zone=21 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2036, sterea, GRS80, "+proj=sterea +lat_0=46.5 +lon_0=-66.5 +k=0.999912 +x_0=2500000 +y_0=7500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2037, utm, GRS80, "+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2038, utm, GRS80, "+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2039, tmerc, GRS80, "+proj=tmerc +lat_0=31.73439361111111 +lon_0=35.20451694444445 +k=1.0000067 +x_0=219529.584 +y_0=626907.39 +ellps=GRS80 +towgs84=-48,55,52,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2040, utm, clrk80, "+proj=utm +zone=30 +ellps=clrk80 +towgs84=-125,53,467,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2041, utm, clrk80, "+proj=utm +zone=30 +ellps=clrk80 +towgs84=-124.76,53,466.79,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2042, utm, clrk80, "+proj=utm +zone=29 +ellps=clrk80 +towgs84=-125,53,467,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2043, utm, clrk80, "+proj=utm +zone=29 +ellps=clrk80 +towgs84=-124.76,53,466.79,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2044, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=0 +ellps=krass +towgs84=-17.51,-108.32,-62.39,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2045, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=0 +ellps=krass +towgs84=-17.51,-108.32,-62.39,0,0,0,0 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 2046, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 2047, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 2048, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 2049, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 2050, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 2051, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 2052, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 2053, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 2054, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 2055, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2056, somerc, bessel, "+proj=somerc +lat_0=46.95240555555556 +lon_0=7.439583333333333 +k_0=1 +x_0=2600000 +y_0=1200000 +ellps=bessel +towgs84=674.374,15.056,405.346,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2057, omerc, intl, "+proj=omerc +lat_0=27.51882880555555 +lonc=52.60353916666667 +alpha=0.5716611944444444 +k=0.999895934 +x_0=658377.437 +y_0=3044969.194 +ellps=intl +towgs84=-133.63,-157.5,-158.62,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2058, utm, intl, "+proj=utm +zone=38 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2059, utm, intl, "+proj=utm +zone=39 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2060, utm, intl, "+proj=utm +zone=40 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2061, utm, intl, "+proj=utm +zone=41 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2062, lcc, 6378298.3, 6356657.142669561, "+proj=lcc +lat_1=40 +lat_0=40 +lon_0=0 +k_0=0.9988085293 +x_0=600000 +y_0=600000 +a=6378298.3 +b=6356657.142669561 +pm=madrid +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2063, utm, 6378249.2, 6356515, "+proj=utm +zone=28 +a=6378249.2 +b=6356515 +towgs84=-23,259,-9,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2064, utm, 6378249.2, 6356515, "+proj=utm +zone=29 +a=6378249.2 +b=6356515 +towgs84=-23,259,-9,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2065, krovak, bessel, "+proj=krovak +lat_0=49.5 +lon_0=42.5 +alpha=30.28813972222222 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel +pm=ferro +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2066, cass, 6378293.645208759, 6356617.987679838, "+proj=cass +lat_0=11.25217861111111 +lon_0=-60.68600888888889 +x_0=37718.66159325 +y_0=36209.91512952 +a=6378293.645208759 +b=6356617.987679838 +to_meter=0.201166195164 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2067, utm, intl, "+proj=utm +zone=20 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2068, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=9 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2069, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=11 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2070, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=13 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2071, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2072, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=17 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2073, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=19 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2074, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=21 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2075, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=23 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2076, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=25 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2077, utm, intl, "+proj=utm +zone=32 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2078, utm, intl, "+proj=utm +zone=33 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2079, utm, intl, "+proj=utm +zone=34 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2080, utm, intl, "+proj=utm +zone=35 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2081, tmerc, intl, "+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2082, tmerc, intl, "+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0=0 +ellps=intl +towgs84=27.5,14,186.4,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2083, tmerc, intl, "+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2084, utm, intl, "+proj=utm +zone=19 +south +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2085, lcc, clrk66, NAD27, "+proj=lcc +lat_1=22.35 +lat_0=22.35 +lon_0=-81 +k_0=0.99993602 +x_0=500000 +y_0=280296.016 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2086, lcc, clrk66, NAD27, "+proj=lcc +lat_1=20.71666666666667 +lat_0=20.71666666666667 +lon_0=-76.83333333333333 +k_0=0.99994848 +x_0=500000 +y_0=229126.939 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2087, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9996 +x_0=500000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2088, tmerc, 6378249.2, 6356515, "+proj=tmerc +lat_0=0 +lon_0=11 +k=0.9996 +x_0=500000 +y_0=0 +a=6378249.2 +b=6356515 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2089, utm, WGS84, "+proj=utm +zone=38 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2090, utm, WGS84, "+proj=utm +zone=39 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2091, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=8500000 +y_0=0 +ellps=krass +towgs84=-76,-138,67,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2092, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=9500000 +y_0=0 +ellps=krass +towgs84=-76,-138,67,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2093, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=106 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=-17.51,-108.32,-62.39,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2094, tmerc, WGS72, "+proj=tmerc +lat_0=0 +lon_0=106 +k=0.9996 +x_0=500000 +y_0=0 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2095, utm, intl, "+proj=utm +zone=28 +ellps=intl +towgs84=-173,253,27,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2096, tmerc, bessel, "+proj=tmerc +lat_0=38 +lon_0=129 +k=1 +x_0=200000 +y_0=500000 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2097, tmerc, bessel, "+proj=tmerc +lat_0=38 +lon_0=127 +k=1 +x_0=200000 +y_0=500000 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2098, tmerc, bessel, "+proj=tmerc +lat_0=38 +lon_0=125 +k=1 +x_0=200000 +y_0=500000 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2099, cass, helmert, "+proj=cass +lat_0=25.38236111111111 +lon_0=50.76138888888889 +x_0=100000 +y_0=100000 +ellps=helmert +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2100, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9996 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=-199.87,74.79,246.62,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2101, lcc, intl, "+proj=lcc +lat_1=10.16666666666667 +lat_0=10.16666666666667 +lon_0=-71.60561777777777 +k_0=1 +x_0=0 +y_0=-52684.972 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2102, lcc, intl, "+proj=lcc +lat_1=10.16666666666667 +lat_0=10.16666666666667 +lon_0=-71.60561777777777 +k_0=1 +x_0=200000 +y_0=147315.028 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2103, lcc, intl, "+proj=lcc +lat_1=10.16666666666667 +lat_0=10.16666666666667 +lon_0=-71.60561777777777 +k_0=1 +x_0=500000 +y_0=447315.028 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2104, lcc, intl, "+proj=lcc +lat_1=10.16666666666667 +lat_0=10.16666666666667 +lon_0=-71.60561777777777 +k_0=1 +x_0=-17044 +y_0=-23139.97 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2105, tmerc, GRS80, "+proj=tmerc +lat_0=-36.87972222222222 +lon_0=174.7641666666667 +k=0.9999 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2106, tmerc, GRS80, "+proj=tmerc +lat_0=-37.76111111111111 +lon_0=176.4661111111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2107, tmerc, GRS80, "+proj=tmerc +lat_0=-38.62444444444444 +lon_0=177.8855555555556 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2108, tmerc, GRS80, "+proj=tmerc +lat_0=-39.65083333333333 +lon_0=176.6736111111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2109, tmerc, GRS80, "+proj=tmerc +lat_0=-39.13555555555556 +lon_0=174.2277777777778 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2110, tmerc, GRS80, "+proj=tmerc +lat_0=-39.51222222222222 +lon_0=175.64 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2111, tmerc, GRS80, "+proj=tmerc +lat_0=-40.24194444444444 +lon_0=175.4880555555555 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2112, tmerc, GRS80, "+proj=tmerc +lat_0=-40.92527777777777 +lon_0=175.6472222222222 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2113, tmerc, GRS80, "+proj=tmerc +lat_0=-41.3011111111111 +lon_0=174.7763888888889 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2114, tmerc, GRS80, "+proj=tmerc +lat_0=-40.71472222222223 +lon_0=172.6719444444444 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2115, tmerc, GRS80, "+proj=tmerc +lat_0=-41.27444444444444 +lon_0=173.2991666666667 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2116, tmerc, GRS80, "+proj=tmerc +lat_0=-41.28972222222222 +lon_0=172.1088888888889 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2117, tmerc, GRS80, "+proj=tmerc +lat_0=-41.81055555555555 +lon_0=171.5811111111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2118, tmerc, GRS80, "+proj=tmerc +lat_0=-42.33361111111111 +lon_0=171.5497222222222 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2119, tmerc, GRS80, "+proj=tmerc +lat_0=-42.68888888888888 +lon_0=173.01 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2120, tmerc, GRS80, "+proj=tmerc +lat_0=-41.54444444444444 +lon_0=173.8019444444444 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2121, tmerc, GRS80, "+proj=tmerc +lat_0=-42.88611111111111 +lon_0=170.9797222222222 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2122, tmerc, GRS80, "+proj=tmerc +lat_0=-43.11 +lon_0=170.2608333333333 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2123, tmerc, GRS80, "+proj=tmerc +lat_0=-43.97777777777778 +lon_0=168.6061111111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2124, tmerc, GRS80, "+proj=tmerc +lat_0=-43.59055555555556 +lon_0=172.7269444444445 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2125, tmerc, GRS80, "+proj=tmerc +lat_0=-43.74861111111111 +lon_0=171.3605555555555 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2126, tmerc, GRS80, "+proj=tmerc +lat_0=-44.40194444444445 +lon_0=171.0572222222222 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2127, tmerc, GRS80, "+proj=tmerc +lat_0=-44.735 +lon_0=169.4675 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2128, tmerc, GRS80, "+proj=tmerc +lat_0=-45.13277777777778 +lon_0=168.3986111111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2129, tmerc, GRS80, "+proj=tmerc +lat_0=-45.56361111111111 +lon_0=167.7386111111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2130, tmerc, GRS80, "+proj=tmerc +lat_0=-45.81611111111111 +lon_0=170.6283333333333 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2131, tmerc, GRS80, "+proj=tmerc +lat_0=-45.86138888888889 +lon_0=170.2825 +k=0.99996 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2132, tmerc, GRS80, "+proj=tmerc +lat_0=-46.6 +lon_0=168.3427777777778 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2133, utm, GRS80, "+proj=utm +zone=58 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2134, utm, GRS80, "+proj=utm +zone=59 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2135, utm, GRS80, "+proj=utm +zone=60 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2136, tmerc, 6378300, 6356751.689189189, "+proj=tmerc +lat_0=4.666666666666667 +lon_0=-1 +k=0.99975 +x_0=274319.7391633579 +y_0=0 +a=6378300 +b=6356751.689189189 +towgs84=-199,32,322,0,0,0,0 +to_meter=0.3047997101815088 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2137, tmerc, 6378300, 6356751.689189189, "+proj=tmerc +lat_0=0 +lon_0=-1 +k=0.9996 +x_0=500000 +y_0=0 +a=6378300 +b=6356751.689189189 +towgs84=-199,32,322,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2138, lcc, clrk66, "+proj=lcc +lat_1=60 +lat_2=46 +lat_0=44 +lon_0=-68.5 +x_0=0 +y_0=0 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2139, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-55.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2140, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-58.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2141, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-61.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2142, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-64.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2143, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-67.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2144, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-70.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2145, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-73.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2146, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-76.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2147, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-79.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2148, utm, GRS80, "+proj=utm +zone=21 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2149, utm, GRS80, "+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2150, utm, GRS80, "+proj=utm +zone=17 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2151, utm, GRS80, "+proj=utm +zone=13 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2152, utm, GRS80, "+proj=utm +zone=12 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2153, utm, GRS80, "+proj=utm +zone=11 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2154, lcc, GRS80, "+proj=lcc +lat_1=49 +lat_2=44 +lat_0=46.5 +lon_0=3 +x_0=700000 +y_0=6600000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2155, lcc, clrk66, "+proj=lcc +lat_1=-14.26666666666667 +lat_0=-14.26666666666667 +lon_0=170 +k_0=1 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +towgs84=-115,118,426,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2156, utm, GRS80, "+proj=utm +zone=59 +south +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2157, tmerc, GRS80, "+proj=tmerc +lat_0=53.5 +lon_0=-8 +k=0.99982 +x_0=600000 +y_0=750000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2158, utm, GRS80, "+proj=utm +zone=29 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2159, tmerc, 6378300, 6356751.689189189, "+proj=tmerc +lat_0=6.666666666666667 +lon_0=-12 +k=1 +x_0=152399.8550907544 +y_0=0 +a=6378300 +b=6356751.689189189 +to_meter=0.3047997101815088 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2160, tmerc, 6378300, 6356751.689189189, "+proj=tmerc +lat_0=6.666666666666667 +lon_0=-12 +k=1 +x_0=243839.7681452071 +y_0=182879.8261089053 +a=6378300 +b=6356751.689189189 +to_meter=0.3047997101815088 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2161, utm, clrk80, "+proj=utm +zone=28 +ellps=clrk80 +towgs84=-88,4,101,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2162, utm, clrk80, "+proj=utm +zone=29 +ellps=clrk80 +towgs84=-88,4,101,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (epsg, 2163, laea, 6370997, "+proj=laea +lat_0=45 +lon_0=-100 +x_0=0 +y_0=0 +a=6370997 +b=6370997 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2164, tmerc, clrk80, "+proj=tmerc +lat_0=0 +lon_0=-5 +k=0.9996 +x_0=500000 +y_0=0 +ellps=clrk80 +towgs84=-125,53,467,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2165, tmerc, clrk80, "+proj=tmerc +lat_0=0 +lon_0=-5 +k=0.9996 +x_0=500000 +y_0=0 +ellps=clrk80 +towgs84=-124.76,53,466.79,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2166, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +ellps=krass +towgs84=24,-123,-94,0.02,-0.25,-0.13,1.1 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2167, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 +ellps=krass +towgs84=24,-123,-94,0.02,-0.25,-0.13,1.1 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2168, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 +ellps=krass +towgs84=24,-123,-94,0.02,-0.25,-0.13,1.1 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2169, tmerc, intl, "+proj=tmerc +lat_0=49.83333333333334 +lon_0=6.166666666666667 +k=1 +x_0=80000 +y_0=100000 +ellps=intl +towgs84=-193,13.7,-39.3,-0.41,-2.933,2.688,0.43 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2170, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9999 +x_0=500000 +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2171, sterea, krass, "+proj=sterea +lat_0=50.625 +lon_0=21.08333333333333 +k=0.9998 +x_0=4637000 +y_0=5647000 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2172, sterea, krass, "+proj=sterea +lat_0=53.00194444444445 +lon_0=21.50277777777778 +k=0.9998 +x_0=4603000 +y_0=5806000 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2173, sterea, krass, "+proj=sterea +lat_0=53.58333333333334 +lon_0=17.00833333333333 +k=0.9998 +x_0=3501000 +y_0=5999000 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2174, sterea, krass, "+proj=sterea +lat_0=51.67083333333333 +lon_0=16.67222222222222 +k=0.9998 +x_0=3703000 +y_0=5627000 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2175, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=18.95833333333333 +k=0.999983 +x_0=237000 +y_0=-4700000 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2176, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.999923 +x_0=5500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2177, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=18 +k=0.999923 +x_0=6500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2178, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=21 +k=0.999923 +x_0=7500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2179, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=24 +k=0.999923 +x_0=8500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2180, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=19 +k=0.9993 +x_0=500000 +y_0=-5300000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2188, utm, intl, "+proj=utm +zone=25 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2189, utm, intl, "+proj=utm +zone=26 +ellps=intl +towgs84=-104,167,-38,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2190, utm, intl, "+proj=utm +zone=26 +ellps=intl +towgs84=-203,141,53,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2191, utm, intl, "+proj=utm +zone=28 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2192, lcc, intl, "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=2.337229166666667 +k_0=0.99987742 +x_0=600000 +y_0=2200000 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2193, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=173 +k=0.9996 +x_0=1600000 +y_0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2194, lcc, clrk66, "+proj=lcc +lat_1=-14.26666666666667 +lat_0=-14.26666666666667 +lon_0=-170 +k_0=1 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +towgs84=-115,118,426,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2195, utm, GRS80, "+proj=utm +zone=2 +south +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2196, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=9.5 +k=0.99995 +x_0=200000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2197, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=12 +k=0.99995 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2198, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=900000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2199, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2200, sterea, 6378135, 6356750.304921594, "+proj=sterea +lat_0=46.5 +lon_0=-66.5 +k=0.999912 +x_0=300000 +y_0=800000 +a=6378135 +b=6356750.304921594 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2201, utm, GRS80, "+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2202, utm, GRS80, "+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2203, utm, GRS80, "+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2204, lcc, clrk66, NAD27, "+proj=lcc +lat_1=35.25 +lat_2=36.41666666666666 +lat_0=34.66666666666666 +lon_0=-86 +x_0=609601.2192024384 +y_0=30480.06096012192 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2205, lcc, GRS80, NAD83, "+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2206, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=9500000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2207, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=10500000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2208, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=11500000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2209, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=12500000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2210, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=13500000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2211, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=14500000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2212, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=15500000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2213, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=30 +k=0.9996 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2214, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=10.5 +k=0.999 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs84=-206.1,-174.7,-87.7,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2215, utm, 6378249.2, 6356515, "+proj=utm +zone=32 +a=6378249.2 +b=6356515 +towgs84=-70.9,-151.8,-41.4,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2216, utm, intl, "+proj=utm +zone=22 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2217, utm, intl, "+proj=utm +zone=23 +ellps=intl +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 2218, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2219, utm, 6378135, 6356750.304921594, "+proj=utm +zone=19 +a=6378135 +b=6356750.304921594 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2220, utm, 6378135, 6356750.304921594, "+proj=utm +zone=20 +a=6378135 +b=6356750.304921594 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 2221, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2222, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2223, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2224, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0=213360 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2225, lcc, GRS80, NAD83, "+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.33333333333334 +lon_0=-122 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2226, lcc, GRS80, NAD83, "+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2227, lcc, GRS80, NAD83, "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666667 +lat_0=36.5 +lon_0=-120.5 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2228, lcc, GRS80, NAD83, "+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.33333333333334 +lon_0=-119 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2229, lcc, GRS80, NAD83, "+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333333 +lat_0=33.5 +lon_0=-118 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2230, lcc, GRS80, NAD83, "+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2231, lcc, GRS80, NAD83, "+proj=lcc +lat_1=40.78333333333333 +lat_2=39.71666666666667 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.6096012192 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2232, lcc, GRS80, NAD83, "+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.83333333333334 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.6096012192 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2233, lcc, GRS80, NAD83, "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.6096012192 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2234, lcc, GRS80, NAD83, "+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40.83333333333334 +lon_0=-72.75 +x_0=304800.6096012192 +y_0=152400.3048006096 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2235, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999995 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2236, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999941177 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2237, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999941177 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2238, lcc, GRS80, NAD83, "+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=29 +lon_0=-84.5 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2239, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.9999 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2240, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.9999 +x_0=699999.9998983998 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2241, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666666667 +k=0.9999473679999999 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2242, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.9999473679999999 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2243, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0.999933333 +x_0=800000.0001016001 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2244, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.999966667 +x_0=99999.99989839978 +y_0=249364.9987299975 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2245, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.999966667 +x_0=900000 +y_0=249364.9987299975 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2246, lcc, GRS80, NAD83, "+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2247, lcc, GRS80, NAD83, "+proj=lcc +lat_1=37.93333333333333 +lat_2=36.73333333333333 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=500000.0001016001 +y_0=500000.0001016001 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2248, lcc, GRS80, NAD83, "+proj=lcc +lat_1=39.45 +lat_2=38.3 +lat_0=37.66666666666666 +lon_0=-77 +x_0=399999.9998983998 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2249, lcc, GRS80, NAD83, "+proj=lcc +lat_1=42.68333333333333 +lat_2=41.71666666666667 +lat_0=41 +lon_0=-71.5 +x_0=200000.0001016002 +y_0=750000 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2250, lcc, GRS80, NAD83, "+proj=lcc +lat_1=41.48333333333333 +lat_2=41.28333333333333 +lat_0=41 +lon_0=-70.5 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2251, lcc, GRS80, NAD83, "+proj=lcc +lat_1=47.08333333333334 +lat_2=45.48333333333333 +lat_0=44.78333333333333 +lon_0=-87 +x_0=7999999.999968001 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2252, lcc, GRS80, NAD83, "+proj=lcc +lat_1=45.7 +lat_2=44.18333333333333 +lat_0=43.31666666666667 +lon_0=-84.36666666666666 +x_0=5999999.999976001 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2253, lcc, GRS80, NAD83, "+proj=lcc +lat_1=43.66666666666666 +lat_2=42.1 +lat_0=41.5 +lon_0=-84.36666666666666 +x_0=3999999.999984 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2254, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=29.5 +lon_0=-88.83333333333333 +k=0.99995 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2255, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=29.5 +lon_0=-90.33333333333333 +k=0.99995 +x_0=699999.9998983998 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2256, lcc, GRS80, NAD83, "+proj=lcc +lat_1=49 +lat_2=45 +lat_0=44.25 +lon_0=-109.5 +x_0=599999.9999976 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2257, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=31 +lon_0=-104.3333333333333 +k=0.999909091 +x_0=165000 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2258, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=31 +lon_0=-106.25 +k=0.9999 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2259, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=31 +lon_0=-107.8333333333333 +k=0.999916667 +x_0=830000.0001016001 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2260, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2261, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=40 +lon_0=-76.58333333333333 +k=0.9999375 +x_0=249999.9998983998 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2262, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=40 +lon_0=-78.58333333333333 +k=0.9999375 +x_0=350000.0001016001 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2263, lcc, GRS80, NAD83, "+proj=lcc +lat_1=41.03333333333333 +lat_2=40.66666666666666 +lat_0=40.16666666666666 +lon_0=-74 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2264, lcc, GRS80, NAD83, "+proj=lcc +lat_1=36.16666666666666 +lat_2=34.33333333333334 +lat_0=33.75 +lon_0=-79 +x_0=609601.2192024384 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2265, lcc, GRS80, NAD83, "+proj=lcc +lat_1=48.73333333333333 +lat_2=47.43333333333333 +lat_0=47 +lon_0=-100.5 +x_0=599999.9999976 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2266, lcc, GRS80, NAD83, "+proj=lcc +lat_1=47.48333333333333 +lat_2=46.18333333333333 +lat_0=45.66666666666666 +lon_0=-100.5 +x_0=599999.9999976 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2267, lcc, GRS80, NAD83, "+proj=lcc +lat_1=36.76666666666667 +lat_2=35.56666666666667 +lat_0=35 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2268, lcc, GRS80, NAD83, "+proj=lcc +lat_1=35.23333333333333 +lat_2=33.93333333333333 +lat_0=33.33333333333334 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2269, lcc, GRS80, NAD83, "+proj=lcc +lat_1=46 +lat_2=44.33333333333334 +lat_0=43.66666666666666 +lon_0=-120.5 +x_0=2500000.0001424 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2270, lcc, GRS80, NAD83, "+proj=lcc +lat_1=44 +lat_2=42.33333333333334 +lat_0=41.66666666666666 +lon_0=-120.5 +x_0=1500000.0001464 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2271, lcc, GRS80, NAD83, "+proj=lcc +lat_1=41.95 +lat_2=40.88333333333333 +lat_0=40.16666666666666 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2272, lcc, GRS80, NAD83, "+proj=lcc +lat_1=40.96666666666667 +lat_2=39.93333333333333 +lat_0=39.33333333333334 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2273, lcc, GRS80, NAD83, "+proj=lcc +lat_1=34.83333333333334 +lat_2=32.5 +lat_0=31.83333333333333 +lon_0=-81 +x_0=609600 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2274, lcc, GRS80, NAD83, "+proj=lcc +lat_1=36.41666666666666 +lat_2=35.25 +lat_0=34.33333333333334 +lon_0=-86 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2275, lcc, GRS80, NAD83, "+proj=lcc +lat_1=36.18333333333333 +lat_2=34.65 +lat_0=34 +lon_0=-101.5 +x_0=200000.0001016002 +y_0=999999.9998983998 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2276, lcc, GRS80, NAD83, "+proj=lcc +lat_1=33.96666666666667 +lat_2=32.13333333333333 +lat_0=31.66666666666667 +lon_0=-98.5 +x_0=600000 +y_0=2000000.0001016 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2277, lcc, GRS80, NAD83, "+proj=lcc +lat_1=31.88333333333333 +lat_2=30.11666666666667 +lat_0=29.66666666666667 +lon_0=-100.3333333333333 +x_0=699999.9998983998 +y_0=3000000 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2278, lcc, GRS80, NAD83, "+proj=lcc +lat_1=30.28333333333333 +lat_2=28.38333333333333 +lat_0=27.83333333333333 +lon_0=-99 +x_0=600000 +y_0=3999999.9998984 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2279, lcc, GRS80, NAD83, "+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666667 +lat_0=25.66666666666667 +lon_0=-98.5 +x_0=300000.0000000001 +y_0=5000000.0001016 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2280, lcc, GRS80, NAD83, "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000.0001504 +y_0=999999.9999960001 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2281, lcc, GRS80, NAD83, "+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=38.33333333333334 +lon_0=-111.5 +x_0=500000.0001504 +y_0=1999999.999992 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2282, lcc, GRS80, NAD83, "+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=36.66666666666666 +lon_0=-111.5 +x_0=500000.0001504 +y_0=2999999.999988 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2283, lcc, GRS80, NAD83, "+proj=lcc +lat_1=39.2 +lat_2=38.03333333333333 +lat_0=37.66666666666666 +lon_0=-78.5 +x_0=3500000.0001016 +y_0=2000000.0001016 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2284, lcc, GRS80, NAD83, "+proj=lcc +lat_1=37.96666666666667 +lat_2=36.76666666666667 +lat_0=36.33333333333334 +lon_0=-78.5 +x_0=3500000.0001016 +y_0=999999.9998983998 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2285, lcc, GRS80, NAD83, "+proj=lcc +lat_1=48.73333333333333 +lat_2=47.5 +lat_0=47 +lon_0=-120.8333333333333 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2286, lcc, GRS80, NAD83, "+proj=lcc +lat_1=47.33333333333334 +lat_2=45.83333333333334 +lat_0=45.33333333333334 +lon_0=-120.5 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2287, lcc, GRS80, NAD83, "+proj=lcc +lat_1=46.76666666666667 +lat_2=45.56666666666667 +lat_0=45.16666666666666 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2288, lcc, GRS80, NAD83, "+proj=lcc +lat_1=45.5 +lat_2=44.25 +lat_0=43.83333333333334 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2289, lcc, GRS80, NAD83, "+proj=lcc +lat_1=44.06666666666667 +lat_2=42.73333333333333 +lat_0=42 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2290, sterea, 6378135, 6356750.304921594, "+proj=sterea +lat_0=47.25 +lon_0=-63 +k=0.999912 +x_0=700000 +y_0=400000 +a=6378135 +b=6356750.304921594 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2291, sterea, 6378135, 6356750.304921594, "+proj=sterea +lat_0=47.25 +lon_0=-63 +k=0.999912 +x_0=400000 +y_0=800000 +a=6378135 +b=6356750.304921594 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2292, sterea, GRS80, "+proj=sterea +lat_0=47.25 +lon_0=-63 +k=0.999912 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2294, tmerc, 6378135, 6356750.304921594, "+proj=tmerc +lat_0=0 +lon_0=-61.5 +k=0.9999 +x_0=4500000 +y_0=0 +a=6378135 +b=6356750.304921594 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2295, tmerc, 6378135, 6356750.304921594, "+proj=tmerc +lat_0=0 +lon_0=-64.5 +k=0.9999 +x_0=5500000 +y_0=0 +a=6378135 +b=6356750.304921594 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 2296, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 2297, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 2298, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 2299, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 2300, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 2301, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 2302, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 2303, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 2304, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 2305, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 2306, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 2307, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2308, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=109 +k=0.9996 +x_0=500000 +y_0=10000000 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2309, tmerc, WGS84, WGS84, "+proj=tmerc +lat_0=0 +lon_0=116 +k=0.9996 +x_0=500000 +y_0=10000000 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2310, tmerc, WGS84, WGS84, "+proj=tmerc +lat_0=0 +lon_0=132 +k=0.9996 +x_0=500000 +y_0=10000000 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2311, tmerc, WGS84, WGS84, "+proj=tmerc +lat_0=0 +lon_0=6 +k=0.9996 +x_0=500000 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2312, utm, clrk80, "+proj=utm +zone=33 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2313, utm, clrk80, "+proj=utm +zone=33 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2314, cass, 6378293.645208759, 6356617.987679838, "+proj=cass +lat_0=10.44166666666667 +lon_0=-61.33333333333334 +x_0=86501.46392052001 +y_0=65379.0134283 +a=6378293.645208759 +b=6356617.987679838 +to_meter=0.3047972654 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2315, utm, intl, "+proj=utm +zone=19 +south +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2316, utm, intl, "+proj=utm +zone=20 +south +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2317, lcc, intl, "+proj=lcc +lat_1=9 +lat_2=3 +lat_0=6 +lon_0=-66 +x_0=1000000 +y_0=1000000 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2318, lcc, intl, "+proj=lcc +lat_1=17 +lat_2=33 +lat_0=25.08951 +lon_0=48 +x_0=0 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2319, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2320, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=500000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2321, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2322, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=500000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2323, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2324, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=500000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2325, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2326, tmerc, intl, "+proj=tmerc +lat_0=22.31213333333334 +lon_0=114.1785555555556 +k=1 +x_0=836694.05 +y_0=819069.8 +ellps=intl +towgs84=-162.619,-276.959,-161.764,0.067753,-2.24365,-1.15883,-1.09425 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2327, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=13500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2328, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=14500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2329, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=15500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2330, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=16500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2331, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=17500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2332, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2333, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2334, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=20500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2335, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=21500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2336, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=22500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2337, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=23500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2338, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2339, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2340, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2341, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2342, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2343, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2344, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2345, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2346, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2347, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2348, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2349, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=25500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2350, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=26500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2351, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=27500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2352, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=28500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2353, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=29500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2354, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=30500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2355, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=31500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2356, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=32500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2357, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=33500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2358, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=34500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2359, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=35500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2360, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=36500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2361, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=37500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2362, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=38500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2363, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=39500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2364, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=40500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2365, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=41500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2366, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=42500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2367, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=43500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2368, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=44500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2369, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=45500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2370, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2371, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2372, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2373, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2374, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2375, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2376, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2377, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2378, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2379, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2380, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2381, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2382, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2383, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2384, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2385, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2386, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2387, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2388, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2389, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2390, tmerc, 6378140, 6356755.288157528, "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2391, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=1500000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2392, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=2500000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2393, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=3500000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2394, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=4500000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2395, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=8500000 +y_0=0 +ellps=krass +towgs84=-76,-138,67,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2396, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=9500000 +y_0=0 +ellps=krass +towgs84=-76,-138,67,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2397, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +ellps=krass +towgs84=24,-123,-94,0.02,-0.25,-0.13,1.1 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2398, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 +ellps=krass +towgs84=24,-123,-94,0.02,-0.25,-0.13,1.1 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2399, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 +ellps=krass +towgs84=24,-123,-94,0.02,-0.25,-0.13,1.1 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2400, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=15.80827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2401, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=25500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2402, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=26500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2403, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=27500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2404, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=28500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2405, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=29500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2406, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=30500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2407, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=31500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2408, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=32500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2409, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=33500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2410, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=34500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2411, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=35500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2412, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=36500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2413, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=37500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2414, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=38500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2415, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=39500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2416, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=40500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2417, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=41500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2418, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=42500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2419, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=43500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2420, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=44500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2421, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=45500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2422, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2423, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2424, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2425, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2426, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2427, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2428, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2429, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2430, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2431, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2432, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2433, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2434, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2435, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2436, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2437, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2438, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2439, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2440, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2441, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2442, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2443, tmerc, GRS80, "+proj=tmerc +lat_0=33 +lon_0=129.5 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2444, tmerc, GRS80, "+proj=tmerc +lat_0=33 +lon_0=131 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2445, tmerc, GRS80, "+proj=tmerc +lat_0=36 +lon_0=132.1666666666667 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2446, tmerc, GRS80, "+proj=tmerc +lat_0=33 +lon_0=133.5 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2447, tmerc, GRS80, "+proj=tmerc +lat_0=36 +lon_0=134.3333333333333 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2448, tmerc, GRS80, "+proj=tmerc +lat_0=36 +lon_0=136 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2449, tmerc, GRS80, "+proj=tmerc +lat_0=36 +lon_0=137.1666666666667 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2450, tmerc, GRS80, "+proj=tmerc +lat_0=36 +lon_0=138.5 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2451, tmerc, GRS80, "+proj=tmerc +lat_0=36 +lon_0=139.8333333333333 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2452, tmerc, GRS80, "+proj=tmerc +lat_0=40 +lon_0=140.8333333333333 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2453, tmerc, GRS80, "+proj=tmerc +lat_0=44 +lon_0=140.25 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2454, tmerc, GRS80, "+proj=tmerc +lat_0=44 +lon_0=142.25 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2455, tmerc, GRS80, "+proj=tmerc +lat_0=44 +lon_0=144.25 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2456, tmerc, GRS80, "+proj=tmerc +lat_0=26 +lon_0=142 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2457, tmerc, GRS80, "+proj=tmerc +lat_0=26 +lon_0=127.5 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2458, tmerc, GRS80, "+proj=tmerc +lat_0=26 +lon_0=124 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2459, tmerc, GRS80, "+proj=tmerc +lat_0=26 +lon_0=131 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2460, tmerc, GRS80, "+proj=tmerc +lat_0=20 +lon_0=136 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2461, tmerc, GRS80, "+proj=tmerc +lat_0=26 +lon_0=154 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2462, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2463, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2464, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2465, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2466, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2467, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2468, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2469, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2470, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2471, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2472, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2473, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2474, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2475, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2476, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2477, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2478, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2479, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2480, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2481, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2482, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2483, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2484, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2485, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2486, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2487, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2488, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2489, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2490, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2491, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2492, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2493, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2494, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2495, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2496, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2497, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2498, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2499, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2500, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2501, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2502, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2503, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2504, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2505, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2506, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2507, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2508, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2509, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2510, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2511, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2512, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2513, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2514, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2515, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2516, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2517, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2518, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2519, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2520, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2521, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2522, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2523, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=7500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2524, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=8500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2525, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=9500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2526, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=10500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2527, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=11500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2528, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=12500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2529, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=13500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2530, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=14500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2531, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=15500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2532, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=48 +k=1 +x_0=16500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2533, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=17500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2534, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=54 +k=1 +x_0=18500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2535, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=19500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2536, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=60 +k=1 +x_0=20500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2537, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=21500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2538, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=66 +k=1 +x_0=22500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2539, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=23500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2540, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=72 +k=1 +x_0=24500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2541, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=25500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2542, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=26500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2543, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=27500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2544, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=28500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2545, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=29500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2546, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=30500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2547, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=31500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2548, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=32500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2549, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=33500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2550, utm, bessel, "+proj=utm +zone=50 +south +ellps=bessel +towgs84=-404.78,685.68,45.47,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2551, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=34500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2552, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=35500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2553, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=36500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2554, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=37500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2555, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=38500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2556, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=39500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2557, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=40500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2558, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=41500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2559, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=42500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2560, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=43500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2561, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=44500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2562, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=45500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2563, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=138 +k=1 +x_0=46500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2564, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=47500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2565, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=144 +k=1 +x_0=48500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2566, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=49500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2567, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=150 +k=1 +x_0=50500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2568, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=51500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2569, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=156 +k=1 +x_0=52500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2570, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=53500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2571, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=162 +k=1 +x_0=54500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2572, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=55500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2573, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=168 +k=1 +x_0=56500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2574, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=57500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2575, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=174 +k=1 +x_0=58500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2576, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=59500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2577, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=180 +k=1 +x_0=60000000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2578, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=61500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2579, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=-174 +k=1 +x_0=62500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2580, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=63500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2581, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=-168 +k=1 +x_0=64500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2582, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2583, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2584, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2585, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2586, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2587, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2588, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2589, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2590, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2591, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=48 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2592, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2593, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=54 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2594, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2595, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=60 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2596, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2597, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=66 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2598, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2599, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=72 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2600, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9998 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2601, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2602, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2603, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2604, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2605, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2606, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2607, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2608, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2609, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2610, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2611, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2612, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2613, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2614, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2615, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2616, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2617, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2618, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2619, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2620, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2621, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2622, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=138 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2623, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2624, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=144 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2625, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2626, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=150 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2627, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2628, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=156 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2629, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2630, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=162 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2631, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2632, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=168 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2633, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2634, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=174 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2635, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2636, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=180 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2637, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2638, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=-174 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2639, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2640, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=-168 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2641, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=7500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2642, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=8500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2643, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=9500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2644, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=10500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2645, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=11500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2646, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=12500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2647, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=13500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2648, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=14500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2649, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=15500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2650, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=48 +k=1 +x_0=16500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2651, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=17500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2652, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=54 +k=1 +x_0=18500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2653, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=19500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2654, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=60 +k=1 +x_0=20500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2655, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=21500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2656, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=66 +k=1 +x_0=22500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2657, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=23500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2658, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=72 +k=1 +x_0=24500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2659, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=25500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2660, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=26500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2661, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=27500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2662, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=28500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2663, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=29500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2664, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=30500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2665, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=31500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2666, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=32500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2667, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=33500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2668, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=34500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2669, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=35500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2670, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=36500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2671, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=37500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2672, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=38500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2673, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=39500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2674, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=40500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2675, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=41500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2676, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=42500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2677, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=43500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2678, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=44500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2679, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=45500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2680, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=138 +k=1 +x_0=46500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2681, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=47500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2682, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=144 +k=1 +x_0=48500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2683, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=49500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2684, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=150 +k=1 +x_0=50500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2685, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=51500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2686, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=156 +k=1 +x_0=52500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2687, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=53500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2688, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=162 +k=1 +x_0=54500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2689, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=55500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2690, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=168 +k=1 +x_0=56500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2691, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=57500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2692, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=174 +k=1 +x_0=58500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2693, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=59500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2694, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=180 +k=1 +x_0=60000000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2695, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=61500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2696, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=-174 +k=1 +x_0=62500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2697, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=63500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2698, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=-168 +k=1 +x_0=64500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2699, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2700, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2701, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2702, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2703, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2704, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2705, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2706, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2707, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2708, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=48 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2709, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2710, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=54 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2711, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2712, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=60 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2713, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2714, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=66 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2715, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2716, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=72 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2717, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2718, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2719, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2720, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2721, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2722, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2723, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2724, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2725, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2726, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2727, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2728, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2729, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2730, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2731, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2732, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2733, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2734, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2735, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2736, utm, clrk66, "+proj=utm +zone=36 +south +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2737, utm, clrk66, "+proj=utm +zone=37 +south +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2738, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2739, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2740, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=138 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2741, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2742, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=144 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2743, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2744, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=150 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2745, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2746, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=156 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2747, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2748, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=162 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2749, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2750, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=168 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2751, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2752, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=174 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2753, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2754, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=180 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2755, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2756, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=-174 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2757, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2758, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=-168 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2759, tmerc, GRS80, "+proj=tmerc +lat_0=30.5 +lon_0=-85.83333333333333 +k=0.99996 +x_0=200000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2760, tmerc, GRS80, "+proj=tmerc +lat_0=30 +lon_0=-87.5 +k=0.999933333 +x_0=600000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2761, tmerc, GRS80, "+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2762, tmerc, GRS80, "+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2763, tmerc, GRS80, "+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0=213360 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2764, lcc, GRS80, "+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=400000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2765, lcc, GRS80, "+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32.66666666666666 +lon_0=-92 +x_0=400000 +y_0=400000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2766, lcc, GRS80, "+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.33333333333334 +lon_0=-122 +x_0=2000000 +y_0=500000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2767, lcc, GRS80, "+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=2000000 +y_0=500000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2768, lcc, GRS80, "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666667 +lat_0=36.5 +lon_0=-120.5 +x_0=2000000 +y_0=500000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2769, lcc, GRS80, "+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.33333333333334 +lon_0=-119 +x_0=2000000 +y_0=500000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2770, lcc, GRS80, "+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333333 +lat_0=33.5 +lon_0=-118 +x_0=2000000 +y_0=500000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2771, lcc, GRS80, "+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=2000000 +y_0=500000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2772, lcc, GRS80, "+proj=lcc +lat_1=40.78333333333333 +lat_2=39.71666666666667 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=914401.8289 +y_0=304800.6096 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2773, lcc, GRS80, "+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.83333333333334 +lon_0=-105.5 +x_0=914401.8289 +y_0=304800.6096 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2774, lcc, GRS80, "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=914401.8289 +y_0=304800.6096 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2775, lcc, GRS80, "+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40.83333333333334 +lon_0=-72.75 +x_0=304800.6096 +y_0=152400.3048 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2776, tmerc, GRS80, "+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999995 +x_0=200000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2777, tmerc, GRS80, "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999941177 +x_0=200000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2778, tmerc, GRS80, "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999941177 +x_0=200000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2779, lcc, GRS80, "+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=29 +lon_0=-84.5 +x_0=600000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2780, tmerc, GRS80, "+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.9999 +x_0=200000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2781, tmerc, GRS80, "+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.9999 +x_0=700000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2782, tmerc, GRS80, "+proj=tmerc +lat_0=18.83333333333333 +lon_0=-155.5 +k=0.999966667 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2783, tmerc, GRS80, "+proj=tmerc +lat_0=20.33333333333333 +lon_0=-156.6666666666667 +k=0.999966667 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2784, tmerc, GRS80, "+proj=tmerc +lat_0=21.16666666666667 +lon_0=-158 +k=0.99999 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2785, tmerc, GRS80, "+proj=tmerc +lat_0=21.83333333333333 +lon_0=-159.5 +k=0.99999 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2786, tmerc, GRS80, "+proj=tmerc +lat_0=21.66666666666667 +lon_0=-160.1666666666667 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2787, tmerc, GRS80, "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666666667 +k=0.9999473679999999 +x_0=200000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2788, tmerc, GRS80, "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.9999473679999999 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2789, tmerc, GRS80, "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0.999933333 +x_0=800000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2790, tmerc, GRS80, "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333333333 +k=0.9999749999999999 +x_0=300000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2791, tmerc, GRS80, "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-90.16666666666667 +k=0.999941177 +x_0=700000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2792, tmerc, GRS80, "+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.999966667 +x_0=100000 +y_0=250000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2793, tmerc, GRS80, "+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.999966667 +x_0=900000 +y_0=250000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2794, lcc, GRS80, "+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666667 +lat_0=41.5 +lon_0=-93.5 +x_0=1500000 +y_0=1000000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2795, lcc, GRS80, "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.61666666666667 +lat_0=40 +lon_0=-93.5 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2796, lcc, GRS80, "+proj=lcc +lat_1=39.78333333333333 +lat_2=38.71666666666667 +lat_0=38.33333333333334 +lon_0=-98 +x_0=400000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2797, lcc, GRS80, "+proj=lcc +lat_1=38.56666666666667 +lat_2=37.26666666666667 +lat_0=36.66666666666666 +lon_0=-98.5 +x_0=400000 +y_0=400000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2798, lcc, GRS80, "+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2799, lcc, GRS80, "+proj=lcc +lat_1=37.93333333333333 +lat_2=36.73333333333333 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=500000 +y_0=500000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2800, lcc, GRS80, "+proj=lcc +lat_1=32.66666666666666 +lat_2=31.16666666666667 +lat_0=30.5 +lon_0=-92.5 +x_0=1000000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2801, lcc, GRS80, "+proj=lcc +lat_1=30.7 +lat_2=29.3 +lat_0=28.5 +lon_0=-91.33333333333333 +x_0=1000000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2802, tmerc, GRS80, "+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9999 +x_0=300000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2803, tmerc, GRS80, "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2804, lcc, GRS80, "+proj=lcc +lat_1=39.45 +lat_2=38.3 +lat_0=37.66666666666666 +lon_0=-77 +x_0=400000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2805, lcc, GRS80, "+proj=lcc +lat_1=42.68333333333333 +lat_2=41.71666666666667 +lat_0=41 +lon_0=-71.5 +x_0=200000 +y_0=750000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2806, lcc, GRS80, "+proj=lcc +lat_1=41.48333333333333 +lat_2=41.28333333333333 +lat_0=41 +lon_0=-70.5 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2807, lcc, GRS80, "+proj=lcc +lat_1=47.08333333333334 +lat_2=45.48333333333333 +lat_0=44.78333333333333 +lon_0=-87 +x_0=8000000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2808, lcc, GRS80, "+proj=lcc +lat_1=45.7 +lat_2=44.18333333333333 +lat_0=43.31666666666667 +lon_0=-84.36666666666666 +x_0=6000000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2809, lcc, GRS80, "+proj=lcc +lat_1=43.66666666666666 +lat_2=42.1 +lat_0=41.5 +lon_0=-84.36666666666666 +x_0=4000000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2810, lcc, GRS80, "+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000 +y_0=100000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2811, lcc, GRS80, "+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=45 +lon_0=-94.25 +x_0=800000 +y_0=100000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2812, lcc, GRS80, "+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333333 +lat_0=43 +lon_0=-94 +x_0=800000 +y_0=100000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2813, tmerc, GRS80, "+proj=tmerc +lat_0=29.5 +lon_0=-88.83333333333333 +k=0.99995 +x_0=300000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2814, tmerc, GRS80, "+proj=tmerc +lat_0=29.5 +lon_0=-90.33333333333333 +k=0.99995 +x_0=700000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2815, tmerc, GRS80, "+proj=tmerc +lat_0=35.83333333333334 +lon_0=-90.5 +k=0.999933333 +x_0=250000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2816, tmerc, GRS80, "+proj=tmerc +lat_0=35.83333333333334 +lon_0=-92.5 +k=0.999933333 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2817, tmerc, GRS80, "+proj=tmerc +lat_0=36.16666666666666 +lon_0=-94.5 +k=0.999941177 +x_0=850000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2818, lcc, GRS80, "+proj=lcc +lat_1=49 +lat_2=45 +lat_0=44.25 +lon_0=-109.5 +x_0=600000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2819, lcc, GRS80, "+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +lon_0=-100 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2820, tmerc, GRS80, "+proj=tmerc +lat_0=34.75 +lon_0=-115.5833333333333 +k=0.9999 +x_0=200000 +y_0=8000000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2821, tmerc, GRS80, "+proj=tmerc +lat_0=34.75 +lon_0=-116.6666666666667 +k=0.9999 +x_0=500000 +y_0=6000000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2822, tmerc, GRS80, "+proj=tmerc +lat_0=34.75 +lon_0=-118.5833333333333 +k=0.9999 +x_0=800000 +y_0=4000000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2823, tmerc, GRS80, "+proj=tmerc +lat_0=42.5 +lon_0=-71.66666666666667 +k=0.999966667 +x_0=300000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2824, tmerc, GRS80, "+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2825, tmerc, GRS80, "+proj=tmerc +lat_0=31 +lon_0=-104.3333333333333 +k=0.999909091 +x_0=165000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2826, tmerc, GRS80, "+proj=tmerc +lat_0=31 +lon_0=-106.25 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2827, tmerc, GRS80, "+proj=tmerc +lat_0=31 +lon_0=-107.8333333333333 +k=0.999916667 +x_0=830000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2828, tmerc, GRS80, "+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2829, tmerc, GRS80, "+proj=tmerc +lat_0=40 +lon_0=-76.58333333333333 +k=0.9999375 +x_0=250000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2830, tmerc, GRS80, "+proj=tmerc +lat_0=40 +lon_0=-78.58333333333333 +k=0.9999375 +x_0=350000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2831, lcc, GRS80, "+proj=lcc +lat_1=41.03333333333333 +lat_2=40.66666666666666 +lat_0=40.16666666666666 +lon_0=-74 +x_0=300000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2832, lcc, GRS80, "+proj=lcc +lat_1=48.73333333333333 +lat_2=47.43333333333333 +lat_0=47 +lon_0=-100.5 +x_0=600000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2833, lcc, GRS80, "+proj=lcc +lat_1=47.48333333333333 +lat_2=46.18333333333333 +lat_0=45.66666666666666 +lon_0=-100.5 +x_0=600000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2834, lcc, GRS80, "+proj=lcc +lat_1=41.7 +lat_2=40.43333333333333 +lat_0=39.66666666666666 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2835, lcc, GRS80, "+proj=lcc +lat_1=40.03333333333333 +lat_2=38.73333333333333 +lat_0=38 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2836, lcc, GRS80, "+proj=lcc +lat_1=36.76666666666667 +lat_2=35.56666666666667 +lat_0=35 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2837, lcc, GRS80, "+proj=lcc +lat_1=35.23333333333333 +lat_2=33.93333333333333 +lat_0=33.33333333333334 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2838, lcc, GRS80, "+proj=lcc +lat_1=46 +lat_2=44.33333333333334 +lat_0=43.66666666666666 +lon_0=-120.5 +x_0=2500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2839, lcc, GRS80, "+proj=lcc +lat_1=44 +lat_2=42.33333333333334 +lat_0=41.66666666666666 +lon_0=-120.5 +x_0=1500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2840, tmerc, GRS80, "+proj=tmerc +lat_0=41.08333333333334 +lon_0=-71.5 +k=0.99999375 +x_0=100000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2841, lcc, GRS80, "+proj=lcc +lat_1=45.68333333333333 +lat_2=44.41666666666666 +lat_0=43.83333333333334 +lon_0=-100 +x_0=600000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2842, lcc, GRS80, "+proj=lcc +lat_1=44.4 +lat_2=42.83333333333334 +lat_0=42.33333333333334 +lon_0=-100.3333333333333 +x_0=600000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2843, lcc, GRS80, "+proj=lcc +lat_1=36.41666666666666 +lat_2=35.25 +lat_0=34.33333333333334 +lon_0=-86 +x_0=600000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2844, lcc, GRS80, "+proj=lcc +lat_1=36.18333333333333 +lat_2=34.65 +lat_0=34 +lon_0=-101.5 +x_0=200000 +y_0=1000000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2845, lcc, GRS80, "+proj=lcc +lat_1=33.96666666666667 +lat_2=32.13333333333333 +lat_0=31.66666666666667 +lon_0=-98.5 +x_0=600000 +y_0=2000000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2846, lcc, GRS80, "+proj=lcc +lat_1=31.88333333333333 +lat_2=30.11666666666667 +lat_0=29.66666666666667 +lon_0=-100.3333333333333 +x_0=700000 +y_0=3000000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2847, lcc, GRS80, "+proj=lcc +lat_1=30.28333333333333 +lat_2=28.38333333333333 +lat_0=27.83333333333333 +lon_0=-99 +x_0=600000 +y_0=4000000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2848, lcc, GRS80, "+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666667 +lat_0=25.66666666666667 +lon_0=-98.5 +x_0=300000 +y_0=5000000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2849, lcc, GRS80, "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000 +y_0=1000000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2850, lcc, GRS80, "+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=38.33333333333334 +lon_0=-111.5 +x_0=500000 +y_0=2000000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2851, lcc, GRS80, "+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=36.66666666666666 +lon_0=-111.5 +x_0=500000 +y_0=3000000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2852, tmerc, GRS80, "+proj=tmerc +lat_0=42.5 +lon_0=-72.5 +k=0.999964286 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2853, lcc, GRS80, "+proj=lcc +lat_1=39.2 +lat_2=38.03333333333333 +lat_0=37.66666666666666 +lon_0=-78.5 +x_0=3500000 +y_0=2000000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2854, lcc, GRS80, "+proj=lcc +lat_1=37.96666666666667 +lat_2=36.76666666666667 +lat_0=36.33333333333334 +lon_0=-78.5 +x_0=3500000 +y_0=1000000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2855, lcc, GRS80, "+proj=lcc +lat_1=48.73333333333333 +lat_2=47.5 +lat_0=47 +lon_0=-120.8333333333333 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2856, lcc, GRS80, "+proj=lcc +lat_1=47.33333333333334 +lat_2=45.83333333333334 +lat_0=45.33333333333334 +lon_0=-120.5 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2857, lcc, GRS80, "+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.5 +x_0=600000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2858, lcc, GRS80, "+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333333 +lat_0=37 +lon_0=-81 +x_0=600000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2859, lcc, GRS80, "+proj=lcc +lat_1=46.76666666666667 +lat_2=45.56666666666667 +lat_0=45.16666666666666 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2860, lcc, GRS80, "+proj=lcc +lat_1=45.5 +lat_2=44.25 +lat_0=43.83333333333334 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2861, lcc, GRS80, "+proj=lcc +lat_1=44.06666666666667 +lat_2=42.73333333333333 +lat_0=42 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2862, tmerc, GRS80, "+proj=tmerc +lat_0=40.5 +lon_0=-105.1666666666667 +k=0.9999375 +x_0=200000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2863, tmerc, GRS80, "+proj=tmerc +lat_0=40.5 +lon_0=-107.3333333333333 +k=0.9999375 +x_0=400000 +y_0=100000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2864, tmerc, GRS80, "+proj=tmerc +lat_0=40.5 +lon_0=-108.75 +k=0.9999375 +x_0=600000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2865, tmerc, GRS80, "+proj=tmerc +lat_0=40.5 +lon_0=-110.0833333333333 +k=0.9999375 +x_0=800000 +y_0=100000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2866, lcc, GRS80, "+proj=lcc +lat_1=18.43333333333333 +lat_2=18.03333333333333 +lat_0=17.83333333333333 +lon_0=-66.43333333333334 +x_0=200000 +y_0=200000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2867, tmerc, GRS80, "+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2868, tmerc, GRS80, "+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2869, tmerc, GRS80, "+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0=213360 +y_0=0 +ellps=GRS80 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2870, lcc, GRS80, "+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.33333333333334 +lon_0=-122 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2871, lcc, GRS80, "+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2872, lcc, GRS80, "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666667 +lat_0=36.5 +lon_0=-120.5 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2873, lcc, GRS80, "+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.33333333333334 +lon_0=-119 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2874, lcc, GRS80, "+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333333 +lat_0=33.5 +lon_0=-118 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2875, lcc, GRS80, "+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2876, lcc, GRS80, "+proj=lcc +lat_1=40.78333333333333 +lat_2=39.71666666666667 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.6096012192 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2877, lcc, GRS80, "+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.83333333333334 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.6096012192 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2878, lcc, GRS80, "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.6096012192 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2879, lcc, GRS80, "+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40.83333333333334 +lon_0=-72.75 +x_0=304800.6096012192 +y_0=152400.3048006096 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2880, tmerc, GRS80, "+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999995 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2881, tmerc, GRS80, "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999941177 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2882, tmerc, GRS80, "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999941177 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2883, lcc, GRS80, "+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=29 +lon_0=-84.5 +x_0=600000 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2884, tmerc, GRS80, "+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.9999 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2885, tmerc, GRS80, "+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.9999 +x_0=699999.9998983998 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2886, tmerc, GRS80, "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666666667 +k=0.9999473679999999 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2887, tmerc, GRS80, "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.9999473679999999 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2888, tmerc, GRS80, "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0.999933333 +x_0=800000.0001016001 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2889, tmerc, GRS80, "+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.999966667 +x_0=99999.99989839978 +y_0=249364.9987299975 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2890, tmerc, GRS80, "+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.999966667 +x_0=900000 +y_0=249364.9987299975 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2891, lcc, GRS80, "+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2892, lcc, GRS80, "+proj=lcc +lat_1=37.93333333333333 +lat_2=36.73333333333333 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=500000.0001016001 +y_0=500000.0001016001 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2893, lcc, GRS80, "+proj=lcc +lat_1=39.45 +lat_2=38.3 +lat_0=37.66666666666666 +lon_0=-77 +x_0=399999.9998983998 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2894, lcc, GRS80, "+proj=lcc +lat_1=42.68333333333333 +lat_2=41.71666666666667 +lat_0=41 +lon_0=-71.5 +x_0=200000.0001016002 +y_0=750000 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2895, lcc, GRS80, "+proj=lcc +lat_1=41.48333333333333 +lat_2=41.28333333333333 +lat_0=41 +lon_0=-70.5 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2896, lcc, GRS80, "+proj=lcc +lat_1=47.08333333333334 +lat_2=45.48333333333333 +lat_0=44.78333333333333 +lon_0=-87 +x_0=7999999.999968001 +y_0=0 +ellps=GRS80 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2897, lcc, GRS80, "+proj=lcc +lat_1=45.7 +lat_2=44.18333333333333 +lat_0=43.31666666666667 +lon_0=-84.36666666666666 +x_0=5999999.999976001 +y_0=0 +ellps=GRS80 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2898, lcc, GRS80, "+proj=lcc +lat_1=43.66666666666666 +lat_2=42.1 +lat_0=41.5 +lon_0=-84.36666666666666 +x_0=3999999.999984 +y_0=0 +ellps=GRS80 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2899, tmerc, GRS80, "+proj=tmerc +lat_0=29.5 +lon_0=-88.83333333333333 +k=0.99995 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2900, tmerc, GRS80, "+proj=tmerc +lat_0=29.5 +lon_0=-90.33333333333333 +k=0.99995 +x_0=699999.9998983998 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2901, lcc, GRS80, "+proj=lcc +lat_1=49 +lat_2=45 +lat_0=44.25 +lon_0=-109.5 +x_0=599999.9999976 +y_0=0 +ellps=GRS80 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2902, tmerc, GRS80, "+proj=tmerc +lat_0=31 +lon_0=-104.3333333333333 +k=0.999909091 +x_0=165000 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2903, tmerc, GRS80, "+proj=tmerc +lat_0=31 +lon_0=-106.25 +k=0.9999 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2904, tmerc, GRS80, "+proj=tmerc +lat_0=31 +lon_0=-107.8333333333333 +k=0.999916667 +x_0=830000.0001016001 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2905, tmerc, GRS80, "+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2906, tmerc, GRS80, "+proj=tmerc +lat_0=40 +lon_0=-76.58333333333333 +k=0.9999375 +x_0=249999.9998983998 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2907, tmerc, GRS80, "+proj=tmerc +lat_0=40 +lon_0=-78.58333333333333 +k=0.9999375 +x_0=350000.0001016001 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2908, lcc, GRS80, "+proj=lcc +lat_1=41.03333333333333 +lat_2=40.66666666666666 +lat_0=40.16666666666666 +lon_0=-74 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2909, lcc, GRS80, "+proj=lcc +lat_1=48.73333333333333 +lat_2=47.43333333333333 +lat_0=47 +lon_0=-100.5 +x_0=599999.9999976 +y_0=0 +ellps=GRS80 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2910, lcc, GRS80, "+proj=lcc +lat_1=47.48333333333333 +lat_2=46.18333333333333 +lat_0=45.66666666666666 +lon_0=-100.5 +x_0=599999.9999976 +y_0=0 +ellps=GRS80 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2911, lcc, GRS80, "+proj=lcc +lat_1=36.76666666666667 +lat_2=35.56666666666667 +lat_0=35 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2912, lcc, GRS80, "+proj=lcc +lat_1=35.23333333333333 +lat_2=33.93333333333333 +lat_0=33.33333333333334 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2913, lcc, GRS80, "+proj=lcc +lat_1=46 +lat_2=44.33333333333334 +lat_0=43.66666666666666 +lon_0=-120.5 +x_0=2500000.0001424 +y_0=0 +ellps=GRS80 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2914, lcc, GRS80, "+proj=lcc +lat_1=44 +lat_2=42.33333333333334 +lat_0=41.66666666666666 +lon_0=-120.5 +x_0=1500000.0001464 +y_0=0 +ellps=GRS80 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2915, lcc, GRS80, "+proj=lcc +lat_1=36.41666666666666 +lat_2=35.25 +lat_0=34.33333333333334 +lon_0=-86 +x_0=600000 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2916, lcc, GRS80, "+proj=lcc +lat_1=36.18333333333333 +lat_2=34.65 +lat_0=34 +lon_0=-101.5 +x_0=200000.0001016002 +y_0=999999.9998983998 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2917, lcc, GRS80, "+proj=lcc +lat_1=33.96666666666667 +lat_2=32.13333333333333 +lat_0=31.66666666666667 +lon_0=-98.5 +x_0=600000 +y_0=2000000.0001016 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2918, lcc, GRS80, "+proj=lcc +lat_1=31.88333333333333 +lat_2=30.11666666666667 +lat_0=29.66666666666667 +lon_0=-100.3333333333333 +x_0=699999.9998983998 +y_0=3000000 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2919, lcc, GRS80, "+proj=lcc +lat_1=30.28333333333333 +lat_2=28.38333333333333 +lat_0=27.83333333333333 +lon_0=-99 +x_0=600000 +y_0=3999999.9998984 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2920, lcc, GRS80, "+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666667 +lat_0=25.66666666666667 +lon_0=-98.5 +x_0=300000.0000000001 +y_0=5000000.0001016 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2921, lcc, GRS80, "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000.0001504 +y_0=999999.9999960001 +ellps=GRS80 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2922, lcc, GRS80, "+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=38.33333333333334 +lon_0=-111.5 +x_0=500000.0001504 +y_0=1999999.999992 +ellps=GRS80 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2923, lcc, GRS80, "+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=36.66666666666666 +lon_0=-111.5 +x_0=500000.0001504 +y_0=2999999.999988 +ellps=GRS80 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2924, lcc, GRS80, "+proj=lcc +lat_1=39.2 +lat_2=38.03333333333333 +lat_0=37.66666666666666 +lon_0=-78.5 +x_0=3500000.0001016 +y_0=2000000.0001016 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2925, lcc, GRS80, "+proj=lcc +lat_1=37.96666666666667 +lat_2=36.76666666666667 +lat_0=36.33333333333334 +lon_0=-78.5 +x_0=3500000.0001016 +y_0=999999.9998983998 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2926, lcc, GRS80, "+proj=lcc +lat_1=48.73333333333333 +lat_2=47.5 +lat_0=47 +lon_0=-120.8333333333333 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2927, lcc, GRS80, "+proj=lcc +lat_1=47.33333333333334 +lat_2=45.83333333333334 +lat_0=45.33333333333334 +lon_0=-120.5 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2928, lcc, GRS80, "+proj=lcc +lat_1=46.76666666666667 +lat_2=45.56666666666667 +lat_0=45.16666666666666 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2929, lcc, GRS80, "+proj=lcc +lat_1=45.5 +lat_2=44.25 +lat_0=43.83333333333334 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2930, lcc, GRS80, "+proj=lcc +lat_1=44.06666666666667 +lat_2=42.73333333333333 +lat_0=42 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 2931, tmerc, 6378249.2, 6356515, "+proj=tmerc +lat_0=0 +lon_0=13 +k=0.9996 +x_0=500000 +y_0=0 +a=6378249.2 +b=6356515 +towgs84=-106,-87,188,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2932, tmerc, intl, "+proj=tmerc +lat_0=24.45 +lon_0=51.21666666666667 +k=0.99999 +x_0=200000 +y_0=300000 +ellps=intl +towgs84=-119.425,-303.659,-11.0006,1.1643,0.174458,1.09626,3.65706 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2933, utm, bessel, "+proj=utm +zone=50 +south +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2934, merc, bessel, "+proj=merc +lon_0=110 +k=0.997 +x_0=3900000 +y_0=900000 +ellps=bessel +pm=jakarta +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2935, tmerc, krass, "+proj=tmerc +lat_0=0.1166666666666667 +lon_0=41.53333333333333 +k=1 +x_0=1300000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2936, tmerc, krass, "+proj=tmerc +lat_0=0.1166666666666667 +lon_0=44.53333333333333 +k=1 +x_0=2300000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2937, tmerc, krass, "+proj=tmerc +lat_0=0.1166666666666667 +lon_0=47.53333333333333 +k=1 +x_0=3300000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2938, tmerc, krass, "+proj=tmerc +lat_0=0.1166666666666667 +lon_0=50.53333333333333 +k=1 +x_0=4300000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2939, tmerc, krass, "+proj=tmerc +lat_0=0.1333333333333333 +lon_0=50.76666666666667 +k=1 +x_0=2300000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2940, tmerc, krass, "+proj=tmerc +lat_0=0.1333333333333333 +lon_0=53.76666666666667 +k=1 +x_0=3300000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2941, tmerc, krass, "+proj=tmerc +lat_0=0.1333333333333333 +lon_0=56.76666666666667 +k=1 +x_0=4300000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2942, utm, intl, "+proj=utm +zone=28 +ellps=intl +towgs84=-499,-249,314,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2943, utm, intl, "+proj=utm +zone=28 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2944, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-55.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2945, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-58.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2946, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-61.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2947, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-64.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2948, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-67.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2949, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-70.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2950, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-73.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2951, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-76.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2952, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-79.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2953, sterea, GRS80, "+proj=sterea +lat_0=46.5 +lon_0=-66.5 +k=0.999912 +x_0=2500000 +y_0=7500000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2954, sterea, GRS80, "+proj=sterea +lat_0=47.25 +lon_0=-63 +k=0.999912 +x_0=400000 +y_0=800000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2955, utm, GRS80, "+proj=utm +zone=11 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2956, utm, GRS80, "+proj=utm +zone=12 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2957, utm, GRS80, "+proj=utm +zone=13 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2958, utm, GRS80, "+proj=utm +zone=17 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2959, utm, GRS80, "+proj=utm +zone=18 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2960, utm, GRS80, "+proj=utm +zone=19 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2961, utm, GRS80, "+proj=utm +zone=20 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2962, utm, GRS80, "+proj=utm +zone=21 +ellps=GRS80 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 2963, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2964, aea, clrk66, NAD27, "+proj=aea +lat_1=55 +lat_2=65 +lat_0=50 +lon_0=-154 +x_0=0 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2965, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.999966667 +x_0=99999.99989839978 +y_0=249999.9998983998 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2966, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.999966667 +x_0=900000 +y_0=249999.9998983998 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2967, tmerc, GRS80, "+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.999966667 +x_0=99999.99989839978 +y_0=249999.9998983998 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2968, tmerc, GRS80, "+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.999966667 +x_0=900000 +y_0=249999.9998983998 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2969, utm, intl, "+proj=utm +zone=20 +ellps=intl +towgs84=137,248,-430,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2970, utm, intl, "+proj=utm +zone=20 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2971, utm, intl, "+proj=utm +zone=22 +ellps=intl +towgs84=-186,230,110,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2972, utm, GRS80, "+proj=utm +zone=22 +ellps=GRS80 +towgs84=2,2,-2,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2973, utm, intl, "+proj=utm +zone=20 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2975, utm, GRS80, "+proj=utm +zone=40 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2976, utm, intl, "+proj=utm +zone=6 +south +ellps=intl +towgs84=162,117,154,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2977, utm, intl, "+proj=utm +zone=5 +south +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2978, utm, intl, "+proj=utm +zone=7 +south +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2979, utm, intl, "+proj=utm +zone=42 +south +ellps=intl +towgs84=145,-187,103,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2980, utm, intl, "+proj=utm +zone=38 +south +ellps=intl +towgs84=-382,-59,-262,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2981, utm, intl, "+proj=utm +zone=58 +south +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2982, utm, intl, "+proj=utm +zone=58 +south +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2983, utm, intl, "+proj=utm +zone=58 +south +ellps=intl +towgs84=-122.383,-188.696,103.344,3.5107,-4.9668,-5.7047,4.4798 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2984, lcc, intl, "+proj=lcc +lat_1=-20.66666666666667 +lat_2=-22.33333333333333 +lat_0=-21.5 +lon_0=166 +x_0=400000 +y_0=300000 +ellps=intl +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 2985, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 2986, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2987, utm, clrk66, "+proj=utm +zone=21 +ellps=clrk66 +towgs84=30,430,368,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2988, utm, intl, "+proj=utm +zone=1 +south +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2989, utm, WGS84, "+proj=utm +zone=20 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2990, tmerc, intl, "+proj=tmerc +lat_0=-21.11666666666667 +lon_0=55.53333333333333 +k=1 +x_0=50000 +y_0=160000 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2991, lcc, GRS80, NAD83, "+proj=lcc +lat_1=43 +lat_2=45.5 +lat_0=41.75 +lon_0=-120.5 +x_0=400000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 2992, lcc, GRS80, NAD83, "+proj=lcc +lat_1=43 +lat_2=45.5 +lat_0=41.75 +lon_0=-120.5 +x_0=399999.9999984 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2993, lcc, GRS80, "+proj=lcc +lat_1=43 +lat_2=45.5 +lat_0=41.75 +lon_0=-120.5 +x_0=400000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2994, lcc, GRS80, "+proj=lcc +lat_1=43 +lat_2=45.5 +lat_0=41.75 +lon_0=-120.5 +x_0=399999.9999984 +y_0=0 +ellps=GRS80 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2995, utm, intl, "+proj=utm +zone=58 +south +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2996, utm, intl, "+proj=utm +zone=58 +south +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2997, utm, intl, "+proj=utm +zone=58 +south +ellps=intl +towgs84=-480.26,-438.32,-643.429,16.3119,20.1721,-4.0349,-111.7 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2998, utm, intl, "+proj=utm +zone=58 +south +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 2999, utm, intl, "+proj=utm +zone=38 +south +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3000, merc, bessel, "+proj=merc +lon_0=110 +k=0.997 +x_0=3900000 +y_0=900000 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3001, merc, bessel, "+proj=merc +lon_0=110 +k=0.997 +x_0=3900000 +y_0=900000 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3002, merc, bessel, "+proj=merc +lon_0=110 +k=0.997 +x_0=3900000 +y_0=900000 +ellps=bessel +towgs84=-587.8,519.75,145.76,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3003, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=9 +k=0.9996 +x_0=1500000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3004, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9996 +x_0=2520000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3005, aea, GRS80, NAD83, "+proj=aea +lat_1=50 +lat_2=58.5 +lat_0=45 +lon_0=-126 +x_0=1000000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3006, utm, GRS80, "+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3007, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3008, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=13.5 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3009, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3010, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=16.5 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3011, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3012, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=14.25 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3013, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=15.75 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3014, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=17.25 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3015, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=18.75 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3016, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=20.25 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3017, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=21.75 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3018, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=23.25 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3019, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=11.30827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3020, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=13.55827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3021, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=15.80827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3022, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=18.05827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3023, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=20.30827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3024, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=22.55827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3025, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=11.30827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3026, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=13.55827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3027, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=15.80827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3028, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=18.05827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3029, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=20.30827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3030, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=22.55827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3031, stere, WGS84, WGS84, "+proj=stere +lat_0=-90 +lat_ts=-71 +lon_0=0 +k=1 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3032, stere, WGS84, WGS84, "+proj=stere +lat_0=-90 +lat_ts=-71 +lon_0=70 +k=1 +x_0=6000000 +y_0=6000000 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3033, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-68.5 +lat_2=-74.5 +lat_0=-50 +lon_0=70 +x_0=6000000 +y_0=6000000 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3034, lcc, GRS80, "+proj=lcc +lat_1=35 +lat_2=65 +lat_0=52 +lon_0=10 +x_0=4000000 +y_0=2800000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3035, laea, GRS80, "+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3036, utm, WGS84, "+proj=utm +zone=36 +south +ellps=WGS84 +towgs84=0,0,0,-0,-0,-0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3037, utm, WGS84, "+proj=utm +zone=37 +south +ellps=WGS84 +towgs84=0,0,0,-0,-0,-0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3038, utm, GRS80, "+proj=utm +zone=26 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3039, utm, GRS80, "+proj=utm +zone=27 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3040, utm, GRS80, "+proj=utm +zone=28 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3041, utm, GRS80, "+proj=utm +zone=29 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3042, utm, GRS80, "+proj=utm +zone=30 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3043, utm, GRS80, "+proj=utm +zone=31 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3044, utm, GRS80, "+proj=utm +zone=32 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3045, utm, GRS80, "+proj=utm +zone=33 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3046, utm, GRS80, "+proj=utm +zone=34 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3047, utm, GRS80, "+proj=utm +zone=35 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3048, utm, GRS80, "+proj=utm +zone=36 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3049, utm, GRS80, "+proj=utm +zone=37 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3050, utm, GRS80, "+proj=utm +zone=38 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3051, utm, GRS80, "+proj=utm +zone=39 +ellps=GRS80 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3052, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3053, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3054, utm, intl, "+proj=utm +zone=26 +ellps=intl +towgs84=-73,46,-86,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3055, utm, intl, "+proj=utm +zone=27 +ellps=intl +towgs84=-73,46,-86,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3056, utm, intl, "+proj=utm +zone=28 +ellps=intl +towgs84=-73,46,-86,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3057, lcc, GRS80, "+proj=lcc +lat_1=64.25 +lat_2=65.75 +lat_0=65 +lon_0=-19 +x_0=500000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3058, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=-8.5 +k=1 +x_0=50000 +y_0=-7800000 +ellps=intl +towgs84=982.609,552.753,-540.873,32.3934,-153.257,-96.2266,16.805 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3059, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9996 +x_0=500000 +y_0=-6000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3060, utm, intl, "+proj=utm +zone=58 +south +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3061, utm, intl, "+proj=utm +zone=28 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3062, utm, intl, "+proj=utm +zone=26 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3063, utm, intl, "+proj=utm +zone=26 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3064, utm, WGS84, "+proj=utm +zone=32 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3065, utm, WGS84, "+proj=utm +zone=33 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3066, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=37 +k=0.9998 +x_0=500000 +y_0=-3000000 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3067, utm, GRS80, "+proj=utm +zone=35 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3068, cass, bessel, potsdam, "+proj=cass +lat_0=52.41864827777778 +lon_0=13.62720366666667 +x_0=40000 +y_0=10000 +ellps=bessel +datum=potsdam +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3069, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=0 +lon_0=-90 +k=0.9996 +x_0=500000 +y_0=-4500000 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3070, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=0 +lon_0=-90 +k=0.9996 +x_0=520000 +y_0=-4480000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3071, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-90 +k=0.9996 +x_0=520000 +y_0=-4480000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3072, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=43.83333333333334 +lon_0=-67.875 +k=0.99998 +x_0=700000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3073, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=43 +lon_0=-69.125 +k=0.99998 +x_0=500000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3074, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.375 +k=0.99998 +x_0=300000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3075, tmerc, GRS80, "+proj=tmerc +lat_0=43.83333333333334 +lon_0=-67.875 +k=0.99998 +x_0=700000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3076, tmerc, GRS80, "+proj=tmerc +lat_0=43 +lon_0=-69.125 +k=0.99998 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3077, tmerc, GRS80, "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.375 +k=0.99998 +x_0=300000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3078, omerc, GRS80, NAD83, "+proj=omerc +lat_0=45.30916666666666 +lonc=-86 +alpha=337.25556 +k=0.9996 +x_0=2546731.496 +y_0=-4354009.816 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3079, omerc, GRS80, "+proj=omerc +lat_0=45.30916666666666 +lonc=-86 +alpha=337.25556 +k=0.9996 +x_0=2546731.496 +y_0=-4354009.816 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3080, lcc, clrk66, NAD27, "+proj=lcc +lat_1=27.41666666666667 +lat_2=34.91666666666666 +lat_0=31.16666666666667 +lon_0=-100 +x_0=914400 +y_0=914400 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3081, lcc, GRS80, NAD83, "+proj=lcc +lat_1=27.41666666666667 +lat_2=34.91666666666666 +lat_0=31.16666666666667 +lon_0=-100 +x_0=1000000 +y_0=1000000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3082, lcc, GRS80, NAD83, "+proj=lcc +lat_1=27.5 +lat_2=35 +lat_0=18 +lon_0=-100 +x_0=1500000 +y_0=5000000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3083, aea, GRS80, NAD83, "+proj=aea +lat_1=27.5 +lat_2=35 +lat_0=18 +lon_0=-100 +x_0=1500000 +y_0=6000000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3084, lcc, GRS80, "+proj=lcc +lat_1=27.5 +lat_2=35 +lat_0=18 +lon_0=-100 +x_0=1500000 +y_0=5000000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3085, aea, GRS80, "+proj=aea +lat_1=27.5 +lat_2=35 +lat_0=18 +lon_0=-100 +x_0=1500000 +y_0=6000000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3086, aea, GRS80, NAD83, "+proj=aea +lat_1=24 +lat_2=31.5 +lat_0=24 +lon_0=-84 +x_0=400000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3087, aea, GRS80, "+proj=aea +lat_1=24 +lat_2=31.5 +lat_0=24 +lon_0=-84 +x_0=400000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3088, lcc, GRS80, NAD83, "+proj=lcc +lat_1=37.08333333333334 +lat_2=38.66666666666666 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=1500000 +y_0=1000000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3089, lcc, GRS80, NAD83, "+proj=lcc +lat_1=37.08333333333334 +lat_2=38.66666666666666 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=1500000 +y_0=999999.9998983998 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3090, lcc, GRS80, "+proj=lcc +lat_1=37.08333333333334 +lat_2=38.66666666666666 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=1500000 +y_0=1000000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3091, lcc, GRS80, "+proj=lcc +lat_1=37.08333333333334 +lat_2=38.66666666666666 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=1500000 +y_0=999999.9998983998 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3092, utm, bessel, "+proj=utm +zone=51 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3093, utm, bessel, "+proj=utm +zone=52 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3094, utm, bessel, "+proj=utm +zone=53 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3095, utm, bessel, "+proj=utm +zone=54 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3096, utm, bessel, "+proj=utm +zone=55 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3097, utm, GRS80, "+proj=utm +zone=51 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3098, utm, GRS80, "+proj=utm +zone=52 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3099, utm, GRS80, "+proj=utm +zone=53 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3100, utm, GRS80, "+proj=utm +zone=54 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3101, utm, GRS80, "+proj=utm +zone=55 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3102, lcc, clrk66, "+proj=lcc +lat_1=-14.26666666666667 +lat_0=-14.26666666666667 +lon_0=-170 +k_0=1 +x_0=152400.3048006096 +y_0=95169.31165862332 +ellps=clrk66 +towgs84=-115,118,426,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3103, utm, clrk80, "+proj=utm +zone=28 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3104, utm, clrk80, "+proj=utm +zone=29 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3105, utm, clrk80, "+proj=utm +zone=30 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 3106, tmerc, 6377276.345, 6356075.41314024, "+proj=tmerc +lat_0=0 +lon_0=90 +k=0.9996 +x_0=500000 +y_0=0 +a=6377276.345 +b=6356075.41314024 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3107, lcc, GRS80, "+proj=lcc +lat_1=-28 +lat_2=-36 +lat_0=-32 +lon_0=135 +x_0=1000000 +y_0=2000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3108, tmerc, GRS80, "+proj=tmerc +lat_0=49.5 +lon_0=-2.416666666666667 +k=0.999997 +x_0=47000 +y_0=50000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3109, tmerc, GRS80, "+proj=tmerc +lat_0=49.225 +lon_0=-2.135 +k=0.9999999000000001 +x_0=40000 +y_0=70000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3110, lcc, aust_SA, "+proj=lcc +lat_1=-36 +lat_2=-38 +lat_0=-37 +lon_0=145 +x_0=2500000 +y_0=4500000 +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3111, lcc, GRS80, "+proj=lcc +lat_1=-36 +lat_2=-38 +lat_0=-37 +lon_0=145 +x_0=2500000 +y_0=2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3112, lcc, GRS80, "+proj=lcc +lat_1=-18 +lat_2=-36 +lat_0=0 +lon_0=134 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3113, tmerc, GRS80, "+proj=tmerc +lat_0=-28 +lon_0=153 +k=0.99999 +x_0=50000 +y_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3114, tmerc, GRS80, "+proj=tmerc +lat_0=4.596200416666666 +lon_0=-80.07750791666666 +k=1 +x_0=1000000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3115, tmerc, GRS80, "+proj=tmerc +lat_0=4.596200416666666 +lon_0=-77.07750791666666 +k=1 +x_0=1000000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3116, tmerc, GRS80, "+proj=tmerc +lat_0=4.596200416666666 +lon_0=-74.07750791666666 +k=1 +x_0=1000000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3117, tmerc, GRS80, "+proj=tmerc +lat_0=4.596200416666666 +lon_0=-71.07750791666666 +k=1 +x_0=1000000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3118, tmerc, GRS80, "+proj=tmerc +lat_0=4.596200416666666 +lon_0=-68.07750791666666 +k=1 +x_0=1000000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3119, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=10.5 +k=0.999 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs84=-206.1,-174.7,-87.7,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3120, sterea, krass, "+proj=sterea +lat_0=50.625 +lon_0=21.08333333333333 +k=0.9998 +x_0=4637000 +y_0=5467000 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3121, tmerc, clrk66, "+proj=tmerc +lat_0=0 +lon_0=117 +k=0.99995 +x_0=500000 +y_0=0 +ellps=clrk66 +towgs84=-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3122, tmerc, clrk66, "+proj=tmerc +lat_0=0 +lon_0=119 +k=0.99995 +x_0=500000 +y_0=0 +ellps=clrk66 +towgs84=-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3123, tmerc, clrk66, "+proj=tmerc +lat_0=0 +lon_0=121 +k=0.99995 +x_0=500000 +y_0=0 +ellps=clrk66 +towgs84=-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3124, tmerc, clrk66, "+proj=tmerc +lat_0=0 +lon_0=123 +k=0.99995 +x_0=500000 +y_0=0 +ellps=clrk66 +towgs84=-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3125, tmerc, clrk66, "+proj=tmerc +lat_0=0 +lon_0=125 +k=0.99995 +x_0=500000 +y_0=0 +ellps=clrk66 +towgs84=-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3126, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=19 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3127, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=20 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3128, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3129, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=22 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3130, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=23 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3131, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3132, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=25 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3133, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=26 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3134, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3135, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=28 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3136, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=29 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3137, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3138, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=31 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3139, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 3140, cass, 6378306.3696, 6356571.996, "+proj=cass +lat_0=-18 +lon_0=178 +x_0=109435.392 +y_0=141622.272 +a=6378306.3696 +b=6356571.996 +towgs84=51,391,-36,0,0,0,0 +to_meter=0.201168 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3141, utm, intl, "+proj=utm +zone=60 +south +ellps=intl +towgs84=265.025,384.929,-194.046,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3142, utm, intl, "+proj=utm +zone=1 +south +ellps=intl +towgs84=265.025,384.929,-194.046,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3143, tmerc, WGS72, "+proj=tmerc +lat_0=-17 +lon_0=178.75 +k=0.99985 +x_0=2000000 +y_0=4000000 +ellps=WGS72 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3144, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3145, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3146, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=6500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3147, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 3148, utm, 6377276.345, 6356075.41314024, "+proj=utm +zone=48 +a=6377276.345 +b=6356075.41314024 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 3149, utm, 6377276.345, 6356075.41314024, "+proj=utm +zone=49 +a=6377276.345 +b=6356075.41314024 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3150, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=6500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3151, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3152, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=18.05779 +k=0.99999425 +x_0=100178.1808 +y_0=-6500614.7836 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3153, aea, GRS80, "+proj=aea +lat_1=50 +lat_2=58.5 +lat_0=45 +lon_0=-126 +x_0=1000000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3154, utm, GRS80, "+proj=utm +zone=7 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3155, utm, GRS80, "+proj=utm +zone=8 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3156, utm, GRS80, "+proj=utm +zone=9 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3157, utm, GRS80, "+proj=utm +zone=10 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3158, utm, GRS80, "+proj=utm +zone=14 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3159, utm, GRS80, "+proj=utm +zone=15 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3160, utm, GRS80, "+proj=utm +zone=16 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3161, lcc, GRS80, NAD83, "+proj=lcc +lat_1=44.5 +lat_2=53.5 +lat_0=0 +lon_0=-85 +x_0=930000 +y_0=6430000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3162, lcc, GRS80, "+proj=lcc +lat_1=44.5 +lat_2=53.5 +lat_0=0 +lon_0=-85 +x_0=930000 +y_0=6430000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3163, lcc, GRS80, "+proj=lcc +lat_1=-20.66666666666667 +lat_2=-22.33333333333333 +lat_0=-21.5 +lon_0=166 +x_0=400000 +y_0=300000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3164, utm, WGS84, "+proj=utm +zone=58 +south +ellps=WGS84 +towgs84=-56.263,16.136,-22.856,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3165, lcc, intl, "+proj=lcc +lat_1=-22.24469175 +lat_2=-22.29469175 +lat_0=-22.26969175 +lon_0=166.44242575 +x_0=0.66 +y_0=1.02 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3166, lcc, intl, "+proj=lcc +lat_1=-22.24472222222222 +lat_2=-22.29472222222222 +lat_0=-22.26972222222222 +lon_0=166.4425 +x_0=8.313000000000001 +y_0=-2.354 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 3167, omerc, 6377295.664, 6356094.667915204, "+proj=omerc +lat_0=4 +lonc=102.25 +alpha=323.0257905 +k=0.99984 +x_0=40000 +y_0=0 +a=6377295.664 +b=6356094.667915204 +to_meter=20.116756 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 3168, omerc, 6377295.664, 6356094.667915204, "+proj=omerc +lat_0=4 +lonc=102.25 +alpha=323.0257905 +k=0.99984 +x_0=804670.24 +y_0=0 +a=6377295.664 +b=6356094.667915204 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3169, utm, GRS80, "+proj=utm +zone=57 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3170, utm, GRS80, "+proj=utm +zone=58 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3171, utm, GRS80, "+proj=utm +zone=59 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3172, utm, intl, "+proj=utm +zone=59 +south +ellps=intl +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3173, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3174, aea, GRS80, NAD83, "+proj=aea +lat_1=42.122774 +lat_2=49.01518 +lat_0=45.568977 +lon_0=-84.455955 +x_0=1000000 +y_0=1000000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3175, aea, GRS80, NAD83, "+proj=aea +lat_1=42.122774 +lat_2=49.01518 +lat_0=45.568977 +lon_0=-83.248627 +x_0=1000000 +y_0=1000000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 3176, tmerc, 6377276.345, 6356075.41314024, "+proj=tmerc +lat_0=0 +lon_0=106 +k=0.9996 +x_0=500000 +y_0=0 +a=6377276.345 +b=6356075.41314024 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3177, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=17 +k=0.9965000000000001 +x_0=1000000 +y_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3178, utm, GRS80, "+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3179, utm, GRS80, "+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3180, utm, GRS80, "+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3181, utm, GRS80, "+proj=utm +zone=21 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3182, utm, GRS80, "+proj=utm +zone=22 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3183, utm, GRS80, "+proj=utm +zone=23 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3184, utm, GRS80, "+proj=utm +zone=24 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3185, utm, GRS80, "+proj=utm +zone=25 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3186, utm, GRS80, "+proj=utm +zone=26 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3187, utm, GRS80, "+proj=utm +zone=27 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3188, utm, GRS80, "+proj=utm +zone=28 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3189, utm, GRS80, "+proj=utm +zone=29 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3190, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=9 +k=0.99995 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3191, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=11 +k=0.99995 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3192, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=13 +k=0.99995 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3193, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.99995 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3194, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=17 +k=0.99995 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3195, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=19 +k=0.99995 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3196, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=21 +k=0.99995 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3197, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=23 +k=0.99995 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3198, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=25 +k=0.99995 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3199, utm, intl, "+proj=utm +zone=32 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3200, lcc, clrk80, "+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=45 +k_0=0.9987864078000001 +x_0=1500000 +y_0=1166200 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3201, utm, intl, "+proj=utm +zone=33 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3202, utm, intl, "+proj=utm +zone=34 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3203, utm, intl, "+proj=utm +zone=35 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3204, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-60.66666666666666 +lat_2=-63.33333333333334 +lat_0=-90 +lon_0=-66 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3205, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-60.66666666666666 +lat_2=-63.33333333333334 +lat_0=-90 +lon_0=-54 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3206, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-60.66666666666666 +lat_2=-63.33333333333334 +lat_0=-90 +lon_0=-42 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3207, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=-174 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3208, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=-66 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3209, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=-54 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3210, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=42 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3211, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=54 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3212, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=66 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3213, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=78 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3214, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=90 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3215, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=102 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3216, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=114 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3217, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=126 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3218, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=138 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3219, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=150 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3220, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=162 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3221, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=-102 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3222, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=-90 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3223, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=-78 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3224, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=-66 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3225, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=-18 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3226, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=-6 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3227, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=6 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3228, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=18 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3229, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=30 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3230, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=42 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3231, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=54 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3232, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=66 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3233, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=78 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3234, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=90 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3235, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=102 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3236, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=114 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3237, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=126 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3238, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=138 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3239, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=150 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3240, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=162 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3241, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=174 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3242, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=-153 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3243, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=-135 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3244, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=-117 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3245, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=-99 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3246, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=-81 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3247, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=-63 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3248, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=-27 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3249, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=-9 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3250, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=9 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3251, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=27 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3252, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=45 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3253, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=63 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3254, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=81 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3255, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=99 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3256, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=117 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3257, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=135 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3258, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=153 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3259, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=171 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3260, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=-168 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3261, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=-144 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3262, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=-120 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3263, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=-96 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3264, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=-72 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3265, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=-48 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3266, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=-24 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3267, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=0 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3268, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=24 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3269, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=48 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3270, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=72 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3271, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=96 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3272, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=120 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3273, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=144 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3274, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=168 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3275, stere, WGS84, WGS84, "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=-165 +k=1 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3276, stere, WGS84, WGS84, "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=-135 +k=1 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3277, stere, WGS84, WGS84, "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=-105 +k=1 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3278, stere, WGS84, WGS84, "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=-75 +k=1 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3279, stere, WGS84, WGS84, "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=-45 +k=1 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3280, stere, WGS84, WGS84, "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=-15 +k=1 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3281, stere, WGS84, WGS84, "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=15 +k=1 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3282, stere, WGS84, WGS84, "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=45 +k=1 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3283, stere, WGS84, WGS84, "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=75 +k=1 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3284, stere, WGS84, WGS84, "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=105 +k=1 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3285, stere, WGS84, WGS84, "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=135 +k=1 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3286, stere, WGS84, WGS84, "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=165 +k=1 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3287, stere, WGS84, WGS84, "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=-150 +k=1 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3288, stere, WGS84, WGS84, "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=-90 +k=1 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3289, stere, WGS84, WGS84, "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=-30 +k=1 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3290, stere, WGS84, WGS84, "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=30 +k=1 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3291, stere, WGS84, WGS84, "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=90 +k=1 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3292, stere, WGS84, WGS84, "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=150 +k=1 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3293, stere, WGS84, WGS84, "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=0 +k=1 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3294, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-78 +lon_0=162 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3295, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3296, utm, GRS80, "+proj=utm +zone=5 +south +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3297, utm, GRS80, "+proj=utm +zone=6 +south +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3298, utm, GRS80, "+proj=utm +zone=7 +south +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3299, utm, GRS80, "+proj=utm +zone=8 +south +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3300, lcc, GRS80, "+proj=lcc +lat_1=59.33333333333334 +lat_2=58 +lat_0=57.51755393055556 +lon_0=24 +x_0=500000 +y_0=6375000 +ellps=GRS80 +towgs84=0.055,-0.541,-0.185,0.0183,-0.0003,-0.007,-0.014 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3301, lcc, GRS80, "+proj=lcc +lat_1=59.33333333333334 +lat_2=58 +lat_0=57.51755393055556 +lon_0=24 +x_0=500000 +y_0=6375000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3302, utm, intl, "+proj=utm +zone=7 +south +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3303, utm, intl, "+proj=utm +zone=7 +south +ellps=intl +towgs84=347.103,1078.12,2623.92,-33.8875,70.6773,-9.3943,186.074 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3304, utm, intl, "+proj=utm +zone=6 +south +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3305, utm, intl, "+proj=utm +zone=6 +south +ellps=intl +towgs84=215.525,149.593,176.229,-3.2624,-1.692,-1.1571,10.4773 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3306, utm, intl, "+proj=utm +zone=5 +south +ellps=intl +towgs84=217.037,86.959,23.956,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3307, utm, WGS84, "+proj=utm +zone=39 +ellps=WGS84 +towgs84=0,-0.15,0.68,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3308, lcc, GRS80, "+proj=lcc +lat_1=-30.75 +lat_2=-35.75 +lat_0=-33.25 +lon_0=147 +x_0=9300000 +y_0=4500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3309, aea, clrk66, NAD27, "+proj=aea +lat_1=34 +lat_2=40.5 +lat_0=0 +lon_0=-120 +x_0=0 +y_0=-4000000 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3310, aea, GRS80, NAD83, "+proj=aea +lat_1=34 +lat_2=40.5 +lat_0=0 +lon_0=-120 +x_0=0 +y_0=-4000000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3311, aea, GRS80, "+proj=aea +lat_1=34 +lat_2=40.5 +lat_0=0 +lon_0=-120 +x_0=0 +y_0=-4000000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3312, utm, intl, "+proj=utm +zone=21 +ellps=intl +towgs84=-186,230,110,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3313, utm, GRS80, "+proj=utm +zone=21 +ellps=GRS80 +towgs84=2,2,-2,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3314, lcc, clrk66, "+proj=lcc +lat_1=-6.5 +lat_2=-11.5 +lat_0=0 +lon_0=26 +x_0=0 +y_0=0 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3315, tmerc, clrk66, "+proj=tmerc +lat_0=-9 +lon_0=26 +k=0.9998 +x_0=0 +y_0=0 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3316, tmerc, clrk80, "+proj=tmerc +lat_0=0 +lon_0=22 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3317, tmerc, clrk80, "+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3318, tmerc, clrk80, "+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3319, tmerc, clrk80, "+proj=tmerc +lat_0=0 +lon_0=14 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3320, tmerc, clrk80, "+proj=tmerc +lat_0=0 +lon_0=16 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3321, tmerc, clrk80, "+proj=tmerc +lat_0=0 +lon_0=18 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3322, tmerc, clrk80, "+proj=tmerc +lat_0=0 +lon_0=20 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3323, tmerc, clrk80, "+proj=tmerc +lat_0=0 +lon_0=22 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3324, tmerc, clrk80, "+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3325, tmerc, clrk80, "+proj=tmerc +lat_0=0 +lon_0=26 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3326, tmerc, clrk80, "+proj=tmerc +lat_0=0 +lon_0=28 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3327, tmerc, clrk80, "+proj=tmerc +lat_0=0 +lon_0=30 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3328, sterea, krass, "+proj=sterea +lat_0=52.16666666666666 +lon_0=19.16666666666667 +k=0.999714 +x_0=500000 +y_0=500000 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3329, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3330, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=6500000 +y_0=0 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3331, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=7500000 +y_0=0 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3332, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=8500000 +y_0=0 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3333, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=3500000 +y_0=0 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3334, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3335, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=5500000 +y_0=0 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3336, utm, intl, "+proj=utm +zone=42 +south +ellps=intl +towgs84=145,-187,103,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3337, lcc, clrk80, "+proj=lcc +lat_1=-20.19506944444445 +lat_0=-20.19506944444445 +lon_0=57.52182777777778 +k_0=1 +x_0=1000000 +y_0=1000000 +ellps=clrk80 +towgs84=-770.1,158.4,-498.2,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3338, aea, GRS80, NAD83, "+proj=aea +lat_1=55 +lat_2=65 +lat_0=50 +lon_0=-154 +x_0=0 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3339, tmerc, clrk80, "+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +towgs84=-79.9,-158,-168.9,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3340, tmerc, clrk80, "+proj=tmerc +lat_0=0 +lon_0=14 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +towgs84=-79.9,-158,-168.9,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3341, tmerc, clrk80, "+proj=tmerc +lat_0=0 +lon_0=16 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +towgs84=-79.9,-158,-168.9,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3342, utm, clrk80, "+proj=utm +zone=33 +south +ellps=clrk80 +towgs84=-79.9,-158,-168.9,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3343, utm, GRS80, "+proj=utm +zone=28 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3344, utm, GRS80, "+proj=utm +zone=29 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3345, utm, GRS80, "+proj=utm +zone=30 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3346, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9998 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3347, lcc, GRS80, NAD83, "+proj=lcc +lat_1=49 +lat_2=77 +lat_0=63.390675 +lon_0=-91.86666666666666 +x_0=6200000 +y_0=3000000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3348, lcc, GRS80, "+proj=lcc +lat_1=49 +lat_2=77 +lat_0=63.390675 +lon_0=-91.86666666666666 +x_0=6200000 +y_0=3000000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3349, merc, WGS84, WGS84, "+proj=merc +lon_0=-150 +k=1 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3350, tmerc, krass, "+proj=tmerc +lat_0=0.1 +lon_0=21.95 +k=1 +x_0=250000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3351, tmerc, krass, "+proj=tmerc +lat_0=0.1 +lon_0=24.95 +k=1 +x_0=1250000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3352, tmerc, krass, "+proj=tmerc +lat_0=0.1 +lon_0=27.95 +k=1 +x_0=2250000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3353, utm, intl, "+proj=utm +zone=32 +south +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3354, utm, intl, "+proj=utm +zone=32 +south +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3355, tmerc, helmert, "+proj=tmerc +lat_0=30 +lon_0=31 +k=1 +x_0=615000 +y_0=810000 +ellps=helmert +towgs84=-146.21,112.63,4.05,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3356, utm, clrk66, "+proj=utm +zone=17 +ellps=clrk66 +towgs84=67.8,106.1,138.8,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3357, utm, clrk66, "+proj=utm +zone=17 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3358, lcc, GRS80, "+proj=lcc +lat_1=36.16666666666666 +lat_2=34.33333333333334 +lat_0=33.75 +lon_0=-79 +x_0=609601.22 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3359, lcc, GRS80, "+proj=lcc +lat_1=36.16666666666666 +lat_2=34.33333333333334 +lat_0=33.75 +lon_0=-79 +x_0=609601.2192024385 +y_0=0 +ellps=GRS80 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3360, lcc, GRS80, "+proj=lcc +lat_1=34.83333333333334 +lat_2=32.5 +lat_0=31.83333333333333 +lon_0=-81 +x_0=609600 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3361, lcc, GRS80, "+proj=lcc +lat_1=34.83333333333334 +lat_2=32.5 +lat_0=31.83333333333333 +lon_0=-81 +x_0=609600 +y_0=0 +ellps=GRS80 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3362, lcc, GRS80, "+proj=lcc +lat_1=41.95 +lat_2=40.88333333333333 +lat_0=40.16666666666666 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3363, lcc, GRS80, "+proj=lcc +lat_1=41.95 +lat_2=40.88333333333333 +lat_0=40.16666666666666 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3364, lcc, GRS80, "+proj=lcc +lat_1=40.96666666666667 +lat_2=39.93333333333333 +lat_0=39.33333333333334 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3365, lcc, GRS80, "+proj=lcc +lat_1=40.96666666666667 +lat_2=39.93333333333333 +lat_0=39.33333333333334 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 3366, cass, 6378293.645208759, 6356617.987679838, "+proj=cass +lat_0=22.31213333333334 +lon_0=114.1785555555556 +x_0=40243.57775604237 +y_0=19069.93351512578 +a=6378293.645208759 +b=6356617.987679838 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3367, utm, clrk80, "+proj=utm +zone=28 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3368, utm, clrk80, "+proj=utm +zone=29 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3369, utm, clrk80, "+proj=utm +zone=30 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3370, utm, clrk66, NAD27, "+proj=utm +zone=59 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3371, utm, clrk66, NAD27, "+proj=utm +zone=60 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3372, utm, GRS80, NAD83, "+proj=utm +zone=59 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3373, utm, GRS80, NAD83, "+proj=utm +zone=60 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3374, utm, intl, "+proj=utm +zone=29 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3375, omerc, GRS80, "+proj=omerc +lat_0=4 +lonc=102.25 +alpha=323.0257964666666 +k=0.99984 +x_0=804671 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3376, omerc, GRS80, "+proj=omerc +lat_0=4 +lonc=115 +alpha=53.31580995 +k=0.99984 +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3377, cass, GRS80, "+proj=cass +lat_0=2.121679744444445 +lon_0=103.4279362361111 +x_0=-14810.562 +y_0=8758.32 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3378, cass, GRS80, "+proj=cass +lat_0=2.682347636111111 +lon_0=101.9749050416667 +x_0=3673.785 +y_0=-4240.573 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3379, cass, GRS80, "+proj=cass +lat_0=3.769388088888889 +lon_0=102.3682989833333 +x_0=-7368.228 +y_0=6485.858 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3380, cass, GRS80, "+proj=cass +lat_0=3.68464905 +lon_0=101.3891079138889 +x_0=-34836.161 +y_0=56464.049 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3381, cass, GRS80, "+proj=cass +lat_0=4.9762852 +lon_0=103.070275625 +x_0=19594.245 +y_0=3371.895 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3382, cass, GRS80, "+proj=cass +lat_0=5.421517541666667 +lon_0=100.3443769638889 +x_0=-23.414 +y_0=62.283 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3383, cass, GRS80, "+proj=cass +lat_0=5.964672713888889 +lon_0=100.6363711111111 +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3384, cass, GRS80, "+proj=cass +lat_0=4.859063022222222 +lon_0=100.8154105861111 +x_0=-1.769 +y_0=133454.779 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3385, cass, GRS80, "+proj=cass +lat_0=5.972543658333334 +lon_0=102.2952416694444 +x_0=13227.851 +y_0=8739.894 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3386, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=500000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3387, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=5500000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3388, merc, krass, "+proj=merc +lon_0=51 +k=1 +x_0=0 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3389, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=180 +k=1 +x_0=60500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3390, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=180 +k=1 +x_0=60500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3391, utm, clrk80, "+proj=utm +zone=37 +ellps=clrk80 +towgs84=84.1,-320.1,218.7,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3392, utm, clrk80, "+proj=utm +zone=38 +ellps=clrk80 +towgs84=84.1,-320.1,218.7,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3393, utm, clrk80, "+proj=utm +zone=39 +ellps=clrk80 +towgs84=84.1,-320.1,218.7,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3394, lcc, clrk80, "+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=45 +k_0=0.9987864078000001 +x_0=1500000 +y_0=1166200 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3395, merc, WGS84, WGS84, "+proj=merc +lon_0=0 +k=1 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3396, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3397, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3398, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3399, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3400, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=0 +lon_0=-115 +k=0.9992 +x_0=500000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3401, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=0 +lon_0=-115 +k=0.9992 +x_0=0 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3402, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-115 +k=0.9992 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3403, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-115 +k=0.9992 +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3404, lcc, GRS80, "+proj=lcc +lat_1=36.16666666666666 +lat_2=34.33333333333334 +lat_0=33.75 +lon_0=-79 +x_0=609601.2192024384 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3405, utm, WGS84, "+proj=utm +zone=48 +ellps=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3406, utm, WGS84, "+proj=utm +zone=49 +ellps=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 3407, cass, 6378293.645208759, 6356617.987679838, "+proj=cass +lat_0=22.31213333333334 +lon_0=114.1785555555556 +x_0=40243.57775604237 +y_0=19069.93351512578 +a=6378293.645208759 +b=6356617.987679838 +to_meter=0.3047972654 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (epsg, 3408, laea, 6371228, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=6371228 +b=6371228 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (epsg, 3409, laea, 6371228, "+proj=laea +lat_0=-90 +lon_0=0 +x_0=0 +y_0=0 +a=6371228 +b=6371228 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (epsg, 3410, cea, 6371228, "+proj=cea +lon_0=0 +lat_ts=30 +x_0=0 +y_0=0 +a=6371228 +b=6371228 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 3411, stere, 6378273, 6356889.449, "+proj=stere +lat_0=90 +lat_ts=70 +lon_0=-45 +k=1 +x_0=0 +y_0=0 +a=6378273 +b=6356889.449 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 3412, stere, 6378273, 6356889.449, "+proj=stere +lat_0=-90 +lat_ts=-70 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=6378273 +b=6356889.449 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3413, stere, WGS84, WGS84, "+proj=stere +lat_0=90 +lat_ts=70 +lon_0=-45 +k=1 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3414, tmerc, WGS84, "+proj=tmerc +lat_0=1.366666666666667 +lon_0=103.8333333333333 +k=1 +x_0=28001.642 +y_0=38744.572 +ellps=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3415, lcc, WGS72, "+proj=lcc +lat_1=18 +lat_2=24 +lat_0=21 +lon_0=114 +x_0=500000 +y_0=500000 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3416, lcc, GRS80, "+proj=lcc +lat_1=49 +lat_2=46 +lat_0=47.5 +lon_0=13.33333333333333 +x_0=400000 +y_0=400000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3417, lcc, GRS80, NAD83, "+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666667 +lat_0=41.5 +lon_0=-93.5 +x_0=1500000 +y_0=999999.9999898402 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3418, lcc, GRS80, NAD83, "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.61666666666667 +lat_0=40 +lon_0=-93.5 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3419, lcc, GRS80, NAD83, "+proj=lcc +lat_1=39.78333333333333 +lat_2=38.71666666666667 +lat_0=38.33333333333334 +lon_0=-98 +x_0=399999.99998984 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3420, lcc, GRS80, NAD83, "+proj=lcc +lat_1=38.56666666666667 +lat_2=37.26666666666667 +lat_0=36.66666666666666 +lon_0=-98.5 +x_0=399999.99998984 +y_0=399999.99998984 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3421, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=34.75 +lon_0=-115.5833333333333 +k=0.9999 +x_0=200000.00001016 +y_0=8000000.000010163 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3422, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=34.75 +lon_0=-116.6666666666667 +k=0.9999 +x_0=500000.00001016 +y_0=6000000 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3423, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=34.75 +lon_0=-118.5833333333333 +k=0.9999 +x_0=800000.0000101599 +y_0=3999999.99998984 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3424, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3425, lcc, GRS80, "+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666667 +lat_0=41.5 +lon_0=-93.5 +x_0=1500000 +y_0=999999.9999898402 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3426, lcc, GRS80, "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.61666666666667 +lat_0=40 +lon_0=-93.5 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3427, lcc, GRS80, "+proj=lcc +lat_1=39.78333333333333 +lat_2=38.71666666666667 +lat_0=38.33333333333334 +lon_0=-98 +x_0=399999.99998984 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3428, lcc, GRS80, "+proj=lcc +lat_1=38.56666666666667 +lat_2=37.26666666666667 +lat_0=36.66666666666666 +lon_0=-98.5 +x_0=399999.99998984 +y_0=399999.99998984 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3429, tmerc, GRS80, "+proj=tmerc +lat_0=34.75 +lon_0=-115.5833333333333 +k=0.9999 +x_0=200000.00001016 +y_0=8000000.000010163 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3430, tmerc, GRS80, "+proj=tmerc +lat_0=34.75 +lon_0=-116.6666666666667 +k=0.9999 +x_0=500000.00001016 +y_0=6000000 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3431, tmerc, GRS80, "+proj=tmerc +lat_0=34.75 +lon_0=-118.5833333333333 +k=0.9999 +x_0=800000.0000101599 +y_0=3999999.99998984 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3432, tmerc, GRS80, "+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3433, lcc, GRS80, NAD83, "+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=399999.99998984 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3434, lcc, GRS80, NAD83, "+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32.66666666666666 +lon_0=-92 +x_0=399999.99998984 +y_0=399999.99998984 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3435, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333333333 +k=0.9999749999999999 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3436, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-90.16666666666667 +k=0.999941177 +x_0=699999.9999898402 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3437, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=42.5 +lon_0=-71.66666666666667 +k=0.999966667 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3438, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=41.08333333333334 +lon_0=-71.5 +k=0.99999375 +x_0=99999.99998983997 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3439, utm, clrk80, "+proj=utm +zone=39 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3440, utm, clrk80, "+proj=utm +zone=40 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3441, lcc, GRS80, "+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=399999.99998984 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3442, lcc, GRS80, "+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32.66666666666666 +lon_0=-92 +x_0=399999.99998984 +y_0=399999.99998984 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3443, tmerc, GRS80, "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333333333 +k=0.9999749999999999 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3444, tmerc, GRS80, "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-90.16666666666667 +k=0.999941177 +x_0=699999.9999898402 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3445, tmerc, GRS80, "+proj=tmerc +lat_0=42.5 +lon_0=-71.66666666666667 +k=0.999966667 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3446, tmerc, GRS80, "+proj=tmerc +lat_0=41.08333333333334 +lon_0=-71.5 +k=0.99999375 +x_0=99999.99998983997 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3447, lcc, GRS80, "+proj=lcc +lat_1=49.83333333333334 +lat_2=51.16666666666666 +lat_0=50.797815 +lon_0=4.359215833333333 +x_0=150328 +y_0=166262 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3448, lcc, WGS84, "+proj=lcc +lat_1=18 +lat_0=18 +lon_0=-77 +k_0=1 +x_0=750000 +y_0=650000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3449, utm, WGS84, "+proj=utm +zone=17 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3450, utm, WGS84, "+proj=utm +zone=18 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3451, lcc, GRS80, NAD83, "+proj=lcc +lat_1=32.66666666666666 +lat_2=31.16666666666667 +lat_0=30.5 +lon_0=-92.5 +x_0=999999.9999898402 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3452, lcc, GRS80, NAD83, "+proj=lcc +lat_1=30.7 +lat_2=29.3 +lat_0=28.5 +lon_0=-91.33333333333333 +x_0=999999.9999898402 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3453, lcc, GRS80, NAD83, "+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666667 +lat_0=25.5 +lon_0=-91.33333333333333 +x_0=999999.9999898402 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3454, lcc, GRS80, NAD83, "+proj=lcc +lat_1=44.4 +lat_2=42.83333333333334 +lat_0=42.33333333333334 +lon_0=-100.3333333333333 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3455, lcc, GRS80, NAD83, "+proj=lcc +lat_1=44.4 +lat_2=42.83333333333334 +lat_0=42.33333333333334 +lon_0=-100.3333333333333 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3456, lcc, GRS80, "+proj=lcc +lat_1=32.66666666666666 +lat_2=31.16666666666667 +lat_0=30.5 +lon_0=-92.5 +x_0=999999.9999898402 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3457, lcc, GRS80, "+proj=lcc +lat_1=30.7 +lat_2=29.3 +lat_0=28.5 +lon_0=-91.33333333333333 +x_0=999999.9999898402 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3458, lcc, GRS80, "+proj=lcc +lat_1=45.68333333333333 +lat_2=44.41666666666666 +lat_0=43.83333333333334 +lon_0=-100 +x_0=600000 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3459, lcc, GRS80, "+proj=lcc +lat_1=44.4 +lat_2=42.83333333333334 +lat_0=42.33333333333334 +lon_0=-100.3333333333333 +x_0=600000 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3460, tmerc, WGS72, "+proj=tmerc +lat_0=-17 +lon_0=178.75 +k=0.99985 +x_0=2000000 +y_0=4000000 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 3461, utm, 6378249.2, 6356515, "+proj=utm +zone=28 +a=6378249.2 +b=6356515 +towgs84=-83,37,124,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 3462, utm, 6378249.2, 6356515, "+proj=utm +zone=29 +a=6378249.2 +b=6356515 +towgs84=-83,37,124,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3463, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=43.5 +lon_0=-69.125 +k=0.99998 +x_0=500000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3464, tmerc, GRS80, "+proj=tmerc +lat_0=43.5 +lon_0=-69.125 +k=0.99998 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3465, tmerc, GRS80, "+proj=tmerc +lat_0=30.5 +lon_0=-85.83333333333333 +k=0.99996 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3466, tmerc, GRS80, "+proj=tmerc +lat_0=30 +lon_0=-87.5 +k=0.999933333 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3467, aea, GRS80, "+proj=aea +lat_1=55 +lat_2=65 +lat_0=50 +lon_0=-154 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3468, omerc, GRS80, "+proj=omerc +lat_0=57 +lonc=-133.6666666666667 +alpha=323.1301023611111 +k=0.9999 +x_0=5000000 +y_0=-5000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3469, tmerc, GRS80, "+proj=tmerc +lat_0=54 +lon_0=-142 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3470, tmerc, GRS80, "+proj=tmerc +lat_0=54 +lon_0=-146 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3471, tmerc, GRS80, "+proj=tmerc +lat_0=54 +lon_0=-150 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3472, tmerc, GRS80, "+proj=tmerc +lat_0=54 +lon_0=-154 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3473, tmerc, GRS80, "+proj=tmerc +lat_0=54 +lon_0=-158 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3474, tmerc, GRS80, "+proj=tmerc +lat_0=54 +lon_0=-162 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3475, tmerc, GRS80, "+proj=tmerc +lat_0=54 +lon_0=-166 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3476, tmerc, GRS80, "+proj=tmerc +lat_0=54 +lon_0=-170 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3477, lcc, GRS80, "+proj=lcc +lat_1=53.83333333333334 +lat_2=51.83333333333334 +lat_0=51 +lon_0=-176 +x_0=1000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3478, tmerc, GRS80, "+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3479, tmerc, GRS80, "+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3480, tmerc, GRS80, "+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3481, tmerc, GRS80, "+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3482, tmerc, GRS80, "+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3483, tmerc, GRS80, "+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3484, lcc, GRS80, "+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3485, lcc, GRS80, "+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=399999.99998984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3486, lcc, GRS80, "+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32.66666666666666 +lon_0=-92 +x_0=400000 +y_0=400000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3487, lcc, GRS80, "+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32.66666666666666 +lon_0=-92 +x_0=399999.99998984 +y_0=399999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3488, aea, GRS80, "+proj=aea +lat_1=34 +lat_2=40.5 +lat_0=0 +lon_0=-120 +x_0=0 +y_0=-4000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3489, lcc, GRS80, "+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.33333333333334 +lon_0=-122 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3490, lcc, GRS80, "+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.33333333333334 +lon_0=-122 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3491, lcc, GRS80, "+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3492, lcc, GRS80, "+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3493, lcc, GRS80, "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666667 +lat_0=36.5 +lon_0=-120.5 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3494, lcc, GRS80, "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666667 +lat_0=36.5 +lon_0=-120.5 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3495, lcc, GRS80, "+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.33333333333334 +lon_0=-119 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3496, lcc, GRS80, "+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.33333333333334 +lon_0=-119 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3497, lcc, GRS80, "+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333333 +lat_0=33.5 +lon_0=-118 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3498, lcc, GRS80, "+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333333 +lat_0=33.5 +lon_0=-118 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3499, lcc, GRS80, "+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3500, lcc, GRS80, "+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3501, lcc, GRS80, "+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.83333333333334 +lon_0=-105.5 +x_0=914401.8289 +y_0=304800.6096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3502, lcc, GRS80, "+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.83333333333334 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.6096012192 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3503, lcc, GRS80, "+proj=lcc +lat_1=40.78333333333333 +lat_2=39.71666666666667 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=914401.8289 +y_0=304800.6096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3504, lcc, GRS80, "+proj=lcc +lat_1=40.78333333333333 +lat_2=39.71666666666667 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.6096012192 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3505, lcc, GRS80, "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=914401.8289 +y_0=304800.6096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3506, lcc, GRS80, "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.6096012192 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3507, lcc, GRS80, "+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40.83333333333334 +lon_0=-72.75 +x_0=304800.6096 +y_0=152400.3048 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3508, lcc, GRS80, "+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40.83333333333334 +lon_0=-72.75 +x_0=304800.6096012192 +y_0=152400.3048006096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3509, tmerc, GRS80, "+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999995 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3510, tmerc, GRS80, "+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999995 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3511, tmerc, GRS80, "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999941177 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3512, tmerc, GRS80, "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999941177 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3513, aea, GRS80, "+proj=aea +lat_1=24 +lat_2=31.5 +lat_0=24 +lon_0=-84 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3514, lcc, GRS80, "+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=29 +lon_0=-84.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3515, lcc, GRS80, "+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=29 +lon_0=-84.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3516, tmerc, GRS80, "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999941177 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3517, tmerc, GRS80, "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999941177 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3518, tmerc, GRS80, "+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.9999 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3519, tmerc, GRS80, "+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.9999 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3520, tmerc, GRS80, "+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.9999 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3521, tmerc, GRS80, "+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.9999 +x_0=699999.9998983998 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3522, tmerc, GRS80, "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.9999473679999999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3523, tmerc, GRS80, "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.9999473679999999 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3524, tmerc, GRS80, "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666666667 +k=0.9999473679999999 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3525, tmerc, GRS80, "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666666667 +k=0.9999473679999999 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3526, tmerc, GRS80, "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0.999933333 +x_0=800000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3527, tmerc, GRS80, "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0.999933333 +x_0=800000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3528, tmerc, GRS80, "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333333333 +k=0.9999749999999999 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3529, tmerc, GRS80, "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333333333 +k=0.9999749999999999 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3530, tmerc, GRS80, "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-90.16666666666667 +k=0.999941177 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3531, tmerc, GRS80, "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-90.16666666666667 +k=0.999941177 +x_0=699999.9999898402 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3532, tmerc, GRS80, "+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.999966667 +x_0=100000 +y_0=250000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3533, tmerc, GRS80, "+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.999966667 +x_0=99999.99989839978 +y_0=249999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3534, tmerc, GRS80, "+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.999966667 +x_0=900000 +y_0=250000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3535, tmerc, GRS80, "+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.999966667 +x_0=900000 +y_0=249999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3536, lcc, GRS80, "+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666667 +lat_0=41.5 +lon_0=-93.5 +x_0=1500000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3537, lcc, GRS80, "+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666667 +lat_0=41.5 +lon_0=-93.5 +x_0=1500000 +y_0=999999.9999898402 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3538, lcc, GRS80, "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.61666666666667 +lat_0=40 +lon_0=-93.5 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3539, lcc, GRS80, "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.61666666666667 +lat_0=40 +lon_0=-93.5 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3540, lcc, GRS80, "+proj=lcc +lat_1=39.78333333333333 +lat_2=38.71666666666667 +lat_0=38.33333333333334 +lon_0=-98 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3541, lcc, GRS80, "+proj=lcc +lat_1=39.78333333333333 +lat_2=38.71666666666667 +lat_0=38.33333333333334 +lon_0=-98 +x_0=399999.99998984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3542, lcc, GRS80, "+proj=lcc +lat_1=38.56666666666667 +lat_2=37.26666666666667 +lat_0=36.66666666666666 +lon_0=-98.5 +x_0=400000 +y_0=400000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3543, lcc, GRS80, "+proj=lcc +lat_1=38.56666666666667 +lat_2=37.26666666666667 +lat_0=36.66666666666666 +lon_0=-98.5 +x_0=399999.99998984 +y_0=399999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3544, lcc, GRS80, "+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3545, lcc, GRS80, "+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3546, lcc, GRS80, "+proj=lcc +lat_1=37.08333333333334 +lat_2=38.66666666666666 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=1500000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3547, lcc, GRS80, "+proj=lcc +lat_1=37.08333333333334 +lat_2=38.66666666666666 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=1500000 +y_0=999999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3548, lcc, GRS80, "+proj=lcc +lat_1=37.93333333333333 +lat_2=36.73333333333333 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=500000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3549, lcc, GRS80, "+proj=lcc +lat_1=37.93333333333333 +lat_2=36.73333333333333 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=500000.0001016001 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3550, lcc, GRS80, "+proj=lcc +lat_1=32.66666666666666 +lat_2=31.16666666666667 +lat_0=30.5 +lon_0=-92.5 +x_0=1000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3551, lcc, GRS80, "+proj=lcc +lat_1=32.66666666666666 +lat_2=31.16666666666667 +lat_0=30.5 +lon_0=-92.5 +x_0=999999.9999898402 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3552, lcc, GRS80, "+proj=lcc +lat_1=30.7 +lat_2=29.3 +lat_0=28.5 +lon_0=-91.33333333333333 +x_0=1000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3553, lcc, GRS80, "+proj=lcc +lat_1=30.7 +lat_2=29.3 +lat_0=28.5 +lon_0=-91.33333333333333 +x_0=999999.9999898402 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3554, tmerc, GRS80, "+proj=tmerc +lat_0=43.5 +lon_0=-69.125 +k=0.99998 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3555, tmerc, GRS80, "+proj=tmerc +lat_0=43.83333333333334 +lon_0=-67.875 +k=0.99998 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3556, tmerc, GRS80, "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.375 +k=0.99998 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3557, tmerc, GRS80, "+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9999 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3558, tmerc, GRS80, "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3559, lcc, GRS80, "+proj=lcc +lat_1=39.45 +lat_2=38.3 +lat_0=37.66666666666666 +lon_0=-77 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3560, lcc, GRS80, NAD83, "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000.00001016 +y_0=999999.9999898402 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3561, tmerc, clrk66, "+proj=tmerc +lat_0=18.83333333333333 +lon_0=-155.5 +k=0.999966667 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3562, tmerc, clrk66, "+proj=tmerc +lat_0=20.33333333333333 +lon_0=-156.6666666666667 +k=0.999966667 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3563, tmerc, clrk66, "+proj=tmerc +lat_0=21.16666666666667 +lon_0=-158 +k=0.99999 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3564, tmerc, clrk66, "+proj=tmerc +lat_0=21.83333333333333 +lon_0=-159.5 +k=0.99999 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3565, tmerc, clrk66, "+proj=tmerc +lat_0=21.66666666666667 +lon_0=-160.1666666666667 +k=1 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3566, lcc, GRS80, NAD83, "+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=38.33333333333334 +lon_0=-111.5 +x_0=500000.00001016 +y_0=2000000.00001016 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3567, lcc, GRS80, NAD83, "+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=36.66666666666666 +lon_0=-111.5 +x_0=500000.00001016 +y_0=3000000 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3568, lcc, GRS80, "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000.00001016 +y_0=999999.9999898402 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3569, lcc, GRS80, "+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=38.33333333333334 +lon_0=-111.5 +x_0=500000.00001016 +y_0=2000000.00001016 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3570, lcc, GRS80, "+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=36.66666666666666 +lon_0=-111.5 +x_0=500000.00001016 +y_0=3000000 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3571, laea, WGS84, WGS84, "+proj=laea +lat_0=90 +lon_0=180 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3572, laea, WGS84, WGS84, "+proj=laea +lat_0=90 +lon_0=-150 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3573, laea, WGS84, WGS84, "+proj=laea +lat_0=90 +lon_0=-100 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3574, laea, WGS84, WGS84, "+proj=laea +lat_0=90 +lon_0=-40 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3575, laea, WGS84, WGS84, "+proj=laea +lat_0=90 +lon_0=10 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3576, laea, WGS84, WGS84, "+proj=laea +lat_0=90 +lon_0=90 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3577, aea, GRS80, "+proj=aea +lat_1=-18 +lat_2=-36 +lat_0=0 +lon_0=132 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3578, aea, GRS80, NAD83, "+proj=aea +lat_1=61.66666666666666 +lat_2=68 +lat_0=59 +lon_0=-132.5 +x_0=500000 +y_0=500000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3579, aea, GRS80, "+proj=aea +lat_1=61.66666666666666 +lat_2=68 +lat_0=59 +lon_0=-132.5 +x_0=500000 +y_0=500000 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3580, lcc, GRS80, NAD83, "+proj=lcc +lat_1=62 +lat_2=70 +lat_0=0 +lon_0=-112 +x_0=0 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3581, lcc, GRS80, "+proj=lcc +lat_1=62 +lat_2=70 +lat_0=0 +lon_0=-112 +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3582, lcc, GRS80, "+proj=lcc +lat_1=39.45 +lat_2=38.3 +lat_0=37.66666666666666 +lon_0=-77 +x_0=399999.9998983998 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3583, lcc, GRS80, "+proj=lcc +lat_1=41.48333333333333 +lat_2=41.28333333333333 +lat_0=41 +lon_0=-70.5 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3584, lcc, GRS80, "+proj=lcc +lat_1=41.48333333333333 +lat_2=41.28333333333333 +lat_0=41 +lon_0=-70.5 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3585, lcc, GRS80, "+proj=lcc +lat_1=42.68333333333333 +lat_2=41.71666666666667 +lat_0=41 +lon_0=-71.5 +x_0=200000 +y_0=750000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3586, lcc, GRS80, "+proj=lcc +lat_1=42.68333333333333 +lat_2=41.71666666666667 +lat_0=41 +lon_0=-71.5 +x_0=200000.0001016002 +y_0=750000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3587, lcc, GRS80, "+proj=lcc +lat_1=45.7 +lat_2=44.18333333333333 +lat_0=43.31666666666667 +lon_0=-84.36666666666666 +x_0=6000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3588, lcc, GRS80, "+proj=lcc +lat_1=45.7 +lat_2=44.18333333333333 +lat_0=43.31666666666667 +lon_0=-84.36666666666666 +x_0=5999999.999976001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3589, lcc, GRS80, "+proj=lcc +lat_1=47.08333333333334 +lat_2=45.48333333333333 +lat_0=44.78333333333333 +lon_0=-87 +x_0=8000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3590, lcc, GRS80, "+proj=lcc +lat_1=47.08333333333334 +lat_2=45.48333333333333 +lat_0=44.78333333333333 +lon_0=-87 +x_0=7999999.999968001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3591, omerc, GRS80, "+proj=omerc +lat_0=45.30916666666666 +lonc=-86 +alpha=337.25556 +k=0.9996 +x_0=2546731.496 +y_0=-4354009.816 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3592, lcc, GRS80, "+proj=lcc +lat_1=43.66666666666666 +lat_2=42.1 +lat_0=41.5 +lon_0=-84.36666666666666 +x_0=4000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3593, lcc, GRS80, "+proj=lcc +lat_1=43.66666666666666 +lat_2=42.1 +lat_0=41.5 +lon_0=-84.36666666666666 +x_0=3999999.999984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3594, lcc, GRS80, "+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=45 +lon_0=-94.25 +x_0=800000 +y_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3595, lcc, GRS80, "+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000 +y_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3596, lcc, GRS80, "+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333333 +lat_0=43 +lon_0=-94 +x_0=800000 +y_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3597, tmerc, GRS80, "+proj=tmerc +lat_0=29.5 +lon_0=-88.83333333333333 +k=0.99995 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3598, tmerc, GRS80, "+proj=tmerc +lat_0=29.5 +lon_0=-88.83333333333333 +k=0.99995 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3599, tmerc, GRS80, "+proj=tmerc +lat_0=29.5 +lon_0=-90.33333333333333 +k=0.99995 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3600, tmerc, GRS80, "+proj=tmerc +lat_0=29.5 +lon_0=-90.33333333333333 +k=0.99995 +x_0=699999.9998983998 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3601, tmerc, GRS80, "+proj=tmerc +lat_0=35.83333333333334 +lon_0=-92.5 +k=0.999933333 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3602, tmerc, GRS80, "+proj=tmerc +lat_0=35.83333333333334 +lon_0=-90.5 +k=0.999933333 +x_0=250000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3603, tmerc, GRS80, "+proj=tmerc +lat_0=36.16666666666666 +lon_0=-94.5 +k=0.999941177 +x_0=850000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3604, lcc, GRS80, "+proj=lcc +lat_1=49 +lat_2=45 +lat_0=44.25 +lon_0=-109.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3605, lcc, GRS80, "+proj=lcc +lat_1=49 +lat_2=45 +lat_0=44.25 +lon_0=-109.5 +x_0=599999.9999976 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3606, lcc, GRS80, "+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +lon_0=-100 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3607, tmerc, GRS80, "+proj=tmerc +lat_0=34.75 +lon_0=-116.6666666666667 +k=0.9999 +x_0=500000 +y_0=6000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3608, tmerc, GRS80, "+proj=tmerc +lat_0=34.75 +lon_0=-116.6666666666667 +k=0.9999 +x_0=500000.00001016 +y_0=6000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3609, tmerc, GRS80, "+proj=tmerc +lat_0=34.75 +lon_0=-115.5833333333333 +k=0.9999 +x_0=200000 +y_0=8000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3610, tmerc, GRS80, "+proj=tmerc +lat_0=34.75 +lon_0=-115.5833333333333 +k=0.9999 +x_0=200000.00001016 +y_0=8000000.000010163 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3611, tmerc, GRS80, "+proj=tmerc +lat_0=34.75 +lon_0=-118.5833333333333 +k=0.9999 +x_0=800000 +y_0=4000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3612, tmerc, GRS80, "+proj=tmerc +lat_0=34.75 +lon_0=-118.5833333333333 +k=0.9999 +x_0=800000.0000101599 +y_0=3999999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3613, tmerc, GRS80, "+proj=tmerc +lat_0=42.5 +lon_0=-71.66666666666667 +k=0.999966667 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3614, tmerc, GRS80, "+proj=tmerc +lat_0=42.5 +lon_0=-71.66666666666667 +k=0.999966667 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3615, tmerc, GRS80, "+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3616, tmerc, GRS80, "+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3617, tmerc, GRS80, "+proj=tmerc +lat_0=31 +lon_0=-106.25 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3618, tmerc, GRS80, "+proj=tmerc +lat_0=31 +lon_0=-106.25 +k=0.9999 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3619, tmerc, GRS80, "+proj=tmerc +lat_0=31 +lon_0=-104.3333333333333 +k=0.999909091 +x_0=165000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3620, tmerc, GRS80, "+proj=tmerc +lat_0=31 +lon_0=-104.3333333333333 +k=0.999909091 +x_0=165000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3621, tmerc, GRS80, "+proj=tmerc +lat_0=31 +lon_0=-107.8333333333333 +k=0.999916667 +x_0=830000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3622, tmerc, GRS80, "+proj=tmerc +lat_0=31 +lon_0=-107.8333333333333 +k=0.999916667 +x_0=830000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3623, tmerc, GRS80, "+proj=tmerc +lat_0=40 +lon_0=-76.58333333333333 +k=0.9999375 +x_0=250000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3624, tmerc, GRS80, "+proj=tmerc +lat_0=40 +lon_0=-76.58333333333333 +k=0.9999375 +x_0=249999.9998983998 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3625, tmerc, GRS80, "+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3626, tmerc, GRS80, "+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3627, lcc, GRS80, "+proj=lcc +lat_1=41.03333333333333 +lat_2=40.66666666666666 +lat_0=40.16666666666666 +lon_0=-74 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3628, lcc, GRS80, "+proj=lcc +lat_1=41.03333333333333 +lat_2=40.66666666666666 +lat_0=40.16666666666666 +lon_0=-74 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3629, tmerc, GRS80, "+proj=tmerc +lat_0=40 +lon_0=-78.58333333333333 +k=0.9999375 +x_0=350000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3630, tmerc, GRS80, "+proj=tmerc +lat_0=40 +lon_0=-78.58333333333333 +k=0.9999375 +x_0=350000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3631, lcc, GRS80, "+proj=lcc +lat_1=36.16666666666666 +lat_2=34.33333333333334 +lat_0=33.75 +lon_0=-79 +x_0=609601.22 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3632, lcc, GRS80, "+proj=lcc +lat_1=36.16666666666666 +lat_2=34.33333333333334 +lat_0=33.75 +lon_0=-79 +x_0=609601.2192024384 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3633, lcc, GRS80, "+proj=lcc +lat_1=48.73333333333333 +lat_2=47.43333333333333 +lat_0=47 +lon_0=-100.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3634, lcc, GRS80, "+proj=lcc +lat_1=48.73333333333333 +lat_2=47.43333333333333 +lat_0=47 +lon_0=-100.5 +x_0=599999.9999976 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3635, lcc, GRS80, "+proj=lcc +lat_1=47.48333333333333 +lat_2=46.18333333333333 +lat_0=45.66666666666666 +lon_0=-100.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3636, lcc, GRS80, "+proj=lcc +lat_1=47.48333333333333 +lat_2=46.18333333333333 +lat_0=45.66666666666666 +lon_0=-100.5 +x_0=599999.9999976 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3637, lcc, GRS80, "+proj=lcc +lat_1=41.7 +lat_2=40.43333333333333 +lat_0=39.66666666666666 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3638, lcc, GRS80, "+proj=lcc +lat_1=40.03333333333333 +lat_2=38.73333333333333 +lat_0=38 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3639, lcc, GRS80, "+proj=lcc +lat_1=36.76666666666667 +lat_2=35.56666666666667 +lat_0=35 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3640, lcc, GRS80, "+proj=lcc +lat_1=36.76666666666667 +lat_2=35.56666666666667 +lat_0=35 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3641, lcc, GRS80, "+proj=lcc +lat_1=35.23333333333333 +lat_2=33.93333333333333 +lat_0=33.33333333333334 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3642, lcc, GRS80, "+proj=lcc +lat_1=35.23333333333333 +lat_2=33.93333333333333 +lat_0=33.33333333333334 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3643, lcc, GRS80, "+proj=lcc +lat_1=43 +lat_2=45.5 +lat_0=41.75 +lon_0=-120.5 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3644, lcc, GRS80, "+proj=lcc +lat_1=43 +lat_2=45.5 +lat_0=41.75 +lon_0=-120.5 +x_0=399999.9999984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3645, lcc, GRS80, "+proj=lcc +lat_1=46 +lat_2=44.33333333333334 +lat_0=43.66666666666666 +lon_0=-120.5 +x_0=2500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3646, lcc, GRS80, "+proj=lcc +lat_1=46 +lat_2=44.33333333333334 +lat_0=43.66666666666666 +lon_0=-120.5 +x_0=2500000.0001424 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3647, lcc, GRS80, "+proj=lcc +lat_1=44 +lat_2=42.33333333333334 +lat_0=41.66666666666666 +lon_0=-120.5 +x_0=1500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3648, lcc, GRS80, "+proj=lcc +lat_1=44 +lat_2=42.33333333333334 +lat_0=41.66666666666666 +lon_0=-120.5 +x_0=1500000.0001464 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3649, lcc, GRS80, "+proj=lcc +lat_1=41.95 +lat_2=40.88333333333333 +lat_0=40.16666666666666 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3650, lcc, GRS80, "+proj=lcc +lat_1=41.95 +lat_2=40.88333333333333 +lat_0=40.16666666666666 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3651, lcc, GRS80, "+proj=lcc +lat_1=40.96666666666667 +lat_2=39.93333333333333 +lat_0=39.33333333333334 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3652, lcc, GRS80, "+proj=lcc +lat_1=40.96666666666667 +lat_2=39.93333333333333 +lat_0=39.33333333333334 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3653, tmerc, GRS80, "+proj=tmerc +lat_0=41.08333333333334 +lon_0=-71.5 +k=0.99999375 +x_0=100000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3654, tmerc, GRS80, "+proj=tmerc +lat_0=41.08333333333334 +lon_0=-71.5 +k=0.99999375 +x_0=99999.99998983997 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3655, lcc, GRS80, "+proj=lcc +lat_1=34.83333333333334 +lat_2=32.5 +lat_0=31.83333333333333 +lon_0=-81 +x_0=609600 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3656, lcc, GRS80, "+proj=lcc +lat_1=34.83333333333334 +lat_2=32.5 +lat_0=31.83333333333333 +lon_0=-81 +x_0=609600 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3657, lcc, GRS80, "+proj=lcc +lat_1=45.68333333333333 +lat_2=44.41666666666666 +lat_0=43.83333333333334 +lon_0=-100 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3658, lcc, GRS80, "+proj=lcc +lat_1=45.68333333333333 +lat_2=44.41666666666666 +lat_0=43.83333333333334 +lon_0=-100 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3659, lcc, GRS80, "+proj=lcc +lat_1=44.4 +lat_2=42.83333333333334 +lat_0=42.33333333333334 +lon_0=-100.3333333333333 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3660, lcc, GRS80, "+proj=lcc +lat_1=44.4 +lat_2=42.83333333333334 +lat_0=42.33333333333334 +lon_0=-100.3333333333333 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3661, lcc, GRS80, "+proj=lcc +lat_1=36.41666666666666 +lat_2=35.25 +lat_0=34.33333333333334 +lon_0=-86 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3662, lcc, GRS80, "+proj=lcc +lat_1=36.41666666666666 +lat_2=35.25 +lat_0=34.33333333333334 +lon_0=-86 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3663, lcc, GRS80, "+proj=lcc +lat_1=31.88333333333333 +lat_2=30.11666666666667 +lat_0=29.66666666666667 +lon_0=-100.3333333333333 +x_0=700000 +y_0=3000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3664, lcc, GRS80, "+proj=lcc +lat_1=31.88333333333333 +lat_2=30.11666666666667 +lat_0=29.66666666666667 +lon_0=-100.3333333333333 +x_0=699999.9998983998 +y_0=3000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3665, aea, GRS80, "+proj=aea +lat_1=27.5 +lat_2=35 +lat_0=18 +lon_0=-100 +x_0=1500000 +y_0=6000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3666, lcc, GRS80, "+proj=lcc +lat_1=27.5 +lat_2=35 +lat_0=18 +lon_0=-100 +x_0=1500000 +y_0=5000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3667, lcc, GRS80, "+proj=lcc +lat_1=36.18333333333333 +lat_2=34.65 +lat_0=34 +lon_0=-101.5 +x_0=200000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3668, lcc, GRS80, "+proj=lcc +lat_1=36.18333333333333 +lat_2=34.65 +lat_0=34 +lon_0=-101.5 +x_0=200000.0001016002 +y_0=999999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3669, lcc, GRS80, "+proj=lcc +lat_1=33.96666666666667 +lat_2=32.13333333333333 +lat_0=31.66666666666667 +lon_0=-98.5 +x_0=600000 +y_0=2000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3670, lcc, GRS80, "+proj=lcc +lat_1=33.96666666666667 +lat_2=32.13333333333333 +lat_0=31.66666666666667 +lon_0=-98.5 +x_0=600000 +y_0=2000000.0001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3671, lcc, GRS80, "+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666667 +lat_0=25.66666666666667 +lon_0=-98.5 +x_0=300000 +y_0=5000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3672, lcc, GRS80, "+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666667 +lat_0=25.66666666666667 +lon_0=-98.5 +x_0=300000.0000000001 +y_0=5000000.0001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3673, lcc, GRS80, "+proj=lcc +lat_1=30.28333333333333 +lat_2=28.38333333333333 +lat_0=27.83333333333333 +lon_0=-99 +x_0=600000 +y_0=4000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3674, lcc, GRS80, "+proj=lcc +lat_1=30.28333333333333 +lat_2=28.38333333333333 +lat_0=27.83333333333333 +lon_0=-99 +x_0=600000 +y_0=3999999.9998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3675, lcc, GRS80, "+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=38.33333333333334 +lon_0=-111.5 +x_0=500000 +y_0=2000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3676, lcc, GRS80, "+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=38.33333333333334 +lon_0=-111.5 +x_0=500000.0001504 +y_0=1999999.999992 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3677, lcc, GRS80, "+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=38.33333333333334 +lon_0=-111.5 +x_0=500000.00001016 +y_0=2000000.00001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3678, lcc, GRS80, "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3679, lcc, GRS80, "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000.0001504 +y_0=999999.9999960001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3680, lcc, GRS80, "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000.00001016 +y_0=999999.9999898402 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3681, lcc, GRS80, "+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=36.66666666666666 +lon_0=-111.5 +x_0=500000 +y_0=3000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3682, lcc, GRS80, "+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=36.66666666666666 +lon_0=-111.5 +x_0=500000.0001504 +y_0=2999999.999988 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3683, lcc, GRS80, "+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=36.66666666666666 +lon_0=-111.5 +x_0=500000.00001016 +y_0=3000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3684, tmerc, GRS80, "+proj=tmerc +lat_0=42.5 +lon_0=-72.5 +k=0.999964286 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3685, lcc, GRS80, "+proj=lcc +lat_1=39.2 +lat_2=38.03333333333333 +lat_0=37.66666666666666 +lon_0=-78.5 +x_0=3500000 +y_0=2000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3686, lcc, GRS80, "+proj=lcc +lat_1=39.2 +lat_2=38.03333333333333 +lat_0=37.66666666666666 +lon_0=-78.5 +x_0=3500000.0001016 +y_0=2000000.0001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3687, lcc, GRS80, "+proj=lcc +lat_1=37.96666666666667 +lat_2=36.76666666666667 +lat_0=36.33333333333334 +lon_0=-78.5 +x_0=3500000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3688, lcc, GRS80, "+proj=lcc +lat_1=37.96666666666667 +lat_2=36.76666666666667 +lat_0=36.33333333333334 +lon_0=-78.5 +x_0=3500000.0001016 +y_0=999999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3689, lcc, GRS80, "+proj=lcc +lat_1=48.73333333333333 +lat_2=47.5 +lat_0=47 +lon_0=-120.8333333333333 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3690, lcc, GRS80, "+proj=lcc +lat_1=48.73333333333333 +lat_2=47.5 +lat_0=47 +lon_0=-120.8333333333333 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3691, lcc, GRS80, "+proj=lcc +lat_1=47.33333333333334 +lat_2=45.83333333333334 +lat_0=45.33333333333334 +lon_0=-120.5 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3692, lcc, GRS80, "+proj=lcc +lat_1=47.33333333333334 +lat_2=45.83333333333334 +lat_0=45.33333333333334 +lon_0=-120.5 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3693, lcc, GRS80, "+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3694, lcc, GRS80, "+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333333 +lat_0=37 +lon_0=-81 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3695, lcc, GRS80, "+proj=lcc +lat_1=45.5 +lat_2=44.25 +lat_0=43.83333333333334 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3696, lcc, GRS80, "+proj=lcc +lat_1=45.5 +lat_2=44.25 +lat_0=43.83333333333334 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3697, lcc, GRS80, "+proj=lcc +lat_1=46.76666666666667 +lat_2=45.56666666666667 +lat_0=45.16666666666666 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3698, lcc, GRS80, "+proj=lcc +lat_1=46.76666666666667 +lat_2=45.56666666666667 +lat_0=45.16666666666666 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3699, lcc, GRS80, "+proj=lcc +lat_1=44.06666666666667 +lat_2=42.73333333333333 +lat_0=42 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3700, lcc, GRS80, "+proj=lcc +lat_1=44.06666666666667 +lat_2=42.73333333333333 +lat_0=42 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3701, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-90 +k=0.9996 +x_0=520000 +y_0=-4480000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3702, tmerc, GRS80, "+proj=tmerc +lat_0=40.5 +lon_0=-105.1666666666667 +k=0.9999375 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3703, tmerc, GRS80, "+proj=tmerc +lat_0=40.5 +lon_0=-107.3333333333333 +k=0.9999375 +x_0=400000 +y_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3704, tmerc, GRS80, "+proj=tmerc +lat_0=40.5 +lon_0=-108.75 +k=0.9999375 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3705, tmerc, GRS80, "+proj=tmerc +lat_0=40.5 +lon_0=-110.0833333333333 +k=0.9999375 +x_0=800000 +y_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3706, utm, GRS80, "+proj=utm +zone=59 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3707, utm, GRS80, "+proj=utm +zone=60 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3708, utm, GRS80, "+proj=utm +zone=1 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3709, utm, GRS80, "+proj=utm +zone=2 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3710, utm, GRS80, "+proj=utm +zone=3 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3711, utm, GRS80, "+proj=utm +zone=4 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3712, utm, GRS80, "+proj=utm +zone=5 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3713, utm, GRS80, "+proj=utm +zone=6 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3714, utm, GRS80, "+proj=utm +zone=7 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3715, utm, GRS80, "+proj=utm +zone=8 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3716, utm, GRS80, "+proj=utm +zone=9 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3717, utm, GRS80, "+proj=utm +zone=10 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3718, utm, GRS80, "+proj=utm +zone=11 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3719, utm, GRS80, "+proj=utm +zone=12 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3720, utm, GRS80, "+proj=utm +zone=13 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3721, utm, GRS80, "+proj=utm +zone=14 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3722, utm, GRS80, "+proj=utm +zone=15 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3723, utm, GRS80, "+proj=utm +zone=16 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3724, utm, GRS80, "+proj=utm +zone=17 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3725, utm, GRS80, "+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3726, utm, GRS80, "+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3727, tmerc, intl, "+proj=tmerc +lat_0=-21.11666666666667 +lon_0=55.53333333333333 +k=1 +x_0=160000 +y_0=50000 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3728, lcc, GRS80, "+proj=lcc +lat_1=41.7 +lat_2=40.43333333333333 +lat_0=39.66666666666666 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3729, lcc, GRS80, "+proj=lcc +lat_1=40.03333333333333 +lat_2=38.73333333333333 +lat_0=38 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3730, tmerc, GRS80, "+proj=tmerc +lat_0=40.5 +lon_0=-105.1666666666667 +k=0.9999375 +x_0=200000.00001016 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3731, tmerc, GRS80, "+proj=tmerc +lat_0=40.5 +lon_0=-107.3333333333333 +k=0.9999375 +x_0=399999.99998984 +y_0=99999.99998983997 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3732, tmerc, GRS80, "+proj=tmerc +lat_0=40.5 +lon_0=-108.75 +k=0.9999375 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3733, tmerc, GRS80, "+proj=tmerc +lat_0=40.5 +lon_0=-110.0833333333333 +k=0.9999375 +x_0=800000.0000101599 +y_0=99999.99998983997 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3734, lcc, GRS80, NAD83, "+proj=lcc +lat_1=41.7 +lat_2=40.43333333333333 +lat_0=39.66666666666666 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3735, lcc, GRS80, NAD83, "+proj=lcc +lat_1=40.03333333333333 +lat_2=38.73333333333333 +lat_0=38 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3736, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=40.5 +lon_0=-105.1666666666667 +k=0.9999375 +x_0=200000.00001016 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3737, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=40.5 +lon_0=-107.3333333333333 +k=0.9999375 +x_0=399999.99998984 +y_0=99999.99998983997 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3738, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=40.5 +lon_0=-108.75 +k=0.9999375 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3739, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=40.5 +lon_0=-110.0833333333333 +k=0.9999375 +x_0=800000.0000101599 +y_0=99999.99998983997 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3740, utm, GRS80, "+proj=utm +zone=10 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3741, utm, GRS80, "+proj=utm +zone=11 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3742, utm, GRS80, "+proj=utm +zone=12 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3743, utm, GRS80, "+proj=utm +zone=13 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3744, utm, GRS80, "+proj=utm +zone=14 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3745, utm, GRS80, "+proj=utm +zone=15 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3746, utm, GRS80, "+proj=utm +zone=16 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3747, utm, GRS80, "+proj=utm +zone=17 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3748, utm, GRS80, "+proj=utm +zone=18 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3749, utm, GRS80, "+proj=utm +zone=19 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3750, utm, GRS80, "+proj=utm +zone=4 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3751, utm, GRS80, "+proj=utm +zone=5 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3752, merc, WGS84, WGS84, "+proj=merc +lon_0=100 +lat_ts=-41 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3753, lcc, GRS80, "+proj=lcc +lat_1=41.7 +lat_2=40.43333333333333 +lat_0=39.66666666666666 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3754, lcc, GRS80, "+proj=lcc +lat_1=40.03333333333333 +lat_2=38.73333333333333 +lat_0=38 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3755, tmerc, GRS80, "+proj=tmerc +lat_0=40.5 +lon_0=-105.1666666666667 +k=0.9999375 +x_0=200000.00001016 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3756, tmerc, GRS80, "+proj=tmerc +lat_0=40.5 +lon_0=-107.3333333333333 +k=0.9999375 +x_0=399999.99998984 +y_0=99999.99998983997 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3757, tmerc, GRS80, "+proj=tmerc +lat_0=40.5 +lon_0=-108.75 +k=0.9999375 +x_0=600000 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3758, tmerc, GRS80, "+proj=tmerc +lat_0=40.5 +lon_0=-110.0833333333333 +k=0.9999375 +x_0=800000.0000101599 +y_0=99999.99998983997 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3759, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=21.16666666666667 +lon_0=-158 +k=0.99999 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3760, tmerc, GRS80, "+proj=tmerc +lat_0=21.16666666666667 +lon_0=-158 +k=0.99999 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3761, utm, GRS80, "+proj=utm +zone=22 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3762, lcc, WGS84, WGS84, "+proj=lcc +lat_1=-54 +lat_2=-54.75 +lat_0=-55 +lon_0=-37 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3763, tmerc, GRS80, "+proj=tmerc +lat_0=39.66825833333333 +lon_0=-8.133108333333334 +k=1 +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3764, tmerc, GRS80, "+proj=tmerc +lat_0=-44 +lon_0=-176.5 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3765, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=16.5 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3766, lcc, GRS80, "+proj=lcc +lat_1=45.91666666666666 +lat_2=43.08333333333334 +lat_0=0 +lon_0=16.5 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3767, utm, GRS80, "+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3768, utm, GRS80, "+proj=utm +zone=34 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3769, utm, clrk66, "+proj=utm +zone=20 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3770, tmerc, WGS84, "+proj=tmerc +lat_0=32 +lon_0=-64.75 +k=1 +x_0=550000 +y_0=100000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3771, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=0 +lon_0=-111 +k=0.9999 +x_0=0 +y_0=0 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3772, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=0 +lon_0=-114 +k=0.9999 +x_0=0 +y_0=0 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3773, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=0 +lon_0=-117 +k=0.9999 +x_0=0 +y_0=0 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3774, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=0 +lon_0=-120 +k=0.9999 +x_0=0 +y_0=0 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3775, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=0 +lon_0=-111 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3776, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=0 +lon_0=-114 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3777, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=0 +lon_0=-117 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3778, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=0 +lon_0=-120 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3779, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-111 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3780, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-114 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3781, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-117 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3782, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-120 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3783, tmerc, WGS84, "+proj=tmerc +lat_0=-25.06855261111111 +lon_0=-130.1129671111111 +k=1 +x_0=14200 +y_0=15500 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3784, utm, intl, "+proj=utm +zone=9 +south +ellps=intl +towgs84=185,165,42,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (epsg, 3785, merc, 6378137, "+proj=merc +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=6378137 +b=6378137 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (epsg, 3786, eqc, 6371007, "+proj=eqc +lat_ts=0 +lat_0=0 +lon_0=0 +x_0=0 +y_0=0 +a=6371007 +b=6371007 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3787, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9999 +x_0=500000 +y_0=-5000000 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3788, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=166 +k=1 +x_0=3500000 +y_0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3789, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=169 +k=1 +x_0=3500000 +y_0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3790, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=179 +k=1 +x_0=3500000 +y_0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3791, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-178 +k=1 +x_0=3500000 +y_0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3793, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-176.5 +k=1 +x_0=3500000 +y_0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3794, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9999 +x_0=500000 +y_0=-5000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3795, lcc, clrk66, NAD27, "+proj=lcc +lat_1=23 +lat_2=21.7 +lat_0=22.35 +lon_0=-81 +x_0=500000 +y_0=280296.016 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3796, lcc, clrk66, NAD27, "+proj=lcc +lat_1=21.3 +lat_2=20.13333333333333 +lat_0=20.71666666666667 +lon_0=-76.83333333333333 +x_0=500000 +y_0=229126.939 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3797, lcc, clrk66, NAD27, "+proj=lcc +lat_1=50 +lat_2=46 +lat_0=44 +lon_0=-70 +x_0=800000 +y_0=0 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3798, lcc, GRS80, NAD83, "+proj=lcc +lat_1=50 +lat_2=46 +lat_0=44 +lon_0=-70 +x_0=800000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3799, lcc, GRS80, "+proj=lcc +lat_1=50 +lat_2=46 +lat_0=44 +lon_0=-70 +x_0=800000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3800, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=0 +lon_0=-120 +k=0.9999 +x_0=0 +y_0=0 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 3801, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=0 +lon_0=-120 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3802, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-120 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3812, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3814, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3815, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3816, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3819, longlat, bessel, "+proj=longlat +ellps=bessel +towgs84=595.48,121.69,515.35,4.115,2.9383,-0.853,-0.7029504596901044 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3821, longlat, aust_SA, "+proj=longlat +ellps=aust_SA +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3822, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3823, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3824, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3825, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3826, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3827, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3828, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3829, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3832, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3833, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3834, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3835, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3836, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3837, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3838, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3839, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3840, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3841, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3842, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3843, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3844, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3845, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3846, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3847, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3848, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3849, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3850, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3920, utm, clrk66, "+proj=utm +zone=20 +ellps=clrk66 +towgs84=11,72,-101,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3942, lcc, GRS80, "+proj=lcc +lat_1=41.25 +lat_2=42.75 +lat_0=42 +lon_0=3 +x_0=1700000 +y_0=1200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3943, lcc, GRS80, "+proj=lcc +lat_1=42.25 +lat_2=43.75 +lat_0=43 +lon_0=3 +x_0=1700000 +y_0=2200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3944, lcc, GRS80, "+proj=lcc +lat_1=43.25 +lat_2=44.75 +lat_0=44 +lon_0=3 +x_0=1700000 +y_0=3200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3945, lcc, GRS80, "+proj=lcc +lat_1=44.25 +lat_2=45.75 +lat_0=45 +lon_0=3 +x_0=1700000 +y_0=4200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3946, lcc, GRS80, "+proj=lcc +lat_1=45.25 +lat_2=46.75 +lat_0=46 +lon_0=3 +x_0=1700000 +y_0=5200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3947, lcc, GRS80, "+proj=lcc +lat_1=46.25 +lat_2=47.75 +lat_0=47 +lon_0=3 +x_0=1700000 +y_0=6200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3948, lcc, GRS80, "+proj=lcc +lat_1=47.25 +lat_2=48.75 +lat_0=48 +lon_0=3 +x_0=1700000 +y_0=7200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3949, lcc, GRS80, "+proj=lcc +lat_1=48.25 +lat_2=49.75 +lat_0=49 +lon_0=3 +x_0=1700000 +y_0=8200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3950, lcc, GRS80, "+proj=lcc +lat_1=49.25 +lat_2=50.75 +lat_0=50 +lon_0=3 +x_0=1700000 +y_0=9200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3991, lcc, clrk66, "+proj=lcc +lat_1=18.43333333333333 +lat_2=18.03333333333333 +lat_0=17.83333333333333 +lon_0=-66.43333333333334 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +towgs84=11,72,-101,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 3992, lcc, clrk66, "+proj=lcc +lat_1=18.43333333333333 +lat_2=18.03333333333333 +lat_0=17.83333333333333 +lon_0=-66.43333333333334 +x_0=152400.3048006096 +y_0=30480.06096012192 +ellps=clrk66 +towgs84=11,72,-101,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3993, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3994, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3995, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3996, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 3997, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4001, longlat, airy, "+proj=longlat +ellps=airy +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4002, longlat, 6377340.189, 6356034.447938534, "+proj=longlat +a=6377340.189 +b=6356034.447938534 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4003, longlat, aust_SA, "+proj=longlat +ellps=aust_SA +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4004, longlat, bessel, "+proj=longlat +ellps=bessel +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4005, longlat, 6377492.018, 6356173.508712696, "+proj=longlat +a=6377492.018 +b=6356173.508712696 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4006, longlat, bess_nam, "+proj=longlat +ellps=bess_nam +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4007, longlat, 6378293.645208759, 6356617.987679838, "+proj=longlat +a=6378293.645208759 +b=6356617.987679838 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4008, longlat, clrk66, "+proj=longlat +ellps=clrk66 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4009, longlat, 6378450.047548896, 6356826.621488444, "+proj=longlat +a=6378450.047548896 +b=6356826.621488444 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4010, longlat, 6378300.789, 6356566.435, "+proj=longlat +a=6378300.789 +b=6356566.435 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4011, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4012, longlat, clrk80, "+proj=longlat +ellps=clrk80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4013, longlat, 6378249.145, 6356514.966398753, "+proj=longlat +a=6378249.145 +b=6356514.966398753 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4014, longlat, 6378249.2, 6356514.996941779, "+proj=longlat +a=6378249.2 +b=6356514.996941779 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4015, longlat, 6377276.345, 6356075.41314024, "+proj=longlat +a=6377276.345 +b=6356075.41314024 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4016, longlat, evrstSS, "+proj=longlat +ellps=evrstSS +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4018, longlat, 6377304.063, 6356103.038993155, "+proj=longlat +a=6377304.063 +b=6356103.038993155 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4019, longlat, GRS80, "+proj=longlat +ellps=GRS80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4020, longlat, helmert, "+proj=longlat +ellps=helmert +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4021, longlat, 6378160, 6356774.50408554, "+proj=longlat +a=6378160 +b=6356774.50408554 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4022, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4024, longlat, krass, "+proj=longlat +ellps=krass +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4025, longlat, WGS66, "+proj=longlat +ellps=WGS66 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4027, longlat, 6376523, 6355862.933255573, "+proj=longlat +a=6376523 +b=6355862.933255573 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4028, longlat, 6378298.3, 6356657.142669561, "+proj=longlat +a=6378298.3 +b=6356657.142669561 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4029, longlat, 6378300, 6356751.689189189, "+proj=longlat +a=6378300 +b=6356751.689189189 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4030, longlat, WGS84, "+proj=longlat +ellps=WGS84 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4031, longlat, WGS84, "+proj=longlat +ellps=WGS84 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4032, longlat, 6378136.2, 6356751.516927429, "+proj=longlat +a=6378136.2 +b=6356751.516927429 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4033, longlat, 6378136.3, 6356751.616592146, "+proj=longlat +a=6378136.3 +b=6356751.616592146 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4034, longlat, 6378249.144808011, 6356514.966204134, "+proj=longlat +a=6378249.144808011 +b=6356514.966204134 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (epsg, 4035, longlat, 6371000, "+proj=longlat +a=6371000 +b=6371000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4036, longlat, GRS67, "+proj=longlat +ellps=GRS67 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4041, longlat, 6378135, 6356750.304921594, "+proj=longlat +a=6378135 +b=6356750.304921594 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4042, longlat, 6377299.36559538, 6356098.359005157, "+proj=longlat +a=6377299.36559538 +b=6356098.359005157 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4043, longlat, WGS72, "+proj=longlat +ellps=WGS72 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4044, longlat, 6377301.243, 6356100.230165384, "+proj=longlat +a=6377301.243 +b=6356100.230165384 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4045, longlat, 6377299.151, 6356098.145120132, "+proj=longlat +a=6377299.151 +b=6356098.145120132 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (epsg, 4047, longlat, 6371007, "+proj=longlat +a=6371007 +b=6371007 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (epsg, 4052, longlat, 6370997, "+proj=longlat +a=6370997 +b=6370997 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (epsg, 4053, longlat, 6371228, "+proj=longlat +a=6371228 +b=6371228 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4054, longlat, 6378273, 6356889.449, "+proj=longlat +a=6378273 +b=6356889.449 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (epsg, 4055, longlat, 6378137, "+proj=longlat +a=6378137 +b=6378137 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4120, longlat, bessel, "+proj=longlat +ellps=bessel +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4121, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=-199.87,74.79,246.62,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4122, longlat, 6378135, 6356750.304921594, "+proj=longlat +a=6378135 +b=6356750.304921594 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4123, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4124, longlat, bessel, "+proj=longlat +ellps=bessel +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4125, longlat, bessel, "+proj=longlat +ellps=bessel +towgs84=-404.78,685.68,45.47,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4126, longlat, GRS80, "+proj=longlat +ellps=GRS80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4127, longlat, clrk66, "+proj=longlat +ellps=clrk66 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4128, longlat, clrk66, "+proj=longlat +ellps=clrk66 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4129, longlat, clrk66, "+proj=longlat +ellps=clrk66 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4130, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,-0,-0,-0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4131, longlat, 6377276.345, 6356075.41314024, "+proj=longlat +a=6377276.345 +b=6356075.41314024 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4132, longlat, clrk80, "+proj=longlat +ellps=clrk80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4133, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.055,-0.541,-0.185,0.0183,-0.0003,-0.007,-0.014 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4134, longlat, clrk80, "+proj=longlat +ellps=clrk80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4135, longlat, clrk66, "+proj=longlat +ellps=clrk66 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4136, longlat, clrk66, "+proj=longlat +ellps=clrk66 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4137, longlat, clrk66, "+proj=longlat +ellps=clrk66 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4138, longlat, clrk66, "+proj=longlat +ellps=clrk66 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4139, longlat, clrk66, "+proj=longlat +ellps=clrk66 +towgs84=11,72,-101,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4140, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4141, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=-48,55,52,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4142, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=-125,53,467,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4143, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=-124.76,53,466.79,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4144, longlat, 6377276.345, 6356075.41314024, "+proj=longlat +a=6377276.345 +b=6356075.41314024 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4145, longlat, 6377301.243, 6356100.230165384, "+proj=longlat +a=6377301.243 +b=6356100.230165384 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4146, longlat, 6377299.151, 6356098.145120132, "+proj=longlat +a=6377299.151 +b=6356098.145120132 +towgs84=295,736,257,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4147, longlat, krass, "+proj=longlat +ellps=krass +towgs84=-17.51,-108.32,-62.39,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4148, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4149, longlat, bessel, "+proj=longlat +ellps=bessel +towgs84=674.374,15.056,405.346,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4150, longlat, bessel, "+proj=longlat +ellps=bessel +towgs84=674.374,15.056,405.346,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4151, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4152, longlat, GRS80, "+proj=longlat +ellps=GRS80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4153, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-133.63,-157.5,-158.62,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4154, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4155, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-83,37,124,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4156, longlat, bessel, "+proj=longlat +ellps=bessel +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4157, longlat, 6378293.645208759, 6356617.987679838, "+proj=longlat +a=6378293.645208759 +b=6356617.987679838 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4158, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4159, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4160, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4161, longlat, intl, "+proj=longlat +ellps=intl +towgs84=27.5,14,186.4,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4162, longlat, bessel, "+proj=longlat +ellps=bessel +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4163, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4164, longlat, krass, "+proj=longlat +ellps=krass +towgs84=-76,-138,67,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4165, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-173,253,27,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4166, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4167, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4168, longlat, 6378300, 6356751.689189189, "+proj=longlat +a=6378300 +b=6356751.689189189 +towgs84=-199,32,322,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4169, longlat, clrk66, "+proj=longlat +ellps=clrk66 +towgs84=-115,118,426,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4170, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4171, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4172, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4173, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4174, longlat, 6378300, 6356751.689189189, "+proj=longlat +a=6378300 +b=6356751.689189189 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4175, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=-88,4,101,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4176, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4178, longlat, krass, "+proj=longlat +ellps=krass +towgs84=24,-123,-94,0.02,-0.25,-0.13,1.1 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4179, longlat, krass, "+proj=longlat +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4180, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4181, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-193,13.7,-39.3,-0.41,-2.933,2.688,0.43 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4182, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4183, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-104,167,-38,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4184, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-203,141,53,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4185, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4188, longlat, airy, "+proj=longlat +ellps=airy +towgs84=482.5,-130.6,564.6,-1.042,-0.214,-0.631,8.15 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4189, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4190, longlat, GRS80, "+proj=longlat +ellps=GRS80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4191, longlat, krass, "+proj=longlat +ellps=krass +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4192, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-206.1,-174.7,-87.7,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4193, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-70.9,-151.8,-41.4,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4194, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4195, longlat, intl, "+proj=longlat +ellps=intl +towgs84=105,326,-102.5,0,0,0.814,-0.6 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4196, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-45,417,-3.5,0,0,0.814,-0.6 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4197, longlat, clrk80, "+proj=longlat +ellps=clrk80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4198, longlat, clrk80, "+proj=longlat +ellps=clrk80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4199, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4200, longlat, krass, "+proj=longlat +ellps=krass +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4201, longlat, clrk80, "+proj=longlat +ellps=clrk80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4202, longlat, aust_SA, "+proj=longlat +ellps=aust_SA +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4203, longlat, aust_SA, "+proj=longlat +ellps=aust_SA +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4204, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4205, longlat, krass, "+proj=longlat +ellps=krass +towgs84=-43,-163,45,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4206, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4207, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4208, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4209, longlat, 6378249.145, 6356514.966398753, "+proj=longlat +a=6378249.145 +b=6356514.966398753 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4210, longlat, clrk80, "+proj=longlat +ellps=clrk80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4211, longlat, bessel, "+proj=longlat +ellps=bessel +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4212, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=31.95,300.99,419.19,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4213, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-106,-87,188,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4214, longlat, krass, "+proj=longlat +ellps=krass +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4215, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4216, longlat, clrk66, "+proj=longlat +ellps=clrk66 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4218, longlat, intl, "+proj=longlat +ellps=intl +towgs84=307,304,-318,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4219, longlat, bessel, "+proj=longlat +ellps=bessel +towgs84=-384,664,-48,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4220, longlat, clrk80, "+proj=longlat +ellps=clrk80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4221, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4222, longlat, 6378249.145, 6356514.966398753, "+proj=longlat +a=6378249.145 +b=6356514.966398753 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4223, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4224, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-134,229,-29,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4225, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-206,172,-6,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4226, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4227, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4228, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4229, longlat, helmert, "+proj=longlat +ellps=helmert +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4230, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4231, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4232, longlat, clrk80, "+proj=longlat +ellps=clrk80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4233, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-133,-321,50,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4234, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4235, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4236, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-637,-549,-203,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4237, longlat, GRS67, "+proj=longlat +ellps=GRS67 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4238, longlat, 6378160, 6356774.50408554, "+proj=longlat +a=6378160 +b=6356774.50408554 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4239, longlat, 6377276.345, 6356075.41314024, "+proj=longlat +a=6377276.345 +b=6356075.41314024 +towgs84=217,823,299,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4240, longlat, 6377276.345, 6356075.41314024, "+proj=longlat +a=6377276.345 +b=6356075.41314024 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4241, longlat, 6378249.144808011, 6356514.966204134, "+proj=longlat +a=6378249.144808011 +b=6356514.966204134 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4242, longlat, clrk66, "+proj=longlat +ellps=clrk66 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4243, longlat, 6377299.36559538, 6356098.359005157, "+proj=longlat +a=6377299.36559538 +b=6356098.359005157 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4244, longlat, 6377276.345, 6356075.41314024, "+proj=longlat +a=6377276.345 +b=6356075.41314024 +towgs84=-97,787,86,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4245, longlat, 6377304.063, 6356103.038993155, "+proj=longlat +a=6377304.063 +b=6356103.038993155 +towgs84=-11,851,5,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4246, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=-294.7,-200.1,525.5,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4247, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-273.5,110.6,-357.9,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4248, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4249, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4250, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=-130,29,364,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4251, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=-90,40,88,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4252, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4253, longlat, clrk66, "+proj=longlat +ellps=clrk66 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4254, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4255, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-333,-222,114,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4256, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=41,-220,-134,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4257, longlat, bessel, "+proj=longlat +ellps=bessel +towgs84=-587.8,519.75,145.76,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4258, longlat, GRS80, "+proj=longlat +ellps=GRS80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4259, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4260, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=-70.9,-151.8,-41.4,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4261, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=31,146,47,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4262, longlat, bessel, "+proj=longlat +ellps=bessel +towgs84=639,405,60,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4263, longlat, clrk80, "+proj=longlat +ellps=clrk80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4264, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-252.95,-4.11,-96.38,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4265, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4266, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 4267, longlat, clrk66, NAD27, "+proj=longlat +ellps=clrk66 +datum=NAD27 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4268, longlat, 6378450.047548896, 6356826.621488444, "+proj=longlat +a=6378450.047548896 +b=6356826.621488444 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 4269, longlat, GRS80, NAD83, "+proj=longlat +ellps=GRS80 +datum=NAD83 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4270, longlat, clrk80, "+proj=longlat +ellps=clrk80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4271, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 4272, longlat, intl, nzgd49, "+proj=longlat +ellps=intl +datum=nzgd49 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4273, longlat, 6377492.018, 6356173.508712696, "+proj=longlat +a=6377492.018 +b=6356173.508712696 +towgs84=278.3,93,474.5,7.889,0.05,-6.61,6.21 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4274, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4275, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4276, longlat, WGS66, "+proj=longlat +ellps=WGS66 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 4277, longlat, airy, OSGB36, "+proj=longlat +ellps=airy +datum=OSGB36 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4278, longlat, airy, "+proj=longlat +ellps=airy +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4279, longlat, airy, "+proj=longlat +ellps=airy +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4280, longlat, bessel, "+proj=longlat +ellps=bessel +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4281, longlat, 6378300.789, 6356566.435, "+proj=longlat +a=6378300.789 +b=6356566.435 +towgs84=-275.722,94.7824,340.894,-8.001,-4.42,-11.821,1 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4282, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4283, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4284, longlat, krass, "+proj=longlat +ellps=krass +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4285, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4286, longlat, helmert, "+proj=longlat +ellps=helmert +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4287, longlat, intl, "+proj=longlat +ellps=intl +towgs84=164,138,-189,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4288, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4289, longlat, bessel, "+proj=longlat +ellps=bessel +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4291, longlat, GRS67, "+proj=longlat +ellps=GRS67 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4292, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-355,21,72,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4293, longlat, bess_nam, "+proj=longlat +ellps=bess_nam +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4294, longlat, bessel, "+proj=longlat +ellps=bessel +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4295, longlat, bessel, "+proj=longlat +ellps=bessel +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4296, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4297, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-189,-242,-91,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4298, longlat, evrstSS, "+proj=longlat +ellps=evrstSS +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4299, longlat, 6377340.189, 6356034.447938534, "+proj=longlat +a=6377340.189 +b=6356034.447938534 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4300, longlat, 6377340.189, 6356034.447938534, "+proj=longlat +a=6377340.189 +b=6356034.447938534 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4301, longlat, bessel, "+proj=longlat +ellps=bessel +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4302, longlat, 6378293.645208759, 6356617.987679838, "+proj=longlat +a=6378293.645208759 +b=6356617.987679838 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4303, longlat, helmert, "+proj=longlat +ellps=helmert +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4304, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-73,-247,227,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4306, longlat, bessel, "+proj=longlat +ellps=bessel +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4307, longlat, clrk80, "+proj=longlat +ellps=clrk80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4308, longlat, bessel, "+proj=longlat +ellps=bessel +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4309, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-155,171,37,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4310, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4311, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-265,120,-358,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4312, longlat, bessel, "+proj=longlat +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4313, longlat, intl, "+proj=longlat +ellps=intl +towgs84=106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 4314, longlat, bessel, potsdam, "+proj=longlat +ellps=bessel +datum=potsdam +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4315, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-23,259,-9,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4316, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4317, longlat, krass, "+proj=longlat +ellps=krass +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4318, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=-3.2,-5.7,2.8,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4319, longlat, GRS80, "+proj=longlat +ellps=GRS80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4322, longlat, WGS72, "+proj=longlat +ellps=WGS72 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4324, longlat, WGS72, "+proj=longlat +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 4326, longlat, WGS84, WGS84, "+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 4327, longlat, WGS84, WGS84, "+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4328, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 4329, longlat, WGS84, WGS84, "+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4330, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4331, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4332, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4333, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4334, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4335, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4336, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4337, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4338, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4339, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4340, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4341, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4342, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4343, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4344, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4345, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4346, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4347, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4348, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4349, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4350, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4351, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4352, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4353, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4354, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4355, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4356, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4357, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0.0,0.0,0.0,-0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4358, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4359, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=-0.991,1.9072,0.5129,0.0257899075194932,-0.009650098960270402,-0.011659943232342112,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4360, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4361, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=-0.991,1.9072,0.5129,0.0257899075194932,-0.009650098960270402,-0.011659943232342112,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4362, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4363, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4364, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4365, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4366, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4367, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4368, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4369, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4370, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4371, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=2.0,2.0,-2.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4372, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4373, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4374, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4375, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4376, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4377, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4378, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4379, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4380, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4381, longlat, intl, "+proj=longlat +ellps=intl +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4382, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4383, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4384, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4385, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4386, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4387, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4388, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4389, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4600, longlat, clrk80, "+proj=longlat +ellps=clrk80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4601, longlat, clrk80, "+proj=longlat +ellps=clrk80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4602, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=725,685,536,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4603, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=72,213.7,93,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4604, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=174,359,365,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4605, longlat, clrk80, "+proj=longlat +ellps=clrk80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4606, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=-149,128,296,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4607, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=195.671,332.517,274.607,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4608, longlat, clrk66, "+proj=longlat +ellps=clrk66 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4609, longlat, clrk66, "+proj=longlat +ellps=clrk66 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4610, longlat, 6378140, 6356755.288157528, "+proj=longlat +a=6378140 +b=6356755.288157528 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4611, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-162.619,-276.959,-161.764,0.067753,-2.24365,-1.15883,-1.09425 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4612, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4613, longlat, bessel, "+proj=longlat +ellps=bessel +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4614, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-119.425,-303.659,-11.0006,1.1643,0.174458,1.09626,3.65706 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4615, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-499,-249,314,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4616, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4617, longlat, GRS80, "+proj=longlat +ellps=GRS80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4618, longlat, aust_SA, "+proj=longlat +ellps=aust_SA +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4619, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4620, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=-106,-129,165,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4621, longlat, intl, "+proj=longlat +ellps=intl +towgs84=137,248,-430,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4622, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4623, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-186,230,110,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4624, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=2,2,-2,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4625, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4626, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4627, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4628, longlat, intl, "+proj=longlat +ellps=intl +towgs84=162,117,154,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4629, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4630, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4631, longlat, intl, "+proj=longlat +ellps=intl +towgs84=145,-187,103,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4632, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-382,-59,-262,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4633, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4634, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4635, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-122.383,-188.696,103.344,3.5107,-4.9668,-5.7047,4.4798 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4636, longlat, intl, "+proj=longlat +ellps=intl +towgs84=365,194,166,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4637, longlat, intl, "+proj=longlat +ellps=intl +towgs84=325,154,172,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4638, longlat, clrk66, "+proj=longlat +ellps=clrk66 +towgs84=30,430,368,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4639, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4640, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4641, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4642, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4643, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-480.26,-438.32,-643.429,16.3119,20.1721,-4.0349,-111.7 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4644, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4645, longlat, intl, "+proj=longlat +ellps=intl +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4646, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4657, longlat, 6377019.27, 6355762.5391, "+proj=longlat +a=6377019.27 +b=6355762.5391 +towgs84=-28,199,5,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4658, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-73,46,-86,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4659, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4660, longlat, intl, "+proj=longlat +ellps=intl +towgs84=982.609,552.753,-540.873,32.3934,-153.257,-96.2266,16.805 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4661, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4662, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4663, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4664, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4665, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4666, longlat, bessel, "+proj=longlat +ellps=bessel +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4667, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4668, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-86,-98,-119,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4669, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4670, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4671, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4672, longlat, intl, "+proj=longlat +ellps=intl +towgs84=175,-38,113,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4673, longlat, intl, "+proj=longlat +ellps=intl +towgs84=174.05,-25.49,112.57,-0,-0,0.554,0.2263 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4674, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4675, longlat, clrk66, "+proj=longlat +ellps=clrk66 +towgs84=-100,-248,259,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4676, longlat, krass, "+proj=longlat +ellps=krass +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4677, longlat, krass, "+proj=longlat +ellps=krass +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4678, longlat, krass, "+proj=longlat +ellps=krass +towgs84=44.585,-131.212,-39.544,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4679, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=-80.01,253.26,291.19,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4680, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=124.5,-63.5,-281,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4681, longlat, clrk80, "+proj=longlat +ellps=clrk80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4682, longlat, 6377276.345, 6356075.41314024, "+proj=longlat +a=6377276.345 +b=6356075.41314024 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4683, longlat, clrk66, "+proj=longlat +ellps=clrk66 +towgs84=-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4684, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-133,-321,50,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4685, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4686, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4687, longlat, GRS80, "+proj=longlat +ellps=GRS80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4688, longlat, intl, "+proj=longlat +ellps=intl +towgs84=347.103,1078.12,2623.92,-33.8875,70.6773,-9.3943,186.074 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4689, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4690, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4691, longlat, intl, "+proj=longlat +ellps=intl +towgs84=215.525,149.593,176.229,-3.2624,-1.692,-1.1571,10.4773 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4692, longlat, intl, "+proj=longlat +ellps=intl +towgs84=217.037,86.959,23.956,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4693, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0,-0.15,0.68,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4694, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4695, longlat, clrk66, "+proj=longlat +ellps=clrk66 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4696, longlat, clrk80, "+proj=longlat +ellps=clrk80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4697, longlat, clrk80, "+proj=longlat +ellps=clrk80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4698, longlat, intl, "+proj=longlat +ellps=intl +towgs84=145,-187,103,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4699, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=-770.1,158.4,-498.2,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4700, longlat, clrk80, "+proj=longlat +ellps=clrk80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4701, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=-79.9,-158,-168.9,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4702, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4703, longlat, clrk80, "+proj=longlat +ellps=clrk80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4704, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4705, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4706, longlat, helmert, "+proj=longlat +ellps=helmert +towgs84=-146.21,112.63,4.05,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4707, longlat, intl, "+proj=longlat +ellps=intl +towgs84=114,-116,-333,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4708, longlat, aust_SA, "+proj=longlat +ellps=aust_SA +towgs84=-491,-22,435,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4709, longlat, intl, "+proj=longlat +ellps=intl +towgs84=145,75,-272,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4710, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-320,550,-494,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4711, longlat, intl, "+proj=longlat +ellps=intl +towgs84=124,-234,-25,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4712, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-205,107,53,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4713, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=-79,-129,145,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4714, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-127,-769,472,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4715, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-104,-129,239,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4716, longlat, intl, "+proj=longlat +ellps=intl +towgs84=298,-304,-375,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4717, longlat, clrk66, "+proj=longlat +ellps=clrk66 +towgs84=-2,151,181,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4718, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4719, longlat, intl, "+proj=longlat +ellps=intl +towgs84=211,147,111,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4720, longlat, WGS72, "+proj=longlat +ellps=WGS72 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4721, longlat, intl, "+proj=longlat +ellps=intl +towgs84=265.025,384.929,-194.046,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4722, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-794,119,-298,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4723, longlat, clrk66, "+proj=longlat +ellps=clrk66 +towgs84=67.8,106.1,138.8,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4724, longlat, intl, "+proj=longlat +ellps=intl +towgs84=208,-435,-229,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4725, longlat, intl, "+proj=longlat +ellps=intl +towgs84=189,-79,-202,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4726, longlat, clrk66, "+proj=longlat +ellps=clrk66 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4727, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4728, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-307,-92,127,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4729, longlat, intl, "+proj=longlat +ellps=intl +towgs84=185,165,42,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4730, longlat, intl, "+proj=longlat +ellps=intl +towgs84=170,42,84,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4731, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=51,391,-36,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4732, longlat, 6378270, 6356794.343434343, "+proj=longlat +a=6378270 +b=6356794.343434343 +towgs84=102,52,-38,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4733, longlat, intl, "+proj=longlat +ellps=intl +towgs84=276,-57,149,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4734, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-632,438,-609,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4735, longlat, intl, "+proj=longlat +ellps=intl +towgs84=647,1777,-1124,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4736, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=260,12,-147,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4737, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4738, longlat, 6378293.645208759, 6356617.987679838, "+proj=longlat +a=6378293.645208759 +b=6356617.987679838 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4739, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-156,-271,-189,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4740, longlat, 6378136, 6356751.361745712, "+proj=longlat +a=6378136 +b=6356751.361745712 +towgs84=0,0,1.5,-0,-0,0.076,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4741, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4742, longlat, GRS80, "+proj=longlat +ellps=GRS80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4743, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=84.1,-320.1,218.7,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4744, longlat, clrk80, "+proj=longlat +ellps=clrk80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4745, longlat, bessel, "+proj=longlat +ellps=bessel +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4746, longlat, bessel, "+proj=longlat +ellps=bessel +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4747, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4748, longlat, 6378306.3696, 6356571.996, "+proj=longlat +a=6378306.3696 +b=6356571.996 +towgs84=51,391,-36,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4749, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4750, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=-56.263,16.136,-22.856,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4751, longlat, 6377295.664, 6356094.667915204, "+proj=longlat +a=6377295.664 +b=6356094.667915204 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4752, longlat, 6378306.3696, 6356571.996, "+proj=longlat +a=6378306.3696 +b=6356571.996 +towgs84=51,391,-36,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4753, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4754, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4755, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4756, longlat, WGS84, "+proj=longlat +ellps=WGS84 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4757, longlat, WGS84, "+proj=longlat +ellps=WGS84 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4758, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4759, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4760, longlat, WGS66, "+proj=longlat +ellps=WGS66 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4761, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4762, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4763, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4764, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4765, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4801, longlat, bessel, "+proj=longlat +ellps=bessel +pm=bern +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4802, longlat, intl, "+proj=longlat +ellps=intl +pm=bogota +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4803, longlat, intl, "+proj=longlat +ellps=intl +pm=lisbon +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4804, longlat, bessel, "+proj=longlat +ellps=bessel +towgs84=-587.8,519.75,145.76,0,0,0,0 +pm=jakarta +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4805, longlat, bessel, "+proj=longlat +ellps=bessel +pm=ferro +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4806, longlat, intl, "+proj=longlat +ellps=intl +pm=rome +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4807, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4808, longlat, bessel, "+proj=longlat +ellps=bessel +pm=jakarta +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4809, longlat, intl, "+proj=longlat +ellps=intl +pm=brussels +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4810, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-189,-242,-91,0,0,0,0 +pm=paris +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4811, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-73,-247,227,0,0,0,0 +pm=paris +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4813, longlat, bessel, "+proj=longlat +ellps=bessel +pm=jakarta +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4814, longlat, bessel, "+proj=longlat +ellps=bessel +pm=stockholm +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4815, longlat, bessel, "+proj=longlat +ellps=bessel +pm=athens +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4816, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +pm=paris +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4817, longlat, 6377492.018, 6356173.508712696, "+proj=longlat +a=6377492.018 +b=6356173.508712696 +towgs84=278.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4818, longlat, bessel, "+proj=longlat +ellps=bessel +pm=ferro +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4819, longlat, clrk80, "+proj=longlat +ellps=clrk80 +pm=paris +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4820, longlat, bessel, "+proj=longlat +ellps=bessel +pm=jakarta +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4821, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +pm=paris +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4882, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4883, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4884, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4885, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4886, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4887, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4888, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4889, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4890, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4891, longlat, WGS66, "+proj=longlat +ellps=WGS66 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4892, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4893, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4894, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4895, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4896, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4897, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4898, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4899, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4900, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-208.4058,-109.8777,-2.5764,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4901, longlat, 6376523, 6355862.933255573, "+proj=longlat +a=6376523 +b=6355862.933255573 +pm=2.3372291666985 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4902, longlat, 6376523, 6355862.933255573, "+proj=longlat +a=6376523 +b=6355862.933255573 +pm=paris +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4903, longlat, 6378298.3, 6356657.142669561, "+proj=longlat +a=6378298.3 +b=6356657.142669561 +pm=madrid +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4904, longlat, bessel, "+proj=longlat +ellps=bessel +pm=lisbon +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4906, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4907, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4908, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4909, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4910, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4911, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4912, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4913, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4914, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4915, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4916, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4917, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4918, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4919, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4920, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4921, longlat, GRS80, "+proj=longlat +ellps=GRS80 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4922, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 4923, longlat, 6378136, 6356751.361745712, "+proj=longlat +a=6378136 +b=6356751.361745712 +towgs84=0.0,0.0,1.5,-0.0,0.0,-0.076,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4924, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4925, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4926, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4927, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4928, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4929, longlat, GRS80, "+proj=longlat +ellps=GRS80 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4930, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4931, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4932, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4933, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4934, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4935, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4936, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4937, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4938, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4939, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4940, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4941, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4942, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4943, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4944, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4945, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4946, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4947, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4948, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4949, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4950, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4951, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4952, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4953, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0.0,0.0,0.0,-0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4954, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4955, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=-0.991,1.9072,0.5129,0.0257899075194932,-0.009650098960270402,-0.011659943232342112,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4956, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4957, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=-0.991,1.9072,0.5129,0.0257899075194932,-0.009650098960270402,-0.011659943232342112,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4958, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4959, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4960, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4961, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4962, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4963, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4964, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4965, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4966, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4967, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=2.0,2.0,-2.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4968, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4969, longlat, intl, "+proj=longlat +ellps=intl +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4970, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4971, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4972, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4973, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4974, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4975, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4976, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4977, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4978, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 4979, longlat, WGS84, WGS84, "+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4980, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4981, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4982, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4983, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4984, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4985, longlat, WGS72, "+proj=longlat +ellps=WGS72 +towgs84=0.0,0.0,4.5,0.0,0.0,0.554,0.045171992568114105 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4986, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4987, longlat, WGS72, "+proj=longlat +ellps=WGS72 +towgs84=0.0,0.0,1.9,0.0,0.0,0.814,-0.07838062637389662 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4988, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4989, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4990, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4991, longlat, krass, "+proj=longlat +ellps=krass +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4992, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4993, longlat, krass, "+proj=longlat +ellps=krass +towgs84=44.585,-131.212,-39.544,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4994, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4995, longlat, clrk66, "+proj=longlat +ellps=clrk66 +towgs84=-127.62,-67.24,-47.04,-3.068,-4.903,-1.578,-0.21864069462192215 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4996, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4997, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 4998, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 4999, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.072,-0.507,-0.245,-0.0183,-0.0003,0.007,-0.001918262698097996 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5600, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5601, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5602, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5603, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5604, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5605, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5606, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5607, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5608, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5609, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5610, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5611, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5612, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5613, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5614, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5615, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5616, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5617, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5618, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5619, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5620, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5701, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5702, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5703, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5704, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5705, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5706, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5709, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5710, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5711, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5712, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5713, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5714, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5715, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5716, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5717, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5718, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5719, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5720, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5721, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5722, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5723, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5724, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5725, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5726, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5727, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5728, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5729, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5730, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5731, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5732, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5733, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5734, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5735, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5736, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5737, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5738, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5739, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5740, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5741, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5742, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5743, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5744, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5745, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5746, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5747, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5748, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5749, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5750, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5751, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5752, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5753, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5754, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5755, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5756, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5757, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5758, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5759, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5760, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5761, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5762, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5763, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5764, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5765, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5766, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5767, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5768, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5769, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5770, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5771, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5772, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5773, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5774, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5775, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5776, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5777, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5778, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5779, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5780, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5781, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5782, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5783, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5784, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5785, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5786, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5787, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5788, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5789, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5790, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5791, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5792, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5793, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5794, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5795, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5796, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5797, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5798, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5799, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5800, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5801, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5802, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5803, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5804, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5805, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5806, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5807, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5808, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5809, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5810, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5811, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5812, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5813, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5814, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5815, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5816, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5817, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5818, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5819, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5820, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 5821, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 7400, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 7401, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 7402, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 7403, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 7404, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 7405, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 7406, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 7407, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 7408, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 7409, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 7410, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 7411, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 7412, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 7413, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 7414, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 7415, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 7416, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 7417, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 7418, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 7419, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 7420, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 7421, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 7422, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20004, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20005, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=5500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20006, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=6500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20007, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=7500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20008, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=8500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20009, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=9500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20010, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=10500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20011, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=11500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20012, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=12500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20013, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=13500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20014, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=14500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20015, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=15500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20016, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=16500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20017, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=17500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20018, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20019, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20020, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=20500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20021, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=21500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20022, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=22500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20023, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=23500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20024, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=24500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20025, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=25500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20026, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=26500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20027, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=27500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20028, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=28500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20029, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=29500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20030, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=30500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20031, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=31500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20032, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=32500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20064, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20065, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20066, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20067, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20068, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20069, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20070, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20071, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20072, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20073, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20074, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20075, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20076, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20077, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20078, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20079, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20080, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20081, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20082, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20083, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20084, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20085, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20086, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20087, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20088, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20089, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20090, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20091, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20092, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20135, utm, clrk80, "+proj=utm +zone=35 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20136, utm, clrk80, "+proj=utm +zone=36 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20137, utm, clrk80, "+proj=utm +zone=37 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20138, utm, clrk80, "+proj=utm +zone=38 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20248, utm, aust_SA, "+proj=utm +zone=48 +south +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20249, utm, aust_SA, "+proj=utm +zone=49 +south +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20250, utm, aust_SA, "+proj=utm +zone=50 +south +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20251, utm, aust_SA, "+proj=utm +zone=51 +south +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20252, utm, aust_SA, "+proj=utm +zone=52 +south +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20253, utm, aust_SA, "+proj=utm +zone=53 +south +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20254, utm, aust_SA, "+proj=utm +zone=54 +south +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20255, utm, aust_SA, "+proj=utm +zone=55 +south +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20256, utm, aust_SA, "+proj=utm +zone=56 +south +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20257, utm, aust_SA, "+proj=utm +zone=57 +south +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20258, utm, aust_SA, "+proj=utm +zone=58 +south +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20348, utm, aust_SA, "+proj=utm +zone=48 +south +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20349, utm, aust_SA, "+proj=utm +zone=49 +south +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20350, utm, aust_SA, "+proj=utm +zone=50 +south +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20351, utm, aust_SA, "+proj=utm +zone=51 +south +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20352, utm, aust_SA, "+proj=utm +zone=52 +south +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20353, utm, aust_SA, "+proj=utm +zone=53 +south +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20354, utm, aust_SA, "+proj=utm +zone=54 +south +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20355, utm, aust_SA, "+proj=utm +zone=55 +south +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20356, utm, aust_SA, "+proj=utm +zone=56 +south +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20357, utm, aust_SA, "+proj=utm +zone=57 +south +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20358, utm, aust_SA, "+proj=utm +zone=58 +south +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20436, utm, intl, "+proj=utm +zone=36 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20437, utm, intl, "+proj=utm +zone=37 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20438, utm, intl, "+proj=utm +zone=38 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20439, utm, intl, "+proj=utm +zone=39 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20440, utm, intl, "+proj=utm +zone=40 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20499, utm, intl, "+proj=utm +zone=39 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20538, utm, krass, "+proj=utm +zone=38 +ellps=krass +towgs84=-43,-163,45,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20539, utm, krass, "+proj=utm +zone=39 +ellps=krass +towgs84=-43,-163,45,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20790, tmerc, intl, "+proj=tmerc +lat_0=39.66666666666666 +lon_0=1 +k=1 +x_0=200000 +y_0=300000 +ellps=intl +pm=lisbon +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20791, tmerc, intl, "+proj=tmerc +lat_0=39.66666666666666 +lon_0=1 +k=1 +x_0=0 +y_0=0 +ellps=intl +pm=lisbon +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20822, utm, intl, "+proj=utm +zone=22 +south +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20823, utm, intl, "+proj=utm +zone=23 +south +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 20824, utm, intl, "+proj=utm +zone=24 +south +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 20934, utm, 6378249.145, 6356514.966398753, "+proj=utm +zone=34 +south +a=6378249.145 +b=6356514.966398753 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 20935, utm, 6378249.145, 6356514.966398753, "+proj=utm +zone=35 +south +a=6378249.145 +b=6356514.966398753 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 20936, utm, 6378249.145, 6356514.966398753, "+proj=utm +zone=36 +south +a=6378249.145 +b=6356514.966398753 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21035, utm, clrk80, "+proj=utm +zone=35 +south +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21036, utm, clrk80, "+proj=utm +zone=36 +south +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21037, utm, clrk80, "+proj=utm +zone=37 +south +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21095, utm, clrk80, "+proj=utm +zone=35 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21096, utm, clrk80, "+proj=utm +zone=36 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21097, utm, clrk80, "+proj=utm +zone=37 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21100, merc, bessel, "+proj=merc +lon_0=110 +k=0.997 +x_0=3900000 +y_0=900000 +ellps=bessel +pm=jakarta +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21148, utm, bessel, "+proj=utm +zone=48 +south +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21149, utm, bessel, "+proj=utm +zone=49 +south +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21150, utm, bessel, "+proj=utm +zone=50 +south +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21291, tmerc, clrk80, "+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=31.95,300.99,419.19,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21292, tmerc, clrk80, "+proj=tmerc +lat_0=13.17638888888889 +lon_0=-59.55972222222222 +k=0.9999986 +x_0=30000 +y_0=75000 +ellps=clrk80 +towgs84=31.95,300.99,419.19,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21413, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=13500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21414, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=14500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21415, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=15500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21416, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=16500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21417, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=17500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21418, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21419, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21420, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=20500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21421, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=21500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21422, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=22500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21423, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=23500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21453, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21454, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21455, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21456, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21457, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21458, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21459, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21460, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21461, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21462, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21463, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21473, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21474, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21475, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21476, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21477, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21478, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21479, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21480, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21481, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21482, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21483, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21500, lcc, intl, "+proj=lcc +lat_1=49.83333333333334 +lat_2=51.16666666666666 +lat_0=90 +lon_0=0 +x_0=150000 +y_0=5400000 +ellps=intl +pm=brussels +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21780, somerc, bessel, "+proj=somerc +lat_0=46.95240555555556 +lon_0=0 +k_0=1 +x_0=0 +y_0=0 +ellps=bessel +pm=bern +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21781, somerc, bessel, "+proj=somerc +lat_0=46.95240555555556 +lon_0=7.439583333333333 +k_0=1 +x_0=600000 +y_0=200000 +ellps=bessel +towgs84=674.374,15.056,405.346,0,0,0,0 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 21782, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21817, utm, intl, "+proj=utm +zone=17 +ellps=intl +towgs84=307,304,-318,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21818, utm, intl, "+proj=utm +zone=18 +ellps=intl +towgs84=307,304,-318,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21891, tmerc, intl, "+proj=tmerc +lat_0=4.599047222222222 +lon_0=-77.08091666666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs84=307,304,-318,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21892, tmerc, intl, "+proj=tmerc +lat_0=4.599047222222222 +lon_0=-74.08091666666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs84=307,304,-318,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21893, tmerc, intl, "+proj=tmerc +lat_0=4.599047222222222 +lon_0=-71.08091666666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs84=307,304,-318,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21894, tmerc, intl, "+proj=tmerc +lat_0=4.599047222222222 +lon_0=-68.08091666666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs84=307,304,-318,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21896, tmerc, intl, "+proj=tmerc +lat_0=4.599047222222222 +lon_0=-77.08091666666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs84=307,304,-318,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21897, tmerc, intl, "+proj=tmerc +lat_0=4.599047222222222 +lon_0=-74.08091666666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs84=307,304,-318,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21898, tmerc, intl, "+proj=tmerc +lat_0=4.599047222222222 +lon_0=-71.08091666666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs84=307,304,-318,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 21899, tmerc, intl, "+proj=tmerc +lat_0=4.599047222222222 +lon_0=-68.08091666666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs84=307,304,-318,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22032, utm, clrk80, "+proj=utm +zone=32 +south +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22033, utm, clrk80, "+proj=utm +zone=33 +south +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22091, tmerc, clrk80, "+proj=tmerc +lat_0=0 +lon_0=11.5 +k=0.9996 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22092, tmerc, clrk80, "+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9996 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22171, tmerc, GRS80, "+proj=tmerc +lat_0=-90 +lon_0=-72 +k=1 +x_0=1500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22172, tmerc, GRS80, "+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22173, tmerc, GRS80, "+proj=tmerc +lat_0=-90 +lon_0=-66 +k=1 +x_0=3500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22174, tmerc, GRS80, "+proj=tmerc +lat_0=-90 +lon_0=-63 +k=1 +x_0=4500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22175, tmerc, GRS80, "+proj=tmerc +lat_0=-90 +lon_0=-60 +k=1 +x_0=5500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22176, tmerc, GRS80, "+proj=tmerc +lat_0=-90 +lon_0=-57 +k=1 +x_0=6500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22177, tmerc, GRS80, "+proj=tmerc +lat_0=-90 +lon_0=-54 +k=1 +x_0=7500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22181, tmerc, WGS84, "+proj=tmerc +lat_0=-90 +lon_0=-72 +k=1 +x_0=1500000 +y_0=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22182, tmerc, WGS84, "+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22183, tmerc, WGS84, "+proj=tmerc +lat_0=-90 +lon_0=-66 +k=1 +x_0=3500000 +y_0=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22184, tmerc, WGS84, "+proj=tmerc +lat_0=-90 +lon_0=-63 +k=1 +x_0=4500000 +y_0=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22185, tmerc, WGS84, "+proj=tmerc +lat_0=-90 +lon_0=-60 +k=1 +x_0=5500000 +y_0=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22186, tmerc, WGS84, "+proj=tmerc +lat_0=-90 +lon_0=-57 +k=1 +x_0=6500000 +y_0=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22187, tmerc, WGS84, "+proj=tmerc +lat_0=-90 +lon_0=-54 +k=1 +x_0=7500000 +y_0=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22191, tmerc, intl, "+proj=tmerc +lat_0=-90 +lon_0=-72 +k=1 +x_0=1500000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22192, tmerc, intl, "+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22193, tmerc, intl, "+proj=tmerc +lat_0=-90 +lon_0=-66 +k=1 +x_0=3500000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22194, tmerc, intl, "+proj=tmerc +lat_0=-90 +lon_0=-63 +k=1 +x_0=4500000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22195, tmerc, intl, "+proj=tmerc +lat_0=-90 +lon_0=-60 +k=1 +x_0=5500000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22196, tmerc, intl, "+proj=tmerc +lat_0=-90 +lon_0=-57 +k=1 +x_0=6500000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22197, tmerc, intl, "+proj=tmerc +lat_0=-90 +lon_0=-54 +k=1 +x_0=7500000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 22234, utm, 6378249.145, 6356514.966398753, "+proj=utm +zone=34 +south +a=6378249.145 +b=6356514.966398753 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 22235, utm, 6378249.145, 6356514.966398753, "+proj=utm +zone=35 +south +a=6378249.145 +b=6356514.966398753 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 22236, utm, 6378249.145, 6356514.966398753, "+proj=utm +zone=36 +south +a=6378249.145 +b=6356514.966398753 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 22275, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 22277, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 22279, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 22281, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 22283, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 22285, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 22287, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 22289, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 22291, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 22293, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 22300, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 22332, utm, 6378249.2, 6356515, "+proj=utm +zone=32 +a=6378249.2 +b=6356515 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 22391, lcc, 6378249.2, 6356515, "+proj=lcc +lat_1=36 +lat_0=36 +lon_0=9.9 +k_0=0.999625544 +x_0=500000 +y_0=300000 +a=6378249.2 +b=6356515 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 22392, lcc, 6378249.2, 6356515, "+proj=lcc +lat_1=33.3 +lat_0=33.3 +lon_0=9.9 +k_0=0.999625769 +x_0=500000 +y_0=300000 +a=6378249.2 +b=6356515 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22521, utm, intl, "+proj=utm +zone=21 +south +ellps=intl +towgs84=-206,172,-6,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22522, utm, intl, "+proj=utm +zone=22 +south +ellps=intl +towgs84=-206,172,-6,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22523, utm, intl, "+proj=utm +zone=23 +south +ellps=intl +towgs84=-206,172,-6,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22524, utm, intl, "+proj=utm +zone=24 +south +ellps=intl +towgs84=-206,172,-6,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22525, utm, intl, "+proj=utm +zone=25 +south +ellps=intl +towgs84=-206,172,-6,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 22700, lcc, 6378249.2, 6356515, "+proj=lcc +lat_1=34.65 +lat_0=34.65 +lon_0=37.35 +k_0=0.9996256 +x_0=300000 +y_0=300000 +a=6378249.2 +b=6356515 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 22770, lcc, 6378249.2, 6356515, "+proj=lcc +lat_1=34.65 +lat_0=34.65 +lon_0=37.35 +k_0=0.9996256 +x_0=300000 +y_0=300000 +a=6378249.2 +b=6356515 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 22780, sterea, 6378249.2, 6356515, "+proj=sterea +lat_0=34.2 +lon_0=39.15 +k=0.9995341 +x_0=0 +y_0=0 +a=6378249.2 +b=6356515 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 22832, utm, 6378249.2, 6356515, "+proj=utm +zone=32 +a=6378249.2 +b=6356515 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22991, tmerc, helmert, "+proj=tmerc +lat_0=30 +lon_0=35 +k=1 +x_0=300000 +y_0=1100000 +ellps=helmert +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22992, tmerc, helmert, "+proj=tmerc +lat_0=30 +lon_0=31 +k=1 +x_0=615000 +y_0=810000 +ellps=helmert +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22993, tmerc, helmert, "+proj=tmerc +lat_0=30 +lon_0=27 +k=1 +x_0=700000 +y_0=200000 +ellps=helmert +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 22994, tmerc, helmert, "+proj=tmerc +lat_0=30 +lon_0=27 +k=1 +x_0=700000 +y_0=1200000 +ellps=helmert +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23028, utm, intl, "+proj=utm +zone=28 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23029, utm, intl, "+proj=utm +zone=29 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23030, utm, intl, "+proj=utm +zone=30 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23031, utm, intl, "+proj=utm +zone=31 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23032, utm, intl, "+proj=utm +zone=32 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23033, utm, intl, "+proj=utm +zone=33 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23034, utm, intl, "+proj=utm +zone=34 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23035, utm, intl, "+proj=utm +zone=35 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23036, utm, intl, "+proj=utm +zone=36 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23037, utm, intl, "+proj=utm +zone=37 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23038, utm, intl, "+proj=utm +zone=38 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23090, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=500000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23095, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=5 +k=0.9996 +x_0=500000 +y_0=0 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23239, utm, clrk80, "+proj=utm +zone=39 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23240, utm, clrk80, "+proj=utm +zone=40 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 23433, utm, 6378249.2, 6356515, "+proj=utm +zone=33 +a=6378249.2 +b=6356515 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23700, somerc, GRS67, "+proj=somerc +lat_0=47.14439372222222 +lon_0=19.04857177777778 +k_0=0.99993 +x_0=650000 +y_0=200000 +ellps=GRS67 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23830, tmerc, WGS84, "+proj=tmerc +lat_0=0 +lon_0=94.5 +k=0.9999 +x_0=200000 +y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23831, tmerc, WGS84, "+proj=tmerc +lat_0=0 +lon_0=97.5 +k=0.9999 +x_0=200000 +y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23832, tmerc, WGS84, "+proj=tmerc +lat_0=0 +lon_0=100.5 +k=0.9999 +x_0=200000 +y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23833, tmerc, WGS84, "+proj=tmerc +lat_0=0 +lon_0=103.5 +k=0.9999 +x_0=200000 +y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23834, tmerc, WGS84, "+proj=tmerc +lat_0=0 +lon_0=106.5 +k=0.9999 +x_0=200000 +y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23835, tmerc, WGS84, "+proj=tmerc +lat_0=0 +lon_0=109.5 +k=0.9999 +x_0=200000 +y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23836, tmerc, WGS84, "+proj=tmerc +lat_0=0 +lon_0=112.5 +k=0.9999 +x_0=200000 +y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23837, tmerc, WGS84, "+proj=tmerc +lat_0=0 +lon_0=115.5 +k=0.9999 +x_0=200000 +y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23838, tmerc, WGS84, "+proj=tmerc +lat_0=0 +lon_0=118.5 +k=0.9999 +x_0=200000 +y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23839, tmerc, WGS84, "+proj=tmerc +lat_0=0 +lon_0=121.5 +k=0.9999 +x_0=200000 +y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23840, tmerc, WGS84, "+proj=tmerc +lat_0=0 +lon_0=124.5 +k=0.9999 +x_0=200000 +y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23841, tmerc, WGS84, "+proj=tmerc +lat_0=0 +lon_0=127.5 +k=0.9999 +x_0=200000 +y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23842, tmerc, WGS84, "+proj=tmerc +lat_0=0 +lon_0=130.5 +k=0.9999 +x_0=200000 +y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23843, tmerc, WGS84, "+proj=tmerc +lat_0=0 +lon_0=133.5 +k=0.9999 +x_0=200000 +y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23844, tmerc, WGS84, "+proj=tmerc +lat_0=0 +lon_0=136.5 +k=0.9999 +x_0=200000 +y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23845, tmerc, WGS84, "+proj=tmerc +lat_0=0 +lon_0=139.5 +k=0.9999 +x_0=200000 +y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 23846, utm, 6378160, 6356774.50408554, "+proj=utm +zone=46 +a=6378160 +b=6356774.50408554 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 23847, utm, 6378160, 6356774.50408554, "+proj=utm +zone=47 +a=6378160 +b=6356774.50408554 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 23848, utm, 6378160, 6356774.50408554, "+proj=utm +zone=48 +a=6378160 +b=6356774.50408554 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 23849, utm, 6378160, 6356774.50408554, "+proj=utm +zone=49 +a=6378160 +b=6356774.50408554 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 23850, utm, 6378160, 6356774.50408554, "+proj=utm +zone=50 +a=6378160 +b=6356774.50408554 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 23851, utm, 6378160, 6356774.50408554, "+proj=utm +zone=51 +a=6378160 +b=6356774.50408554 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 23852, utm, 6378160, 6356774.50408554, "+proj=utm +zone=52 +a=6378160 +b=6356774.50408554 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 23853, utm, 6378160, 6356774.50408554, "+proj=utm +zone=53 +a=6378160 +b=6356774.50408554 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23866, utm, WGS84, "+proj=utm +zone=46 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23867, utm, WGS84, "+proj=utm +zone=47 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23868, utm, WGS84, "+proj=utm +zone=48 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23869, utm, WGS84, "+proj=utm +zone=49 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23870, utm, WGS84, "+proj=utm +zone=50 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23871, utm, WGS84, "+proj=utm +zone=51 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23872, utm, WGS84, "+proj=utm +zone=52 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23877, utm, WGS84, "+proj=utm +zone=47 +south +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23878, utm, WGS84, "+proj=utm +zone=48 +south +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23879, utm, WGS84, "+proj=utm +zone=49 +south +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23880, utm, WGS84, "+proj=utm +zone=50 +south +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23881, utm, WGS84, "+proj=utm +zone=51 +south +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23882, utm, WGS84, "+proj=utm +zone=52 +south +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23883, utm, WGS84, "+proj=utm +zone=53 +south +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 23884, utm, WGS84, "+proj=utm +zone=54 +south +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 23886, utm, 6378160, 6356774.50408554, "+proj=utm +zone=46 +south +a=6378160 +b=6356774.50408554 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 23887, utm, 6378160, 6356774.50408554, "+proj=utm +zone=47 +south +a=6378160 +b=6356774.50408554 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 23888, utm, 6378160, 6356774.50408554, "+proj=utm +zone=48 +south +a=6378160 +b=6356774.50408554 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 23889, utm, 6378160, 6356774.50408554, "+proj=utm +zone=49 +south +a=6378160 +b=6356774.50408554 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 23890, utm, 6378160, 6356774.50408554, "+proj=utm +zone=50 +south +a=6378160 +b=6356774.50408554 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 23891, utm, 6378160, 6356774.50408554, "+proj=utm +zone=51 +south +a=6378160 +b=6356774.50408554 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 23892, utm, 6378160, 6356774.50408554, "+proj=utm +zone=52 +south +a=6378160 +b=6356774.50408554 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 23893, utm, 6378160, 6356774.50408554, "+proj=utm +zone=53 +south +a=6378160 +b=6356774.50408554 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 23894, utm, 6378160, 6356774.50408554, "+proj=utm +zone=54 +south +a=6378160 +b=6356774.50408554 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 23946, utm, 6377276.345, 6356075.41314024, "+proj=utm +zone=46 +a=6377276.345 +b=6356075.41314024 +towgs84=217,823,299,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 23947, utm, 6377276.345, 6356075.41314024, "+proj=utm +zone=47 +a=6377276.345 +b=6356075.41314024 +towgs84=217,823,299,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 23948, utm, 6377276.345, 6356075.41314024, "+proj=utm +zone=48 +a=6377276.345 +b=6356075.41314024 +towgs84=217,823,299,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 24047, utm, 6377276.345, 6356075.41314024, "+proj=utm +zone=47 +a=6377276.345 +b=6356075.41314024 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 24048, utm, 6377276.345, 6356075.41314024, "+proj=utm +zone=48 +a=6377276.345 +b=6356075.41314024 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 24100, lcc, 6378249.144808011, 6356514.966204134, "+proj=lcc +lat_1=18 +lat_0=18 +lon_0=-77 +k_0=1 +x_0=167638.49597 +y_0=121918.90616 +a=6378249.144808011 +b=6356514.966204134 +to_meter=0.3047972654 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 24200, lcc, clrk66, "+proj=lcc +lat_1=18 +lat_0=18 +lon_0=-77 +k_0=1 +x_0=250000 +y_0=150000 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 24305, utm, 6377276.345, 6356075.41314024, "+proj=utm +zone=45 +a=6377276.345 +b=6356075.41314024 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 24306, utm, 6377276.345, 6356075.41314024, "+proj=utm +zone=46 +a=6377276.345 +b=6356075.41314024 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 24311, utm, 6377301.243, 6356100.230165384, "+proj=utm +zone=41 +a=6377301.243 +b=6356100.230165384 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 24312, utm, 6377301.243, 6356100.230165384, "+proj=utm +zone=42 +a=6377301.243 +b=6356100.230165384 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 24313, utm, 6377301.243, 6356100.230165384, "+proj=utm +zone=43 +a=6377301.243 +b=6356100.230165384 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 24342, utm, 6377299.151, 6356098.145120132, "+proj=utm +zone=42 +a=6377299.151 +b=6356098.145120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 24343, utm, 6377299.151, 6356098.145120132, "+proj=utm +zone=43 +a=6377299.151 +b=6356098.145120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 24344, utm, 6377299.151, 6356098.145120132, "+proj=utm +zone=44 +a=6377299.151 +b=6356098.145120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 24345, utm, 6377299.151, 6356098.145120132, "+proj=utm +zone=45 +a=6377299.151 +b=6356098.145120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 24346, utm, 6377299.151, 6356098.145120132, "+proj=utm +zone=46 +a=6377299.151 +b=6356098.145120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 24347, utm, 6377299.151, 6356098.145120132, "+proj=utm +zone=47 +a=6377299.151 +b=6356098.145120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 24370, lcc, 6377299.36559538, 6356098.359005157, "+proj=lcc +lat_1=39.5 +lat_0=39.5 +lon_0=68 +k_0=0.99846154 +x_0=2153865.73916853 +y_0=2368292.194628102 +a=6377299.36559538 +b=6356098.359005157 +to_meter=0.9143985307444408 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 24371, lcc, 6377299.36559538, 6356098.359005157, "+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=68 +k_0=0.99878641 +x_0=2743195.592233322 +y_0=914398.5307444407 +a=6377299.36559538 +b=6356098.359005157 +to_meter=0.9143985307444408 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 24372, lcc, 6377299.36559538, 6356098.359005157, "+proj=lcc +lat_1=26 +lat_0=26 +lon_0=74 +k_0=0.99878641 +x_0=2743195.592233322 +y_0=914398.5307444407 +a=6377299.36559538 +b=6356098.359005157 +to_meter=0.9143985307444408 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 24373, lcc, 6377299.36559538, 6356098.359005157, "+proj=lcc +lat_1=19 +lat_0=19 +lon_0=80 +k_0=0.99878641 +x_0=2743195.592233322 +y_0=914398.5307444407 +a=6377299.36559538 +b=6356098.359005157 +to_meter=0.9143985307444408 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 24374, lcc, 6377299.36559538, 6356098.359005157, "+proj=lcc +lat_1=12 +lat_0=12 +lon_0=80 +k_0=0.99878641 +x_0=2743195.592233322 +y_0=914398.5307444407 +a=6377299.36559538 +b=6356098.359005157 +to_meter=0.9143985307444408 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 24375, lcc, 6377276.345, 6356075.41314024, "+proj=lcc +lat_1=26 +lat_0=26 +lon_0=90 +k_0=0.99878641 +x_0=2743185.69 +y_0=914395.23 +a=6377276.345 +b=6356075.41314024 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 24376, lcc, 6377301.243, 6356100.230165384, "+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=68 +k_0=0.99878641 +x_0=2743196.4 +y_0=914398.8 +a=6377301.243 +b=6356100.230165384 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 24377, lcc, 6377301.243, 6356100.230165384, "+proj=lcc +lat_1=26 +lat_0=26 +lon_0=74 +k_0=0.99878641 +x_0=2743196.4 +y_0=914398.8 +a=6377301.243 +b=6356100.230165384 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 24378, lcc, 6377299.151, 6356098.145120132, "+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=68 +k_0=0.99878641 +x_0=2743195.5 +y_0=914398.5 +a=6377299.151 +b=6356098.145120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 24379, lcc, 6377299.151, 6356098.145120132, "+proj=lcc +lat_1=26 +lat_0=26 +lon_0=74 +k_0=0.99878641 +x_0=2743195.5 +y_0=914398.5 +a=6377299.151 +b=6356098.145120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 24380, lcc, 6377299.151, 6356098.145120132, "+proj=lcc +lat_1=26 +lat_0=26 +lon_0=90 +k_0=0.99878641 +x_0=2743195.5 +y_0=914398.5 +a=6377299.151 +b=6356098.145120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 24381, lcc, 6377299.151, 6356098.145120132, "+proj=lcc +lat_1=19 +lat_0=19 +lon_0=80 +k_0=0.99878641 +x_0=2743195.5 +y_0=914398.5 +a=6377299.151 +b=6356098.145120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 24382, lcc, 6377299.36559538, 6356098.359005157, "+proj=lcc +lat_1=26 +lat_0=26 +lon_0=90 +k_0=0.99878641 +x_0=2743195.592233322 +y_0=914398.5307444407 +a=6377299.36559538 +b=6356098.359005157 +to_meter=0.9143985307444408 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 24383, lcc, 6377299.151, 6356098.145120132, "+proj=lcc +lat_1=12 +lat_0=12 +lon_0=80 +k_0=0.99878641 +x_0=2743195.5 +y_0=914398.5 +a=6377299.151 +b=6356098.145120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 24500, cass, 6377304.063, 6356103.038993155, "+proj=cass +lat_0=1.287646666666667 +lon_0=103.8530022222222 +x_0=30000 +y_0=30000 +a=6377304.063 +b=6356103.038993155 +towgs84=-11,851,5,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 24547, utm, 6377304.063, 6356103.038993155, "+proj=utm +zone=47 +a=6377304.063 +b=6356103.038993155 +towgs84=-11,851,5,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 24548, utm, 6377304.063, 6356103.038993155, "+proj=utm +zone=48 +a=6377304.063 +b=6356103.038993155 +towgs84=-11,851,5,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 24571, omerc, 6377304.063, 6356103.038993155, "+proj=omerc +lat_0=4 +lonc=102.25 +alpha=323.0257905 +k=0.99984 +x_0=804671.2997750348 +y_0=0 +a=6377304.063 +b=6356103.038993155 +towgs84=-11,851,5,0,0,0,0 +to_meter=20.11678249437587 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 24600, lcc, clrk80, "+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=45 +k_0=0.9987864078000001 +x_0=1500000 +y_0=1166200 +ellps=clrk80 +towgs84=-294.7,-200.1,525.5,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 24718, utm, intl, "+proj=utm +zone=18 +ellps=intl +towgs84=-273.5,110.6,-357.9,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 24719, utm, intl, "+proj=utm +zone=19 +ellps=intl +towgs84=-273.5,110.6,-357.9,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 24720, utm, intl, "+proj=utm +zone=20 +ellps=intl +towgs84=-273.5,110.6,-357.9,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 24817, utm, intl, "+proj=utm +zone=17 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 24818, utm, intl, "+proj=utm +zone=18 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 24819, utm, intl, "+proj=utm +zone=19 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 24820, utm, intl, "+proj=utm +zone=20 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 24821, utm, intl, "+proj=utm +zone=21 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 24877, utm, intl, "+proj=utm +zone=17 +south +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 24878, utm, intl, "+proj=utm +zone=18 +south +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 24879, utm, intl, "+proj=utm +zone=19 +south +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 24880, utm, intl, "+proj=utm +zone=20 +south +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 24881, utm, intl, "+proj=utm +zone=21 +south +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 24882, utm, intl, "+proj=utm +zone=22 +south +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 24891, tmerc, intl, "+proj=tmerc +lat_0=-6 +lon_0=-80.5 +k=0.99983008 +x_0=222000 +y_0=1426834.743 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 24892, tmerc, intl, "+proj=tmerc +lat_0=-9.5 +lon_0=-76 +k=0.99932994 +x_0=720000 +y_0=1039979.159 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 24893, tmerc, intl, "+proj=tmerc +lat_0=-9.5 +lon_0=-70.5 +k=0.99952992 +x_0=1324000 +y_0=1040084.558 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 25000, tmerc, clrk80, "+proj=tmerc +lat_0=4.666666666666667 +lon_0=-1 +k=0.99975 +x_0=274319.51 +y_0=0 +ellps=clrk80 +towgs84=-130,29,364,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 25231, utm, 6378249.2, 6356515, "+proj=utm +zone=31 +a=6378249.2 +b=6356515 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 25391, tmerc, clrk66, "+proj=tmerc +lat_0=0 +lon_0=117 +k=0.99995 +x_0=500000 +y_0=0 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 25392, tmerc, clrk66, "+proj=tmerc +lat_0=0 +lon_0=119 +k=0.99995 +x_0=500000 +y_0=0 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 25393, tmerc, clrk66, "+proj=tmerc +lat_0=0 +lon_0=121 +k=0.99995 +x_0=500000 +y_0=0 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 25394, tmerc, clrk66, "+proj=tmerc +lat_0=0 +lon_0=123 +k=0.99995 +x_0=500000 +y_0=0 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 25395, tmerc, clrk66, "+proj=tmerc +lat_0=0 +lon_0=125 +k=0.99995 +x_0=500000 +y_0=0 +ellps=clrk66 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 25700, merc, bessel, "+proj=merc +lon_0=110 +k=0.997 +x_0=3900000 +y_0=900000 +ellps=bessel +towgs84=-587.8,519.75,145.76,0,0,0,0 +pm=jakarta +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 25828, utm, GRS80, "+proj=utm +zone=28 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 25829, utm, GRS80, "+proj=utm +zone=29 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 25830, utm, GRS80, "+proj=utm +zone=30 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 25831, utm, GRS80, "+proj=utm +zone=31 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 25832, utm, GRS80, "+proj=utm +zone=32 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 25833, utm, GRS80, "+proj=utm +zone=33 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 25834, utm, GRS80, "+proj=utm +zone=34 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 25835, utm, GRS80, "+proj=utm +zone=35 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 25836, utm, GRS80, "+proj=utm +zone=36 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 25837, utm, GRS80, "+proj=utm +zone=37 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 25838, utm, GRS80, "+proj=utm +zone=38 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 25884, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9996 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 25932, utm, intl, "+proj=utm +zone=32 +south +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 26191, lcc, 6378249.2, 6356515, "+proj=lcc +lat_1=33.3 +lat_0=33.3 +lon_0=-5.4 +k_0=0.999625769 +x_0=500000 +y_0=300000 +a=6378249.2 +b=6356515 +towgs84=31,146,47,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 26192, lcc, 6378249.2, 6356515, "+proj=lcc +lat_1=29.7 +lat_0=29.7 +lon_0=-5.4 +k_0=0.9996155960000001 +x_0=500000 +y_0=300000 +a=6378249.2 +b=6356515 +towgs84=31,146,47,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 26193, lcc, 6378249.2, 6356515, "+proj=lcc +lat_1=26.1 +lat_0=26.1 +lon_0=-5.4 +k_0=0.9996 +x_0=1200000 +y_0=400000 +a=6378249.2 +b=6356515 +towgs84=31,146,47,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 26194, lcc, 6378249.2, 6356515, "+proj=lcc +lat_1=26.1 +lat_0=26.1 +lon_0=-5.4 +k_0=0.999616304 +x_0=1200000 +y_0=400000 +a=6378249.2 +b=6356515 +towgs84=31,146,47,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 26195, lcc, 6378249.2, 6356515, "+proj=lcc +lat_1=22.5 +lat_0=22.5 +lon_0=-5.4 +k_0=0.999616437 +x_0=1500000 +y_0=400000 +a=6378249.2 +b=6356515 +towgs84=31,146,47,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26237, utm, bessel, "+proj=utm +zone=37 +ellps=bessel +towgs84=639,405,60,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26331, utm, clrk80, "+proj=utm +zone=31 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26332, utm, clrk80, "+proj=utm +zone=32 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26391, tmerc, clrk80, "+proj=tmerc +lat_0=4 +lon_0=4.5 +k=0.99975 +x_0=230738.26 +y_0=0 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26392, tmerc, clrk80, "+proj=tmerc +lat_0=4 +lon_0=8.5 +k=0.99975 +x_0=670553.98 +y_0=0 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26393, tmerc, clrk80, "+proj=tmerc +lat_0=4 +lon_0=12.5 +k=0.99975 +x_0=1110369.7 +y_0=0 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26432, utm, intl, "+proj=utm +zone=32 +south +ellps=intl +towgs84=-252.95,-4.11,-96.38,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26591, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=-3.45233333333333 +k=0.9996 +x_0=1500000 +y_0=0 +ellps=intl +pm=rome +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26592, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=2.54766666666666 +k=0.9996 +x_0=2520000 +y_0=0 +ellps=intl +pm=rome +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 26632, utm, 6378249.2, 6356515, "+proj=utm +zone=32 +a=6378249.2 +b=6356515 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 26692, utm, 6378249.2, 6356515, "+proj=utm +zone=32 +south +a=6378249.2 +b=6356515 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26701, utm, clrk66, NAD27, "+proj=utm +zone=1 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26702, utm, clrk66, NAD27, "+proj=utm +zone=2 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26703, utm, clrk66, NAD27, "+proj=utm +zone=3 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26704, utm, clrk66, NAD27, "+proj=utm +zone=4 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26705, utm, clrk66, NAD27, "+proj=utm +zone=5 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26706, utm, clrk66, NAD27, "+proj=utm +zone=6 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26707, utm, clrk66, NAD27, "+proj=utm +zone=7 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26708, utm, clrk66, NAD27, "+proj=utm +zone=8 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26709, utm, clrk66, NAD27, "+proj=utm +zone=9 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26710, utm, clrk66, NAD27, "+proj=utm +zone=10 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26711, utm, clrk66, NAD27, "+proj=utm +zone=11 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26712, utm, clrk66, NAD27, "+proj=utm +zone=12 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26713, utm, clrk66, NAD27, "+proj=utm +zone=13 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26714, utm, clrk66, NAD27, "+proj=utm +zone=14 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26715, utm, clrk66, NAD27, "+proj=utm +zone=15 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26716, utm, clrk66, NAD27, "+proj=utm +zone=16 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26717, utm, clrk66, NAD27, "+proj=utm +zone=17 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26718, utm, clrk66, NAD27, "+proj=utm +zone=18 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26719, utm, clrk66, NAD27, "+proj=utm +zone=19 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26720, utm, clrk66, NAD27, "+proj=utm +zone=20 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26721, utm, clrk66, NAD27, "+proj=utm +zone=21 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26722, utm, clrk66, NAD27, "+proj=utm +zone=22 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26729, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=30.5 +lon_0=-85.83333333333333 +k=0.99996 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26730, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=30 +lon_0=-87.5 +k=0.999933333 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26731, omerc, clrk66, NAD27, "+proj=omerc +lat_0=57 +lonc=-133.6666666666667 +alpha=323.1301023611111 +k=0.9999 +x_0=5000000.001016002 +y_0=-5000000.001016002 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26732, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=54 +lon_0=-142 +k=0.9999 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26733, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=54 +lon_0=-146 +k=0.9999 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26734, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=54 +lon_0=-150 +k=0.9999 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26735, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=54 +lon_0=-154 +k=0.9999 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26736, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=54 +lon_0=-158 +k=0.9999 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26737, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=54 +lon_0=-162 +k=0.9999 +x_0=213360.4267208534 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26738, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=54 +lon_0=-166 +k=0.9999 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26739, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=54 +lon_0=-170 +k=0.9999 +x_0=182880.3657607315 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26740, lcc, clrk66, NAD27, "+proj=lcc +lat_1=53.83333333333334 +lat_2=51.83333333333334 +lat_0=51 +lon_0=-176 +x_0=914401.8288036576 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26741, lcc, clrk66, NAD27, "+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.33333333333334 +lon_0=-122 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26742, lcc, clrk66, NAD27, "+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26743, lcc, clrk66, NAD27, "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666667 +lat_0=36.5 +lon_0=-120.5 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26744, lcc, clrk66, NAD27, "+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.33333333333334 +lon_0=-119 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26745, lcc, clrk66, NAD27, "+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333333 +lat_0=33.5 +lon_0=-118 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26746, lcc, clrk66, NAD27, "+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26747, lcc, clrk66, NAD27, "+proj=lcc +lat_1=34.41666666666666 +lat_2=33.86666666666667 +lat_0=34.13333333333333 +lon_0=-118.3333333333333 +x_0=1276106.450596901 +y_0=127079.524511049 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26748, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.9999 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26749, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.9999 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26750, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26751, lcc, clrk66, NAD27, "+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26752, lcc, clrk66, NAD27, "+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32.66666666666666 +lon_0=-92 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26753, lcc, clrk66, NAD27, "+proj=lcc +lat_1=39.71666666666667 +lat_2=40.78333333333333 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26754, lcc, clrk66, NAD27, "+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.83333333333334 +lon_0=-105.5 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26755, lcc, clrk66, NAD27, "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26756, lcc, clrk66, NAD27, "+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40.83333333333334 +lon_0=-72.75 +x_0=182880.3657607315 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26757, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999995 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26758, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999941177 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26759, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999941177 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26760, lcc, clrk66, NAD27, "+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=29 +lon_0=-84.5 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26766, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.9999 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26767, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.9999 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26768, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666666667 +k=0.9999473679999999 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26769, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.9999473679999999 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26770, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0.999933333 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26771, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333333333 +k=0.9999749999999999 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26772, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-90.16666666666667 +k=0.999941177 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26773, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.999966667 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26774, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.999966667 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26775, lcc, clrk66, NAD27, "+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666667 +lat_0=41.5 +lon_0=-93.5 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26776, lcc, clrk66, NAD27, "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.61666666666667 +lat_0=40 +lon_0=-93.5 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26777, lcc, clrk66, NAD27, "+proj=lcc +lat_1=39.78333333333333 +lat_2=38.71666666666667 +lat_0=38.33333333333334 +lon_0=-98 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26778, lcc, clrk66, NAD27, "+proj=lcc +lat_1=38.56666666666667 +lat_2=37.26666666666667 +lat_0=36.66666666666666 +lon_0=-98.5 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26779, lcc, clrk66, NAD27, "+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666667 +lat_0=37.5 +lon_0=-84.25 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26780, lcc, clrk66, NAD27, "+proj=lcc +lat_1=36.73333333333333 +lat_2=37.93333333333333 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26781, lcc, clrk66, NAD27, "+proj=lcc +lat_1=31.16666666666667 +lat_2=32.66666666666666 +lat_0=30.66666666666667 +lon_0=-92.5 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26782, lcc, clrk66, NAD27, "+proj=lcc +lat_1=29.3 +lat_2=30.7 +lat_0=28.66666666666667 +lon_0=-91.33333333333333 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26783, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=43.83333333333334 +lon_0=-68.5 +k=0.9999 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26784, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666666667 +k=0.999966667 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26785, lcc, clrk66, NAD27, "+proj=lcc +lat_1=38.3 +lat_2=39.45 +lat_0=37.83333333333334 +lon_0=-77 +x_0=243840.4876809754 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26786, lcc, clrk66, NAD27, "+proj=lcc +lat_1=41.71666666666667 +lat_2=42.68333333333333 +lat_0=41 +lon_0=-71.5 +x_0=182880.3657607315 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26787, lcc, clrk66, NAD27, "+proj=lcc +lat_1=41.28333333333333 +lat_2=41.48333333333333 +lat_0=41 +lon_0=-70.5 +x_0=60960.12192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26791, lcc, clrk66, NAD27, "+proj=lcc +lat_1=47.03333333333333 +lat_2=48.63333333333333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26792, lcc, clrk66, NAD27, "+proj=lcc +lat_1=45.61666666666667 +lat_2=47.05 +lat_0=45 +lon_0=-94.25 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26793, lcc, clrk66, NAD27, "+proj=lcc +lat_1=43.78333333333333 +lat_2=45.21666666666667 +lat_0=43 +lon_0=-94 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26794, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=29.66666666666667 +lon_0=-88.83333333333333 +k=0.99996 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26795, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=30.5 +lon_0=-90.33333333333333 +k=0.999941177 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26796, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=35.83333333333334 +lon_0=-90.5 +k=0.999933333 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26797, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=35.83333333333334 +lon_0=-92.5 +k=0.999933333 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26798, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=36.16666666666666 +lon_0=-94.5 +k=0.999941177 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26799, lcc, clrk66, NAD27, "+proj=lcc +lat_1=34.41666666666666 +lat_2=33.86666666666667 +lat_0=34.13333333333333 +lon_0=-118.3333333333333 +x_0=1276106.450596901 +y_0=1268253.006858014 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 26801, tmerc, 6378450.047548896, 6356826.621488444, "+proj=tmerc +lat_0=41.5 +lon_0=-83.66666666666667 +k=0.999942857 +x_0=152400.3048006096 +y_0=0 +a=6378450.047548896 +b=6356826.621488444 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 26802, tmerc, 6378450.047548896, 6356826.621488444, "+proj=tmerc +lat_0=41.5 +lon_0=-85.75 +k=0.999909091 +x_0=152400.3048006096 +y_0=0 +a=6378450.047548896 +b=6356826.621488444 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 26803, tmerc, 6378450.047548896, 6356826.621488444, "+proj=tmerc +lat_0=41.5 +lon_0=-88.75 +k=0.999909091 +x_0=152400.3048006096 +y_0=0 +a=6378450.047548896 +b=6356826.621488444 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 26811, lcc, 6378450.047548896, 6356826.621488444, "+proj=lcc +lat_1=45.48333333333333 +lat_2=47.08333333333334 +lat_0=44.78333333333333 +lon_0=-87 +x_0=609601.2192024384 +y_0=0 +a=6378450.047548896 +b=6356826.621488444 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 26812, lcc, 6378450.047548896, 6356826.621488444, "+proj=lcc +lat_1=44.18333333333333 +lat_2=45.7 +lat_0=43.31666666666667 +lon_0=-84.33333333333333 +x_0=609601.2192024384 +y_0=0 +a=6378450.047548896 +b=6356826.621488444 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 26813, lcc, 6378450.047548896, 6356826.621488444, "+proj=lcc +lat_1=42.1 +lat_2=43.66666666666666 +lat_0=41.5 +lon_0=-84.33333333333333 +x_0=609601.2192024384 +y_0=0 +a=6378450.047548896 +b=6356826.621488444 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26814, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9999 +x_0=300000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26815, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26819, lcc, GRS80, NAD83, "+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000.0000101601 +y_0=99999.99998984 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26820, lcc, GRS80, NAD83, "+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=45 +lon_0=-94.25 +x_0=800000.0000101601 +y_0=99999.99998984 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26821, lcc, GRS80, NAD83, "+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333333 +lat_0=43 +lon_0=-94 +x_0=800000.0000101601 +y_0=99999.99998984 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26822, lcc, GRS80, NAD83, "+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +lon_0=-100 +x_0=500000.0000101601 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26823, lcc, GRS80, NAD83, "+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.5 +x_0=1968500 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26824, lcc, GRS80, NAD83, "+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333333 +lat_0=37 +lon_0=-81 +x_0=1968500 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26825, tmerc, GRS80, "+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9999 +x_0=300000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26826, tmerc, GRS80, "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26830, lcc, GRS80, "+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000.0000101601 +y_0=99999.99998984 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26831, lcc, GRS80, "+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=45 +lon_0=-94.25 +x_0=800000.0000101601 +y_0=99999.99998984 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26832, lcc, GRS80, "+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333333 +lat_0=43 +lon_0=-94 +x_0=800000.0000101601 +y_0=99999.99998984 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26833, lcc, GRS80, "+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +lon_0=-100 +x_0=500000.0000101601 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26834, lcc, GRS80, "+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.5 +x_0=1968500 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26835, lcc, GRS80, "+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333333 +lat_0=37 +lon_0=-81 +x_0=1968500 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26836, tmerc, GRS80, "+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9999 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26837, tmerc, GRS80, "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26841, lcc, GRS80, "+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000.0000101601 +y_0=99999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26842, lcc, GRS80, "+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=45 +lon_0=-94.25 +x_0=800000.0000101601 +y_0=99999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26843, lcc, GRS80, "+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333333 +lat_0=43 +lon_0=-94 +x_0=800000.0000101601 +y_0=99999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26844, lcc, GRS80, "+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +lon_0=-100 +x_0=500000.0000101601 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26845, lcc, GRS80, "+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.5 +x_0=1968500 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26846, lcc, GRS80, "+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333333 +lat_0=37 +lon_0=-81 +x_0=1968500 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26847, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9999 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26848, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26849, lcc, GRS80, NAD83, "+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000.0000101599 +y_0=99999.99998983997 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26850, lcc, GRS80, NAD83, "+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=45 +lon_0=-94.25 +x_0=800000.0000101599 +y_0=99999.99998983997 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26851, lcc, GRS80, NAD83, "+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333333 +lat_0=43 +lon_0=-94 +x_0=800000.0000101599 +y_0=99999.99998983997 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26852, lcc, GRS80, NAD83, "+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +lon_0=-100 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26853, lcc, GRS80, NAD83, "+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.5 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26854, lcc, GRS80, NAD83, "+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333333 +lat_0=37 +lon_0=-81 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26855, tmerc, GRS80, "+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9999 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26856, tmerc, GRS80, "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26857, lcc, GRS80, "+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000.0000101599 +y_0=99999.99998983997 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26858, lcc, GRS80, "+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=45 +lon_0=-94.25 +x_0=800000.0000101599 +y_0=99999.99998983997 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26859, lcc, GRS80, "+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333333 +lat_0=43 +lon_0=-94 +x_0=800000.0000101599 +y_0=99999.99998983997 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26860, lcc, GRS80, "+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +lon_0=-100 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26861, lcc, GRS80, "+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.5 +x_0=600000 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26862, lcc, GRS80, "+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333333 +lat_0=37 +lon_0=-81 +x_0=600000 +y_0=0 +ellps=GRS80 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26863, tmerc, GRS80, "+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9999 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26864, tmerc, GRS80, "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26865, lcc, GRS80, "+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000.0000101599 +y_0=99999.99998983997 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26866, lcc, GRS80, "+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=45 +lon_0=-94.25 +x_0=800000.0000101599 +y_0=99999.99998983997 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26867, lcc, GRS80, "+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333333 +lat_0=43 +lon_0=-94 +x_0=800000.0000101599 +y_0=99999.99998983997 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26868, lcc, GRS80, "+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +lon_0=-100 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26869, lcc, GRS80, "+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26870, lcc, GRS80, "+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333333 +lat_0=37 +lon_0=-81 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26891, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-82.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26892, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-81 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26893, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-84 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26894, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-87 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26895, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-90 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26896, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-93 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26897, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-96 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26898, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-53 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 26899, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=-56 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26901, utm, GRS80, NAD83, "+proj=utm +zone=1 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26902, utm, GRS80, NAD83, "+proj=utm +zone=2 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26903, utm, GRS80, NAD83, "+proj=utm +zone=3 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26904, utm, GRS80, NAD83, "+proj=utm +zone=4 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26905, utm, GRS80, NAD83, "+proj=utm +zone=5 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26906, utm, GRS80, NAD83, "+proj=utm +zone=6 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26907, utm, GRS80, NAD83, "+proj=utm +zone=7 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26908, utm, GRS80, NAD83, "+proj=utm +zone=8 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26909, utm, GRS80, NAD83, "+proj=utm +zone=9 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26910, utm, GRS80, NAD83, "+proj=utm +zone=10 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26911, utm, GRS80, NAD83, "+proj=utm +zone=11 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26912, utm, GRS80, NAD83, "+proj=utm +zone=12 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26913, utm, GRS80, NAD83, "+proj=utm +zone=13 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26914, utm, GRS80, NAD83, "+proj=utm +zone=14 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26915, utm, GRS80, NAD83, "+proj=utm +zone=15 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26916, utm, GRS80, NAD83, "+proj=utm +zone=16 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26917, utm, GRS80, NAD83, "+proj=utm +zone=17 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26918, utm, GRS80, NAD83, "+proj=utm +zone=18 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26919, utm, GRS80, NAD83, "+proj=utm +zone=19 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26920, utm, GRS80, NAD83, "+proj=utm +zone=20 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26921, utm, GRS80, NAD83, "+proj=utm +zone=21 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26922, utm, GRS80, NAD83, "+proj=utm +zone=22 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26923, utm, GRS80, NAD83, "+proj=utm +zone=23 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26929, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=30.5 +lon_0=-85.83333333333333 +k=0.99996 +x_0=200000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26930, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=30 +lon_0=-87.5 +k=0.999933333 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26931, omerc, GRS80, NAD83, "+proj=omerc +lat_0=57 +lonc=-133.6666666666667 +alpha=323.1301023611111 +k=0.9999 +x_0=5000000 +y_0=-5000000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26932, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=54 +lon_0=-142 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26933, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=54 +lon_0=-146 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26934, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=54 +lon_0=-150 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26935, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=54 +lon_0=-154 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26936, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=54 +lon_0=-158 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26937, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=54 +lon_0=-162 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26938, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=54 +lon_0=-166 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26939, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=54 +lon_0=-170 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26940, lcc, GRS80, NAD83, "+proj=lcc +lat_1=53.83333333333334 +lat_2=51.83333333333334 +lat_0=51 +lon_0=-176 +x_0=1000000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26941, lcc, GRS80, NAD83, "+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.33333333333334 +lon_0=-122 +x_0=2000000 +y_0=500000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26942, lcc, GRS80, NAD83, "+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=2000000 +y_0=500000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26943, lcc, GRS80, NAD83, "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666667 +lat_0=36.5 +lon_0=-120.5 +x_0=2000000 +y_0=500000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26944, lcc, GRS80, NAD83, "+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.33333333333334 +lon_0=-119 +x_0=2000000 +y_0=500000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26945, lcc, GRS80, NAD83, "+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333333 +lat_0=33.5 +lon_0=-118 +x_0=2000000 +y_0=500000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26946, lcc, GRS80, NAD83, "+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=2000000 +y_0=500000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26948, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26949, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26950, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0=213360 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26951, lcc, GRS80, NAD83, "+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=400000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26952, lcc, GRS80, NAD83, "+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32.66666666666666 +lon_0=-92 +x_0=400000 +y_0=400000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26953, lcc, GRS80, NAD83, "+proj=lcc +lat_1=40.78333333333333 +lat_2=39.71666666666667 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=914401.8289 +y_0=304800.6096 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26954, lcc, GRS80, NAD83, "+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.83333333333334 +lon_0=-105.5 +x_0=914401.8289 +y_0=304800.6096 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26955, lcc, GRS80, NAD83, "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=914401.8289 +y_0=304800.6096 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26956, lcc, GRS80, NAD83, "+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40.83333333333334 +lon_0=-72.75 +x_0=304800.6096 +y_0=152400.3048 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26957, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999995 +x_0=200000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26958, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999941177 +x_0=200000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26959, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999941177 +x_0=200000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26960, lcc, GRS80, NAD83, "+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=29 +lon_0=-84.5 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26961, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=18.83333333333333 +lon_0=-155.5 +k=0.999966667 +x_0=500000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26962, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=20.33333333333333 +lon_0=-156.6666666666667 +k=0.999966667 +x_0=500000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26963, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=21.16666666666667 +lon_0=-158 +k=0.99999 +x_0=500000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26964, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=21.83333333333333 +lon_0=-159.5 +k=0.99999 +x_0=500000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26965, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=21.66666666666667 +lon_0=-160.1666666666667 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26966, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.9999 +x_0=200000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26967, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.9999 +x_0=700000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26968, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666666667 +k=0.9999473679999999 +x_0=200000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26969, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.9999473679999999 +x_0=500000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26970, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0.999933333 +x_0=800000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26971, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333333333 +k=0.9999749999999999 +x_0=300000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26972, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-90.16666666666667 +k=0.999941177 +x_0=700000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26973, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.999966667 +x_0=100000 +y_0=250000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26974, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.999966667 +x_0=900000 +y_0=250000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26975, lcc, GRS80, NAD83, "+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666667 +lat_0=41.5 +lon_0=-93.5 +x_0=1500000 +y_0=1000000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26976, lcc, GRS80, NAD83, "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.61666666666667 +lat_0=40 +lon_0=-93.5 +x_0=500000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26977, lcc, GRS80, NAD83, "+proj=lcc +lat_1=39.78333333333333 +lat_2=38.71666666666667 +lat_0=38.33333333333334 +lon_0=-98 +x_0=400000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26978, lcc, GRS80, NAD83, "+proj=lcc +lat_1=38.56666666666667 +lat_2=37.26666666666667 +lat_0=36.66666666666666 +lon_0=-98.5 +x_0=400000 +y_0=400000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26979, lcc, GRS80, NAD83, "+proj=lcc +lat_1=37.96666666666667 +lat_2=37.96666666666667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26980, lcc, GRS80, NAD83, "+proj=lcc +lat_1=37.93333333333333 +lat_2=36.73333333333333 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=500000 +y_0=500000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26981, lcc, GRS80, NAD83, "+proj=lcc +lat_1=32.66666666666666 +lat_2=31.16666666666667 +lat_0=30.5 +lon_0=-92.5 +x_0=1000000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26982, lcc, GRS80, NAD83, "+proj=lcc +lat_1=30.7 +lat_2=29.3 +lat_0=28.5 +lon_0=-91.33333333333333 +x_0=1000000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26983, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9999 +x_0=300000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26984, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26985, lcc, GRS80, NAD83, "+proj=lcc +lat_1=39.45 +lat_2=38.3 +lat_0=37.66666666666666 +lon_0=-77 +x_0=400000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26986, lcc, GRS80, NAD83, "+proj=lcc +lat_1=42.68333333333333 +lat_2=41.71666666666667 +lat_0=41 +lon_0=-71.5 +x_0=200000 +y_0=750000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26987, lcc, GRS80, NAD83, "+proj=lcc +lat_1=41.48333333333333 +lat_2=41.28333333333333 +lat_0=41 +lon_0=-70.5 +x_0=500000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26988, lcc, GRS80, NAD83, "+proj=lcc +lat_1=47.08333333333334 +lat_2=45.48333333333333 +lat_0=44.78333333333333 +lon_0=-87 +x_0=8000000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26989, lcc, GRS80, NAD83, "+proj=lcc +lat_1=45.7 +lat_2=44.18333333333333 +lat_0=43.31666666666667 +lon_0=-84.36666666666666 +x_0=6000000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26990, lcc, GRS80, NAD83, "+proj=lcc +lat_1=43.66666666666666 +lat_2=42.1 +lat_0=41.5 +lon_0=-84.36666666666666 +x_0=4000000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26991, lcc, GRS80, NAD83, "+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000 +y_0=100000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26992, lcc, GRS80, NAD83, "+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=45 +lon_0=-94.25 +x_0=800000 +y_0=100000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26993, lcc, GRS80, NAD83, "+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333333 +lat_0=43 +lon_0=-94 +x_0=800000 +y_0=100000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26994, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=29.5 +lon_0=-88.83333333333333 +k=0.99995 +x_0=300000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26995, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=29.5 +lon_0=-90.33333333333333 +k=0.99995 +x_0=700000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26996, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=35.83333333333334 +lon_0=-90.5 +k=0.999933333 +x_0=250000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26997, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=35.83333333333334 +lon_0=-92.5 +k=0.999933333 +x_0=500000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 26998, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=36.16666666666666 +lon_0=-94.5 +k=0.999941177 +x_0=850000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 27037, utm, clrk80, "+proj=utm +zone=37 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 27038, utm, clrk80, "+proj=utm +zone=38 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 27039, utm, clrk80, "+proj=utm +zone=39 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 27040, utm, clrk80, "+proj=utm +zone=40 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 27120, utm, intl, "+proj=utm +zone=20 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27200, nzmg, intl, nzgd49, "+proj=nzmg +lat_0=-41 +lon_0=173 +x_0=2510000 +y_0=6023150 +ellps=intl +datum=nzgd49 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27205, tmerc, intl, nzgd49, "+proj=tmerc +lat_0=-36.87986527777778 +lon_0=174.7643393611111 +k=0.9999 +x_0=300000 +y_0=700000 +ellps=intl +datum=nzgd49 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27206, tmerc, intl, nzgd49, "+proj=tmerc +lat_0=-37.76124980555556 +lon_0=176.46619725 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +datum=nzgd49 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27207, tmerc, intl, nzgd49, "+proj=tmerc +lat_0=-38.62470277777778 +lon_0=177.8856362777778 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +datum=nzgd49 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27208, tmerc, intl, nzgd49, "+proj=tmerc +lat_0=-39.65092930555556 +lon_0=176.6736805277778 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +datum=nzgd49 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27209, tmerc, intl, nzgd49, "+proj=tmerc +lat_0=-39.13575830555556 +lon_0=174.22801175 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +datum=nzgd49 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27210, tmerc, intl, nzgd49, "+proj=tmerc +lat_0=-39.51247038888889 +lon_0=175.6400368055556 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +datum=nzgd49 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27211, tmerc, intl, nzgd49, "+proj=tmerc +lat_0=-40.24194713888889 +lon_0=175.4880996111111 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +datum=nzgd49 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27212, tmerc, intl, nzgd49, "+proj=tmerc +lat_0=-40.92553263888889 +lon_0=175.6473496666667 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +datum=nzgd49 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27213, tmerc, intl, nzgd49, "+proj=tmerc +lat_0=-41.30131963888888 +lon_0=174.7766231111111 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +datum=nzgd49 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27214, tmerc, intl, nzgd49, "+proj=tmerc +lat_0=-40.71475905555556 +lon_0=172.6720465 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +datum=nzgd49 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27215, tmerc, intl, nzgd49, "+proj=tmerc +lat_0=-41.27454472222222 +lon_0=173.2993168055555 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +datum=nzgd49 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27216, tmerc, intl, nzgd49, "+proj=tmerc +lat_0=-41.28991152777778 +lon_0=172.1090281944444 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +datum=nzgd49 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27217, tmerc, intl, nzgd49, "+proj=tmerc +lat_0=-41.81080286111111 +lon_0=171.5812600555556 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +datum=nzgd49 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27218, tmerc, intl, nzgd49, "+proj=tmerc +lat_0=-42.33369427777778 +lon_0=171.5497713055556 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +datum=nzgd49 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27219, tmerc, intl, nzgd49, "+proj=tmerc +lat_0=-42.68911658333333 +lon_0=173.0101333888889 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +datum=nzgd49 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27220, tmerc, intl, nzgd49, "+proj=tmerc +lat_0=-41.54448666666666 +lon_0=173.8020741111111 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +datum=nzgd49 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27221, tmerc, intl, nzgd49, "+proj=tmerc +lat_0=-42.88632236111111 +lon_0=170.9799935 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +datum=nzgd49 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27222, tmerc, intl, nzgd49, "+proj=tmerc +lat_0=-43.11012813888889 +lon_0=170.2609258333333 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +datum=nzgd49 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27223, tmerc, intl, nzgd49, "+proj=tmerc +lat_0=-43.97780288888889 +lon_0=168.606267 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +datum=nzgd49 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27224, tmerc, intl, nzgd49, "+proj=tmerc +lat_0=-43.59063758333333 +lon_0=172.7271935833333 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +datum=nzgd49 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27225, tmerc, intl, nzgd49, "+proj=tmerc +lat_0=-43.74871155555556 +lon_0=171.3607484722222 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +datum=nzgd49 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27226, tmerc, intl, nzgd49, "+proj=tmerc +lat_0=-44.40222036111111 +lon_0=171.0572508333333 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +datum=nzgd49 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27227, tmerc, intl, nzgd49, "+proj=tmerc +lat_0=-44.73526797222222 +lon_0=169.4677550833333 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +datum=nzgd49 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27228, tmerc, intl, nzgd49, "+proj=tmerc +lat_0=-45.13290258333333 +lon_0=168.3986411944444 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +datum=nzgd49 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27229, tmerc, intl, nzgd49, "+proj=tmerc +lat_0=-45.56372616666666 +lon_0=167.7388617777778 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +datum=nzgd49 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27230, tmerc, intl, nzgd49, "+proj=tmerc +lat_0=-45.81619661111111 +lon_0=170.6285951666667 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +datum=nzgd49 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27231, tmerc, intl, nzgd49, "+proj=tmerc +lat_0=-45.86151336111111 +lon_0=170.2825891111111 +k=0.99996 +x_0=300000 +y_0=700000 +ellps=intl +datum=nzgd49 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27232, tmerc, intl, nzgd49, "+proj=tmerc +lat_0=-46.60000961111111 +lon_0=168.342872 +k=1 +x_0=300002.66 +y_0=699999.58 +ellps=intl +datum=nzgd49 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27258, utm, intl, nzgd49, "+proj=utm +zone=58 +south +ellps=intl +datum=nzgd49 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27259, utm, intl, nzgd49, "+proj=utm +zone=59 +south +ellps=intl +datum=nzgd49 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27260, utm, intl, nzgd49, "+proj=utm +zone=60 +south +ellps=intl +datum=nzgd49 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27291, tmerc, intl, nzgd49, "+proj=tmerc +lat_0=-39 +lon_0=175.5 +k=1 +x_0=274319.5243848086 +y_0=365759.3658464114 +ellps=intl +datum=nzgd49 +to_meter=0.9143984146160287 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27292, tmerc, intl, nzgd49, "+proj=tmerc +lat_0=-44 +lon_0=171.5 +k=1 +x_0=457199.2073080143 +y_0=457199.2073080143 +ellps=intl +datum=nzgd49 +to_meter=0.9143984146160287 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 27391, tmerc, 6377492.018, 6356173.508712696, "+proj=tmerc +lat_0=58 +lon_0=-4.666666666666667 +k=1 +x_0=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=278.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 27392, tmerc, 6377492.018, 6356173.508712696, "+proj=tmerc +lat_0=58 +lon_0=-2.333333333333333 +k=1 +x_0=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=278.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 27393, tmerc, 6377492.018, 6356173.508712696, "+proj=tmerc +lat_0=58 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=278.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 27394, tmerc, 6377492.018, 6356173.508712696, "+proj=tmerc +lat_0=58 +lon_0=2.5 +k=1 +x_0=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=278.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 27395, tmerc, 6377492.018, 6356173.508712696, "+proj=tmerc +lat_0=58 +lon_0=6.166666666666667 +k=1 +x_0=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=278.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 27396, tmerc, 6377492.018, 6356173.508712696, "+proj=tmerc +lat_0=58 +lon_0=10.16666666666667 +k=1 +x_0=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=278.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 27397, tmerc, 6377492.018, 6356173.508712696, "+proj=tmerc +lat_0=58 +lon_0=14.16666666666667 +k=1 +x_0=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=278.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 27398, tmerc, 6377492.018, 6356173.508712696, "+proj=tmerc +lat_0=58 +lon_0=18.33333333333333 +k=1 +x_0=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=278.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 27429, utm, intl, "+proj=utm +zone=29 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 27492, tmerc, intl, "+proj=tmerc +lat_0=39.66666666666666 +lon_0=-8.131906111111112 +k=1 +x_0=180.598 +y_0=-86.98999999999999 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 27493, tmerc, intl, "+proj=tmerc +lat_0=39.66666666666666 +lon_0=-8.131906111111112 +k=1 +x_0=180.598 +y_0=-86.98999999999999 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 27500, lcc, 6376523, 6355862.933255573, "+proj=lcc +lat_1=49.5 +lat_0=49.5 +lon_0=5.4 +k_0=0.99950908 +x_0=500000 +y_0=300000 +a=6376523 +b=6355862.933255573 +pm=2.3372291666985 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 27561, lcc, 6378249.2, 6356515, "+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 27562, lcc, 6378249.2, 6356515, "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.99987742 +x_0=600000 +y_0=200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 27563, lcc, 6378249.2, 6356515, "+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 27564, lcc, 6378249.2, 6356515, "+proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000001 +lon_0=0 +k_0=0.99994471 +x_0=234.358 +y_0=185861.369 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 27571, lcc, 6378249.2, 6356515, "+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=1200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 27572, lcc, 6378249.2, 6356515, "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.99987742 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 27573, lcc, 6378249.2, 6356515, "+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=3200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 27574, lcc, 6378249.2, 6356515, "+proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000001 +lon_0=0 +k_0=0.99994471 +x_0=234.358 +y_0=4185861.369 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 27581, lcc, 6378249.2, 6356515, "+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=1200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 27582, lcc, 6378249.2, 6356515, "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.99987742 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 27583, lcc, 6378249.2, 6356515, "+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=3200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 27584, lcc, 6378249.2, 6356515, "+proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000001 +lon_0=0 +k_0=0.99994471 +x_0=234.358 +y_0=4185861.369 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 27591, lcc, 6378249.2, 6356515, "+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 27592, lcc, 6378249.2, 6356515, "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.99987742 +x_0=600000 +y_0=200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 27593, lcc, 6378249.2, 6356515, "+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 27594, lcc, 6378249.2, 6356515, "+proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000001 +lon_0=0 +k_0=0.99994471 +x_0=234.358 +y_0=185861.369 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 27700, tmerc, airy, OSGB36, "+proj=tmerc +lat_0=49 +lon_0=-2 +k=0.9996012717 +x_0=400000 +y_0=-100000 +ellps=airy +datum=OSGB36 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 28191, cass, 6378300.789, 6356566.435, "+proj=cass +lat_0=31.73409694444445 +lon_0=35.21208055555556 +x_0=170251.555 +y_0=126867.909 +a=6378300.789 +b=6356566.435 +towgs84=-275.722,94.7824,340.894,-8.001,-4.42,-11.821,1 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 28192, tmerc, 6378300.789, 6356566.435, "+proj=tmerc +lat_0=31.73409694444445 +lon_0=35.21208055555556 +k=1 +x_0=170251.555 +y_0=1126867.909 +a=6378300.789 +b=6356566.435 +towgs84=-275.722,94.7824,340.894,-8.001,-4.42,-11.821,1 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 28193, cass, 6378300.789, 6356566.435, "+proj=cass +lat_0=31.73409694444445 +lon_0=35.21208055555556 +x_0=170251.555 +y_0=1126867.909 +a=6378300.789 +b=6356566.435 +towgs84=-275.722,94.7824,340.894,-8.001,-4.42,-11.821,1 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 28232, utm, 6378249.2, 6356515, "+proj=utm +zone=32 +south +a=6378249.2 +b=6356515 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28348, utm, GRS80, "+proj=utm +zone=48 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28349, utm, GRS80, "+proj=utm +zone=49 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28350, utm, GRS80, "+proj=utm +zone=50 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28351, utm, GRS80, "+proj=utm +zone=51 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28352, utm, GRS80, "+proj=utm +zone=52 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28353, utm, GRS80, "+proj=utm +zone=53 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28354, utm, GRS80, "+proj=utm +zone=54 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28355, utm, GRS80, "+proj=utm +zone=55 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28356, utm, GRS80, "+proj=utm +zone=56 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28357, utm, GRS80, "+proj=utm +zone=57 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28358, utm, GRS80, "+proj=utm +zone=58 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28402, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=2500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28403, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=3500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28404, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28405, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=5500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28406, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=6500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28407, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=7500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28408, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=8500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28409, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=9500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28410, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=10500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28411, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=11500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28412, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=12500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28413, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=13500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28414, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=14500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28415, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=15500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28416, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=16500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28417, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=17500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28418, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28419, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28420, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=20500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28421, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=21500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28422, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=22500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28423, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=23500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28424, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=24500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28425, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=25500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28426, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=26500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28427, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=27500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28428, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=28500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28429, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=29500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28430, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=30500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28431, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=31500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28432, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=32500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28462, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28463, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28464, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28465, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28466, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28467, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28468, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28469, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28470, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28471, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28472, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28473, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28474, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28475, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28476, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28477, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28478, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28479, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28480, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28481, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28482, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28483, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28484, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28485, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28486, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28487, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28488, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28489, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28490, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28491, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28492, tmerc, krass, "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28600, tmerc, intl, "+proj=tmerc +lat_0=24.45 +lon_0=51.21666666666667 +k=0.99999 +x_0=200000 +y_0=300000 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28991, sterea, bessel, "+proj=sterea +lat_0=52.15616055555555 +lon_0=5.38763888888889 +k=0.9999079 +x_0=0 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 28992, sterea, bessel, "+proj=sterea +lat_0=52.15616055555555 +lon_0=5.38763888888889 +k=0.9999079 +x_0=155000 +y_0=463000 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29100, poly, GRS67, "+proj=poly +lat_0=0 +lon_0=-54 +x_0=5000000 +y_0=10000000 +ellps=GRS67 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29101, poly, aust_SA, "+proj=poly +lat_0=0 +lon_0=-54 +x_0=5000000 +y_0=10000000 +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29118, utm, GRS67, "+proj=utm +zone=18 +ellps=GRS67 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29119, utm, GRS67, "+proj=utm +zone=19 +ellps=GRS67 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29120, utm, GRS67, "+proj=utm +zone=20 +ellps=GRS67 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29121, utm, GRS67, "+proj=utm +zone=21 +ellps=GRS67 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29122, utm, GRS67, "+proj=utm +zone=22 +ellps=GRS67 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29168, utm, aust_SA, "+proj=utm +zone=18 +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29169, utm, aust_SA, "+proj=utm +zone=19 +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29170, utm, aust_SA, "+proj=utm +zone=20 +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29171, utm, aust_SA, "+proj=utm +zone=21 +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29172, utm, aust_SA, "+proj=utm +zone=22 +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29177, utm, GRS67, "+proj=utm +zone=17 +south +ellps=GRS67 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29178, utm, GRS67, "+proj=utm +zone=18 +south +ellps=GRS67 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29179, utm, GRS67, "+proj=utm +zone=19 +south +ellps=GRS67 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29180, utm, GRS67, "+proj=utm +zone=20 +south +ellps=GRS67 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29181, utm, GRS67, "+proj=utm +zone=21 +south +ellps=GRS67 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29182, utm, GRS67, "+proj=utm +zone=22 +south +ellps=GRS67 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29183, utm, GRS67, "+proj=utm +zone=23 +south +ellps=GRS67 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29184, utm, GRS67, "+proj=utm +zone=24 +south +ellps=GRS67 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29185, utm, GRS67, "+proj=utm +zone=25 +south +ellps=GRS67 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29187, utm, aust_SA, "+proj=utm +zone=17 +south +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29188, utm, aust_SA, "+proj=utm +zone=18 +south +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29189, utm, aust_SA, "+proj=utm +zone=19 +south +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29190, utm, aust_SA, "+proj=utm +zone=20 +south +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29191, utm, aust_SA, "+proj=utm +zone=21 +south +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29192, utm, aust_SA, "+proj=utm +zone=22 +south +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29193, utm, aust_SA, "+proj=utm +zone=23 +south +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29194, utm, aust_SA, "+proj=utm +zone=24 +south +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29195, utm, aust_SA, "+proj=utm +zone=25 +south +ellps=aust_SA +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29220, utm, intl, "+proj=utm +zone=20 +south +ellps=intl +towgs84=-355,21,72,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29221, utm, intl, "+proj=utm +zone=21 +south +ellps=intl +towgs84=-355,21,72,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29333, utm, bess_nam, "+proj=utm +zone=33 +south +ellps=bess_nam +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 29371, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 29373, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 29375, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 29377, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 29379, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 29381, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 29383, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 29385, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 29635, utm, 6378249.2, 6356515, "+proj=utm +zone=35 +a=6378249.2 +b=6356515 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 29636, utm, 6378249.2, 6356515, "+proj=utm +zone=36 +a=6378249.2 +b=6356515 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29700, omerc, intl, "+proj=omerc +lat_0=-18.9 +lonc=44.10000000000001 +alpha=18.9 +k=0.9995000000000001 +x_0=400000 +y_0=800000 +ellps=intl +towgs84=-189,-242,-91,0,0,0,0 +pm=paris +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 29701, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29702, omerc, intl, "+proj=omerc +lat_0=-18.9 +lonc=44.10000000000001 +alpha=18.9 +k=0.9995000000000001 +x_0=400000 +y_0=800000 +ellps=intl +towgs84=-189,-242,-91,0,0,0,0 +pm=paris +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29738, utm, intl, "+proj=utm +zone=38 +south +ellps=intl +towgs84=-189,-242,-91,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29739, utm, intl, "+proj=utm +zone=39 +south +ellps=intl +towgs84=-189,-242,-91,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29849, utm, evrstSS, "+proj=utm +zone=49 +ellps=evrstSS +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29850, utm, evrstSS, "+proj=utm +zone=50 +ellps=evrstSS +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29871, omerc, evrstSS, "+proj=omerc +lat_0=4 +lonc=115 +alpha=53.31582047222222 +k=0.99984 +x_0=590476.8714630401 +y_0=442857.653094361 +ellps=evrstSS +to_meter=20.11676512155263 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29872, omerc, evrstSS, "+proj=omerc +lat_0=4 +lonc=115 +alpha=53.31582047222222 +k=0.99984 +x_0=590476.8727431979 +y_0=442857.6545573985 +ellps=evrstSS +to_meter=0.3047994715386762 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29873, omerc, evrstSS, "+proj=omerc +lat_0=4 +lonc=115 +alpha=53.31582047222222 +k=0.99984 +x_0=590476.87 +y_0=442857.65 +ellps=evrstSS +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 29900, tmerc, 6377340.189, 6356034.447938534, "+proj=tmerc +lat_0=53.5 +lon_0=-8 +k=1.000035 +x_0=200000 +y_0=250000 +a=6377340.189 +b=6356034.447938534 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 29901, tmerc, airy, "+proj=tmerc +lat_0=53.5 +lon_0=-8 +k=1 +x_0=200000 +y_0=250000 +ellps=airy +towgs84=482.5,-130.6,564.6,-1.042,-0.214,-0.631,8.15 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 29902, tmerc, 6377340.189, 6356034.447938534, "+proj=tmerc +lat_0=53.5 +lon_0=-8 +k=1.000035 +x_0=200000 +y_0=250000 +a=6377340.189 +b=6356034.447938534 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 29903, tmerc, 6377340.189, 6356034.447938534, "+proj=tmerc +lat_0=53.5 +lon_0=-8 +k=1.000035 +x_0=200000 +y_0=250000 +a=6377340.189 +b=6356034.447938534 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 30161, tmerc, bessel, "+proj=tmerc +lat_0=33 +lon_0=129.5 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 30162, tmerc, bessel, "+proj=tmerc +lat_0=33 +lon_0=131 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 30163, tmerc, bessel, "+proj=tmerc +lat_0=36 +lon_0=132.1666666666667 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 30164, tmerc, bessel, "+proj=tmerc +lat_0=33 +lon_0=133.5 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 30165, tmerc, bessel, "+proj=tmerc +lat_0=36 +lon_0=134.3333333333333 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 30166, tmerc, bessel, "+proj=tmerc +lat_0=36 +lon_0=136 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 30167, tmerc, bessel, "+proj=tmerc +lat_0=36 +lon_0=137.1666666666667 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 30168, tmerc, bessel, "+proj=tmerc +lat_0=36 +lon_0=138.5 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 30169, tmerc, bessel, "+proj=tmerc +lat_0=36 +lon_0=139.8333333333333 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 30170, tmerc, bessel, "+proj=tmerc +lat_0=40 +lon_0=140.8333333333333 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 30171, tmerc, bessel, "+proj=tmerc +lat_0=44 +lon_0=140.25 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 30172, tmerc, bessel, "+proj=tmerc +lat_0=44 +lon_0=142.25 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 30173, tmerc, bessel, "+proj=tmerc +lat_0=44 +lon_0=144.25 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 30174, tmerc, bessel, "+proj=tmerc +lat_0=26 +lon_0=142 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 30175, tmerc, bessel, "+proj=tmerc +lat_0=26 +lon_0=127.5 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 30176, tmerc, bessel, "+proj=tmerc +lat_0=26 +lon_0=124 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 30177, tmerc, bessel, "+proj=tmerc +lat_0=26 +lon_0=131 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 30178, tmerc, bessel, "+proj=tmerc +lat_0=20 +lon_0=136 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 30179, tmerc, bessel, "+proj=tmerc +lat_0=26 +lon_0=154 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 30200, cass, 6378293.645208759, 6356617.987679838, "+proj=cass +lat_0=10.44166666666667 +lon_0=-61.33333333333334 +x_0=86501.46392051999 +y_0=65379.0134283 +a=6378293.645208759 +b=6356617.987679838 +to_meter=0.201166195164 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 30339, utm, helmert, "+proj=utm +zone=39 +ellps=helmert +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 30340, utm, helmert, "+proj=utm +zone=40 +ellps=helmert +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 30491, lcc, 6378249.2, 6356515, "+proj=lcc +lat_1=36 +lat_0=36 +lon_0=2.7 +k_0=0.999625544 +x_0=500000 +y_0=300000 +a=6378249.2 +b=6356515 +towgs84=-73,-247,227,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 30492, lcc, 6378249.2, 6356515, "+proj=lcc +lat_1=33.3 +lat_0=33.3 +lon_0=2.7 +k_0=0.999625769 +x_0=500000 +y_0=300000 +a=6378249.2 +b=6356515 +towgs84=-73,-247,227,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 30493, lcc, 6378249.2, 6356515, "+proj=lcc +lat_1=36 +lat_0=36 +lon_0=2.7 +k_0=0.999625544 +x_0=500000 +y_0=300000 +a=6378249.2 +b=6356515 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 30494, lcc, 6378249.2, 6356515, "+proj=lcc +lat_1=33.3 +lat_0=33.3 +lon_0=2.7 +k_0=0.999625769 +x_0=500000 +y_0=300000 +a=6378249.2 +b=6356515 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 30729, utm, clrk80, "+proj=utm +zone=29 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 30730, utm, clrk80, "+proj=utm +zone=30 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 30731, utm, clrk80, "+proj=utm +zone=31 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 30732, utm, clrk80, "+proj=utm +zone=32 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 30791, lcc, clrk80, "+proj=lcc +lat_1=36 +lat_0=36 +lon_0=2.7 +k_0=0.999625544 +x_0=500135 +y_0=300090 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 30792, lcc, clrk80, "+proj=lcc +lat_1=33.3 +lat_0=33.3 +lon_0=2.7 +k_0=0.999625769 +x_0=500135 +y_0=300090 +ellps=clrk80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 30800, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=15.80827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 31028, utm, 6378249.2, 6356515, "+proj=utm +zone=28 +a=6378249.2 +b=6356515 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31121, utm, intl, "+proj=utm +zone=21 +ellps=intl +towgs84=-265,120,-358,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31154, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=-54 +k=0.9996 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-265,120,-358,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31170, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=-55.68333333333333 +k=0.9996 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-265,120,-358,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31171, tmerc, intl, "+proj=tmerc +lat_0=0 +lon_0=-55.68333333333333 +k=0.9999 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-265,120,-358,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31251, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=28 +k=1 +x_0=0 +y_0=-5000000 +ellps=bessel +pm=ferro +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31252, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=31 +k=1 +x_0=0 +y_0=-5000000 +ellps=bessel +pm=ferro +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31253, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=34 +k=1 +x_0=0 +y_0=-5000000 +ellps=bessel +pm=ferro +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31254, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=10.33333333333333 +k=1 +x_0=0 +y_0=-5000000 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31255, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=13.33333333333333 +k=1 +x_0=0 +y_0=-5000000 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31256, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=16.33333333333333 +k=1 +x_0=0 +y_0=-5000000 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31257, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=10.33333333333333 +k=1 +x_0=150000 +y_0=-5000000 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31258, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=13.33333333333333 +k=1 +x_0=450000 +y_0=-5000000 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31259, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=16.33333333333333 +k=1 +x_0=750000 +y_0=-5000000 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31265, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31266, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=6500000 +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31267, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=7500000 +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31268, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=8500000 +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31275, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9999 +x_0=5500000 +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31276, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=18 +k=0.9999 +x_0=6500000 +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31277, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=21 +k=0.9999 +x_0=7500000 +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31278, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=21 +k=0.9999 +x_0=7500000 +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31279, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9999 +x_0=8500000 +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31281, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=28 +k=1 +x_0=0 +y_0=0 +ellps=bessel +pm=ferro +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31282, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=31 +k=1 +x_0=0 +y_0=0 +ellps=bessel +pm=ferro +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31283, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=34 +k=1 +x_0=0 +y_0=0 +ellps=bessel +pm=ferro +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31284, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=10.33333333333333 +k=1 +x_0=150000 +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31285, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=13.33333333333333 +k=1 +x_0=450000 +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31286, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=16.33333333333333 +k=1 +x_0=750000 +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31287, lcc, bessel, "+proj=lcc +lat_1=49 +lat_2=46 +lat_0=47.5 +lon_0=13.33333333333333 +x_0=400000 +y_0=400000 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31288, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=28 +k=1 +x_0=150000 +y_0=0 +ellps=bessel +pm=ferro +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31289, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=31 +k=1 +x_0=450000 +y_0=0 +ellps=bessel +pm=ferro +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31290, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=34 +k=1 +x_0=750000 +y_0=0 +ellps=bessel +pm=ferro +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31291, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=28 +k=1 +x_0=0 +y_0=0 +ellps=bessel +pm=ferro +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31292, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=31 +k=1 +x_0=0 +y_0=0 +ellps=bessel +pm=ferro +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31293, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=34 +k=1 +x_0=0 +y_0=0 +ellps=bessel +pm=ferro +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31294, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=10.33333333333333 +k=1 +x_0=150000 +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31295, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=13.33333333333333 +k=1 +x_0=450000 +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31296, tmerc, bessel, "+proj=tmerc +lat_0=0 +lon_0=16.33333333333333 +k=1 +x_0=750000 +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31297, lcc, bessel, "+proj=lcc +lat_1=49 +lat_2=46 +lat_0=47.5 +lon_0=13.33333333333333 +x_0=400000 +y_0=400000 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 31300, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31370, lcc, intl, "+proj=lcc +lat_1=51.16666723333333 +lat_2=49.8333339 +lat_0=90 +lon_0=4.367486666666666 +x_0=150000.013 +y_0=5400088.438 +ellps=intl +towgs84=106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 31461, tmerc, bessel, potsdam, "+proj=tmerc +lat_0=0 +lon_0=3 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 31462, tmerc, bessel, potsdam, "+proj=tmerc +lat_0=0 +lon_0=6 +k=1 +x_0=2500000 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 31463, tmerc, bessel, potsdam, "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 31464, tmerc, bessel, potsdam, "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 31465, tmerc, bessel, potsdam, "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 31466, tmerc, bessel, potsdam, "+proj=tmerc +lat_0=0 +lon_0=6 +k=1 +x_0=2500000 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 31467, tmerc, bessel, potsdam, "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 31468, tmerc, bessel, potsdam, "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 31469, tmerc, bessel, potsdam, "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 31528, utm, 6378249.2, 6356515, "+proj=utm +zone=28 +a=6378249.2 +b=6356515 +towgs84=-23,259,-9,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 31529, utm, 6378249.2, 6356515, "+proj=utm +zone=29 +a=6378249.2 +b=6356515 +towgs84=-23,259,-9,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31600, sterea, intl, "+proj=sterea +lat_0=45.9 +lon_0=25.39246588888889 +k=0.9996667 +x_0=500000 +y_0=500000 +ellps=intl +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31700, sterea, krass, "+proj=sterea +lat_0=46 +lon_0=25 +k=0.99975 +x_0=500000 +y_0=500000 +ellps=krass +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31838, utm, WGS84, "+proj=utm +zone=38 +ellps=WGS84 +towgs84=-3.2,-5.7,2.8,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31839, utm, WGS84, "+proj=utm +zone=39 +ellps=WGS84 +towgs84=-3.2,-5.7,2.8,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31900, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=48 +k=0.9996 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31901, tmerc, GRS80, "+proj=tmerc +lat_0=0 +lon_0=48 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31965, utm, GRS80, "+proj=utm +zone=11 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31966, utm, GRS80, "+proj=utm +zone=12 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31967, utm, GRS80, "+proj=utm +zone=13 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31968, utm, GRS80, "+proj=utm +zone=14 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31969, utm, GRS80, "+proj=utm +zone=15 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31970, utm, GRS80, "+proj=utm +zone=16 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31971, utm, GRS80, "+proj=utm +zone=17 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31972, utm, GRS80, "+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31973, utm, GRS80, "+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31974, utm, GRS80, "+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31975, utm, GRS80, "+proj=utm +zone=21 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31976, utm, GRS80, "+proj=utm +zone=22 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31977, utm, GRS80, "+proj=utm +zone=17 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31978, utm, GRS80, "+proj=utm +zone=18 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31979, utm, GRS80, "+proj=utm +zone=19 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31980, utm, GRS80, "+proj=utm +zone=20 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31981, utm, GRS80, "+proj=utm +zone=21 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31982, utm, GRS80, "+proj=utm +zone=22 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31983, utm, GRS80, "+proj=utm +zone=23 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31984, utm, GRS80, "+proj=utm +zone=24 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31985, utm, GRS80, "+proj=utm +zone=25 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31986, utm, GRS80, "+proj=utm +zone=17 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31987, utm, GRS80, "+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31988, utm, GRS80, "+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31989, utm, GRS80, "+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31990, utm, GRS80, "+proj=utm +zone=21 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31991, utm, GRS80, "+proj=utm +zone=22 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31992, utm, GRS80, "+proj=utm +zone=17 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31993, utm, GRS80, "+proj=utm +zone=18 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31994, utm, GRS80, "+proj=utm +zone=19 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31995, utm, GRS80, "+proj=utm +zone=20 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31996, utm, GRS80, "+proj=utm +zone=21 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31997, utm, GRS80, "+proj=utm +zone=22 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31998, utm, GRS80, "+proj=utm +zone=23 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 31999, utm, GRS80, "+proj=utm +zone=24 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32000, utm, GRS80, "+proj=utm +zone=25 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32001, lcc, clrk66, NAD27, "+proj=lcc +lat_1=48.71666666666667 +lat_2=47.85 +lat_0=47 +lon_0=-109.5 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32002, lcc, clrk66, NAD27, "+proj=lcc +lat_1=47.88333333333333 +lat_2=46.45 +lat_0=45.83333333333334 +lon_0=-109.5 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32003, lcc, clrk66, NAD27, "+proj=lcc +lat_1=46.4 +lat_2=44.86666666666667 +lat_0=44 +lon_0=-109.5 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32005, lcc, clrk66, NAD27, "+proj=lcc +lat_1=41.85 +lat_2=42.81666666666667 +lat_0=41.33333333333334 +lon_0=-100 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32006, lcc, clrk66, NAD27, "+proj=lcc +lat_1=40.28333333333333 +lat_2=41.71666666666667 +lat_0=39.66666666666666 +lon_0=-99.5 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32007, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=34.75 +lon_0=-115.5833333333333 +k=0.9999 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32008, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=34.75 +lon_0=-116.6666666666667 +k=0.9999 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32009, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=34.75 +lon_0=-118.5833333333333 +k=0.9999 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32010, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=42.5 +lon_0=-71.66666666666667 +k=0.999966667 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32011, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.66666666666667 +k=0.9999749999999999 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32012, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=31 +lon_0=-104.3333333333333 +k=0.999909091 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32013, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=31 +lon_0=-106.25 +k=0.9999 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32014, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=31 +lon_0=-107.8333333333333 +k=0.999916667 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32015, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=40 +lon_0=-74.33333333333333 +k=0.999966667 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32016, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=40 +lon_0=-76.58333333333333 +k=0.9999375 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32017, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=40 +lon_0=-78.58333333333333 +k=0.9999375 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32018, lcc, clrk66, NAD27, "+proj=lcc +lat_1=41.03333333333333 +lat_2=40.66666666666666 +lat_0=40.5 +lon_0=-74 +x_0=304800.6096012192 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32019, lcc, clrk66, NAD27, "+proj=lcc +lat_1=34.33333333333334 +lat_2=36.16666666666666 +lat_0=33.75 +lon_0=-79 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32020, lcc, clrk66, NAD27, "+proj=lcc +lat_1=47.43333333333333 +lat_2=48.73333333333333 +lat_0=47 +lon_0=-100.5 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32021, lcc, clrk66, NAD27, "+proj=lcc +lat_1=46.18333333333333 +lat_2=47.48333333333333 +lat_0=45.66666666666666 +lon_0=-100.5 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32022, lcc, clrk66, NAD27, "+proj=lcc +lat_1=40.43333333333333 +lat_2=41.7 +lat_0=39.66666666666666 +lon_0=-82.5 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32023, lcc, clrk66, NAD27, "+proj=lcc +lat_1=38.73333333333333 +lat_2=40.03333333333333 +lat_0=38 +lon_0=-82.5 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32024, lcc, clrk66, NAD27, "+proj=lcc +lat_1=35.56666666666667 +lat_2=36.76666666666667 +lat_0=35 +lon_0=-98 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32025, lcc, clrk66, NAD27, "+proj=lcc +lat_1=33.93333333333333 +lat_2=35.23333333333333 +lat_0=33.33333333333334 +lon_0=-98 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32026, lcc, clrk66, NAD27, "+proj=lcc +lat_1=44.33333333333334 +lat_2=46 +lat_0=43.66666666666666 +lon_0=-120.5 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32027, lcc, clrk66, NAD27, "+proj=lcc +lat_1=42.33333333333334 +lat_2=44 +lat_0=41.66666666666666 +lon_0=-120.5 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32028, lcc, clrk66, NAD27, "+proj=lcc +lat_1=40.88333333333333 +lat_2=41.95 +lat_0=40.16666666666666 +lon_0=-77.75 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32029, lcc, clrk66, NAD27, "+proj=lcc +lat_1=39.93333333333333 +lat_2=40.8 +lat_0=39.33333333333334 +lon_0=-77.75 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32030, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=41.08333333333334 +lon_0=-71.5 +k=0.9999938 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32031, lcc, clrk66, NAD27, "+proj=lcc +lat_1=33.76666666666667 +lat_2=34.96666666666667 +lat_0=33 +lon_0=-81 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32033, lcc, clrk66, NAD27, "+proj=lcc +lat_1=32.33333333333334 +lat_2=33.66666666666666 +lat_0=31.83333333333333 +lon_0=-81 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32034, lcc, clrk66, NAD27, "+proj=lcc +lat_1=44.41666666666666 +lat_2=45.68333333333333 +lat_0=43.83333333333334 +lon_0=-100 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32035, lcc, clrk66, NAD27, "+proj=lcc +lat_1=42.83333333333334 +lat_2=44.4 +lat_0=42.33333333333334 +lon_0=-100.3333333333333 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32036, lcc, clrk66, NAD27, "+proj=lcc +lat_1=35.25 +lat_2=36.41666666666666 +lat_0=34.66666666666666 +lon_0=-86 +x_0=30480.06096012192 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32037, lcc, clrk66, NAD27, "+proj=lcc +lat_1=34.65 +lat_2=36.18333333333333 +lat_0=34 +lon_0=-101.5 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32038, lcc, clrk66, NAD27, "+proj=lcc +lat_1=32.13333333333333 +lat_2=33.96666666666667 +lat_0=31.66666666666667 +lon_0=-97.5 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32039, lcc, clrk66, NAD27, "+proj=lcc +lat_1=30.11666666666667 +lat_2=31.88333333333333 +lat_0=29.66666666666667 +lon_0=-100.3333333333333 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32040, lcc, clrk66, NAD27, "+proj=lcc +lat_1=28.38333333333333 +lat_2=30.28333333333333 +lat_0=27.83333333333333 +lon_0=-99 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32041, lcc, clrk66, NAD27, "+proj=lcc +lat_1=26.16666666666667 +lat_2=27.83333333333333 +lat_0=25.66666666666667 +lon_0=-98.5 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32042, lcc, clrk66, NAD27, "+proj=lcc +lat_1=40.71666666666667 +lat_2=41.78333333333333 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32043, lcc, clrk66, NAD27, "+proj=lcc +lat_1=39.01666666666667 +lat_2=40.65 +lat_0=38.33333333333334 +lon_0=-111.5 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32044, lcc, clrk66, NAD27, "+proj=lcc +lat_1=37.21666666666667 +lat_2=38.35 +lat_0=36.66666666666666 +lon_0=-111.5 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32045, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=42.5 +lon_0=-72.5 +k=0.999964286 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32046, lcc, clrk66, NAD27, "+proj=lcc +lat_1=38.03333333333333 +lat_2=39.2 +lat_0=37.66666666666666 +lon_0=-78.5 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32047, lcc, clrk66, NAD27, "+proj=lcc +lat_1=36.76666666666667 +lat_2=37.96666666666667 +lat_0=36.33333333333334 +lon_0=-78.5 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32048, lcc, clrk66, NAD27, "+proj=lcc +lat_1=47.5 +lat_2=48.73333333333333 +lat_0=47 +lon_0=-120.8333333333333 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32049, lcc, clrk66, NAD27, "+proj=lcc +lat_1=45.83333333333334 +lat_2=47.33333333333334 +lat_0=45.33333333333334 +lon_0=-120.5 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32050, lcc, clrk66, NAD27, "+proj=lcc +lat_1=39 +lat_2=40.25 +lat_0=38.5 +lon_0=-79.5 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32051, lcc, clrk66, NAD27, "+proj=lcc +lat_1=37.48333333333333 +lat_2=38.88333333333333 +lat_0=37 +lon_0=-81 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32052, lcc, clrk66, NAD27, "+proj=lcc +lat_1=45.56666666666667 +lat_2=46.76666666666667 +lat_0=45.16666666666666 +lon_0=-90 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32053, lcc, clrk66, NAD27, "+proj=lcc +lat_1=44.25 +lat_2=45.5 +lat_0=43.83333333333334 +lon_0=-90 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32054, lcc, clrk66, NAD27, "+proj=lcc +lat_1=42.73333333333333 +lat_2=44.06666666666667 +lat_0=42 +lon_0=-90 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32055, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=40.66666666666666 +lon_0=-105.1666666666667 +k=0.999941177 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32056, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=40.66666666666666 +lon_0=-107.3333333333333 +k=0.999941177 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32057, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=40.66666666666666 +lon_0=-108.75 +k=0.999941177 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32058, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=40.66666666666666 +lon_0=-110.0833333333333 +k=0.999941177 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32061, lcc, clrk66, NAD27, "+proj=lcc +lat_1=16.81666666666667 +lat_0=16.81666666666667 +lon_0=-90.33333333333333 +k_0=0.99992226 +x_0=500000 +y_0=292209.579 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32062, lcc, clrk66, NAD27, "+proj=lcc +lat_1=14.9 +lat_0=14.9 +lon_0=-90.33333333333333 +k_0=0.99989906 +x_0=500000 +y_0=325992.681 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32064, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=0 +lon_0=-99 +k=0.9996 +x_0=500000.001016002 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32065, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=0 +lon_0=-93 +k=0.9996 +x_0=500000.001016002 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32066, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=0 +lon_0=-87 +k=0.9996 +x_0=500000.001016002 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32067, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=0 +lon_0=-81 +k=0.9996 +x_0=500000.001016002 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32074, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=0 +lon_0=-99 +k=0.9996 +x_0=500000.001016002 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32075, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=0 +lon_0=-93 +k=0.9996 +x_0=500000.001016002 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32076, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=0 +lon_0=-87 +k=0.9996 +x_0=500000.001016002 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32077, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=0 +lon_0=-81 +k=0.9996 +x_0=500000.001016002 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32081, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=0 +lon_0=-53 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32082, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=0 +lon_0=-56 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32083, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=0 +lon_0=-58.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32084, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=0 +lon_0=-61.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32085, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=0 +lon_0=-64.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32086, tmerc, clrk66, NAD27, "+proj=tmerc +lat_0=0 +lon_0=-67.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32098, lcc, clrk66, NAD27, "+proj=lcc +lat_1=60 +lat_2=46 +lat_0=44 +lon_0=-68.5 +x_0=0 +y_0=0 +ellps=clrk66 +datum=NAD27 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32099, lcc, clrk66, NAD27, "+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666667 +lat_0=25.66666666666667 +lon_0=-91.33333333333333 +x_0=609601.2192024384 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32100, lcc, GRS80, NAD83, "+proj=lcc +lat_1=49 +lat_2=45 +lat_0=44.25 +lon_0=-109.5 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32104, lcc, GRS80, NAD83, "+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +lon_0=-100 +x_0=500000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32107, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=34.75 +lon_0=-115.5833333333333 +k=0.9999 +x_0=200000 +y_0=8000000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32108, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=34.75 +lon_0=-116.6666666666667 +k=0.9999 +x_0=500000 +y_0=6000000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32109, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=34.75 +lon_0=-118.5833333333333 +k=0.9999 +x_0=800000 +y_0=4000000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32110, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=42.5 +lon_0=-71.66666666666667 +k=0.999966667 +x_0=300000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32111, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32112, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=31 +lon_0=-104.3333333333333 +k=0.999909091 +x_0=165000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32113, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=31 +lon_0=-106.25 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32114, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=31 +lon_0=-107.8333333333333 +k=0.999916667 +x_0=830000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32115, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32116, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=40 +lon_0=-76.58333333333333 +k=0.9999375 +x_0=250000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32117, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=40 +lon_0=-78.58333333333333 +k=0.9999375 +x_0=350000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32118, lcc, GRS80, NAD83, "+proj=lcc +lat_1=41.03333333333333 +lat_2=40.66666666666666 +lat_0=40.16666666666666 +lon_0=-74 +x_0=300000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32119, lcc, GRS80, NAD83, "+proj=lcc +lat_1=36.16666666666666 +lat_2=34.33333333333334 +lat_0=33.75 +lon_0=-79 +x_0=609601.22 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32120, lcc, GRS80, NAD83, "+proj=lcc +lat_1=48.73333333333333 +lat_2=47.43333333333333 +lat_0=47 +lon_0=-100.5 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32121, lcc, GRS80, NAD83, "+proj=lcc +lat_1=47.48333333333333 +lat_2=46.18333333333333 +lat_0=45.66666666666666 +lon_0=-100.5 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32122, lcc, GRS80, NAD83, "+proj=lcc +lat_1=41.7 +lat_2=40.43333333333333 +lat_0=39.66666666666666 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32123, lcc, GRS80, NAD83, "+proj=lcc +lat_1=40.03333333333333 +lat_2=38.73333333333333 +lat_0=38 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32124, lcc, GRS80, NAD83, "+proj=lcc +lat_1=36.76666666666667 +lat_2=35.56666666666667 +lat_0=35 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32125, lcc, GRS80, NAD83, "+proj=lcc +lat_1=35.23333333333333 +lat_2=33.93333333333333 +lat_0=33.33333333333334 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32126, lcc, GRS80, NAD83, "+proj=lcc +lat_1=46 +lat_2=44.33333333333334 +lat_0=43.66666666666666 +lon_0=-120.5 +x_0=2500000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32127, lcc, GRS80, NAD83, "+proj=lcc +lat_1=44 +lat_2=42.33333333333334 +lat_0=41.66666666666666 +lon_0=-120.5 +x_0=1500000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32128, lcc, GRS80, NAD83, "+proj=lcc +lat_1=41.95 +lat_2=40.88333333333333 +lat_0=40.16666666666666 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32129, lcc, GRS80, NAD83, "+proj=lcc +lat_1=40.96666666666667 +lat_2=39.93333333333333 +lat_0=39.33333333333334 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32130, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=41.08333333333334 +lon_0=-71.5 +k=0.99999375 +x_0=100000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32133, lcc, GRS80, NAD83, "+proj=lcc +lat_1=34.83333333333334 +lat_2=32.5 +lat_0=31.83333333333333 +lon_0=-81 +x_0=609600 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32134, lcc, GRS80, NAD83, "+proj=lcc +lat_1=45.68333333333333 +lat_2=44.41666666666666 +lat_0=43.83333333333334 +lon_0=-100 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32135, lcc, GRS80, NAD83, "+proj=lcc +lat_1=44.4 +lat_2=42.83333333333334 +lat_0=42.33333333333334 +lon_0=-100.3333333333333 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32136, lcc, GRS80, NAD83, "+proj=lcc +lat_1=36.41666666666666 +lat_2=35.25 +lat_0=34.33333333333334 +lon_0=-86 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32137, lcc, GRS80, NAD83, "+proj=lcc +lat_1=36.18333333333333 +lat_2=34.65 +lat_0=34 +lon_0=-101.5 +x_0=200000 +y_0=1000000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32138, lcc, GRS80, NAD83, "+proj=lcc +lat_1=33.96666666666667 +lat_2=32.13333333333333 +lat_0=31.66666666666667 +lon_0=-98.5 +x_0=600000 +y_0=2000000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32139, lcc, GRS80, NAD83, "+proj=lcc +lat_1=31.88333333333333 +lat_2=30.11666666666667 +lat_0=29.66666666666667 +lon_0=-100.3333333333333 +x_0=700000 +y_0=3000000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32140, lcc, GRS80, NAD83, "+proj=lcc +lat_1=30.28333333333333 +lat_2=28.38333333333333 +lat_0=27.83333333333333 +lon_0=-99 +x_0=600000 +y_0=4000000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32141, lcc, GRS80, NAD83, "+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666667 +lat_0=25.66666666666667 +lon_0=-98.5 +x_0=300000 +y_0=5000000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32142, lcc, GRS80, NAD83, "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000 +y_0=1000000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32143, lcc, GRS80, NAD83, "+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=38.33333333333334 +lon_0=-111.5 +x_0=500000 +y_0=2000000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32144, lcc, GRS80, NAD83, "+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=36.66666666666666 +lon_0=-111.5 +x_0=500000 +y_0=3000000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32145, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=42.5 +lon_0=-72.5 +k=0.999964286 +x_0=500000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32146, lcc, GRS80, NAD83, "+proj=lcc +lat_1=39.2 +lat_2=38.03333333333333 +lat_0=37.66666666666666 +lon_0=-78.5 +x_0=3500000 +y_0=2000000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32147, lcc, GRS80, NAD83, "+proj=lcc +lat_1=37.96666666666667 +lat_2=36.76666666666667 +lat_0=36.33333333333334 +lon_0=-78.5 +x_0=3500000 +y_0=1000000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32148, lcc, GRS80, NAD83, "+proj=lcc +lat_1=48.73333333333333 +lat_2=47.5 +lat_0=47 +lon_0=-120.8333333333333 +x_0=500000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32149, lcc, GRS80, NAD83, "+proj=lcc +lat_1=47.33333333333334 +lat_2=45.83333333333334 +lat_0=45.33333333333334 +lon_0=-120.5 +x_0=500000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32150, lcc, GRS80, NAD83, "+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.5 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32151, lcc, GRS80, NAD83, "+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333333 +lat_0=37 +lon_0=-81 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32152, lcc, GRS80, NAD83, "+proj=lcc +lat_1=46.76666666666667 +lat_2=45.56666666666667 +lat_0=45.16666666666666 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32153, lcc, GRS80, NAD83, "+proj=lcc +lat_1=45.5 +lat_2=44.25 +lat_0=43.83333333333334 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32154, lcc, GRS80, NAD83, "+proj=lcc +lat_1=44.06666666666667 +lat_2=42.73333333333333 +lat_0=42 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32155, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=40.5 +lon_0=-105.1666666666667 +k=0.9999375 +x_0=200000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32156, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=40.5 +lon_0=-107.3333333333333 +k=0.9999375 +x_0=400000 +y_0=100000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32157, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=40.5 +lon_0=-108.75 +k=0.9999375 +x_0=600000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32158, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=40.5 +lon_0=-110.0833333333333 +k=0.9999375 +x_0=800000 +y_0=100000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32161, lcc, GRS80, NAD83, "+proj=lcc +lat_1=18.43333333333333 +lat_2=18.03333333333333 +lat_0=17.83333333333333 +lon_0=-66.43333333333334 +x_0=200000 +y_0=200000 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32164, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=0 +lon_0=-99 +k=0.9996 +x_0=500000.001016002 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32165, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=0 +lon_0=-93 +k=0.9996 +x_0=500000.001016002 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32166, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=0 +lon_0=-87 +k=0.9996 +x_0=500000.001016002 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32167, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=0 +lon_0=-81 +k=0.9996 +x_0=500000.001016002 +y_0=0 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32180, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=0 +lon_0=-55.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32181, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=0 +lon_0=-53 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32182, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=0 +lon_0=-56 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32183, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=0 +lon_0=-58.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32184, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=0 +lon_0=-61.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32185, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=0 +lon_0=-64.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32186, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=0 +lon_0=-67.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32187, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=0 +lon_0=-70.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32188, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=0 +lon_0=-73.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32189, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=0 +lon_0=-76.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32190, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=0 +lon_0=-79.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32191, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=0 +lon_0=-82.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32192, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=0 +lon_0=-81 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32193, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=0 +lon_0=-84 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32194, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=0 +lon_0=-87 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32195, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=0 +lon_0=-90 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32196, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=0 +lon_0=-93 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32197, tmerc, GRS80, NAD83, "+proj=tmerc +lat_0=0 +lon_0=-96 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32198, lcc, GRS80, NAD83, "+proj=lcc +lat_1=60 +lat_2=46 +lat_0=44 +lon_0=-68.5 +x_0=0 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32199, lcc, GRS80, NAD83, "+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666667 +lat_0=25.5 +lon_0=-91.33333333333333 +x_0=1000000 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32201, utm, WGS72, "+proj=utm +zone=1 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32202, utm, WGS72, "+proj=utm +zone=2 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32203, utm, WGS72, "+proj=utm +zone=3 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32204, utm, WGS72, "+proj=utm +zone=4 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32205, utm, WGS72, "+proj=utm +zone=5 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32206, utm, WGS72, "+proj=utm +zone=6 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32207, utm, WGS72, "+proj=utm +zone=7 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32208, utm, WGS72, "+proj=utm +zone=8 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32209, utm, WGS72, "+proj=utm +zone=9 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32210, utm, WGS72, "+proj=utm +zone=10 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32211, utm, WGS72, "+proj=utm +zone=11 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32212, utm, WGS72, "+proj=utm +zone=12 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32213, utm, WGS72, "+proj=utm +zone=13 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32214, utm, WGS72, "+proj=utm +zone=14 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32215, utm, WGS72, "+proj=utm +zone=15 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32216, utm, WGS72, "+proj=utm +zone=16 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32217, utm, WGS72, "+proj=utm +zone=17 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32218, utm, WGS72, "+proj=utm +zone=18 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32219, utm, WGS72, "+proj=utm +zone=19 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32220, utm, WGS72, "+proj=utm +zone=20 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32221, utm, WGS72, "+proj=utm +zone=21 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32222, utm, WGS72, "+proj=utm +zone=22 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32223, utm, WGS72, "+proj=utm +zone=23 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32224, utm, WGS72, "+proj=utm +zone=24 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32225, utm, WGS72, "+proj=utm +zone=25 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32226, utm, WGS72, "+proj=utm +zone=26 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32227, utm, WGS72, "+proj=utm +zone=27 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32228, utm, WGS72, "+proj=utm +zone=28 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32229, utm, WGS72, "+proj=utm +zone=29 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32230, utm, WGS72, "+proj=utm +zone=30 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32231, utm, WGS72, "+proj=utm +zone=31 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32232, utm, WGS72, "+proj=utm +zone=32 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32233, utm, WGS72, "+proj=utm +zone=33 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32234, utm, WGS72, "+proj=utm +zone=34 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32235, utm, WGS72, "+proj=utm +zone=35 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32236, utm, WGS72, "+proj=utm +zone=36 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32237, utm, WGS72, "+proj=utm +zone=37 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32238, utm, WGS72, "+proj=utm +zone=38 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32239, utm, WGS72, "+proj=utm +zone=39 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32240, utm, WGS72, "+proj=utm +zone=40 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32241, utm, WGS72, "+proj=utm +zone=41 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32242, utm, WGS72, "+proj=utm +zone=42 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32243, utm, WGS72, "+proj=utm +zone=43 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32244, utm, WGS72, "+proj=utm +zone=44 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32245, utm, WGS72, "+proj=utm +zone=45 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32246, utm, WGS72, "+proj=utm +zone=46 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32247, utm, WGS72, "+proj=utm +zone=47 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32248, utm, WGS72, "+proj=utm +zone=48 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32249, utm, WGS72, "+proj=utm +zone=49 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32250, utm, WGS72, "+proj=utm +zone=50 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32251, utm, WGS72, "+proj=utm +zone=51 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32252, utm, WGS72, "+proj=utm +zone=52 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32253, utm, WGS72, "+proj=utm +zone=53 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32254, utm, WGS72, "+proj=utm +zone=54 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32255, utm, WGS72, "+proj=utm +zone=55 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32256, utm, WGS72, "+proj=utm +zone=56 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32257, utm, WGS72, "+proj=utm +zone=57 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32258, utm, WGS72, "+proj=utm +zone=58 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32259, utm, WGS72, "+proj=utm +zone=59 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32260, utm, WGS72, "+proj=utm +zone=60 +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32301, utm, WGS72, "+proj=utm +zone=1 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32302, utm, WGS72, "+proj=utm +zone=2 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32303, utm, WGS72, "+proj=utm +zone=3 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32304, utm, WGS72, "+proj=utm +zone=4 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32305, utm, WGS72, "+proj=utm +zone=5 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32306, utm, WGS72, "+proj=utm +zone=6 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32307, utm, WGS72, "+proj=utm +zone=7 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32308, utm, WGS72, "+proj=utm +zone=8 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32309, utm, WGS72, "+proj=utm +zone=9 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32310, utm, WGS72, "+proj=utm +zone=10 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32311, utm, WGS72, "+proj=utm +zone=11 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32312, utm, WGS72, "+proj=utm +zone=12 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32313, utm, WGS72, "+proj=utm +zone=13 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32314, utm, WGS72, "+proj=utm +zone=14 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32315, utm, WGS72, "+proj=utm +zone=15 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32316, utm, WGS72, "+proj=utm +zone=16 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32317, utm, WGS72, "+proj=utm +zone=17 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32318, utm, WGS72, "+proj=utm +zone=18 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32319, utm, WGS72, "+proj=utm +zone=19 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32320, utm, WGS72, "+proj=utm +zone=20 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32321, utm, WGS72, "+proj=utm +zone=21 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32322, utm, WGS72, "+proj=utm +zone=22 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32323, utm, WGS72, "+proj=utm +zone=23 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32324, utm, WGS72, "+proj=utm +zone=24 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32325, utm, WGS72, "+proj=utm +zone=25 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32326, utm, WGS72, "+proj=utm +zone=26 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32327, utm, WGS72, "+proj=utm +zone=27 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32328, utm, WGS72, "+proj=utm +zone=28 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32329, utm, WGS72, "+proj=utm +zone=29 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32330, utm, WGS72, "+proj=utm +zone=30 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32331, utm, WGS72, "+proj=utm +zone=31 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32332, utm, WGS72, "+proj=utm +zone=32 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32333, utm, WGS72, "+proj=utm +zone=33 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32334, utm, WGS72, "+proj=utm +zone=34 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32335, utm, WGS72, "+proj=utm +zone=35 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32336, utm, WGS72, "+proj=utm +zone=36 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32337, utm, WGS72, "+proj=utm +zone=37 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32338, utm, WGS72, "+proj=utm +zone=38 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32339, utm, WGS72, "+proj=utm +zone=39 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32340, utm, WGS72, "+proj=utm +zone=40 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32341, utm, WGS72, "+proj=utm +zone=41 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32342, utm, WGS72, "+proj=utm +zone=42 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32343, utm, WGS72, "+proj=utm +zone=43 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32344, utm, WGS72, "+proj=utm +zone=44 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32345, utm, WGS72, "+proj=utm +zone=45 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32346, utm, WGS72, "+proj=utm +zone=46 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32347, utm, WGS72, "+proj=utm +zone=47 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32348, utm, WGS72, "+proj=utm +zone=48 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32349, utm, WGS72, "+proj=utm +zone=49 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32350, utm, WGS72, "+proj=utm +zone=50 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32351, utm, WGS72, "+proj=utm +zone=51 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32352, utm, WGS72, "+proj=utm +zone=52 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32353, utm, WGS72, "+proj=utm +zone=53 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32354, utm, WGS72, "+proj=utm +zone=54 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32355, utm, WGS72, "+proj=utm +zone=55 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32356, utm, WGS72, "+proj=utm +zone=56 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32357, utm, WGS72, "+proj=utm +zone=57 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32358, utm, WGS72, "+proj=utm +zone=58 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32359, utm, WGS72, "+proj=utm +zone=59 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32360, utm, WGS72, "+proj=utm +zone=60 +south +ellps=WGS72 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32401, utm, WGS72, "+proj=utm +zone=1 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32402, utm, WGS72, "+proj=utm +zone=2 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32403, utm, WGS72, "+proj=utm +zone=3 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32404, utm, WGS72, "+proj=utm +zone=4 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32405, utm, WGS72, "+proj=utm +zone=5 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32406, utm, WGS72, "+proj=utm +zone=6 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32407, utm, WGS72, "+proj=utm +zone=7 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32408, utm, WGS72, "+proj=utm +zone=8 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32409, utm, WGS72, "+proj=utm +zone=9 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32410, utm, WGS72, "+proj=utm +zone=10 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32411, utm, WGS72, "+proj=utm +zone=11 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32412, utm, WGS72, "+proj=utm +zone=12 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32413, utm, WGS72, "+proj=utm +zone=13 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32414, utm, WGS72, "+proj=utm +zone=14 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32415, utm, WGS72, "+proj=utm +zone=15 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32416, utm, WGS72, "+proj=utm +zone=16 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32417, utm, WGS72, "+proj=utm +zone=17 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32418, utm, WGS72, "+proj=utm +zone=18 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32419, utm, WGS72, "+proj=utm +zone=19 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32420, utm, WGS72, "+proj=utm +zone=20 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32421, utm, WGS72, "+proj=utm +zone=21 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32422, utm, WGS72, "+proj=utm +zone=22 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32423, utm, WGS72, "+proj=utm +zone=23 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32424, utm, WGS72, "+proj=utm +zone=24 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32425, utm, WGS72, "+proj=utm +zone=25 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32426, utm, WGS72, "+proj=utm +zone=26 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32427, utm, WGS72, "+proj=utm +zone=27 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32428, utm, WGS72, "+proj=utm +zone=28 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32429, utm, WGS72, "+proj=utm +zone=29 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32430, utm, WGS72, "+proj=utm +zone=30 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32431, utm, WGS72, "+proj=utm +zone=31 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32432, utm, WGS72, "+proj=utm +zone=32 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32433, utm, WGS72, "+proj=utm +zone=33 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32434, utm, WGS72, "+proj=utm +zone=34 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32435, utm, WGS72, "+proj=utm +zone=35 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32436, utm, WGS72, "+proj=utm +zone=36 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32437, utm, WGS72, "+proj=utm +zone=37 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32438, utm, WGS72, "+proj=utm +zone=38 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32439, utm, WGS72, "+proj=utm +zone=39 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32440, utm, WGS72, "+proj=utm +zone=40 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32441, utm, WGS72, "+proj=utm +zone=41 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32442, utm, WGS72, "+proj=utm +zone=42 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32443, utm, WGS72, "+proj=utm +zone=43 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32444, utm, WGS72, "+proj=utm +zone=44 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32445, utm, WGS72, "+proj=utm +zone=45 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32446, utm, WGS72, "+proj=utm +zone=46 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32447, utm, WGS72, "+proj=utm +zone=47 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32448, utm, WGS72, "+proj=utm +zone=48 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32449, utm, WGS72, "+proj=utm +zone=49 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32450, utm, WGS72, "+proj=utm +zone=50 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32451, utm, WGS72, "+proj=utm +zone=51 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32452, utm, WGS72, "+proj=utm +zone=52 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32453, utm, WGS72, "+proj=utm +zone=53 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32454, utm, WGS72, "+proj=utm +zone=54 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32455, utm, WGS72, "+proj=utm +zone=55 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32456, utm, WGS72, "+proj=utm +zone=56 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32457, utm, WGS72, "+proj=utm +zone=57 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32458, utm, WGS72, "+proj=utm +zone=58 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32459, utm, WGS72, "+proj=utm +zone=59 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32460, utm, WGS72, "+proj=utm +zone=60 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32501, utm, WGS72, "+proj=utm +zone=1 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32502, utm, WGS72, "+proj=utm +zone=2 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32503, utm, WGS72, "+proj=utm +zone=3 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32504, utm, WGS72, "+proj=utm +zone=4 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32505, utm, WGS72, "+proj=utm +zone=5 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32506, utm, WGS72, "+proj=utm +zone=6 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32507, utm, WGS72, "+proj=utm +zone=7 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32508, utm, WGS72, "+proj=utm +zone=8 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32509, utm, WGS72, "+proj=utm +zone=9 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32510, utm, WGS72, "+proj=utm +zone=10 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32511, utm, WGS72, "+proj=utm +zone=11 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32512, utm, WGS72, "+proj=utm +zone=12 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32513, utm, WGS72, "+proj=utm +zone=13 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32514, utm, WGS72, "+proj=utm +zone=14 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32515, utm, WGS72, "+proj=utm +zone=15 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32516, utm, WGS72, "+proj=utm +zone=16 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32517, utm, WGS72, "+proj=utm +zone=17 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32518, utm, WGS72, "+proj=utm +zone=18 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32519, utm, WGS72, "+proj=utm +zone=19 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32520, utm, WGS72, "+proj=utm +zone=20 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32521, utm, WGS72, "+proj=utm +zone=21 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32522, utm, WGS72, "+proj=utm +zone=22 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32523, utm, WGS72, "+proj=utm +zone=23 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32524, utm, WGS72, "+proj=utm +zone=24 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32525, utm, WGS72, "+proj=utm +zone=25 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32526, utm, WGS72, "+proj=utm +zone=26 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32527, utm, WGS72, "+proj=utm +zone=27 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32528, utm, WGS72, "+proj=utm +zone=28 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32529, utm, WGS72, "+proj=utm +zone=29 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32530, utm, WGS72, "+proj=utm +zone=30 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32531, utm, WGS72, "+proj=utm +zone=31 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32532, utm, WGS72, "+proj=utm +zone=32 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32533, utm, WGS72, "+proj=utm +zone=33 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32534, utm, WGS72, "+proj=utm +zone=34 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32535, utm, WGS72, "+proj=utm +zone=35 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32536, utm, WGS72, "+proj=utm +zone=36 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32537, utm, WGS72, "+proj=utm +zone=37 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32538, utm, WGS72, "+proj=utm +zone=38 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32539, utm, WGS72, "+proj=utm +zone=39 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32540, utm, WGS72, "+proj=utm +zone=40 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32541, utm, WGS72, "+proj=utm +zone=41 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32542, utm, WGS72, "+proj=utm +zone=42 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32543, utm, WGS72, "+proj=utm +zone=43 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32544, utm, WGS72, "+proj=utm +zone=44 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32545, utm, WGS72, "+proj=utm +zone=45 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32546, utm, WGS72, "+proj=utm +zone=46 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32547, utm, WGS72, "+proj=utm +zone=47 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32548, utm, WGS72, "+proj=utm +zone=48 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32549, utm, WGS72, "+proj=utm +zone=49 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32550, utm, WGS72, "+proj=utm +zone=50 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32551, utm, WGS72, "+proj=utm +zone=51 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32552, utm, WGS72, "+proj=utm +zone=52 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32553, utm, WGS72, "+proj=utm +zone=53 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32554, utm, WGS72, "+proj=utm +zone=54 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32555, utm, WGS72, "+proj=utm +zone=55 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32556, utm, WGS72, "+proj=utm +zone=56 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32557, utm, WGS72, "+proj=utm +zone=57 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32558, utm, WGS72, "+proj=utm +zone=58 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32559, utm, WGS72, "+proj=utm +zone=59 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 32560, utm, WGS72, "+proj=utm +zone=60 +south +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 32600, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32601, utm, WGS84, WGS84, "+proj=utm +zone=1 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32602, utm, WGS84, WGS84, "+proj=utm +zone=2 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32603, utm, WGS84, WGS84, "+proj=utm +zone=3 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32604, utm, WGS84, WGS84, "+proj=utm +zone=4 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32605, utm, WGS84, WGS84, "+proj=utm +zone=5 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32606, utm, WGS84, WGS84, "+proj=utm +zone=6 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32607, utm, WGS84, WGS84, "+proj=utm +zone=7 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32608, utm, WGS84, WGS84, "+proj=utm +zone=8 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32609, utm, WGS84, WGS84, "+proj=utm +zone=9 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32610, utm, WGS84, WGS84, "+proj=utm +zone=10 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32611, utm, WGS84, WGS84, "+proj=utm +zone=11 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32612, utm, WGS84, WGS84, "+proj=utm +zone=12 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32613, utm, WGS84, WGS84, "+proj=utm +zone=13 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32614, utm, WGS84, WGS84, "+proj=utm +zone=14 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32615, utm, WGS84, WGS84, "+proj=utm +zone=15 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32616, utm, WGS84, WGS84, "+proj=utm +zone=16 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32617, utm, WGS84, WGS84, "+proj=utm +zone=17 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32618, utm, WGS84, WGS84, "+proj=utm +zone=18 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32619, utm, WGS84, WGS84, "+proj=utm +zone=19 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32620, utm, WGS84, WGS84, "+proj=utm +zone=20 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32621, utm, WGS84, WGS84, "+proj=utm +zone=21 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32622, utm, WGS84, WGS84, "+proj=utm +zone=22 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32623, utm, WGS84, WGS84, "+proj=utm +zone=23 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32624, utm, WGS84, WGS84, "+proj=utm +zone=24 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32625, utm, WGS84, WGS84, "+proj=utm +zone=25 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32626, utm, WGS84, WGS84, "+proj=utm +zone=26 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32627, utm, WGS84, WGS84, "+proj=utm +zone=27 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32628, utm, WGS84, WGS84, "+proj=utm +zone=28 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32629, utm, WGS84, WGS84, "+proj=utm +zone=29 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32630, utm, WGS84, WGS84, "+proj=utm +zone=30 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32631, utm, WGS84, WGS84, "+proj=utm +zone=31 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32632, utm, WGS84, WGS84, "+proj=utm +zone=32 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32633, utm, WGS84, WGS84, "+proj=utm +zone=33 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32634, utm, WGS84, WGS84, "+proj=utm +zone=34 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32635, utm, WGS84, WGS84, "+proj=utm +zone=35 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32636, utm, WGS84, WGS84, "+proj=utm +zone=36 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32637, utm, WGS84, WGS84, "+proj=utm +zone=37 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32638, utm, WGS84, WGS84, "+proj=utm +zone=38 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32639, utm, WGS84, WGS84, "+proj=utm +zone=39 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32640, utm, WGS84, WGS84, "+proj=utm +zone=40 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32641, utm, WGS84, WGS84, "+proj=utm +zone=41 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32642, utm, WGS84, WGS84, "+proj=utm +zone=42 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32643, utm, WGS84, WGS84, "+proj=utm +zone=43 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32644, utm, WGS84, WGS84, "+proj=utm +zone=44 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32645, utm, WGS84, WGS84, "+proj=utm +zone=45 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32646, utm, WGS84, WGS84, "+proj=utm +zone=46 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32647, utm, WGS84, WGS84, "+proj=utm +zone=47 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32648, utm, WGS84, WGS84, "+proj=utm +zone=48 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32649, utm, WGS84, WGS84, "+proj=utm +zone=49 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32650, utm, WGS84, WGS84, "+proj=utm +zone=50 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32651, utm, WGS84, WGS84, "+proj=utm +zone=51 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32652, utm, WGS84, WGS84, "+proj=utm +zone=52 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32653, utm, WGS84, WGS84, "+proj=utm +zone=53 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32654, utm, WGS84, WGS84, "+proj=utm +zone=54 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32655, utm, WGS84, WGS84, "+proj=utm +zone=55 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32656, utm, WGS84, WGS84, "+proj=utm +zone=56 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32657, utm, WGS84, WGS84, "+proj=utm +zone=57 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32658, utm, WGS84, WGS84, "+proj=utm +zone=58 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32659, utm, WGS84, WGS84, "+proj=utm +zone=59 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32660, utm, WGS84, WGS84, "+proj=utm +zone=60 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32661, stere, WGS84, WGS84, "+proj=stere +lat_0=90 +lat_ts=90 +lon_0=0 +k=0.994 +x_0=2000000 +y_0=2000000 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32662, eqc, WGS84, WGS84, "+proj=eqc +lat_ts=0 +lat_0=0 +lon_0=0 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 32663, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32664, tmerc, WGS84, WGS84, "+proj=tmerc +lat_0=0 +lon_0=-99 +k=0.9996 +x_0=500000.001016002 +y_0=0 +ellps=WGS84 +datum=WGS84 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32665, tmerc, WGS84, WGS84, "+proj=tmerc +lat_0=0 +lon_0=-93 +k=0.9996 +x_0=500000.001016002 +y_0=0 +ellps=WGS84 +datum=WGS84 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32666, tmerc, WGS84, WGS84, "+proj=tmerc +lat_0=0 +lon_0=-87 +k=0.9996 +x_0=500000.001016002 +y_0=0 +ellps=WGS84 +datum=WGS84 +to_meter=0.3048006096012192 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32667, tmerc, WGS84, WGS84, "+proj=tmerc +lat_0=0 +lon_0=-81 +k=0.9996 +x_0=500000.001016002 +y_0=0 +ellps=WGS84 +datum=WGS84 +to_meter=0.3048006096012192 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 32700, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32701, utm, WGS84, WGS84, "+proj=utm +zone=1 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32702, utm, WGS84, WGS84, "+proj=utm +zone=2 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32703, utm, WGS84, WGS84, "+proj=utm +zone=3 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32704, utm, WGS84, WGS84, "+proj=utm +zone=4 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32705, utm, WGS84, WGS84, "+proj=utm +zone=5 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32706, utm, WGS84, WGS84, "+proj=utm +zone=6 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32707, utm, WGS84, WGS84, "+proj=utm +zone=7 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32708, utm, WGS84, WGS84, "+proj=utm +zone=8 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32709, utm, WGS84, WGS84, "+proj=utm +zone=9 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32710, utm, WGS84, WGS84, "+proj=utm +zone=10 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32711, utm, WGS84, WGS84, "+proj=utm +zone=11 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32712, utm, WGS84, WGS84, "+proj=utm +zone=12 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32713, utm, WGS84, WGS84, "+proj=utm +zone=13 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32714, utm, WGS84, WGS84, "+proj=utm +zone=14 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32715, utm, WGS84, WGS84, "+proj=utm +zone=15 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32716, utm, WGS84, WGS84, "+proj=utm +zone=16 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32717, utm, WGS84, WGS84, "+proj=utm +zone=17 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32718, utm, WGS84, WGS84, "+proj=utm +zone=18 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32719, utm, WGS84, WGS84, "+proj=utm +zone=19 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32720, utm, WGS84, WGS84, "+proj=utm +zone=20 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32721, utm, WGS84, WGS84, "+proj=utm +zone=21 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32722, utm, WGS84, WGS84, "+proj=utm +zone=22 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32723, utm, WGS84, WGS84, "+proj=utm +zone=23 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32724, utm, WGS84, WGS84, "+proj=utm +zone=24 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32725, utm, WGS84, WGS84, "+proj=utm +zone=25 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32726, utm, WGS84, WGS84, "+proj=utm +zone=26 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32727, utm, WGS84, WGS84, "+proj=utm +zone=27 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32728, utm, WGS84, WGS84, "+proj=utm +zone=28 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32729, utm, WGS84, WGS84, "+proj=utm +zone=29 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32730, utm, WGS84, WGS84, "+proj=utm +zone=30 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32731, utm, WGS84, WGS84, "+proj=utm +zone=31 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32732, utm, WGS84, WGS84, "+proj=utm +zone=32 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32733, utm, WGS84, WGS84, "+proj=utm +zone=33 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32734, utm, WGS84, WGS84, "+proj=utm +zone=34 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32735, utm, WGS84, WGS84, "+proj=utm +zone=35 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32736, utm, WGS84, WGS84, "+proj=utm +zone=36 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32737, utm, WGS84, WGS84, "+proj=utm +zone=37 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32738, utm, WGS84, WGS84, "+proj=utm +zone=38 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32739, utm, WGS84, WGS84, "+proj=utm +zone=39 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32740, utm, WGS84, WGS84, "+proj=utm +zone=40 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32741, utm, WGS84, WGS84, "+proj=utm +zone=41 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32742, utm, WGS84, WGS84, "+proj=utm +zone=42 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32743, utm, WGS84, WGS84, "+proj=utm +zone=43 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32744, utm, WGS84, WGS84, "+proj=utm +zone=44 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32745, utm, WGS84, WGS84, "+proj=utm +zone=45 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32746, utm, WGS84, WGS84, "+proj=utm +zone=46 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32747, utm, WGS84, WGS84, "+proj=utm +zone=47 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32748, utm, WGS84, WGS84, "+proj=utm +zone=48 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32749, utm, WGS84, WGS84, "+proj=utm +zone=49 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32750, utm, WGS84, WGS84, "+proj=utm +zone=50 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32751, utm, WGS84, WGS84, "+proj=utm +zone=51 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32752, utm, WGS84, WGS84, "+proj=utm +zone=52 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32753, utm, WGS84, WGS84, "+proj=utm +zone=53 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32754, utm, WGS84, WGS84, "+proj=utm +zone=54 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32755, utm, WGS84, WGS84, "+proj=utm +zone=55 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32756, utm, WGS84, WGS84, "+proj=utm +zone=56 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32757, utm, WGS84, WGS84, "+proj=utm +zone=57 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32758, utm, WGS84, WGS84, "+proj=utm +zone=58 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32759, utm, WGS84, WGS84, "+proj=utm +zone=59 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32760, utm, WGS84, WGS84, "+proj=utm +zone=60 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32761, stere, WGS84, WGS84, "+proj=stere +lat_0=-90 +lat_ts=-90 +lon_0=0 +k=0.994 +x_0=2000000 +y_0=2000000 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 32766, tmerc, WGS84, WGS84, "+proj=tmerc +lat_0=0 +lon_0=36 +k=0.9996 +x_0=500000 +y_0=10000000 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61206405, longlat, bessel, "+proj=longlat +ellps=bessel +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61216405, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=-199.87,74.79,246.62,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 61226405, longlat, 6378135, 6356750.304921594, "+proj=longlat +a=6378135 +b=6356750.304921594 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61236405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,-0.345,1.376,0.30857215014565614 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61246405, longlat, bessel, "+proj=longlat +ellps=bessel +towgs84=414.1,41.3,603.1,-0.855,-2.141,7.023,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61266405, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61266413, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61276405, longlat, clrk66, "+proj=longlat +ellps=clrk66 +towgs84=-82.875,-57.097,-156.768,-2.158,-1.524,0.982,-0.07404906544270759 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61286405, longlat, clrk66, "+proj=longlat +ellps=clrk66 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61296405, longlat, clrk66, "+proj=longlat +ellps=clrk66 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61306405, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0.0,0.0,0.0,-0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61306413, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0.0,0.0,0.0,-0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 61316405, longlat, 6377276.345, 6356075.41314024, "+proj=longlat +a=6377276.345 +b=6356075.41314024 +towgs84=182.0,915.0,344.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61326405, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=-244.72,-162.773,400.75,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61336405, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.055,-0.541,-0.185,0.0183,0.0003,0.007,-0.002887707287459349 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61346405, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=-191.808,-250.512,167.861,-0.792,-1.653,8.558,4.270300283733636 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61356405, longlat, clrk66, "+proj=longlat +ellps=clrk66 +towgs84=58.0,-283.0,-182.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61366405, longlat, clrk66, "+proj=longlat +ellps=clrk66 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61376405, longlat, clrk66, "+proj=longlat +ellps=clrk66 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61386405, longlat, clrk66, "+proj=longlat +ellps=clrk66 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61396405, longlat, clrk66, "+proj=longlat +ellps=clrk66 +towgs84=11.0,72.0,-101.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61406405, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=-0.991,1.9072,0.5129,0.0257899075194932,-0.009650098960270402,-0.011659943232342112,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61406413, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=-0.991,1.9072,0.5129,0.0257899075194932,-0.009650098960270402,-0.011659943232342112,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61416405, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=-48.0,55.0,52.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61426405, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=-125.0,53.0,467.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61436405, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=-124.76,53.0,466.79,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 61446405, longlat, 6377276.345, 6356075.41314024, "+proj=longlat +a=6377276.345 +b=6356075.41314024 +towgs84=214.0,804.0,268.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 61456405, longlat, 6377301.243, 6356100.230165384, "+proj=longlat +a=6377301.243 +b=6356100.230165384 +towgs84=275.57,676.78,229.6,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 61466405, longlat, 6377299.151, 6356098.145120132, "+proj=longlat +a=6377299.151 +b=6356098.145120132 +towgs84=295.0,736.0,257.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61476405, longlat, krass, "+proj=longlat +ellps=krass +towgs84=-17.51,-108.32,-62.39,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61486405, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61486413, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61496405, longlat, bessel, "+proj=longlat +ellps=bessel +towgs84=674.4,15.1,405.3,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61506405, longlat, bessel, "+proj=longlat +ellps=bessel +towgs84=674.374,15.056,405.346,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61516405, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61516413, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61526405, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=-0.991,1.9072,0.5129,0.0257899075194932,-0.009650098960270402,-0.011659943232342112,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61526413, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=-0.991,1.9072,0.5129,0.0257899075194932,-0.009650098960270402,-0.011659943232342112,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61536405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-133.63,-157.5,-158.62,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61546405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-123.02,-158.95,-168.47,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 61556405, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-83.0,37.0,124.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61566405, longlat, bessel, "+proj=longlat +ellps=bessel +towgs84=559.0,68.7,451.5,7.92,4.073,4.251,1.1777720436709203 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 61576405, longlat, 6378293.645208759, 6356617.987679838, "+proj=longlat +a=6378293.645208759 +b=6356617.987679838 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61586405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-0.465,372.095,171.736,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61596405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-114.7,-98.5,-150.7,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61606405, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61616405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=27.5,14.0,186.4,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61626405, longlat, bessel, "+proj=longlat +ellps=bessel +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61636405, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61636413, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61646405, longlat, krass, "+proj=longlat +ellps=krass +towgs84=-76.0,-138.0,67.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61656405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-173.0,253.0,27.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61666405, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61676405, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61676413, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 61686405, longlat, 6378300, 6356751.689189189, "+proj=longlat +a=6378300 +b=6356751.689189189 +towgs84=-199.0,32.0,322.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61696405, longlat, clrk66, "+proj=longlat +ellps=clrk66 +towgs84=-115.0,118.0,426.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61706405, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61706413, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61716405, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61716413, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61736405, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61736413, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 61746405, longlat, 6378300, 6356751.689189189, "+proj=longlat +a=6378300 +b=6356751.689189189 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61756405, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=-88.0,4.0,101.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61766405, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61766413, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61786405, longlat, krass, "+proj=longlat +ellps=krass +towgs84=24.0,-123.0,-94.0,0.02,0.25,0.13,0.226891286871806 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61796405, longlat, krass, "+proj=longlat +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.17326243724756094 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61806405, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61806413, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61816405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-193.0,13.7,-39.3,-0.41,-2.933,2.688,0.08869386668625144 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61826405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-422.651,-172.995,84.02,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61836405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-104.0,167.0,-38.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61846405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-203.0,141.0,53.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61886405, longlat, airy, "+proj=longlat +ellps=airy +towgs84=482.5,-130.6,564.6,-1.042,-0.214,-0.631,1.6810581709138355 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61896405, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61896413, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61906405, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61906413, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61916405, longlat, krass, "+proj=longlat +ellps=krass +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61926405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-206.1,-174.7,-87.7,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 61936405, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-70.9,-151.8,-41.4,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61946405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=163.511,127.533,-159.789,0.0,0.0,0.814,-0.12375888374825782 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61956405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=105.0,326.0,-102.5,0.0,0.0,0.814,-0.12375888374825782 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61966405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-45.0,417.0,-3.5,0.0,0.0,0.814,-0.12375888374825782 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61976405, longlat, clrk80, "+proj=longlat +ellps=clrk80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61986405, longlat, clrk80, "+proj=longlat +ellps=clrk80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 61996405, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62006405, longlat, krass, "+proj=longlat +ellps=krass +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62016405, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=-165.0,-11.0,206.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62026405, longlat, aust_SA, "+proj=longlat +ellps=aust_SA +towgs84=-124.133,-42.003,137.4,-0.008,-0.557,-0.178,-0.3824149507821167 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62036405, longlat, aust_SA, "+proj=longlat +ellps=aust_SA +towgs84=-117.763,-51.51,139.061,0.292,-0.443,-0.277,-0.03939657799319541 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62046405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-18.944,-379.364,-24.063,0.04,0.764,-6.431,0.7543103964456315 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62056405, longlat, krass, "+proj=longlat +ellps=krass +towgs84=-43.0,-163.0,45.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 62066405, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62076405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-288.885,-91.744,126.244,-1.691,-0.41,0.211,-0.948405579124149 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62086405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-161.0,310.0,-145.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 62096405, longlat, 6378249.145, 6356514.966398753, "+proj=longlat +a=6378249.145 +b=6356514.966398753 +towgs84=-138.0,-105.0,-289.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62106405, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=-157.0,-2.0,-299.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62116405, longlat, bessel, "+proj=longlat +ellps=bessel +towgs84=-377.7,675.1,-52.2,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62126405, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=31.95,300.99,419.19,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 62136405, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-106.0,-87.0,188.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62146405, longlat, krass, "+proj=longlat +ellps=krass +towgs84=15.8,-154.4,-82.3,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62156405, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62166405, longlat, clrk66, "+proj=longlat +ellps=clrk66 +towgs84=-73.0,213.0,296.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62186405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=304.5,306.5,-318.1,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62196405, longlat, bessel, "+proj=longlat +ellps=bessel +towgs84=-384.0,664.0,-48.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62206405, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=-50.9,-347.6,-231.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62216405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-154.5,150.7,100.4,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 62226405, longlat, 6378249.145, 6356514.966398753, "+proj=longlat +a=6378249.145 +b=6356514.966398753 +towgs84=-136.0,-108.0,-292.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 62236405, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-260.1,5.5,432.2,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62246405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-134.0,229.0,-29.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62256405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-206.0,172.0,-6.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 62276405, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-83.58,-397.54,458.78,-17.595,-2.847,4.256,0.6652040001468859 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62296405, longlat, helmert, "+proj=longlat +ellps=helmert +towgs84=-130.0,110.0,-13.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62306405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-157.89,-17.16,-78.41,2.118,2.697,-1.434,-1.1097046576093785 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62316405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-82.981,-99.719,-110.709,-0.10470001565102613,0.031001600378938583,0.08040202147511816,-0.06482902860346239 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62326405, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=-346.0,-1.0,224.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62336405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-133.0,-321.0,50.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62366405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-637.0,-549.0,-203.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62376405, longlat, GRS67, "+proj=longlat +ellps=GRS67 +towgs84=57.01,-69.97,-9.29,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 62386405, longlat, 6378160, 6356774.50408554, "+proj=longlat +a=6378160 +b=6356774.50408554 +towgs84=-1.977,-13.06,-9.993,0.364,-0.254,-0.689,-0.2138966040782389 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 62396405, longlat, 6377276.345, 6356075.41314024, "+proj=longlat +a=6377276.345 +b=6356075.41314024 +towgs84=217.0,823.0,299.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 62406405, longlat, 6377276.345, 6356075.41314024, "+proj=longlat +a=6377276.345 +b=6356075.41314024 +towgs84=204.64,834.74,293.8,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62416405, longlat, clrk80, "+proj=longlat +ellps=clrk80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62426405, longlat, clrk66, "+proj=longlat +ellps=clrk66 +towgs84=-33.722,153.789,94.959,-8.581,4.478,-4.54,1.8460700159115124 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 62436405, longlat, 6377299.36559538, 6356098.357204818, "+proj=longlat +a=6377299.36559538 +b=6356098.357204818 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 62446405, longlat, 6377276.345, 6356075.41314024, "+proj=longlat +a=6377276.345 +b=6356075.41314024 +towgs84=-97.0,787.0,86.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 62456405, longlat, 6377304.063, 6356103.038993155, "+proj=longlat +a=6377304.063 +b=6356103.038993155 +towgs84=-11.0,851.0,5.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62466405, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=-294.7,-200.1,525.5,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62476405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-273.5,110.6,-357.9,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62486405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-307.7,265.3,-363.5,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62496405, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62506405, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=-130.0,29.0,364.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62516405, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=-90.0,40.0,88.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 62526405, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62536405, longlat, clrk66, "+proj=longlat +ellps=clrk66 +towgs84=-133.0,-77.0,-51.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62546405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=18.38,192.45,96.82,0.056,-0.142,-0.2,-0.0002681442481212253 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62556405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-333.0,-222.0,114.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62566405, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=41.0,-220.0,-134.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62576405, longlat, bessel, "+proj=longlat +ellps=bessel +towgs84=-587.8,519.75,145.76,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62586405, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62586413, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62596405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-254.1,-5.36,-100.29,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 62616405, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=31.0,146.0,47.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62626405, longlat, bessel, "+proj=longlat +ellps=bessel +towgs84=639.0,405.0,60.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62636405, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=-90.2,-87.32,114.17,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62646405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-252.95,-4.11,-96.38,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62656405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-50.2,-50.4,84.8,-0.69,-2.012,0.459,-5.791915759418465 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 62666405, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-80.7,-132.5,41.1,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 62676405, longlat, clrk66, NAD27, "+proj=longlat +ellps=clrk66 +datum=NAD27 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 62686405, longlat, 6378450.047548896, 6356826.621488444, "+proj=longlat +a=6378450.047548896 +b=6356826.621488444 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 62696405, longlat, GRS80, NAD83, "+proj=longlat +ellps=GRS80 +datum=NAD83 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62706405, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=-245.0,-153.9,382.8,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62716405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-2.0,374.0,172.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 62726405, longlat, intl, nzgd49, "+proj=longlat +ellps=intl +datum=nzgd49 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 62736405, longlat, 6377492.018, 6356173.508712696, "+proj=longlat +a=6377492.018 +b=6356173.508712696 +towgs84=278.3,93.0,474.5,7.889,0.05,-6.61,1.2809044467944684 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62746405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-239.749,88.181,30.488,0.263,-0.082,-1.211,0.4597642531247778 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 62756405, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-168.0,-60.0,320.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62766405, longlat, WGS66, "+proj=longlat +ellps=WGS66 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 62776405, longlat, airy, OSGB36, "+proj=longlat +ellps=airy +datum=OSGB36 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62786405, longlat, airy, "+proj=longlat +ellps=airy +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62796405, longlat, airy, "+proj=longlat +ellps=airy +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62806405, longlat, bessel, "+proj=longlat +ellps=bessel +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 62816405, longlat, 6378300.789, 6356566.435, "+proj=longlat +a=6378300.789 +b=6356566.435 +towgs84=-275.7224,94.7824,340.8944,-8.001,-4.42,-11.821,0.20626480624709637 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 62826405, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-178.3,-316.7,-131.5,5.278,6.077,10.979,3.953271276531849 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62836405, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62836413, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62846405, longlat, krass, "+proj=longlat +ellps=krass +towgs84=-40.595,-18.55,-69.339,2.508,-1.832,2.611,-0.8867324020562674 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62856405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-128.033,-283.697,21.052,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62866405, longlat, helmert, "+proj=longlat +ellps=helmert +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62886405, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62896405, longlat, bessel, "+proj=longlat +ellps=bessel +towgs84=565.04,49.91,465.84,-0.40939438743923684,-0.35970519561431136,1.868491000350572,0.8409828680306614 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62926405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-355.0,21.0,72.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62936405, longlat, bess_nam, "+proj=longlat +ellps=bess_nam +towgs84=616.0,97.0,-251.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62956405, longlat, bessel, "+proj=longlat +ellps=bessel +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62976405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-189.0,-242.0,-91.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 62986405, longlat, evrstSS, "+proj=longlat +ellps=evrstSS +towgs84=-533.4,669.2,-52.5,0.0,0.0,4.28,1.9388891787227058 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 62996405, longlat, 6377340.189, 6356034.447938534, "+proj=longlat +a=6377340.189 +b=6356034.447938534 +towgs84=482.5,-130.6,564.6,-1.042,-0.214,-0.631,1.6810581709138355 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 63006405, longlat, 6377340.189, 6356034.447938534, "+proj=longlat +a=6377340.189 +b=6356034.447938534 +towgs84=482.5,-130.6,564.6,-1.042,-0.214,-0.631,1.6810581709138355 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 63016405, longlat, bessel, "+proj=longlat +ellps=bessel +towgs84=-147.0,506.0,687.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 63026405, longlat, 6378293.645208759, 6356617.987679838, "+proj=longlat +a=6378293.645208759 +b=6356617.987679838 +towgs84=-61.702,284.488,472.052,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 63036405, longlat, helmert, "+proj=longlat +ellps=helmert +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 63046405, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-73.0,-247.0,227.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 63066405, longlat, bessel, "+proj=longlat +ellps=bessel +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 63076405, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=-169.559,-72.34,303.102,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 63086405, longlat, bessel, "+proj=longlat +ellps=bessel +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 63096405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-155.0,171.0,37.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 63106405, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 63116405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-265.0,120.0,-358.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 63126405, longlat, bessel, "+proj=longlat +ellps=bessel +towgs84=426.9,142.6,460.1,4.91,4.49,-12.42,3.5271281868253483 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 63136405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-106.8686,52.2978,-103.7239,0.3366,0.457,-1.8422,0.26292574852317374 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 63146405, longlat, bessel, potsdam, "+proj=longlat +ellps=bessel +datum=potsdam +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 63156405, longlat, 6378249.2, 6356515, "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-23.0,259.0,-9.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 63166405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=103.25,-100.4,-307.19,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 63176405, longlat, krass, "+proj=longlat +ellps=krass +towgs84=28.0,-121.0,-77.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 63186405, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=-3.2,-5.7,2.8,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 63196405, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=226.702,-193.337,-35.371,-2.229,4.391,-9.238,0.20209825716090501 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 63226405, longlat, WGS72, "+proj=longlat +ellps=WGS72 +towgs84=0.0,0.0,4.5,0.0,0.0,0.554,0.045171992568114105 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 63246405, longlat, WGS72, "+proj=longlat +ellps=WGS72 +towgs84=0.0,0.0,1.9,0.0,0.0,0.814,-0.07838062637389662 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 63266405, longlat, WGS84, WGS84, "+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 63266406, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 63266407, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 63266408, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 63266409, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 63266410, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 63266411, longlat, WGS84, WGS84, "+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 63266412, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 63266413, longlat, WGS84, WGS84, "+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 63266414, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 63266415, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 63266416, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 63266417, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 63266418, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_ED(epsg, 63266419, longlat, WGS84, WGS84, "+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (epsg, 63266420, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66006405, longlat, clrk80, "+proj=longlat +ellps=clrk80 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66016405, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=-255.0,-15.0,71.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66026405, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=725.0,685.0,536.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66036405, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=72.0,213.7,93.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66046405, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=174.0,359.0,365.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66056405, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=9.0,183.0,236.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66066405, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=-149.0,128.0,296.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66076405, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=195.671,332.517,274.607,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66086405, longlat, clrk66, "+proj=longlat +ellps=clrk66 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66096405, longlat, clrk66, "+proj=longlat +ellps=clrk66 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 66106405, longlat, 6378140, 6356755.288157528, "+proj=longlat +a=6378140 +b=6356755.288157528 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66116405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-162.619,-276.959,-161.764,0.067753,-2.243649,-1.158827,-0.22570443917666022 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66126405, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66126413, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66136405, longlat, bessel, "+proj=longlat +ellps=bessel +towgs84=-404.78,685.68,45.47,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66146405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-119.4248,-303.65872,-11.00061,1.164298,0.174458,1.096259,0.7543238036580374 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66156405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-499.0,-249.0,314.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66166405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-289.0,-124.0,60.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66186405, longlat, aust_SA, "+proj=longlat +ellps=aust_SA +towgs84=-66.87,4.37,-38.52,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66196405, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66196413, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66206405, longlat, clrk80, "+proj=longlat +ellps=clrk80 +towgs84=-106.0,-129.0,165.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66216405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=137.0,248.0,-430.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66226405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-472.29,-5.63,-304.12,0.4362,-0.8374,0.2563,0.39157310817948776 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66236405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-186.0,230.0,110.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66246405, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=2.0,2.0,-2.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66246413, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=2.0,2.0,-2.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66256405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=126.93,547.94,130.41,-2.7867,5.1612,-0.8584,2.851136537311739 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66266405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=94.0,-948.0,-1262.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66276405, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66276413, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66286405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=162.0,117.0,154.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66296405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=72.438,345.918,79.486,1.6045,-0.8823,-0.5565,0.2835316026672587 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66306405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=259.551,297.612,197.833,-1.4866,2.1224,0.4612,5.574285762347154 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66316405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=145.0,-187.0,103.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66326405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-382.0,-59.0,-262.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66336405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=335.47,222.58,-230.94,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66346405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-11.64,-348.6,291.98,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66356405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-122.383,-188.696,103.344,3.5107,-4.9668,-5.7047,0.9240250790257423 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66366405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=365.0,194.0,166.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66376405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=325.0,154.0,172.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66386405, longlat, clrk66, "+proj=longlat +ellps=clrk66 +towgs84=30.0,430.0,368.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66396405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=253.0,-132.0,-127.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66406405, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66406413, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66416405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=287.58,177.78,-135.41,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66426405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-13.0,-348.0,292.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66436405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-480.26,-438.32,-643.429,16.3119,20.1721,-4.0349,-23.039820110761912 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66446405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-10.18,-350.43,291.37,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66456405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66456413, longlat, intl, "+proj=longlat +ellps=intl +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66466405, longlat, intl, "+proj=longlat +ellps=intl +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 66576405, longlat, 6377019.27, 6355762.5391, "+proj=longlat +a=6377019.27 +b=6355762.5391 +towgs84=-28.0,199.0,5.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66586405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-73.0,46.0,-86.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66596405, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66596413, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66606405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=982.6087,552.753,-540.873,6.681626625276941,-31.61149240864225,-19.848161004816845,3.466280068982454 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66616405, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66616413, longlat, GRS80, "+proj=longlat +ellps=GRS80 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66636405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-210.502,-66.902,-48.476,2.094,15.067,5.817,0.10003843102984174 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66646405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-208.719,129.685,52.092,-0.195,0.014,-0.327,0.040840431636925086 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66656405, longlat, intl, "+proj=longlat +ellps=intl +towgs84=-103.088,162.481,-28.276,0.167,-0.082,-0.168,-0.31022226859563296 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66666405, longlat, bessel, "+proj=longlat +ellps=bessel +towgs84=631.392,-66.551,481.442,1.09,4.445,4.487,-0.9137530916746368 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 66676405, longlat, WGS84, "+proj=longlat +ellps=WGS84 +towgs84=0.0,0.0,0.0,0.0,0.0,0.0,0.0 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 68016405, longlat, bessel, "+proj=longlat +ellps=bessel +pm=bern +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 68026405, longlat, intl, "+proj=longlat +ellps=intl +pm=bogota +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 68036405, longlat, intl, "+proj=longlat +ellps=intl +pm=lisbon +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 68046405, longlat, bessel, "+proj=longlat +ellps=bessel +pm=jakarta +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 68056405, longlat, bessel, "+proj=longlat +ellps=bessel +pm=ferro +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 68066405, longlat, intl, "+proj=longlat +ellps=intl +pm=rome +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 68086405, longlat, bessel, "+proj=longlat +ellps=bessel +pm=jakarta +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 68096405, longlat, intl, "+proj=longlat +ellps=intl +pm=brussels +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 68136405, longlat, bessel, "+proj=longlat +ellps=bessel +pm=jakarta +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 68146405, longlat, bessel, "+proj=longlat +ellps=bessel +pm=stockholm +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 68156405, longlat, bessel, "+proj=longlat +ellps=bessel +pm=athens +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 68186405, longlat, bessel, "+proj=longlat +ellps=bessel +pm=ferro +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_E (epsg, 68206405, longlat, bessel, "+proj=longlat +ellps=bessel +pm=jakarta +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(epsg, 69036405, longlat, 6378298.3, 6356657.142669561, "+proj=longlat +a=6378298.3 +b=6356657.142669561 +pm=madrid +no_defs")

} // namespace detail
#endif // DOXYGEN_NO_DETAIL

}}} // namespace boost::geometry::projections


#endif

