#include "Bdef.h"

void sgupk_amn(MatInf, buff)
MATINFO  *MatInf;
char  *buff;
/*
 * Unpacks the amn and distance matrices a column at a time into buff,
 * and then does a amn into the matrices pointed at by MatInf
 */
{
   int m, n, lda, ldd, i, j;
   float *A, *v;
   float diff;
   unsigned short *Ad, *vd;

   m = MatInf->M;
   n = MatInf->N;
   A = (float *) MatInf->A;
   lda = MatInf->lda;
   Ad = (unsigned short *) MatInf->B;
   ldd = (MatInf->ldb) * (sizeof(int) / sizeof(short));
   v = (float *) buff;
   vd = (unsigned short *) &v[m];

   for(j=0; j < n; j++)
   {
      i = pvm_upkfloat((float *) v, m, 1);
      Mpvmerror(i, "pvm_upkfloat", __LINE__, __FILE__);
      i = pvm_upkshort((short *) vd, m, 1);
      Mpvmerror(i, "pvm_upkshort", __LINE__, __FILE__);
      for (i=0; i < m; i++)
      {
         diff = Rabs(A[i]) - Rabs(v[i]);
         if (diff >= 0)
         {
            if (diff != 0)
	    {
               A[i] = v[i];
               Ad[i] = vd[i];
	    }
	    else if (vd[i] < Ad[i])
	    {
               A[i] = v[i];
               Ad[i] = vd[i];
	    }
	 }
      }
      A += lda;
      Ad += ldd;
   }
}
