;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.
;; RUN: foreach %s %t wasm-opt -all --gufa -S -o - | filecheck %s

(module
  ;; CHECK:      (type $0 (func))

  ;; CHECK:      (global $foo (mut (ref string)) (string.const "foo"))
  (global $foo (mut (ref string)) (string.const "foo"))

  ;; CHECK:      (global $bar (mut (ref string)) (string.const "bar"))
  (global $bar (mut (ref string)) (string.const "bar"))

  ;; CHECK:      (global $baz (mut (ref string)) (string.const "baz"))
  (global $baz (mut (ref string)) (string.const "baz"))

  ;; CHECK:      (func $set (type $0)
  ;; CHECK-NEXT:  (global.set $foo
  ;; CHECK-NEXT:   (string.const "foo")
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (global.set $bar
  ;; CHECK-NEXT:   (string.const "BAR_BAR_BAR")
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $set
    ;; Modify $foo to the same value as it begins.
    (global.set $foo
      (string.const "foo")
    )
    ;; Modify $bar to a new value
    (global.set $bar
      (string.const "BAR_BAR_BAR")
    )
    ;; Do not modify $baz at all.
  )

  ;; CHECK:      (func $get (type $0)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (string.const "foo")
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (global.get $bar)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (string.const "baz")
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $get
    ;; $foo and $baz can be optimized, but not $bar.
    (drop
      (global.get $foo)
    )
    (drop
      (global.get $bar)
    )
    (drop
      (global.get $baz)
    )
  )
)
