/*  Copyright (C) 2012-2022 by László Nagy
    This file is part of Bear.

    Bear is a tool to generate compilation database for clang tooling.

    Bear is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Bear is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

namespace el::env {

    /**
     * Returns the value for the given environment name, from the given
     * environment array.
     *
     * It's a re-implementation of the standard library function..
     *
     * @param envp the environment array.
     * @param key the name of the environment.
     * @return the value of the environment.
     */
    const char* get_env_value(const char** envp, const char* key) noexcept;
}
