/*
 * Decompiled with CFR 0.152.
 */
package org.probatron.officeotron;

import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import org.probatron.officeotron.ValidationReport;
import org.probatron.officeotron.XMLNameSet;
import org.probatron.officeotron.XMLSniffer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ODFSniffer
extends XMLSniffer {
    private String generator = "";
    private ValidationReport commentary;
    private boolean checkIds;
    private int dupCount;
    static final String ODF_ANIM_NS = "urn:oasis:names:tc:opendocument:xmlns:animation:1.0";
    static final String ODF_CHART_NS = "urn:oasis:names:tc:opendocument:xmlns:chart:1.0";
    static final String ODF_CONFIG_NS = "urn:oasis:names:tc:opendocument:xmlns:config:1.0";
    static final String ODF_DC_NS = "http://purl.org/dc/elements/1.1/";
    static final String ODF_DR3D_NS = "urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0";
    static final String ODF_DRAW_NS = "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0";
    static final String ODF_FO_NS = "urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0";
    static final String ODF_FORM_NS = "urn:oasis:names:tc:opendocument:xmlns:form:1.0";
    static final String ODF_MATH_NS = "http://www.w3.org/1998/Math/MathML";
    static final String ODF_META_NS = "urn:oasis:names:tc:opendocument:xmlns:meta:1.0";
    static final String ODF_NUMBER_NS = "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0";
    static final String ODF_OFFICE_NS = "urn:oasis:names:tc:opendocument:xmlns:office:1.0";
    static final String ODF_PRESENTATION_NS = "urn:oasis:names:tc:opendocument:xmlns:presentation:1.0";
    static final String ODF_SCRIPT_NS = "urn:oasis:names:tc:opendocument:xmlns:script:1.0";
    static final String ODF_SMIL_NS = "urn:oasis:names:tc:opendocument:xmlns:smil-compatible:1.0";
    static final String ODF_STYLE_NS = "urn:oasis:names:tc:opendocument:xmlns:style:1.0";
    static final String ODF_SVG_NS = "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0";
    static final String ODF_TABLE_NS = "urn:oasis:names:tc:opendocument:xmlns:table:1.0";
    static final String ODF_TEXT_NS = "urn:oasis:names:tc:opendocument:xmlns:text:1.0";
    static final String ODF_XFORMS_NS = "http://www.w3.org/2002/xforms";
    static final String ODF_XLINK_NS = "http://www.w3.org/1999/xlink";
    private static XMLNameSet idTypes = new XMLNameSet();
    private static XMLNameSet idRefTypes = new XMLNameSet();
    private static XMLNameSet textIdOddBalls = new XMLNameSet();
    private ArrayList<String> idValues = new ArrayList();
    private ArrayList<String> idRefValues = new ArrayList();

    public ODFSniffer(ValidationReport validationReport, boolean bl) {
        this.commentary = validationReport;
        this.checkIds = bl;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        super.startElement(string, string2, string3, attributes);
        if (this.checkIds) {
            this.harvestIdStuff(attributes);
        }
    }

    private void harvestIdStuff(Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string;
            String string2;
            String string3 = attributes.getURI(i);
            if (idTypes.contains(string3, string2 = attributes.getLocalName(i)) && !textIdOddBalls.contains(this.getContextNs(), this.getContextElement())) {
                string = attributes.getValue(i);
                logger.trace("Got ID value" + string);
                int n = Collections.binarySearch(this.idValues, string);
                if (n >= 0) {
                    ++this.dupCount;
                    if (this.dupCount > 10) continue;
                    this.commentary.addComment("ERROR", "Duplicate ID value found: \"" + string + "\"");
                    continue;
                }
                logger.trace("Adding ID value" + string);
                this.idValues.add(-n - 1, string);
                continue;
            }
            if (!idRefTypes.contains(string3, string2)) continue;
            string = attributes.getValue(i);
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                logger.trace("Got IDREF value" + string4);
                int n = Collections.binarySearch(this.idValues, string4);
                if (n >= 0) continue;
                logger.trace("Adding IDREF value" + string4);
                this.idRefValues.add(-n - 1, string4);
            }
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        super.characters(cArray, n, n2);
        if (this.getContextNs().equals(ODF_META_NS) && this.getContextElement().equals("generator")) {
            this.generator = this.generator + new String(cArray, n, n2);
        }
    }

    public String getGenerator() {
        return this.generator;
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.checkIds) {
            if (this.dupCount > 10) {
                this.commentary.addComment("WARN", "<i>" + (this.dupCount - 10) + " duplicate ID message(s) omitted for the sake of brevity</i>");
            }
            int n = 0;
            for (String string : this.idRefValues) {
                int n2 = Collections.binarySearch(this.idValues, string);
                logger.trace("Checking ID references for value: " + string);
                if (n2 >= 0 || ++n > 10) continue;
                this.commentary.addComment("WARNING", "Reference to absent ID \"" + string + "\"");
            }
            if (n > 10) {
                this.commentary.addComment("WARN", "<i>" + (n - 10) + " absent ID message(s) omitted for the sake of brevity</i>");
            }
        }
        super.endDocument();
    }

    static {
        idTypes.put(ODF_TEXT_NS, "id");
        idTypes.put(ODF_DRAW_NS, "id");
        idTypes.put(ODF_FORM_NS, "id");
        idTypes.put(ODF_TEXT_NS, "id");
        idRefTypes.put(ODF_TEXT_NS, "change-id");
        idRefTypes.put(ODF_DRAW_NS, "nav-order");
        idRefTypes.put(ODF_DRAW_NS, "start-shape");
        idRefTypes.put(ODF_DRAW_NS, "end-shape");
        idRefTypes.put(ODF_DRAW_NS, "control");
        idRefTypes.put(ODF_DRAW_NS, "caption-id");
        idRefTypes.put(ODF_DRAW_NS, "shape-id");
        idRefTypes.put(ODF_PRESENTATION_NS, "master-element");
        idRefTypes.put(ODF_SMIL_NS, "target-element");
        textIdOddBalls.put(ODF_TEXT_NS, "alphabetical-index-mark-end");
        textIdOddBalls.put(ODF_TEXT_NS, "alphabetical-index-mark-start");
        textIdOddBalls.put(ODF_TEXT_NS, "note");
        textIdOddBalls.put(ODF_TEXT_NS, "toc-mark-end");
        textIdOddBalls.put(ODF_TEXT_NS, "toc-mark-start");
        textIdOddBalls.put(ODF_TEXT_NS, "user-index-mark-end");
        textIdOddBalls.put(ODF_TEXT_NS, "user-index-mark-start");
    }
}

