/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.www.protocol.https;

import com.sun.net.ssl.internal.www.HeaderParser;
import com.sun.net.ssl.internal.www.MessageHeader;
import com.sun.net.ssl.internal.www.ProgressData;
import com.sun.net.ssl.internal.www.ProgressEntry;
import com.sun.net.ssl.internal.www.https.HttpClient;
import com.sun.net.ssl.internal.www.https.HttpsClient;
import com.sun.net.ssl.internal.www.protocol.https.BasicAuthentication;
import com.sun.net.ssl.internal.www.protocol.https.DigestAuthentication;
import com.sun.net.ssl.internal.www.protocol.https.EmptyInputStream;
import com.sun.net.ssl.internal.www.protocol.https.Handler;
import com.sun.net.ssl.internal.www.protocol.https.HttpAuthenticator;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.security.cert.X509Certificate;
import sun.security.action.GetPropertyAction;

public class HttpsURLConnection
extends com.sun.net.ssl.HttpsURLConnection {
    public static final String a = AccessController.doPrivileged(new GetPropertyAction("java.version"));
    public static final String userAgent = AccessController.doPrivileged(new GetPropertyAction("http.agent", "Java" + a));
    public static final String b = "HTTP/1.1";
    public static final String c = "text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2";
    public static final int d = 5;
    public HttpClient http;
    public Handler handler;
    public PrintStream ps = null;
    public static HttpAuthenticator e;
    public MessageHeader f = new MessageHeader();
    public ProgressEntry pe;
    public MessageHeader g = new MessageHeader();
    public InputStream h = null;
    public ByteArrayOutputStream i = null;
    public boolean j = false;
    public boolean k = false;
    public Exception l = null;
    public boolean m;

    public HttpsURLConnection(URL uRL, Handler handler) throws IOException {
        super(uRL);
        this.handler = handler;
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.http = HttpsClient.New(this.getSSLSocketFactory(), this.url);
        this.connected = true;
    }

    public void disconnect() {
        this.responseCode = -1;
        if (this.pe != null) {
            ProgressData.pdata.unregister(this.pe);
        }
        if (this.http != null) {
            this.http.closeServer();
            this.http = null;
            this.connected = false;
        }
    }

    public void finalize() {
    }

    private boolean b() throws IOException {
        if (!this.getInstanceFollowRedirects()) {
            return false;
        }
        int n2 = this.getResponseCode();
        if (n2 < 300 || n2 > 305 || n2 == 304) {
            return false;
        }
        String string = this.getHeaderField("Location");
        if (string == null) {
            return false;
        }
        this.disconnect();
        this.g = new MessageHeader();
        if (n2 == 305) {
            URL uRL = new URL(string);
            this.http = this.getProxiedClient(this.url, uRL.getHost(), uRL.getPort());
            this.f.set(0, String.valueOf(this.method) + " " + this.http.getURLFile() + " " + b, null);
            this.connected = true;
        } else {
            this.url = new URL(this.url, string);
            if (this.method.equals("POST") && !Boolean.getBoolean("http.strictPostRedirect")) {
                this.f = new MessageHeader();
                this.j = false;
                this.setRequestMethod("GET");
                this.i = null;
                this.connect();
            } else {
                this.connect();
                this.f.set(0, String.valueOf(this.method) + " " + this.http.getURLFile() + " " + b, null);
                this.f.set("Host", String.valueOf(this.url.getHost()) + (this.url.getPort() == -1 || this.url.getPort() == 80 ? "" : ":" + String.valueOf(this.url.getPort())));
            }
        }
        return true;
    }

    public String getCipherSuite() {
        return ((HttpsClient)this.http).getCipherSuite();
    }

    public String getHeaderField(int n2) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {}
        return this.g.getValue(n2);
    }

    public String getHeaderField(String string) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {}
        return this.g.findValue(string);
    }

    public String getHeaderFieldKey(int n2) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {}
        return this.g.getKey(n2);
    }

    private bj c() {
        bj bj2 = null;
        String string = this.getHeaderField("Proxy-authenticate");
        String string2 = this.http.getProxyHostUsed();
        int n2 = this.http.getProxyPortUsed();
        if (string2 != null && string != null) {
            Object object;
            Serializable serializable;
            HeaderParser headerParser = new HeaderParser(string);
            String string3 = headerParser.findValue("realm");
            String string4 = headerParser.findKey(0);
            bj2 = bj.a(string2, n2, string3);
            if (bj2 == null && "basic".equalsIgnoreCase(string4)) {
                serializable = null;
                try {
                    serializable = InetAddress.getByName(string2);
                }
                catch (UnknownHostException unknownHostException) {}
                object = HttpsURLConnection.a(serializable, n2, "http", string3, string4);
                if (object != null) {
                    bj2 = new BasicAuthentication(true, string2, n2, string3, (PasswordAuthentication)object);
                }
            }
            if (bj2 == null && e != null && e.schemeSupported(string4)) {
                try {
                    serializable = new URL("http", string2, n2, "/");
                    object = e.authString((URL)serializable, string4, string3);
                    if (object != null) {
                        bj2 = new BasicAuthentication(true, string2, n2, string3, (String)object);
                    }
                }
                catch (MalformedURLException malformedURLException) {}
            }
            if (bj2 != null && !bj2.a(this, headerParser)) {
                bj2 = null;
            }
        }
        return bj2;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new ProtocolException("Cannot read from URLConnection if doInput=false (call setDoInput(true))");
        }
        if (this.h != null && !this.connected && this.l != null) {
            if (this.l instanceof RuntimeException) {
                throw (RuntimeException)this.l;
            }
            throw (IOException)this.l;
        }
        if (this.h != null) {
            return this.h;
        }
        int n2 = 0;
        bj bj2 = null;
        bj bj3 = null;
        try {
            do {
                this.pe = new ProgressEntry(this.url.getFile(), null);
                ProgressData.pdata.register(this.pe);
                this.connect();
                this.ps = (PrintStream)this.http.getOutputStream();
                this.e();
                this.http.parseHTTP(this.g, this.pe);
                this.h = this.http.getInputStream();
                int n3 = this.getResponseCode();
                if (n3 == 407) {
                    if (bj3 != null) {
                        bj3.d();
                    }
                    if ((bj3 = this.c()) != null) {
                        this.disconnect();
                        ++n2;
                        continue;
                    }
                }
                if (n3 == 401) {
                    if (bj2 != null) {
                        bj2.d();
                    }
                    if ((bj2 = this.d()) != null) {
                        this.disconnect();
                        ++n2;
                        continue;
                    }
                }
                if (n3 == 200 || n3 >= 300 && n3 <= 305) {
                    if (bj3 != null) {
                        bj3.a();
                    }
                    if (bj2 != null) {
                        bj2.a();
                    }
                }
                if (this.b()) {
                    ++n2;
                    continue;
                }
                if (this.method.equals("HEAD") || this.method.equals("TRACE")) {
                    this.disconnect();
                    this.h = new EmptyInputStream();
                    return this.h;
                }
                String string = this.url.getFile();
                if (!(n3 < 400 || string == null || string.endsWith(".html") || string.endsWith(".htm") || string.endsWith("/") || string.endsWith(".txt"))) {
                    throw new FileNotFoundException(this.url.toString());
                }
                return this.h;
            } while (n2 < 5);
            throw new ProtocolException("Server redirected too many times (" + n2 + ")");
        }
        catch (RuntimeException runtimeException) {
            this.disconnect();
            this.l = runtimeException;
            throw runtimeException;
        }
        catch (IOException iOException) {
            this.disconnect();
            this.l = iOException;
            throw iOException;
        }
    }

    public boolean getInstanceFollowRedirects() {
        return this.m;
    }

    public String a() {
        return this.method;
    }

    public HttpClient getNewClient(URL uRL) throws IOException {
        return new HttpsClient(this.getSSLSocketFactory(), uRL);
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        try {
            if (!this.doOutput) {
                throw new ProtocolException("cannot write to a URLConnection if doOutput=false - call setDoOutput(true)");
            }
            if (this.method.equals("GET")) {
                this.setRequestMethod("POST");
            }
            if (!"POST".equals(this.method) && !"PUT".equals(this.method) && "http".equals(this.url.getProtocol())) {
                throw new ProtocolException("HTTP method " + this.method + " doesn't support output");
            }
            if (this.h != null) {
                throw new ProtocolException("Cannot write output after reading input.");
            }
            this.connect();
            this.ps = (PrintStream)this.http.getOutputStream();
            if (this.i == null) {
                this.i = new ByteArrayOutputStream();
            }
            return this.i;
        }
        catch (RuntimeException runtimeException) {
            this.disconnect();
            throw runtimeException;
        }
        catch (IOException iOException) {
            this.disconnect();
            throw iOException;
        }
    }

    public HttpClient getProxiedClient(URL uRL, String string, int n2) throws IOException {
        return new HttpClient(uRL, string, n2);
    }

    public String getRequestProperty(String string) {
        return this.f.findValue(string);
    }

    private bj d() {
        bj bj2 = null;
        String string = this.getHeaderField("WWW-Authenticate");
        if (string != null) {
            Object object;
            HeaderParser headerParser = new HeaderParser(string);
            String string2 = headerParser.findValue("realm");
            String string3 = headerParser.findKey(0);
            bj2 = bj.a(this.url, string2);
            InetAddress inetAddress = null;
            if (bj2 == null) {
                try {
                    inetAddress = InetAddress.getByName(this.url.getHost());
                }
                catch (UnknownHostException unknownHostException) {}
            }
            if (bj2 == null && "basic".equalsIgnoreCase(string3) && (object = HttpsURLConnection.a(inetAddress, this.url.getPort(), this.url.getProtocol(), string2, string3)) != null) {
                bj2 = new BasicAuthentication(false, this.url, string2, (PasswordAuthentication)object);
            }
            if (bj2 == null && "digest".equalsIgnoreCase(string3) && (object = HttpsURLConnection.a(inetAddress, this.url.getPort(), this.url.getProtocol(), string2, string3)) != null) {
                bj2 = new DigestAuthentication(this.url, string2, string3, (PasswordAuthentication)object);
            }
            if (bj2 == null && e != null && e.schemeSupported(string3) && (object = e.authString(this.url, string3, string2)) != null) {
                bj2 = new BasicAuthentication(false, this.url, string2, (String)object);
            }
            if (bj2 != null && !bj2.a(this, headerParser)) {
                bj2 = null;
            }
        }
        return bj2;
    }

    public X509Certificate[] getServerCertificateChain() {
        return ((HttpsClient)this.http).getServerCertificateChain();
    }

    private static boolean a(URL uRL, URL uRL2) {
        final String string = uRL.getHost();
        final String string2 = uRL2.getHost();
        if (string == null) {
            return string2 == null;
        }
        if (string2 == null) {
            return false;
        }
        if (string.equalsIgnoreCase(string2)) {
            return true;
        }
        final boolean[] blArray = new boolean[1];
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    InetAddress inetAddress = InetAddress.getByName(string);
                    InetAddress inetAddress2 = InetAddress.getByName(string2);
                    blArray[0] = inetAddress.equals(inetAddress2);
                }
                catch (UnknownHostException unknownHostException) {
                }
                catch (SecurityException securityException) {}
                return null;
            }
        });
        return blArray[0];
    }

    private static PasswordAuthentication a(final InetAddress inetAddress, final int n2, final String string, final String string2, final String string3) {
        return (PasswordAuthentication)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Authenticator.requestPasswordAuthentication(inetAddress, n2, string, string2, string3);
            }
        });
    }

    public void a(String string, String string2) {
        this.f.set(string, string2);
    }

    public static void setDefaultAuthenticator(HttpAuthenticator httpAuthenticator) {
        e = httpAuthenticator;
    }

    public void setInstanceFollowRedirects(boolean bl2) {
        this.m = bl2;
    }

    public void setRequestProperty(String string, String string2) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        this.f.set(string, string2);
    }

    public boolean usingProxy() {
        if (this.http != null) {
            return this.http.usingProxy;
        }
        return false;
    }

    private void e() throws IOException {
        if (!this.j) {
            Object object;
            Object object2;
            long l2;
            bj bj2;
            this.f.prepend(String.valueOf(this.method) + " " + this.http.getURLFile() + " " + b, null);
            this.f.setIfNotSet("User-Agent", userAgent);
            int n2 = this.url.getPort();
            String string = this.url.getHost();
            if (n2 != -1 && n2 != 80) {
                string = String.valueOf(string) + ":" + String.valueOf(n2);
            }
            this.f.setIfNotSet("Host", string);
            this.f.setIfNotSet("Accept", c);
            if (!this.k && this.http.getHttpKeepAliveSet()) {
                if (this.http.usingProxy && !this.method.equals("POST") && !this.method.equals("PUT")) {
                    this.f.set("Proxy-Connection", "keep-alive");
                } else if (!this.http.usingProxy) {
                    this.f.set("Connection", "keep-alive");
                }
            } else {
                this.f.set("Connection", "close");
            }
            if (this.http.usingProxy && (bj2 = bj.a(this.http.getProxyHostUsed(), this.http.getProxyPortUsed())) != null && bj2.e()) {
                this.f.setIfNotSet(bj2.b(), bj2.c());
            }
            if ((l2 = this.getIfModifiedSince()) != 0L) {
                object2 = new Date(l2);
                object = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'");
                ((DateFormat)object).setTimeZone(TimeZone.getTimeZone("GMT"));
                this.f.setIfNotSet("If-Modified-Since", ((DateFormat)object).format((Date)object2));
            }
            if ((object2 = bj.a(this.url)) != null && ((bj)object2).e()) {
                this.f.setIfNotSet(((bj)object2).b(), ((bj)object2).c());
            }
            if (this.i != null) {
                object = this.i;
                synchronized (object) {
                    if (!this.method.equals("PUT")) {
                        String string2 = "application/x-www-form-urlencoded";
                        this.f.setIfNotSet("Content-type", string2);
                    }
                    this.f.set("Content-length", String.valueOf(this.i.size()));
                }
            }
            this.j = true;
        }
        this.http.writeRequests(this.f);
        if (this.i != null) {
            this.i.writeTo(this.ps);
            this.ps.flush();
        }
        if (this.ps.checkError()) {
            this.disconnect();
            if (this.k) {
                throw new IOException("Error writing to server");
            }
            this.k = true;
            this.http = this.getNewClient(this.url);
            this.ps = (PrintStream)this.http.getOutputStream();
            this.connected = true;
            this.g = new MessageHeader();
            this.f = new MessageHeader();
            this.j = false;
            this.e();
        }
    }
}

