/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.HandshakeMessage;
import com.sun.net.ssl.internal.ssl.RSACipher;
import com.sun.net.ssl.internal.ssl.SSLInputStream;
import com.sun.net.ssl.internal.ssl.SSLOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.net.ssl.SSLKeyException;

public final class PreMasterSecret
extends HandshakeMessage {
    public byte a;
    public byte b;
    public byte[] c;
    public byte[] d;

    public PreMasterSecret(byte by2, byte by3, SecureRandom secureRandom, SSLInputStream sSLInputStream, int n2, PrivateKey privateKey) throws IOException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new SSLKeyException("Private key not of type RSA");
        }
        this.d = new byte[n2];
        if (sSLInputStream.read(this.d) != n2) {
            throw new IOException("SSL: read PreMasterSecret:  short read");
        }
        try {
            RSACipher rSACipher = new RSACipher();
            rSACipher.decryptInit((RSAPrivateKey)privateKey);
            this.c = rSACipher.doDecrypt(this.d, 0, this.d.length);
            this.a = this.c[0];
            this.b = this.c[1];
        }
        catch (Exception exception) {
            this.c = null;
        }
        if (this.a != by2 || this.b != by3 || this.c == null || this.c.length != 48) {
            this.c = new byte[48];
            secureRandom.nextBytes(this.c);
            this.c[0] = this.a = by2;
            this.c[1] = this.b = by3;
        }
    }

    public PreMasterSecret(byte by2, byte by3, SecureRandom secureRandom, PublicKey publicKey) throws IOException, NoSuchAlgorithmException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new SSLKeyException("Public key not of type RSA");
        }
        this.c = new byte[48];
        secureRandom.nextBytes(this.c);
        this.c[0] = this.a = by2;
        this.c[1] = this.b = by3;
        RSACipher rSACipher = new RSACipher();
        try {
            rSACipher.encryptInit((RSAPublicKey)publicKey, secureRandom);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SSLKeyException(invalidKeyException.getMessage());
        }
        this.d = rSACipher.doEncrypt(this.c, 0, this.c.length);
    }

    public int messageLength() {
        return this.d.length;
    }

    public int messageType() {
        return 16;
    }

    public void a(PrintStream printStream) throws IOException {
        printStream.println("*** ClientKeyExchange, RSA PreMasterSecret, v" + this.a + "." + this.b);
        if (HandshakeMessage.debug != null && Debug.isOn("verbose")) {
            printStream.print("Random Secret:  { ");
            int n2 = 0;
            while (n2 < this.c.length) {
                if (n2 != 0) {
                    printStream.print(", ");
                }
                printStream.print(this.c[n2] & 0xFF);
                ++n2;
            }
            printStream.println(" }");
        }
    }

    public void send(SSLOutputStream sSLOutputStream) throws IOException {
        sSLOutputStream.write(this.d);
    }
}

