/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.JS_PrivateKey;
import com.sun.net.ssl.internal.ssl.JS_PublicKey;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;

public abstract class JS_Signature
extends SignatureSpi
implements Cloneable,
Serializable {
    public ao jsafeSignature;
    public cp jsafeParams;
    public int[] signatureParams;
    public String a;
    public boolean b;

    public JS_Signature(String string, String string2, String string3) throws NoSuchAlgorithmException {
        try {
            this.jsafeSignature = ao.a(string, "Java");
        }
        catch (m m2) {
            throw new NoSuchAlgorithmException("JSAFE provider does not perform " + string);
        }
        this.a = string3;
    }

    public void a() {
        if (this.jsafeSignature != null) {
            this.jsafeSignature.a();
        }
        this.jsafeSignature = null;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            Class<?> clazz = Class.forName(this.getSubclassName());
            JS_Signature jS_Signature = (JS_Signature)clazz.newInstance();
            return jS_Signature;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CloneNotSupportedException();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CloneNotSupportedException();
        }
        catch (InstantiationException instantiationException) {
            throw new CloneNotSupportedException();
        }
    }

    public Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException("JSAFE provider does not support deprecated methods.");
    }

    public void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.b = true;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(this.a, "SunJSSE");
            JS_PrivateKey jS_PrivateKey = (JS_PrivateKey)keyFactory.translateKey(privateKey);
            az az2 = jS_PrivateKey.b();
            SecureRandom secureRandom = null;
            if (this.needSignRandom()) {
                if (this.appRandom != null) {
                    secureRandom = this.appRandom;
                } else {
                    try {
                        SecureRandom secureRandom2;
                        secureRandom = secureRandom2 = v.getInstance("SHA1Random", "Java");
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new InvalidKeyException(noSuchAlgorithmException.getMessage());
                    }
                }
            }
            this.jsafeSignature.a(az2, this.jsafeParams, secureRandom);
            az2.a();
            jS_PrivateKey.a();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidKeyException("Could not initialize for signing with the given key.");
        }
        catch (m m2) {
            throw new InvalidKeyException(m2.getMessage());
        }
    }

    public void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        if (secureRandom != null) {
            this.appRandom = secureRandom;
        }
        this.engineInitSign(privateKey);
    }

    public void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.b = false;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(this.a, "SunJSSE");
            JS_PublicKey jS_PublicKey = (JS_PublicKey)keyFactory.translateKey(publicKey);
            an an2 = jS_PublicKey.b();
            SecureRandom secureRandom = null;
            if (this.needVerifyRandom()) {
                if (this.appRandom != null) {
                    secureRandom = this.appRandom;
                } else {
                    try {
                        SecureRandom secureRandom2 = v.getInstance("SHA1Random", "Java");
                        secureRandom = this.appRandom;
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new InvalidKeyException(noSuchAlgorithmException.getMessage());
                    }
                }
            }
            this.jsafeSignature.a(an2, this.jsafeParams, secureRandom);
            an2.a();
            jS_PublicKey.a();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidKeyException("Could not initialize for verifying with the given key.");
        }
        catch (m m2) {
            throw new InvalidKeyException(m2.getMessage());
        }
    }

    public void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException("JSAFE provider does not support deprecated methods.");
    }

    public void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        cp cp2 = this.getSystemParameters(algorithmParameterSpec);
    }

    public byte[] engineSign() throws SignatureException {
        if (!this.b) {
            throw new SignatureException("Object initialized for verify.");
        }
        try {
            byte[] byArray = this.jsafeSignature.j();
            this.jsafeSignature.k();
            return byArray;
        }
        catch (m m2) {
            throw new SignatureException(m2.getMessage());
        }
    }

    public void engineUpdate(byte by2) throws SignatureException {
        try {
            byte[] byArray = new byte[]{by2};
            if (this.b) {
                this.jsafeSignature.a(byArray, 0, 1);
            } else {
                this.jsafeSignature.c(byArray, 0, 1);
            }
        }
        catch (m m2) {
            throw new SignatureException(m2.getMessage());
        }
    }

    public void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        try {
            if (this.b) {
                this.jsafeSignature.a(byArray, n2, n3);
            } else {
                this.jsafeSignature.c(byArray, n2, n3);
            }
        }
        catch (m m2) {
            throw new SignatureException(m2.getMessage());
        }
    }

    public boolean engineVerify(byte[] byArray) throws SignatureException {
        if (this.b) {
            throw new SignatureException("Object initialized for signing.");
        }
        try {
            boolean bl2 = this.jsafeSignature.b(byArray, 0, byArray.length);
            this.jsafeSignature.l();
            return bl2;
        }
        catch (m m2) {
            throw new SignatureException(m2.getMessage());
        }
    }

    public void finalize() {
        this.a();
    }

    public abstract int[] getSignatureParameters(AlgorithmParameterSpec var1) throws InvalidAlgorithmParameterException;

    public String getSubclassName() {
        return null;
    }

    public abstract cp getSystemParameters(AlgorithmParameterSpec var1) throws InvalidAlgorithmParameterException;

    public boolean needSignRandom() {
        return false;
    }

    public boolean needVerifyRandom() {
        return false;
    }
}

