/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.DerInputStream;
import com.sun.net.ssl.internal.ssl.DerOutputStream;
import com.sun.net.ssl.internal.ssl.DerValue;
import com.sun.net.ssl.internal.ssl.ObjectIdentifier;
import com.sun.net.ssl.internal.ssl.ParsingException;
import java.io.IOException;

public class ContentInfo {
    public static int[] a = new int[]{1, 2, 840, 113549, 1, 7};
    public static int[] b = new int[]{1, 2, 840, 113549, 1, 7, 1};
    public static int[] c = new int[]{1, 2, 840, 113549, 1, 7, 2};
    public static int[] d = new int[]{1, 2, 840, 113549, 1, 7, 3};
    public static int[] e = new int[]{1, 2, 840, 113549, 1, 7, 4};
    public static int[] f = new int[]{1, 2, 840, 113549, 1, 7, 5};
    public static int[] g = new int[]{1, 2, 840, 113549, 1, 7, 6};
    public static int[] h = new int[]{2, 16, 840, 1, 113730, 2, 5};
    public static final ObjectIdentifier PKCS7_OID = new ObjectIdentifier(a);
    public static final ObjectIdentifier DATA_OID = new ObjectIdentifier(b);
    public static final ObjectIdentifier SIGNED_DATA_OID = new ObjectIdentifier(c);
    public static final ObjectIdentifier ENVELOPED_DATA_OID = new ObjectIdentifier(d);
    public static final ObjectIdentifier SIGNED_AND_ENVELOPED_DATA_OID = new ObjectIdentifier(e);
    public static final ObjectIdentifier DIGESTED_DATA_OID = new ObjectIdentifier(f);
    public static final ObjectIdentifier ENCRYPTED_DATA_OID = new ObjectIdentifier(g);
    public static final int[] i = new int[]{1, 2, 840, 1113549, 1, 7, 2};
    public static final ObjectIdentifier OLD_SIGNED_DATA_OID = new ObjectIdentifier(i);
    public static final int[] j = new int[]{1, 2, 840, 1113549, 1, 7, 1};
    public static final ObjectIdentifier OLD_DATA_OID = new ObjectIdentifier(j);
    public static final ObjectIdentifier NETSCAPE_CERT_SEQUENCE_OID = new ObjectIdentifier(h);
    public ObjectIdentifier k;
    public DerValue l;

    public ContentInfo(DerInputStream derInputStream) throws IOException, ParsingException {
        this(derInputStream, false);
    }

    public ContentInfo(DerInputStream derInputStream, boolean bl2) throws IOException, ParsingException {
        DerValue[] derValueArray = derInputStream.getSequence(2);
        DerValue derValue = derValueArray[0];
        DerInputStream derInputStream2 = new DerInputStream(derValue.toByteArray());
        this.k = derInputStream2.getOID();
        if (bl2) {
            this.l = derValueArray[1];
        } else if (derValueArray.length > 1) {
            DerValue derValue2 = derValueArray[1];
            DerInputStream derInputStream3 = new DerInputStream(derValue2.toByteArray());
            DerValue[] derValueArray2 = derInputStream3.getSet(1, true);
            this.l = derValueArray2[0];
        }
    }

    public ContentInfo(ObjectIdentifier objectIdentifier, DerValue derValue) {
        this.k = objectIdentifier;
        this.l = derValue;
    }

    public ContentInfo(byte[] byArray) {
        DerValue derValue = new DerValue(4, byArray);
        this.k = DATA_OID;
        this.l = derValue;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOID(this.k);
        if (this.l != null) {
            DerValue derValue = null;
            DerOutputStream derOutputStream3 = new DerOutputStream();
            this.l.encode(derOutputStream3);
            derValue = new DerValue(-96, derOutputStream3.toByteArray());
            derOutputStream2.putDerValue(derValue);
        }
        derOutputStream.write((byte)48, derOutputStream2);
    }

    public DerValue getContent() {
        return this.l;
    }

    public byte[] getContentBytes() throws IOException {
        if (this.l == null) {
            return null;
        }
        DerInputStream derInputStream = new DerInputStream(this.l.toByteArray());
        return derInputStream.getOctetString();
    }

    public ObjectIdentifier getContentType() {
        return this.k;
    }

    public byte[] getData() throws IOException {
        if (this.k.equals(DATA_OID) || this.k.equals(OLD_DATA_OID)) {
            if (this.l == null) {
                return null;
            }
            return this.l.getOctetString();
        }
        throw new IOException("content type is not DATA: " + this.k);
    }

    public String toString() {
        String string = "";
        string = String.valueOf(string) + "Content Info Sequence\n\tContent type: " + this.k + "\n";
        string = String.valueOf(string) + "\tContent: " + this.l;
        return string;
    }
}

