/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public abstract class CharacterEncoder {
    public PrintStream pStream;

    public abstract int bytesPerAtom();

    public abstract int bytesPerLine();

    public void encode(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2;
        byte[] byArray = new byte[this.bytesPerLine()];
        this.encodeBufferPrefix(outputStream);
        while ((n2 = this.readFully(inputStream, byArray)) != 0) {
            this.encodeLinePrefix(outputStream, n2);
            int n3 = 0;
            while (n3 < n2) {
                if (n3 + this.bytesPerAtom() <= n2) {
                    this.encodeAtom(outputStream, byArray, n3, this.bytesPerAtom());
                } else {
                    this.encodeAtom(outputStream, byArray, n3, n2 - n3);
                }
                n3 += this.bytesPerAtom();
            }
            if (n2 < this.bytesPerLine()) break;
            this.encodeLineSuffix(outputStream);
        }
        this.encodeBufferSuffix(outputStream);
    }

    public String encode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        String string = null;
        try {
            this.encode(byteArrayInputStream, (OutputStream)byteArrayOutputStream);
            string = byteArrayOutputStream.toString("8859_1");
        }
        catch (Exception exception) {
            throw new Error("ChracterEncoder::encodeBuffer internal error");
        }
        return string;
    }

    public void encode(byte[] byArray, OutputStream outputStream) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.encode(byteArrayInputStream, outputStream);
    }

    public abstract void encodeAtom(OutputStream var1, byte[] var2, int var3, int var4) throws IOException;

    public void encodeBuffer(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2;
        byte[] byArray = new byte[this.bytesPerLine()];
        this.encodeBufferPrefix(outputStream);
        while ((n2 = this.readFully(inputStream, byArray)) != 0) {
            this.encodeLinePrefix(outputStream, n2);
            int n3 = 0;
            while (n3 < n2) {
                if (n3 + this.bytesPerAtom() <= n2) {
                    this.encodeAtom(outputStream, byArray, n3, this.bytesPerAtom());
                } else {
                    this.encodeAtom(outputStream, byArray, n3, n2 - n3);
                }
                n3 += this.bytesPerAtom();
            }
            this.encodeLineSuffix(outputStream);
            if (n2 >= this.bytesPerLine()) continue;
        }
        this.encodeBufferSuffix(outputStream);
    }

    public String encodeBuffer(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            this.encodeBuffer(byteArrayInputStream, (OutputStream)byteArrayOutputStream);
        }
        catch (Exception exception) {
            throw new Error("ChracterEncoder::encodeBuffer internal error");
        }
        return byteArrayOutputStream.toString();
    }

    public void encodeBuffer(byte[] byArray, OutputStream outputStream) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.encodeBuffer(byteArrayInputStream, outputStream);
    }

    public void encodeBufferPrefix(OutputStream outputStream) throws IOException {
        this.pStream = new PrintStream(outputStream);
    }

    public void encodeBufferSuffix(OutputStream outputStream) throws IOException {
    }

    public void encodeLinePrefix(OutputStream outputStream, int n2) throws IOException {
    }

    public void encodeLineSuffix(OutputStream outputStream) throws IOException {
        this.pStream.println();
    }

    public int readFully(InputStream inputStream, byte[] byArray) throws IOException {
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = inputStream.read();
            if (n3 == -1) {
                return n2;
            }
            byArray[n2] = (byte)n3;
            ++n2;
        }
        return byArray.length;
    }
}

