/*  ksim - a system monitor for kde
 *
 *  Copyright (C) 2001  Robbie Ward <linuxphreak@gmx.co.uk>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <kiconloader.h>
#include <kwin.h>
#include <kstandarddirs.h>
#include <kdesktopfile.h>
#include <klocale.h>
#include <kdebug.h>
#include <kpopupmenu.h>
#include <kmessagebox.h>
#include <kapplication.h>
#include <kstdaccel.h>

#include <qcursor.h>
#include <qregexp.h>

#include "ksim.h"
#include "ksim.moc"

#include "ksimview.h"
#include <ksimconfig.h>
#include <ksimdock.h>

KSim::MainWindow::MainWindow(const KURL::List &urlList, QWidget *parent,
   const char *name) : KMainWindow(parent, name, WType_TopLevel |
   WDestructiveClose | WStyle_NoBorder | WStyle_Customize)
{
  initWidget(urlList);
}

KSim::MainWindow::~MainWindow()
{
}

void KSim::MainWindow::contextMenu()
{
  switch (m_mainMenu->exec(QCursor::pos())) {
    case 6:
      windowMenu(6);
      break;
    case 7:
      windowMenu(7);
      break;
    case 8:
      windowMenu(8);
      break;
  }
}

void KSim::MainWindow::loadPlugins(const KURL::List &urlList)
{
  if (urlList.isEmpty())
    return;

  // Maybe make this network transparent some day
  // (dont think it needs to be though)
  KURL::List::ConstIterator it;
  QString url;
  for (it = urlList.begin(); it != urlList.end(); ++it) {
    url = (*it).prettyURL();
    url.replace(QRegExp("file:"), QString::null);
    if (KDesktopFile::isDesktopFile(url))
      m_view->addPlugin(KDesktopFile(url, true), true);
  }

  m_view->createPluginMenu();
}

void KSim::MainWindow::show()
{
  KMainWindow::show();

  if (m_shownBefore) // A little hackish
    return;

  m_shownBefore = 1;
  if (m_view->config()->savePos())
    move(m_view->config()->position(pos()));
}

void KSim::MainWindow::reparse()
{
  showDock();

  if (m_view->config()->stayOnTop())
    KWin::setState(winId(), NET::StaysOnTop);
  else
    KWin::clearState(winId(), NET::StaysOnTop);

  m_winMenu->setItemChecked(m_ontopItem, m_view->config()->stayOnTop());
  resize(width(), minimumHeight());
}

bool KSim::MainWindow::queryClose()
{
  m_view->config()->setWidth(width());
  m_view->config()->setPosition(pos());

  m_view->cleanup();
  return true;
}

void KSim::MainWindow::showDock()
{
  if (m_view->config()->showDock()) {
    if (m_dock)
      return;

    KWin::setState(winId(), NET::SkipTaskbar);
    m_dock = new KSim::Dock(m_view->pluginMenu(), this, "m_dock");
    connect(m_dock, SIGNAL(preferences()), m_view, SLOT(preferences()));
    m_dock->show();
  }
  else {
    KWin::clearState(winId(), NET::SkipTaskbar);
    delete m_dock;
    m_dock = 0;
  }
}

void KSim::MainWindow::windowMenu(int windowId)
{
  switch (windowId) {
    case 6:
      if (m_winMenu->isItemChecked(m_desktopItem)) {
        m_winMenu->setItemChecked(m_desktopItem, false);
        KWin::setOnAllDesktops(winId(), false);
      }
      else {
        m_winMenu->setItemChecked(m_desktopItem, true);
        KWin::setOnAllDesktops(winId(), true);
      }
      break;
    case 7:
      if (m_winMenu->isItemChecked(m_ontopItem)) {
        m_winMenu->setItemChecked(m_ontopItem, false);
        KWin::clearState(winId(), NET::StaysOnTop);
        m_view->config()->setStayOnTop(false);
      }
      else {
        m_winMenu->setItemChecked(m_ontopItem, true);
        KWin::setState(winId(), NET::StaysOnTop);
        m_view->config()->setStayOnTop(true);
      }
      break;
    case 8:
      if (!isMinimized())
        showMinimized();
      break;
  }
}

void KSim::MainWindow::initWidget(const KURL::List &urlList)
{
  m_view = new KSim::MainView(kapp->config(), urlList.isEmpty(), this, "m_view");
  m_shownBefore = 0;
  m_dock = 0L;

  setCentralWidget(m_view);
  setCaption(m_view->hostname());
  loadPlugins(urlList);

  // Create the dock icon (if enabled)
  showDock();

  m_winMenu = new QPopupMenu(this);
  m_desktopItem = m_winMenu->insertItem(i18n("To All Desktops"), 6);
  m_ontopItem = m_winMenu->insertItem(SmallIcon("attach"),
     i18n("Always on Top"), 7);
  m_winMenu->insertItem(i18n("Minimize"), 8);

  m_mainMenu = new QPopupMenu(this, "m_mainMenu");
  m_mainMenu->insertItem(SmallIcon("configure"),
     i18n("Configure KSim..."), m_view, SLOT(preferences()));
  m_mainMenu->insertItem(SmallIcon("ksim"), i18n("Window"), m_winMenu, 1);
  m_mainMenu->insertItem(i18n("Plugins"), m_view->pluginMenu(), 2);
  m_mainMenu->insertSeparator(3);
  m_mainMenu->insertItem(SmallIconSet("help"), i18n("Help"), helpMenu(), 4);
  m_mainMenu->insertItem(SmallIconSet("exit"), i18n("Quit"), this,
     SLOT(close()), KStdAccel::quit(), 5);

  // set the height to the minimum possible
  resize(m_view->config()->width(minimumWidth()), minimumHeight());
  if (m_view->config()->stayOnTop())
  {
    KWin::setState(winId(), NET::StaysOnTop);
    m_winMenu->setItemChecked(m_ontopItem, true);
  }
}
